// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationTemplateGetReader is a Reader for the ApplicationTemplateGet structure.
type ApplicationTemplateGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationTemplateGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationTemplateGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationTemplateGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationTemplateGetOK creates a ApplicationTemplateGetOK with default headers values
func NewApplicationTemplateGetOK() *ApplicationTemplateGetOK {
	return &ApplicationTemplateGetOK{}
}

/*
ApplicationTemplateGetOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationTemplateGetOK struct {
	Payload *models.ApplicationTemplate
}

// IsSuccess returns true when this application template get o k response has a 2xx status code
func (o *ApplicationTemplateGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application template get o k response has a 3xx status code
func (o *ApplicationTemplateGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application template get o k response has a 4xx status code
func (o *ApplicationTemplateGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application template get o k response has a 5xx status code
func (o *ApplicationTemplateGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application template get o k response a status code equal to that given
func (o *ApplicationTemplateGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application template get o k response
func (o *ApplicationTemplateGetOK) Code() int {
	return 200
}

func (o *ApplicationTemplateGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/templates/{name}][%d] applicationTemplateGetOK %s", 200, payload)
}

func (o *ApplicationTemplateGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/templates/{name}][%d] applicationTemplateGetOK %s", 200, payload)
}

func (o *ApplicationTemplateGetOK) GetPayload() *models.ApplicationTemplate {
	return o.Payload
}

func (o *ApplicationTemplateGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationTemplate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationTemplateGetDefault creates a ApplicationTemplateGetDefault with default headers values
func NewApplicationTemplateGetDefault(code int) *ApplicationTemplateGetDefault {
	return &ApplicationTemplateGetDefault{
		_statusCode: code,
	}
}

/*
ApplicationTemplateGetDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationTemplateGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application template get default response has a 2xx status code
func (o *ApplicationTemplateGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application template get default response has a 3xx status code
func (o *ApplicationTemplateGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application template get default response has a 4xx status code
func (o *ApplicationTemplateGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application template get default response has a 5xx status code
func (o *ApplicationTemplateGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application template get default response a status code equal to that given
func (o *ApplicationTemplateGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application template get default response
func (o *ApplicationTemplateGetDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationTemplateGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/templates/{name}][%d] application_template_get default %s", o._statusCode, payload)
}

func (o *ApplicationTemplateGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/templates/{name}][%d] application_template_get default %s", o._statusCode, payload)
}

func (o *ApplicationTemplateGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationTemplateGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
