// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupCollectionGetReader is a Reader for the ConsistencyGroupCollectionGet structure.
type ConsistencyGroupCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupCollectionGetOK creates a ConsistencyGroupCollectionGetOK with default headers values
func NewConsistencyGroupCollectionGetOK() *ConsistencyGroupCollectionGetOK {
	return &ConsistencyGroupCollectionGetOK{}
}

/*
ConsistencyGroupCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupCollectionGetOK struct {
	Payload *models.ConsistencyGroupResponse
}

// IsSuccess returns true when this consistency group collection get o k response has a 2xx status code
func (o *ConsistencyGroupCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group collection get o k response has a 3xx status code
func (o *ConsistencyGroupCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group collection get o k response has a 4xx status code
func (o *ConsistencyGroupCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group collection get o k response has a 5xx status code
func (o *ConsistencyGroupCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group collection get o k response a status code equal to that given
func (o *ConsistencyGroupCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group collection get o k response
func (o *ConsistencyGroupCollectionGetOK) Code() int {
	return 200
}

func (o *ConsistencyGroupCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups][%d] consistencyGroupCollectionGetOK %s", 200, payload)
}

func (o *ConsistencyGroupCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups][%d] consistencyGroupCollectionGetOK %s", 200, payload)
}

func (o *ConsistencyGroupCollectionGetOK) GetPayload() *models.ConsistencyGroupResponse {
	return o.Payload
}

func (o *ConsistencyGroupCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupCollectionGetDefault creates a ConsistencyGroupCollectionGetDefault with default headers values
func NewConsistencyGroupCollectionGetDefault(code int) *ConsistencyGroupCollectionGetDefault {
	return &ConsistencyGroupCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ConsistencyGroupCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ConsistencyGroupCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group collection get default response has a 2xx status code
func (o *ConsistencyGroupCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group collection get default response has a 3xx status code
func (o *ConsistencyGroupCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group collection get default response has a 4xx status code
func (o *ConsistencyGroupCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group collection get default response has a 5xx status code
func (o *ConsistencyGroupCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group collection get default response a status code equal to that given
func (o *ConsistencyGroupCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group collection get default response
func (o *ConsistencyGroupCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups][%d] consistency_group_collection_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups][%d] consistency_group_collection_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
