// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupCreateReader is a Reader for the ConsistencyGroupCreate structure.
type ConsistencyGroupCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewConsistencyGroupCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewConsistencyGroupCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupCreateCreated creates a ConsistencyGroupCreateCreated with default headers values
func NewConsistencyGroupCreateCreated() *ConsistencyGroupCreateCreated {
	return &ConsistencyGroupCreateCreated{}
}

/*
ConsistencyGroupCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ConsistencyGroupCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ConsistencyGroupResponse
}

// IsSuccess returns true when this consistency group create created response has a 2xx status code
func (o *ConsistencyGroupCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group create created response has a 3xx status code
func (o *ConsistencyGroupCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group create created response has a 4xx status code
func (o *ConsistencyGroupCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group create created response has a 5xx status code
func (o *ConsistencyGroupCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group create created response a status code equal to that given
func (o *ConsistencyGroupCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the consistency group create created response
func (o *ConsistencyGroupCreateCreated) Code() int {
	return 201
}

func (o *ConsistencyGroupCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistencyGroupCreateCreated %s", 201, payload)
}

func (o *ConsistencyGroupCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistencyGroupCreateCreated %s", 201, payload)
}

func (o *ConsistencyGroupCreateCreated) GetPayload() *models.ConsistencyGroupResponse {
	return o.Payload
}

func (o *ConsistencyGroupCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ConsistencyGroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupCreateAccepted creates a ConsistencyGroupCreateAccepted with default headers values
func NewConsistencyGroupCreateAccepted() *ConsistencyGroupCreateAccepted {
	return &ConsistencyGroupCreateAccepted{}
}

/*
ConsistencyGroupCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ConsistencyGroupCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ConsistencyGroupJobLinkResponse
}

// IsSuccess returns true when this consistency group create accepted response has a 2xx status code
func (o *ConsistencyGroupCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group create accepted response has a 3xx status code
func (o *ConsistencyGroupCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group create accepted response has a 4xx status code
func (o *ConsistencyGroupCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group create accepted response has a 5xx status code
func (o *ConsistencyGroupCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group create accepted response a status code equal to that given
func (o *ConsistencyGroupCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the consistency group create accepted response
func (o *ConsistencyGroupCreateAccepted) Code() int {
	return 202
}

func (o *ConsistencyGroupCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistencyGroupCreateAccepted %s", 202, payload)
}

func (o *ConsistencyGroupCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistencyGroupCreateAccepted %s", 202, payload)
}

func (o *ConsistencyGroupCreateAccepted) GetPayload() *models.ConsistencyGroupJobLinkResponse {
	return o.Payload
}

func (o *ConsistencyGroupCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ConsistencyGroupJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupCreateDefault creates a ConsistencyGroupCreateDefault with default headers values
func NewConsistencyGroupCreateDefault(code int) *ConsistencyGroupCreateDefault {
	return &ConsistencyGroupCreateDefault{
		_statusCode: code,
	}
}

/*
	ConsistencyGroupCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621707 | No SVM was specified. Either `svm.name` or `svm.uuid` must be supplied.<personalities supports=unified,asar2> |
| 5374127 | The specified LUN name is invalid.</personalities> |
| 5376461 | The specified name is invalid because it does not match the format requirements. |
| 5440501 | The specified storage unit size is insufficient. |
| 5440509 | No suitable storage can be found for the specified requirements. |
| 53411842 | Consistency group does not exist. |
| 53411843 | A consistency group with specified UUID was not found. |
| 53411844 | Specified consistency group was not found in the specified SVM. |
| 53411845 | The specified UUID and name refer to different consistency groups. |
| 53411846 | Either name or UUID must be provided. |
| 53411853 | Fields provided in the request conflict with each other. |
| 53411856 | The provided field is only supported when provisioning new objects.<personalities supports=asar2> |
| 53411857 | LUNs that are not members of the application are not supported by this API. LUNs can be added to an application by adding the volume containing the LUNs to the application.</personalities> |
| 53411860 | An object with the same identifier in the same scope exists. |
| 53411861 | The specified volume does not exist in provided volume array. |
| 53411862 | Modifying existing igroups is not supported using this API. |
| 53411864 | Request content insufficient to add an existing volume to an application. |
| 53411865 | Volumes contained in one consistency group cannot be added to a different consistency group.<personalities supports=unified,asar2> |
| 53411866 | LUNs are not supported on FlexGroup volumes. |
| 53411867 | LUN name is too long after appending a unique suffix.</personalities> |
| 53411869 | Volume name is too long after appending a unique suffix.<personalities supports=unified,asar2> |
| 53411870 | When using the \"round_robin\" layout, the volume count must not be greater than the LUN count. |
| 53411959 | Volumes with snapshot locking enabled cannot be added to a consistency group. |
| 53412040 | Splitting a non-SnapLock clone from a Snaplock consistency group during clone creation is not supported.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConsistencyGroupCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group create default response has a 2xx status code
func (o *ConsistencyGroupCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group create default response has a 3xx status code
func (o *ConsistencyGroupCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group create default response has a 4xx status code
func (o *ConsistencyGroupCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group create default response has a 5xx status code
func (o *ConsistencyGroupCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group create default response a status code equal to that given
func (o *ConsistencyGroupCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group create default response
func (o *ConsistencyGroupCreateDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistency_group_create default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/consistency-groups][%d] consistency_group_create default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
