// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupDeleteCollectionReader is a Reader for the ConsistencyGroupDeleteCollection structure.
type ConsistencyGroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewConsistencyGroupDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupDeleteCollectionOK creates a ConsistencyGroupDeleteCollectionOK with default headers values
func NewConsistencyGroupDeleteCollectionOK() *ConsistencyGroupDeleteCollectionOK {
	return &ConsistencyGroupDeleteCollectionOK{}
}

/*
ConsistencyGroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupDeleteCollectionOK struct {
}

// IsSuccess returns true when this consistency group delete collection o k response has a 2xx status code
func (o *ConsistencyGroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group delete collection o k response has a 3xx status code
func (o *ConsistencyGroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group delete collection o k response has a 4xx status code
func (o *ConsistencyGroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group delete collection o k response has a 5xx status code
func (o *ConsistencyGroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group delete collection o k response a status code equal to that given
func (o *ConsistencyGroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group delete collection o k response
func (o *ConsistencyGroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *ConsistencyGroupDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistencyGroupDeleteCollectionOK", 200)
}

func (o *ConsistencyGroupDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistencyGroupDeleteCollectionOK", 200)
}

func (o *ConsistencyGroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConsistencyGroupDeleteCollectionAccepted creates a ConsistencyGroupDeleteCollectionAccepted with default headers values
func NewConsistencyGroupDeleteCollectionAccepted() *ConsistencyGroupDeleteCollectionAccepted {
	return &ConsistencyGroupDeleteCollectionAccepted{}
}

/*
ConsistencyGroupDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ConsistencyGroupDeleteCollectionAccepted struct {
	Payload *models.ConsistencyGroupJobLinkResponse
}

// IsSuccess returns true when this consistency group delete collection accepted response has a 2xx status code
func (o *ConsistencyGroupDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group delete collection accepted response has a 3xx status code
func (o *ConsistencyGroupDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group delete collection accepted response has a 4xx status code
func (o *ConsistencyGroupDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group delete collection accepted response has a 5xx status code
func (o *ConsistencyGroupDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group delete collection accepted response a status code equal to that given
func (o *ConsistencyGroupDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the consistency group delete collection accepted response
func (o *ConsistencyGroupDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *ConsistencyGroupDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistencyGroupDeleteCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistencyGroupDeleteCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupDeleteCollectionAccepted) GetPayload() *models.ConsistencyGroupJobLinkResponse {
	return o.Payload
}

func (o *ConsistencyGroupDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupDeleteCollectionDefault creates a ConsistencyGroupDeleteCollectionDefault with default headers values
func NewConsistencyGroupDeleteCollectionDefault(code int) *ConsistencyGroupDeleteCollectionDefault {
	return &ConsistencyGroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ConsistencyGroupDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 53411842 | Consistency group does not exist. |
| 53411843 | A consistency group with specified UUID was not found. |
| 53411844 | Specified consistency group was not found in the specified SVM. |
| 53411845 | The specified UUID and name refer to different consistency groups. |
| 53411846 | Either name or UUID must be provided.<personalities supports=unified,asar2> |
| 53412041 | Cannot delete a consistency group because it contains one or more storage units that are part of replication relationships.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConsistencyGroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group delete collection default response has a 2xx status code
func (o *ConsistencyGroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group delete collection default response has a 3xx status code
func (o *ConsistencyGroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group delete collection default response has a 4xx status code
func (o *ConsistencyGroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group delete collection default response has a 5xx status code
func (o *ConsistencyGroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group delete collection default response a status code equal to that given
func (o *ConsistencyGroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group delete collection default response
func (o *ConsistencyGroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistency_group_delete_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups][%d] consistency_group_delete_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ConsistencyGroupDeleteCollectionBody consistency group delete collection body
swagger:model ConsistencyGroupDeleteCollectionBody
*/
type ConsistencyGroupDeleteCollectionBody struct {

	// consistency group response inline records
	ConsistencyGroupResponseInlineRecords []*models.ConsistencyGroupResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this consistency group delete collection body
func (o *ConsistencyGroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConsistencyGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionBody) validateConsistencyGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ConsistencyGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.ConsistencyGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ConsistencyGroupResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection body based on the context it is used
func (o *ConsistencyGroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConsistencyGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionBody) contextValidateConsistencyGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroupResponseInlineRecords); i++ {

		if o.ConsistencyGroupResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0 consistency group delete collection params body records items0 consistency groups items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application `json:"application,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 `json:"luns"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos `json:"qos,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo `json:"restore_to,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space `json:"space,omitempty"`

	// svm
	Svm *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering `json:"tiering,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(o.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(o.Tags))

	if err := validate.MaxItems("_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(o.Luns))

	if err := validate.MinItems("luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", o.Luns); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(o.Namespaces))

	if err := validate.MinItems("namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", o.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(o.RestoreTo) { // not required
		return nil
	}

	if o.RestoreTo != nil {
		if err := o.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(o.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", o.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if o.RestoreTo != nil {
		if err := o.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application consistency group delete collection params body records items0 consistency groups items0 application
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 application
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeOther string = "other"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(o.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := o.validateComponentTypeEnum("application"+"."+"component_type", "body", *o.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOther captures enum value "other"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("application"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 application based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 clone
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 clone based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 clone source
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 clone source based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos consistency group delete collection params body records items0 consistency groups items0 luns items0 qos
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 qos
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 qos based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 qos policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 luns items0 space guarantee
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 space guarantee
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 status
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 status based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 subsystem map
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup The parent consistency group.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 parent consistency group
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 parent consistency group based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(o.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(o.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 provisioning options based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 provisioning options storage service
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos consistency group delete collection params body records items0 consistency groups items0 qos
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 qos
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 qos based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 qos policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 qos policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo Use to restore a consistency group to a previous snapshot
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 restore to
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 restore to based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot A consistency group's snapshot
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 restore to snapshot
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 restore to snapshot based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space Space information for the consistency group.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 space based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm struct {

	// links
	Links *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 svm
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 svm based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks consistency group delete collection params body records items0 consistency groups items0 svm links
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 svm links
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 svm links based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering The tiering placement and policy definitions for volumes in this consistency group.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 tiering
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 tiering based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 consistency group delete collection params body records items0 consistency groups items0 tiering object stores items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 tiering object stores items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 consistency group delete collection params body records items0 consistency groups items0 volumes items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas cifs
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas cifs
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas export policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas junction parent
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas junction parent
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 provisioning options storage service
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 qos
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 qos based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 qos policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space consistency group delete collection params body records items0 consistency groups items0 volumes items0 space
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 tiering
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 consistency groups items0 volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 consistency group delete collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 clone
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 clone based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 clone source
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 luns items0 clone source based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 lun maps items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group delete collection params body records items0 luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos consistency group delete collection params body records items0 luns items0 qos
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 qos
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 qos based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 qos policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 luns items0 space guarantee
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 namespaces items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0 space guarantee
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0 status
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 namespaces items0 status based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 namespaces items0 subsystem map
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0 consistency group delete collection params body records items0 replication relationships items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Indicates whether or not this consistency group is protected by SVM DR.
	//
	// Read Only: true
	IsProtectedBySvmDr *bool `json:"is_protected_by_svm_dr,omitempty"`

	// Indicates whether or not this consistency group is the source for replication.
	//
	// Read Only: true
	IsSource *bool `json:"is_source,omitempty"`

	// The unique identifier of the SnapMirror relationship.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 replication relationships items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 replication relationships items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtectedBySvmDr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateIsProtectedBySvmDr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_protected_by_svm_dr", "body", o.IsProtectedBySvmDr); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateIsSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_source", "body", o.IsSource); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0 consistency group delete collection params body records items0 tiering object stores items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 tiering object stores items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0 consistency group delete collection params body records items0 volumes items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 nas
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 nas based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs consistency group delete collection params body records items0 volumes items0 nas cifs
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 nas cifs
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 nas export policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent consistency group delete collection params body records items0 volumes items0 nas junction parent
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 nas junction parent
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 provisioning options
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 provisioning options storage service
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 qos
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 qos based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 qos policy
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space consistency group delete collection params body records items0 volumes items0 space
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 space
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 space based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 tiering
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group delete collection params body records items0 volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 consistency group delete collection params body records items0 volumes items0 tiering object stores items0
swagger:model ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group delete collection params body records items0 volumes items0 tiering object stores items0
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group delete collection params body records items0 volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItem consistency group response inline records inline array item
swagger:model consistency_group_response_inline_records_inline_array_item
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication `json:"application,omitempty"`

	// clone
	Clone *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone `json:"clone,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A consistency group can only be associated with one direct parent consistency group.
	//
	// Max Items: 5
	// Min Items: 0
	// Unique: true
	ConsistencyGroups []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0 `json:"consistency_groups"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0LunsItems0 `json:"luns"`

	// map to
	MapTo *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo `json:"map_to,omitempty"`

	// metric
	Metric *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric `json:"metric,omitempty"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// Indicates whether or not replication has been enabled on this consistency group.
	//
	// Read Only: true
	Replicated *bool `json:"replicated,omitempty"`

	// Indicates the SnapMirror relationship of this consistency group.
	//
	// Read Only: true
	ReplicationRelationships []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0 `json:"replication_relationships"`

	// Since support for this field is to be removed in the next release, use replication_relationships.is_source instead.
	//
	// Read Only: true
	ReplicationSource *bool `json:"replication_source,omitempty"`

	// restore to
	RestoreTo *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo `json:"restore_to,omitempty"`

	// snaplock
	Snaplock *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// unmap from
	UnmapFrom *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom `json:"unmap_from,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Type of objects in the consistency group.
	// Example: luns
	// Enum: ["luns","namespaces","mixed"]
	VdiskType *string `json:"vdisk_type,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group response inline records inline array item
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMapTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReplicationRelationships(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnmapFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVdiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(o.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(o.Tags))

	if err := validate.MaxItems("_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateConsistencyGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroups) { // not required
		return nil
	}

	iConsistencyGroupsSize := int64(len(o.ConsistencyGroups))

	if err := validate.MinItems("consistency_groups", "body", iConsistencyGroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("consistency_groups", "body", iConsistencyGroupsSize, 5); err != nil {
		return err
	}

	if err := validate.UniqueItems("consistency_groups", "body", o.ConsistencyGroups); err != nil {
		return err
	}

	for i := 0; i < len(o.ConsistencyGroups); i++ {
		if swag.IsZero(o.ConsistencyGroups[i]) { // not required
			continue
		}

		if o.ConsistencyGroups[i] != nil {
			if err := o.ConsistencyGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(o.Luns))

	if err := validate.MinItems("luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", o.Luns); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateMapTo(formats strfmt.Registry) error {
	if swag.IsZero(o.MapTo) { // not required
		return nil
	}

	if o.MapTo != nil {
		if err := o.MapTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("map_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(o.Namespaces))

	if err := validate.MinItems("namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", o.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateReplicationRelationships(formats strfmt.Registry) error {
	if swag.IsZero(o.ReplicationRelationships) { // not required
		return nil
	}

	for i := 0; i < len(o.ReplicationRelationships); i++ {
		if swag.IsZero(o.ReplicationRelationships[i]) { // not required
			continue
		}

		if o.ReplicationRelationships[i] != nil {
			if err := o.ReplicationRelationships[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(o.RestoreTo) { // not required
		return nil
	}

	if o.RestoreTo != nil {
		if err := o.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateUnmapFrom(formats strfmt.Registry) error {
	if swag.IsZero(o.UnmapFrom) { // not required
		return nil
	}

	if o.UnmapFrom != nil {
		if err := o.UnmapFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unmap_from")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemTypeVdiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["luns","namespaces","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemTypeVdiskTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemTypeVdiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item
	// ConsistencyGroupResponseInlineRecordsInlineArrayItem
	// vdisk_type
	// VdiskType
	// luns
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeLuns captures enum value "luns"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeLuns string = "luns"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item
	// ConsistencyGroupResponseInlineRecordsInlineArrayItem
	// vdisk_type
	// VdiskType
	// namespaces
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeNamespaces captures enum value "namespaces"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeNamespaces string = "namespaces"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item
	// ConsistencyGroupResponseInlineRecordsInlineArrayItem
	// vdisk_type
	// VdiskType
	// mixed
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeMixed captures enum value "mixed"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemVdiskTypeMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateVdiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemTypeVdiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateVdiskType(formats strfmt.Registry) error {
	if swag.IsZero(o.VdiskType) { // not required
		return nil
	}

	// value enum
	if err := o.validateVdiskTypeEnum("vdisk_type", "body", *o.VdiskType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(o.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", o.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMapTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicationRelationships(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicationSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnmapFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateConsistencyGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroups); i++ {

		if o.ConsistencyGroups[i] != nil {
			if err := o.ConsistencyGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateMapTo(ctx context.Context, formats strfmt.Registry) error {

	if o.MapTo != nil {
		if err := o.MapTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("map_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateReplicated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replicated", "body", o.Replicated); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateReplicationRelationships(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication_relationships", "body", []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0(o.ReplicationRelationships)); err != nil {
		return err
	}

	for i := 0; i < len(o.ReplicationRelationships); i++ {

		if o.ReplicationRelationships[i] != nil {
			if err := o.ReplicationRelationships[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateReplicationSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication_source", "body", o.ReplicationSource); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if o.RestoreTo != nil {
		if err := o.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateUnmapFrom(ctx context.Context, formats strfmt.Registry) error {

	if o.UnmapFrom != nil {
		if err := o.UnmapFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unmap_from")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication consistency group response inline records inline array item inline application
swagger:model consistency_group_response_inline_records_inline_array_item_inline_application
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline application
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeComponentTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationComponentTypeOther string = "other"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(o.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := o.validateComponentTypeEnum("application"+"."+"component_type", "body", *o.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeOther captures enum value "other"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_application
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("application"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline application based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone Creates a clone of an existing consistency group from the current contents or an existing snapshot.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone struct {

	// guarantee
	Guarantee *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee `json:"guarantee,omitempty"`

	// Specifies if the consistency group contains any unsplit FlexClone storage units.
	// Read Only: true
	HasUnsplitFlexclones *bool `json:"has_unsplit_flexclones,omitempty"`

	// Specifies if this consistency group is a FlexClone of a consistency group.
	// Read Only: true
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// parent consistency group
	ParentConsistencyGroup *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// parent snapshot
	ParentSnapshot *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot `json:"parent_snapshot,omitempty"`

	// parent svm
	ParentSvm *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm `json:"parent_svm,omitempty"`

	// Specifies the SnapLock type for the clone consistency group.
	// Enum: ["compliance","enterprise","non_snaplock"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// Percentage of FlexClone blocks split from its parent consistency group.
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required to split the FlexClone consistency group.
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// Splits volumes after cloning. Defaults to false during POST. Only accepts true during a PATCH.
	SplitInitiated *bool `json:"split_initiated,omitempty"`

	// storage unit
	StorageUnit *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit `json:"storage_unit,omitempty"`

	// A list of unsplit FlexClone storage units in the consistency group.
	// Read Only: true
	UnsplitFlexclones []*string `json:"unsplit_flexclones"`

	// volume
	Volume *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume `json:"volume,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateParentSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentSnapshot) { // not required
		return nil
	}

	if o.ParentSnapshot != nil {
		if err := o.ParentSnapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateParentSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentSvm) { // not required
		return nil
	}

	if o.ParentSvm != nil {
		if err := o.ParentSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneTypeSnaplockTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_clone
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeCompliance captures enum value "compliance"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_clone
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeEnterprise captures enum value "enterprise"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_clone
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := o.validateSnaplockTypeEnum("clone"+"."+"snaplock_type", "body", *o.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnit) { // not required
		return nil
	}

	if o.StorageUnit != nil {
		if err := o.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHasUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsFlexclone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateHasUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"has_unsplit_flexclones", "body", o.HasUnsplitFlexclones); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateIsFlexclone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"is_flexclone", "body", o.IsFlexclone); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateParentSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentSnapshot != nil {
		if err := o.ParentSnapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateParentSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentSvm != nil {
		if err := o.ParentSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_complete_percent", "body", o.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_estimate", "body", o.SplitEstimate); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageUnit != nil {
		if err := o.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"unsplit_flexclones", "body", []*string(o.UnsplitFlexclones)); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee consistency group response inline records inline array item inline clone inline guarantee
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_guarantee
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee struct {

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline guarantee
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_clone_inline_guarantee
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeVolume captures enum value "volume"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_clone_inline_guarantee
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeNone captures enum value "none"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("clone"+"."+"guarantee"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline clone inline guarantee based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup Consistency group that is to be cloned.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_parent_consistency_group
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	Name *string `json:"name,omitempty"`

	// The name of the parent consistency group used when cloning a child consistency group.
	ParentName *string `json:"parent_name,omitempty"`

	// The unique identifier of the parent consistency group used when cloning a child consistency group.
	ParentUUID *string `json:"parent_uuid,omitempty"`

	// The unique identifier of the consistency group.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline parent consistency group
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone inline parent consistency group based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot Consistency group that is to be cloned.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_parent_snapshot
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot struct {

	// links
	Links *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks `json:"_links,omitempty"`

	// name
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline parent snapshot
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone inline parent snapshot based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks consistency group response inline records inline array item inline clone inline parent snapshot inline links
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_parent_snapshot_inline__links
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline parent snapshot inline links
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone inline parent snapshot inline links based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm SVM, applies only to SVM-scoped objects.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_parent_svm
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm struct {

	// links
	Links *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline parent svm
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone inline parent svm based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks consistency group response inline records inline array item inline clone inline parent svm inline links
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_parent_svm_inline__links
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline parent svm inline links
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline clone inline parent svm inline links based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineParentSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit Storage unit name suffix/prefix for the cloned blocks. This is applied to all the vdisks, i.e. LUNs or NVMe namespaces within the consistency group.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_storage_unit
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit struct {

	// Storage unit name prefix for cloned volume blocks.
	Prefix *string `json:"prefix,omitempty"`

	// Storage unit name suffix for cloned volume blocks.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline storage unit
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline clone inline storage unit based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume Volume name suffix/prefix for the cloned volumes.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_clone_inline_volume
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume struct {

	// Volume name prefix for cloned volumes.
	Prefix *string `json:"prefix,omitempty"`

	// Volume name suffix for cloned volumes.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline clone inline volume
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline clone inline volume based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineCloneInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo Specifies the igroup or subsystem to map the LUNs or namespaces within the consistency group. This parameter can only be used if all the storage objects within the consistency groups are either LUNs or namespaces.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_map_to
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo struct {

	// Name of the igroup or subsystem.
	// Example: igroup1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline map to
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline map to based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric Performance and capacity numbers, such as, IOPS, latency, throughput, used space, and available space.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_metric
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric struct {

	// links
	Links *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks `json:"_links,omitempty"`

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency `json:"latency,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance and capacity data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total space used in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline metric
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT15S captures enum value "PT15S"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT4M captures enum value "PT4M"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT30M captures enum value "PT30M"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT2H captures enum value "PT2H"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationP1D captures enum value "P1D"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT5M captures enum value "PT5M"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusOk captures enum value "ok"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusError captures enum value "error"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_metric
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline metric based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"available_space", "body", o.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"used_space", "body", o.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks consistency group response inline records inline array item inline metric inline links
swagger:model consistency_group_response_inline_records_inline_array_item_inline_metric_inline__links
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline metric inline links
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline metric inline links based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_metric_inline_iops
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline metric inline iops
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline metric inline iops based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency The round trip latency observed at the storage object, in microseconds.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_metric_inline_latency
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline metric inline latency
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline metric inline latency based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_metric_inline_throughput
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline metric inline throughput
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline metric inline throughput based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup The parent consistency group.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_parent_consistency_group
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline parent consistency group
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline parent consistency group based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags"`
}

// Validate validates this consistency group response inline records inline array item inline provisioning options
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(o.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(o.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline provisioning options based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_provisioning_options_inline_storage_service
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline provisioning options inline storage service
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline provisioning options inline storage service based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos consistency group response inline records inline array item inline qos
swagger:model consistency_group_response_inline_records_inline_array_item_inline_qos
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos struct {

	// policy
	Policy *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline qos
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline qos based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy The QoS policy
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_qos_inline_policy
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline qos inline policy
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline qos inline policy based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo Use to restore a consistency group to a previous snapshot
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_restore_to
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo struct {

	// snapshot
	Snapshot *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline restore to
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline restore to based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot A consistency group's snapshot
swagger:model consistency_group_response_inline_records_inline_array_item_inline_restore_to_inline_snapshot
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline restore to inline snapshot
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline restore to inline snapshot based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreToInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock consistency group response inline records inline array item inline snaplock
swagger:model consistency_group_response_inline_records_inline_array_item_inline_snaplock
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock struct {

	// The compliance clock time used to manage the SnapLock objects in the consistency group.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`

	// Expiry time of the consistency group. For consistency group with an infinite SnapLock expiry time, "9999-12-31T23:59:59" is used to denote the time.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// retention
	Retention *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the consistency group. <br>compliance &dash; A SnapLock Compliance (SLC) consistency group provides the highest level of WORM protection and an administrator cannot destroy an SLC consistency group if it contains unexpired WORM objects. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise (SLE) consistency group.<br> non_snaplock &dash; Indicates the consistency group is non-snaplock.
	// Example: enterprise
	// Read Only: true
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline snaplock
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", o.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(o.Retention) { // not required
		return nil
	}

	if o.Retention != nil {
		if err := o.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeTypePropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_snaplock
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeCompliance captures enum value "compliance"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_snaplock
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeEnterprise captures enum value "enterprise"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_snaplock
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("snaplock"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline snaplock based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComplianceClockTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateComplianceClockTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"compliance_clock_time", "body", o.ComplianceClockTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expiry_time", "body", o.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if o.Retention != nil {
		if err := o.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_snaplock_inline_retention
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to objects within a consistency group while committing them to the WORM state without an associated retention period.
	// Example: P6M
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for objects committed to the WORM state on the consistency group.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for objects within a consistency group committed to the WORM state on the consistency group.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline snaplock inline retention
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline snaplock inline retention based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace Space information for the consistency group.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_space
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline space
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline space based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics These are raw performance and space numbers, such as, IOPS, latency, throughput, used space, and available space. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_statistics
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics struct {

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// iops raw
	IopsRaw *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total used space in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline statistics
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusOk captures enum value "ok"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusError captures enum value "error"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_statistics
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline statistics based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"available_space", "body", o.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"used_space", "body", o.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_statistics_inline_iops_raw
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline statistics inline iops raw
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline statistics inline iops raw based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw The raw latency observed at the storage object, in microseconds. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_statistics_inline_latency_raw
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline statistics inline latency raw
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline statistics inline latency raw based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_statistics_inline_throughput_raw
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline statistics inline throughput raw
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline statistics inline throughput raw based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_svm
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// links
	Links *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline svm
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline svm based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks consistency group response inline records inline array item inline svm inline links
swagger:model consistency_group_response_inline_records_inline_array_item_inline_svm_inline__links
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline svm inline links
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline svm inline links based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering The tiering placement and policy definitions for volumes in this consistency group.
//
swagger:model consistency_group_response_inline_records_inline_array_item_inline_tiering
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupDeleteCollectionParamsBodyRecordsItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline tiering
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypeControlPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypePolicyPropEnum = append(consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_response_inline_records_inline_array_item_inline_tiering
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupResponseInlineRecordsInlineArrayItemInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group response inline records inline array item inline tiering based on the context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom Specify the igroup or subsystem within the consistency group from which the LUNs or namespaces will be unmapped. This parameter can only be used if all the storage objects within the consistency groups are either LUNs or namespaces.
swagger:model consistency_group_response_inline_records_inline_array_item_inline_unmap_from
*/
type ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom struct {

	// Name of the igroup or subsystem.
	// Example: subsystem1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group response inline records inline array item inline unmap from
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group response inline records inline array item inline unmap from based on context it is used
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
