// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConsistencyGroupDeleteParams creates a new ConsistencyGroupDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConsistencyGroupDeleteParams() *ConsistencyGroupDeleteParams {
	return &ConsistencyGroupDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConsistencyGroupDeleteParamsWithTimeout creates a new ConsistencyGroupDeleteParams object
// with the ability to set a timeout on a request.
func NewConsistencyGroupDeleteParamsWithTimeout(timeout time.Duration) *ConsistencyGroupDeleteParams {
	return &ConsistencyGroupDeleteParams{
		timeout: timeout,
	}
}

// NewConsistencyGroupDeleteParamsWithContext creates a new ConsistencyGroupDeleteParams object
// with the ability to set a context for a request.
func NewConsistencyGroupDeleteParamsWithContext(ctx context.Context) *ConsistencyGroupDeleteParams {
	return &ConsistencyGroupDeleteParams{
		Context: ctx,
	}
}

// NewConsistencyGroupDeleteParamsWithHTTPClient creates a new ConsistencyGroupDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewConsistencyGroupDeleteParamsWithHTTPClient(client *http.Client) *ConsistencyGroupDeleteParams {
	return &ConsistencyGroupDeleteParams{
		HTTPClient: client,
	}
}

/*
ConsistencyGroupDeleteParams contains all the parameters to send to the API endpoint

	for the consistency group delete operation.

	Typically these are written to a http.Request.
*/
type ConsistencyGroupDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   The unique identifier of the consistency group to delete.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the consistency group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupDeleteParams) WithDefaults() *ConsistencyGroupDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the consistency group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := ConsistencyGroupDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) WithTimeout(timeout time.Duration) *ConsistencyGroupDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) WithContext(ctx context.Context) *ConsistencyGroupDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) WithHTTPClient(client *http.Client) *ConsistencyGroupDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) WithReturnTimeout(returnTimeout *int64) *ConsistencyGroupDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) WithUUID(uuid string) *ConsistencyGroupDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the consistency group delete params
func (o *ConsistencyGroupDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ConsistencyGroupDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
