// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupModifyCollectionReader is a Reader for the ConsistencyGroupModifyCollection structure.
type ConsistencyGroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewConsistencyGroupModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupModifyCollectionOK creates a ConsistencyGroupModifyCollectionOK with default headers values
func NewConsistencyGroupModifyCollectionOK() *ConsistencyGroupModifyCollectionOK {
	return &ConsistencyGroupModifyCollectionOK{}
}

/*
ConsistencyGroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupModifyCollectionOK struct {
}

// IsSuccess returns true when this consistency group modify collection o k response has a 2xx status code
func (o *ConsistencyGroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group modify collection o k response has a 3xx status code
func (o *ConsistencyGroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group modify collection o k response has a 4xx status code
func (o *ConsistencyGroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group modify collection o k response has a 5xx status code
func (o *ConsistencyGroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group modify collection o k response a status code equal to that given
func (o *ConsistencyGroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group modify collection o k response
func (o *ConsistencyGroupModifyCollectionOK) Code() int {
	return 200
}

func (o *ConsistencyGroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistencyGroupModifyCollectionOK", 200)
}

func (o *ConsistencyGroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistencyGroupModifyCollectionOK", 200)
}

func (o *ConsistencyGroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConsistencyGroupModifyCollectionAccepted creates a ConsistencyGroupModifyCollectionAccepted with default headers values
func NewConsistencyGroupModifyCollectionAccepted() *ConsistencyGroupModifyCollectionAccepted {
	return &ConsistencyGroupModifyCollectionAccepted{}
}

/*
ConsistencyGroupModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ConsistencyGroupModifyCollectionAccepted struct {
	Payload *models.ConsistencyGroupJobLinkResponse
}

// IsSuccess returns true when this consistency group modify collection accepted response has a 2xx status code
func (o *ConsistencyGroupModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group modify collection accepted response has a 3xx status code
func (o *ConsistencyGroupModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group modify collection accepted response has a 4xx status code
func (o *ConsistencyGroupModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group modify collection accepted response has a 5xx status code
func (o *ConsistencyGroupModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group modify collection accepted response a status code equal to that given
func (o *ConsistencyGroupModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the consistency group modify collection accepted response
func (o *ConsistencyGroupModifyCollectionAccepted) Code() int {
	return 202
}

func (o *ConsistencyGroupModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistencyGroupModifyCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistencyGroupModifyCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupModifyCollectionAccepted) GetPayload() *models.ConsistencyGroupJobLinkResponse {
	return o.Payload
}

func (o *ConsistencyGroupModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupModifyCollectionDefault creates a ConsistencyGroupModifyCollectionDefault with default headers values
func NewConsistencyGroupModifyCollectionDefault(code int) *ConsistencyGroupModifyCollectionDefault {
	return &ConsistencyGroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ConsistencyGroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262285 | Consistency group does not support removing elements using a PATCH request. |
| 2621761 | Consistency groups with DP volumes are not supported on storage-limit enabled SVM. |
| 53411842 | Consistency group does not exist. |
| 53411843 | A consistency group with specified UUID was not found. |
| 53411844 | Specified consistency group was not found in the specified SVM. |
| 53411845 | The specified UUID and name refer to different consistency groups. |
| 53411846 | Either name or UUID must be provided.<personalities supports=unified,asar2> |
| 53411852 | A consistency group with the same identifier in the same scope exists. |
| 53411853 | Fields provided in the request conflict with each other. |
| 53411856 | Field provided is only supported when provisioning new objects. |
| 53411857 | LUNs that are not members of the application are not supported by this API. LUNs can be added to an application by adding the volume containing the LUNs to the application.</personalities> |
| 53411860 | An object with the same identifier in the same scope exists. |
| 53411861 | The specified volume does not exist in provided volume array. |
| 53411862 | Modifying existing igroups is not supported using this API. |
| 53411864 | Request content insufficient to add an existing volume to an application. |
| 53411865 | Volumes contained in one consistency group cannot be added to a different consistency group.<personalities supports=unified,asar2> |
| 53411866 | LUNs are not supported on FlexGroup volumes. |
| 53411867 | LUN name is too long after appending a unique suffix.</personalities> |
| 53411869 | Volume name is too long after appending a unique suffix.<personalities supports=unified,asar2> |
| 53411870 | When using the \"round_robin\" layout, the volume count must not be greater than the LUN count.</personalities> |
| 53411942 | The application or component type of a consistency group that has an associated SnapMirror relationship cannot be changed.<personalities supports=unified,asar2> |
| 53411959 | Volumes with snapshot locking enabled cannot be added to a consistency group.</personalities> |
| 53412027 | Failed to update the snapshot policy because the snapshot policies are not supported on the destination consistency group of SnapMirror active sync relationships. |
| 53412056 | The consistency group is not a FlexClone. |
| 53412057 | Consistency group split operation failed.<personalities supports=unified,asar2> |
| 53412058 | Failed to map or unmap because the consistency group consists of both 'luns' and 'namespaces'.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConsistencyGroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group modify collection default response has a 2xx status code
func (o *ConsistencyGroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group modify collection default response has a 3xx status code
func (o *ConsistencyGroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group modify collection default response has a 4xx status code
func (o *ConsistencyGroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group modify collection default response has a 5xx status code
func (o *ConsistencyGroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group modify collection default response a status code equal to that given
func (o *ConsistencyGroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group modify collection default response
func (o *ConsistencyGroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistency_group_modify_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups][%d] consistency_group_modify_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ConsistencyGroupModifyCollectionBody consistency group modify collection body
swagger:model ConsistencyGroupModifyCollectionBody
*/
type ConsistencyGroupModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineApplication `json:"application,omitempty"`

	// clone
	Clone *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineClone `json:"clone,omitempty"`

	// consistency group response inline records
	ConsistencyGroupResponseInlineRecords []*models.ConsistencyGroupResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A consistency group can only be associated with one direct parent consistency group.
	//
	// Max Items: 5
	// Min Items: 0
	// Unique: true
	ConsistencyGroups []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0 `json:"consistency_groups"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupModifyCollectionParamsBodyLunsItems0 `json:"luns"`

	// map to
	MapTo *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMapTo `json:"map_to,omitempty"`

	// metric
	Metric *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineMetric `json:"metric,omitempty"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// Indicates whether or not replication has been enabled on this consistency group.
	//
	// Read Only: true
	Replicated *bool `json:"replicated,omitempty"`

	// Indicates the SnapMirror relationship of this consistency group.
	//
	// Read Only: true
	ReplicationRelationships []*ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0 `json:"replication_relationships"`

	// Since support for this field is to be removed in the next release, use replication_relationships.is_source instead.
	//
	// Read Only: true
	ReplicationSource *bool `json:"replication_source,omitempty"`

	// restore to
	RestoreTo *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineRestoreTo `json:"restore_to,omitempty"`

	// snaplock
	Snaplock *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// unmap from
	UnmapFrom *models.ConsistencyGroupResponseInlineRecordsInlineArrayItemInlineUnmapFrom `json:"unmap_from,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Type of objects in the consistency group.
	// Example: luns
	// Enum: ["luns","namespaces","mixed"]
	VdiskType *string `json:"vdisk_type,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupModifyCollectionParamsBodyVolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group modify collection body
func (o *ConsistencyGroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMapTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReplicationRelationships(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnmapFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVdiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(o.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(o.Tags))

	if err := validate.MaxItems("info"+"."+"_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateConsistencyGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ConsistencyGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.ConsistencyGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ConsistencyGroupResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateConsistencyGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroups) { // not required
		return nil
	}

	iConsistencyGroupsSize := int64(len(o.ConsistencyGroups))

	if err := validate.MinItems("info"+"."+"consistency_groups", "body", iConsistencyGroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"consistency_groups", "body", iConsistencyGroupsSize, 5); err != nil {
		return err
	}

	if err := validate.UniqueItems("info"+"."+"consistency_groups", "body", o.ConsistencyGroups); err != nil {
		return err
	}

	for i := 0; i < len(o.ConsistencyGroups); i++ {
		if swag.IsZero(o.ConsistencyGroups[i]) { // not required
			continue
		}

		if o.ConsistencyGroups[i] != nil {
			if err := o.ConsistencyGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(o.Luns))

	if err := validate.MinItems("info"+"."+"luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("info"+"."+"luns", "body", o.Luns); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateMapTo(formats strfmt.Registry) error {
	if swag.IsZero(o.MapTo) { // not required
		return nil
	}

	if o.MapTo != nil {
		if err := o.MapTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "map_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(o.Namespaces))

	if err := validate.MinItems("info"+"."+"namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("info"+"."+"namespaces", "body", o.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateReplicationRelationships(formats strfmt.Registry) error {
	if swag.IsZero(o.ReplicationRelationships) { // not required
		return nil
	}

	for i := 0; i < len(o.ReplicationRelationships); i++ {
		if swag.IsZero(o.ReplicationRelationships[i]) { // not required
			continue
		}

		if o.ReplicationRelationships[i] != nil {
			if err := o.ReplicationRelationships[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(o.RestoreTo) { // not required
		return nil
	}

	if o.RestoreTo != nil {
		if err := o.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateUnmapFrom(formats strfmt.Registry) error {
	if swag.IsZero(o.UnmapFrom) { // not required
		return nil
	}

	if o.UnmapFrom != nil {
		if err := o.UnmapFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "unmap_from")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupModifyCollectionBodyTypeVdiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["luns","namespaces","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionBodyTypeVdiskTypePropEnum = append(consistencyGroupModifyCollectionBodyTypeVdiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionBody
	// ConsistencyGroupModifyCollectionBody
	// vdisk_type
	// VdiskType
	// luns
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionBodyVdiskTypeLuns captures enum value "luns"
	ConsistencyGroupModifyCollectionBodyVdiskTypeLuns string = "luns"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionBody
	// ConsistencyGroupModifyCollectionBody
	// vdisk_type
	// VdiskType
	// namespaces
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionBodyVdiskTypeNamespaces captures enum value "namespaces"
	ConsistencyGroupModifyCollectionBodyVdiskTypeNamespaces string = "namespaces"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionBody
	// ConsistencyGroupModifyCollectionBody
	// vdisk_type
	// VdiskType
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionBodyVdiskTypeMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionBodyVdiskTypeMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionBody) validateVdiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionBodyTypeVdiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateVdiskType(formats strfmt.Registry) error {
	if swag.IsZero(o.VdiskType) { // not required
		return nil
	}

	// value enum
	if err := o.validateVdiskTypeEnum("info"+"."+"vdisk_type", "body", *o.VdiskType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(o.Volumes))

	if err := validate.MinItems("info"+"."+"volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("info"+"."+"volumes", "body", o.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection body based on the context it is used
func (o *ConsistencyGroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMapTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicationRelationships(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplicationSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnmapFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateConsistencyGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroupResponseInlineRecords); i++ {

		if o.ConsistencyGroupResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateConsistencyGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroups); i++ {

		if o.ConsistencyGroups[i] != nil {
			if err := o.ConsistencyGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateMapTo(ctx context.Context, formats strfmt.Registry) error {

	if o.MapTo != nil {
		if err := o.MapTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "map_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateReplicated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replicated", "body", o.Replicated); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateReplicationRelationships(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication_relationships", "body", []*ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0(o.ReplicationRelationships)); err != nil {
		return err
	}

	for i := 0; i < len(o.ReplicationRelationships); i++ {

		if o.ReplicationRelationships[i] != nil {
			if err := o.ReplicationRelationships[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateReplicationSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication_source", "body", o.ReplicationSource); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if o.RestoreTo != nil {
		if err := o.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateUnmapFrom(ctx context.Context, formats strfmt.Registry) error {

	if o.UnmapFrom != nil {
		if err := o.UnmapFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "unmap_from")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionBody) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0 consistency group modify collection params body consistency groups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application `json:"application,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0 `json:"luns"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos `json:"qos,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo `json:"restore_to,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space `json:"space,omitempty"`

	// svm
	Svm *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering `json:"tiering,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group modify collection params body consistency groups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(o.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(o.Tags))

	if err := validate.MaxItems("_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(o.Luns))

	if err := validate.MinItems("luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", o.Luns); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(o.Namespaces))

	if err := validate.MinItems("namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", o.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(o.RestoreTo) { // not required
		return nil
	}

	if o.RestoreTo != nil {
		if err := o.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(o.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", o.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if o.RestoreTo != nil {
		if err := o.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application consistency group modify collection params body consistency groups items0 application
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 application
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationComponentTypeOther string = "other"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(o.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := o.validateComponentTypeEnum("application"+"."+"component_type", "body", *o.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeOther captures enum value "other"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("application"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 application based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Application
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 clone
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 clone based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 clone source
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 luns items0 clone source based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos consistency group modify collection params body consistency groups items0 luns items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 luns items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 namespaces items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0 status
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 namespaces items0 status based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 namespaces items0 subsystem map
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup The parent consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 parent consistency group
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 parent consistency group based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(o.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(o.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos consistency group modify collection params body consistency groups items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo Use to restore a consistency group to a previous snapshot
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 restore to
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 restore to based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot A consistency group's snapshot
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 restore to snapshot
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 restore to snapshot based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0RestoreToSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space Space information for the consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 space based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm struct {

	// links
	Links *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 svm
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 svm based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks consistency group modify collection params body consistency groups items0 svm links
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 svm links
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 svm links based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering The tiering placement and policy definitions for volumes in this consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0 consistency group modify collection params body consistency groups items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0 consistency group modify collection params body consistency groups items0 volumes items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 nas
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 nas based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs consistency group modify collection params body consistency groups items0 volumes items0 nas cifs
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 nas cifs
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 nas export policy
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent consistency group modify collection params body consistency groups items0 volumes items0 nas junction parent
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 nas junction parent
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space consistency group modify collection params body consistency groups items0 volumes items0 space
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body consistency groups items0 volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 consistency group modify collection params body consistency groups items0 volumes items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body consistency groups items0 volumes items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body consistency groups items0 volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0 struct {

	// clone
	Clone *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyLunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyLunsItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyLunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyLunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone struct {

	// source
	Source *ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 clone
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 clone based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 clone source
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body luns items0 clone source based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 lun maps items0
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 lun maps items0 igroup
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group modify collection params body luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos consistency group modify collection params body luns items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body luns items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyLunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyNamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyNamespacesItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyNamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyNamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body namespaces items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body namespaces items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0 status
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyNamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body namespaces items0 status based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap
*/
type ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group modify collection params body namespaces items0 subsystem map
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyNamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0 consistency group modify collection params body records items0 consistency groups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application `json:"application,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 `json:"luns"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos `json:"qos,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo `json:"restore_to,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space `json:"space,omitempty"`

	// svm
	Svm *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering `json:"tiering,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(o.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(o.Tags))

	if err := validate.MaxItems("_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	if o.Application != nil {
		if err := o.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(o.Luns))

	if err := validate.MinItems("luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", o.Luns); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(o.Namespaces))

	if err := validate.MinItems("namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", o.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ParentConsistencyGroup) { // not required
		return nil
	}

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(o.RestoreTo) { // not required
		return nil
	}

	if o.RestoreTo != nil {
		if err := o.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(o.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", o.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Application != nil {
		if err := o.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ParentConsistencyGroup != nil {
		if err := o.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if o.RestoreTo != nil {
		if err := o.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application consistency group modify collection params body records items0 consistency groups items0 application
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 application
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationComponentTypeOther string = "other"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(o.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := o.validateComponentTypeEnum("application"+"."+"component_type", "body", *o.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOther captures enum value "other"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("application"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 application based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Application
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 clone
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 clone based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 clone source
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 clone source based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos consistency group modify collection params body records items0 consistency groups items0 luns items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 luns items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 status
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 status based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 subsystem map
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup The parent consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 parent consistency group
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 parent consistency group based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(o.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(o.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos consistency group modify collection params body records items0 consistency groups items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo Use to restore a consistency group to a previous snapshot
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 restore to
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 restore to based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot A consistency group's snapshot
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 restore to snapshot
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 restore to snapshot based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0RestoreToSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space Space information for the consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 space based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm struct {

	// links
	Links *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 svm
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 svm based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks consistency group modify collection params body records items0 consistency groups items0 svm links
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 svm links
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 svm links based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering The tiering placement and policy definitions for volumes in this consistency group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 consistency group modify collection params body records items0 consistency groups items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 consistency group modify collection params body records items0 consistency groups items0 volumes items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas cifs
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas cifs
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas export policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas junction parent
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas junction parent
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space consistency group modify collection params body records items0 consistency groups items0 volumes items0 space
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 consistency groups items0 volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 consistency group modify collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 consistency groups items0 volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMaps); i++ {
		if swag.IsZero(o.LunMaps[i]) { // not required
			continue
		}

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMaps); i++ {

		if o.LunMaps[i] != nil {
			if err := o.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 clone
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 clone based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 clone source
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 luns items0 clone source based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 lun maps items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 lun maps items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(o.Igroups); i++ {
		if swag.IsZero(o.Igroups[i]) { // not required
			continue
		}

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(o.Initiators); i++ {
		if swag.IsZero(o.Initiators[i]) { // not required
			continue
		}

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("igroup"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("igroup"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Igroups); i++ {

		if o.Igroups[i] != nil {
			if err := o.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Initiators); i++ {

		if o.Initiators[i] != nil {
			if err := o.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group modify collection params body records items0 luns items0 lun maps items0 igroup igroups items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup igroups items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup initiators items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 luns items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos consistency group modify collection params body records items0 luns items0 qos
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", o.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", o.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", o.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", o.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space The storage space related properties of the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 luns items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 luns items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 namespaces items0 provisioning options based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 namespaces items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0 space guarantee
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 namespaces items0 space guarantee based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0 status
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 namespaces items0 status based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *models.ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 namespaces items0 subsystem map
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 namespaces items0 subsystem map based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0 consistency group modify collection params body records items0 replication relationships items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Indicates whether or not this consistency group is protected by SVM DR.
	//
	// Read Only: true
	IsProtectedBySvmDr *bool `json:"is_protected_by_svm_dr,omitempty"`

	// Indicates whether or not this consistency group is the source for replication.
	//
	// Read Only: true
	IsSource *bool `json:"is_source,omitempty"`

	// The unique identifier of the SnapMirror relationship.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 replication relationships items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 replication relationships items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtectedBySvmDr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateIsProtectedBySvmDr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_protected_by_svm_dr", "body", o.IsProtectedBySvmDr); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateIsSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_source", "body", o.IsSource); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0ReplicationRelationshipsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0 consistency group modify collection params body records items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0 consistency group modify collection params body records items0 volumes items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 nas
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 nas based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs consistency group modify collection params body records items0 volumes items0 nas cifs
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 nas cifs
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 nas export policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent consistency group modify collection params body records items0 volumes items0 nas junction parent
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 nas junction parent
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space consistency group modify collection params body records items0 volumes items0 space
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body records items0 volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 consistency group modify collection params body records items0 volumes items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body records items0 volumes items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body records items0 volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyRecordsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0 consistency group modify collection params body replication relationships items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0 struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Indicates whether or not this consistency group is protected by SVM DR.
	//
	// Read Only: true
	IsProtectedBySvmDr *bool `json:"is_protected_by_svm_dr,omitempty"`

	// Indicates whether or not this consistency group is the source for replication.
	//
	// Read Only: true
	IsSource *bool `json:"is_source,omitempty"`

	// The unique identifier of the SnapMirror relationship.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body replication relationships items0
func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body replication relationships items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtectedBySvmDr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) contextValidateIsProtectedBySvmDr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_protected_by_svm_dr", "body", o.IsProtectedBySvmDr); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) contextValidateIsSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_source", "body", o.IsSource); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyReplicationRelationshipsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0 consistency group modify collection params body tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0 consistency group modify collection params body volumes items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(o.Qos) { // not required
		return nil
	}

	if o.Qos != nil {
		if err := o.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if o.Qos != nil {
		if err := o.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 nas
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ExportPolicy) { // not required
		return nil
	}

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(o.JunctionParent) { // not required
		return nil
	}

	if o.JunctionParent != nil {
		if err := o.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyVolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyVolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupModifyCollectionParamsBodyVolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyVolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *o.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 nas based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ExportPolicy != nil {
		if err := o.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if o.JunctionParent != nil {
		if err := o.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs consistency group modify collection params body volumes items0 nas cifs
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs struct {

	// shares
	Shares []*models.ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group modify collection params body volumes items0 nas cifs
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(o.Shares) { // not required
		return nil
	}

	for i := 0; i < len(o.Shares); i++ {
		if swag.IsZero(o.Shares[i]) { // not required
			continue
		}

		if o.Shares[i] != nil {
			if err := o.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 nas cifs based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Shares); i++ {

		if o.Shares[i] != nil {
			if err := o.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*models.ExportRules `json:"rules"`
}

// Validate validates this consistency group modify collection params body volumes items0 nas export policy
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 nas export policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent consistency group modify collection params body volumes items0 nas junction parent
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 nas junction parent
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 nas junction parent based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions Options that are applied to the operation.
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 provisioning options
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("provisioning_options"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 provisioning options based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 provisioning options storage service
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group modify collection params body volumes items0 provisioning options storage service based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos The QoS policy for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 qos
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 qos based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy The QoS policy
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 qos policy
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 qos policy based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space consistency group modify collection params body volumes items0 space
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 space
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 space based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 tiering
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypeControlPropEnum = append(consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupModifyCollectionParamsBodyVolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group modify collection params body volumes items0 tiering based on the context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupModifyCollectionParamsBodyVolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0 consistency group modify collection params body volumes items0 tiering object stores items0
swagger:model ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0
*/
type ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group modify collection params body volumes items0 tiering object stores items0
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group modify collection params body volumes items0 tiering object stores items0 based on context it is used
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupModifyCollectionParamsBodyVolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *Co