// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConsistencyGroupSnapshotCollectionGetParams creates a new ConsistencyGroupSnapshotCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConsistencyGroupSnapshotCollectionGetParams() *ConsistencyGroupSnapshotCollectionGetParams {
	return &ConsistencyGroupSnapshotCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConsistencyGroupSnapshotCollectionGetParamsWithTimeout creates a new ConsistencyGroupSnapshotCollectionGetParams object
// with the ability to set a timeout on a request.
func NewConsistencyGroupSnapshotCollectionGetParamsWithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotCollectionGetParams {
	return &ConsistencyGroupSnapshotCollectionGetParams{
		timeout: timeout,
	}
}

// NewConsistencyGroupSnapshotCollectionGetParamsWithContext creates a new ConsistencyGroupSnapshotCollectionGetParams object
// with the ability to set a context for a request.
func NewConsistencyGroupSnapshotCollectionGetParamsWithContext(ctx context.Context) *ConsistencyGroupSnapshotCollectionGetParams {
	return &ConsistencyGroupSnapshotCollectionGetParams{
		Context: ctx,
	}
}

// NewConsistencyGroupSnapshotCollectionGetParamsWithHTTPClient creates a new ConsistencyGroupSnapshotCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewConsistencyGroupSnapshotCollectionGetParamsWithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotCollectionGetParams {
	return &ConsistencyGroupSnapshotCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ConsistencyGroupSnapshotCollectionGetParams contains all the parameters to send to the API endpoint

	for the consistency group snapshot collection get operation.

	Typically these are written to a http.Request.
*/
type ConsistencyGroupSnapshotCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConsistencyGroupName.

	   Filter by consistency_group.name
	*/
	ConsistencyGroupName *string

	/* ConsistencyGroupUUID.

	   The unique identifier of the consistency group to retrieve.

	*/
	ConsistencyGroupUUID string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *bool

	/* LunsName.

	   Filter by luns.name
	*/
	LunsName *string

	/* LunsUUID.

	   Filter by luns.uuid
	*/
	LunsUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MissingLunsName.

	   Filter by missing_luns.name
	*/
	MissingLunsName *string

	/* MissingLunsUUID.

	   Filter by missing_luns.uuid
	*/
	MissingLunsUUID *string

	/* MissingNamespacesName.

	   Filter by missing_namespaces.name
	*/
	MissingNamespacesName *string

	/* MissingNamespacesUUID.

	   Filter by missing_namespaces.uuid
	*/
	MissingNamespacesUUID *string

	/* MissingVolumesName.

	   Filter by missing_volumes.name
	*/
	MissingVolumesName *string

	/* MissingVolumesUUID.

	   Filter by missing_volumes.uuid
	*/
	MissingVolumesUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NamespacesName.

	   Filter by namespaces.name
	*/
	NamespacesName *string

	/* NamespacesUUID.

	   Filter by namespaces.uuid
	*/
	NamespacesUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReclaimableSpace.

	   Filter by reclaimable_space
	*/
	ReclaimableSpace *int64

	/* RestoreSize.

	   Filter by restore_size
	*/
	RestoreSize *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SnaplockExpired.

	   Filter by snaplock.expired
	*/
	SnaplockExpired *bool

	/* SnaplockExpiryTime.

	   Filter by snaplock.expiry_time
	*/
	SnaplockExpiryTime *string

	/* SnaplockTimeUntilExpiry.

	   Filter by snaplock.time_until_expiry
	*/
	SnaplockTimeUntilExpiry *string

	/* SnapmirrorLabel.

	   Filter by snapmirror_label
	*/
	SnapmirrorLabel *string

	/* SnapshotVolumesSnapshotName.

	   Filter by snapshot_volumes.snapshot.name
	*/
	SnapshotVolumesSnapshotName *string

	/* SnapshotVolumesSnapshotUUID.

	   Filter by snapshot_volumes.snapshot.uuid
	*/
	SnapshotVolumesSnapshotUUID *string

	/* SnapshotVolumesVolumeName.

	   Filter by snapshot_volumes.volume.name
	*/
	SnapshotVolumesVolumeName *string

	/* SnapshotVolumesVolumeUUID.

	   Filter by snapshot_volumes.volume.uuid
	*/
	SnapshotVolumesVolumeUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WriteFence.

	   Filter by write_fence
	*/
	WriteFence *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the consistency group snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithDefaults() *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the consistency group snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ConsistencyGroupSnapshotCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithContext(ctx context.Context) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithComment(comment *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithConsistencyGroupName(consistencyGroupName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetConsistencyGroupName(consistencyGroupName)
	return o
}

// SetConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetConsistencyGroupName(consistencyGroupName *string) {
	o.ConsistencyGroupName = consistencyGroupName
}

// WithConsistencyGroupUUID adds the consistencyGroupUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithConsistencyGroupUUID(consistencyGroupUUID string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetConsistencyGroupUUID(consistencyGroupUUID)
	return o
}

// SetConsistencyGroupUUID adds the consistencyGroupUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetConsistencyGroupUUID(consistencyGroupUUID string) {
	o.ConsistencyGroupUUID = consistencyGroupUUID
}

// WithConsistencyType adds the consistencyType to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithConsistencyType(consistencyType *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithCreateTime adds the createTime to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithCreateTime(createTime *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithFields adds the fields to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithFields(fields []string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsPartial adds the isPartial to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithIsPartial(isPartial *bool) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetIsPartial(isPartial *bool) {
	o.IsPartial = isPartial
}

// WithLunsName adds the lunsName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithLunsName(lunsName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetLunsName(lunsName)
	return o
}

// SetLunsName adds the lunsName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetLunsName(lunsName *string) {
	o.LunsName = lunsName
}

// WithLunsUUID adds the lunsUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithLunsUUID(lunsUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetLunsUUID(lunsUUID)
	return o
}

// SetLunsUUID adds the lunsUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetLunsUUID(lunsUUID *string) {
	o.LunsUUID = lunsUUID
}

// WithMaxRecords adds the maxRecords to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMaxRecords(maxRecords *int64) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMissingLunsName adds the missingLunsName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingLunsName(missingLunsName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingLunsName(missingLunsName)
	return o
}

// SetMissingLunsName adds the missingLunsName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingLunsName(missingLunsName *string) {
	o.MissingLunsName = missingLunsName
}

// WithMissingLunsUUID adds the missingLunsUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingLunsUUID(missingLunsUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingLunsUUID(missingLunsUUID)
	return o
}

// SetMissingLunsUUID adds the missingLunsUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingLunsUUID(missingLunsUUID *string) {
	o.MissingLunsUUID = missingLunsUUID
}

// WithMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingNamespacesName(missingNamespacesName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingNamespacesName(missingNamespacesName)
	return o
}

// SetMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingNamespacesName(missingNamespacesName *string) {
	o.MissingNamespacesName = missingNamespacesName
}

// WithMissingNamespacesUUID adds the missingNamespacesUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingNamespacesUUID(missingNamespacesUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingNamespacesUUID(missingNamespacesUUID)
	return o
}

// SetMissingNamespacesUUID adds the missingNamespacesUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingNamespacesUUID(missingNamespacesUUID *string) {
	o.MissingNamespacesUUID = missingNamespacesUUID
}

// WithMissingVolumesName adds the missingVolumesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingVolumesName(missingVolumesName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingVolumesName(missingVolumesName)
	return o
}

// SetMissingVolumesName adds the missingVolumesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingVolumesName(missingVolumesName *string) {
	o.MissingVolumesName = missingVolumesName
}

// WithMissingVolumesUUID adds the missingVolumesUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithMissingVolumesUUID(missingVolumesUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetMissingVolumesUUID(missingVolumesUUID)
	return o
}

// SetMissingVolumesUUID adds the missingVolumesUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetMissingVolumesUUID(missingVolumesUUID *string) {
	o.MissingVolumesUUID = missingVolumesUUID
}

// WithName adds the name to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithName(name *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNamespacesName adds the namespacesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithNamespacesName(namespacesName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetNamespacesName(namespacesName)
	return o
}

// SetNamespacesName adds the namespacesName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetNamespacesName(namespacesName *string) {
	o.NamespacesName = namespacesName
}

// WithNamespacesUUID adds the namespacesUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithNamespacesUUID(namespacesUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetNamespacesUUID(namespacesUUID)
	return o
}

// SetNamespacesUUID adds the namespacesUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetNamespacesUUID(namespacesUUID *string) {
	o.NamespacesUUID = namespacesUUID
}

// WithOrderBy adds the orderBy to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithOrderBy(orderBy []string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReclaimableSpace adds the reclaimableSpace to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithReclaimableSpace(reclaimableSpace *int64) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetReclaimableSpace(reclaimableSpace)
	return o
}

// SetReclaimableSpace adds the reclaimableSpace to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetReclaimableSpace(reclaimableSpace *int64) {
	o.ReclaimableSpace = reclaimableSpace
}

// WithRestoreSize adds the restoreSize to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithRestoreSize(restoreSize *int64) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetRestoreSize(restoreSize)
	return o
}

// SetRestoreSize adds the restoreSize to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetRestoreSize(restoreSize *int64) {
	o.RestoreSize = restoreSize
}

// WithReturnRecords adds the returnRecords to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithReturnRecords(returnRecords *bool) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSnaplockExpired adds the snaplockExpired to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnaplockExpired(snaplockExpired *bool) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnaplockExpired(snaplockExpired)
	return o
}

// SetSnaplockExpired adds the snaplockExpired to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnaplockExpired(snaplockExpired *bool) {
	o.SnaplockExpired = snaplockExpired
}

// WithSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnaplockExpiryTime(snaplockExpiryTime *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnaplockExpiryTime(snaplockExpiryTime)
	return o
}

// SetSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnaplockExpiryTime(snaplockExpiryTime *string) {
	o.SnaplockExpiryTime = snaplockExpiryTime
}

// WithSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry)
	return o
}

// SetSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) {
	o.SnaplockTimeUntilExpiry = snaplockTimeUntilExpiry
}

// WithSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnapmirrorLabel(snapmirrorLabel *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnapmirrorLabel(snapmirrorLabel)
	return o
}

// SetSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnapmirrorLabel(snapmirrorLabel *string) {
	o.SnapmirrorLabel = snapmirrorLabel
}

// WithSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName)
	return o
}

// SetSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) {
	o.SnapshotVolumesSnapshotName = snapshotVolumesSnapshotName
}

// WithSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID)
	return o
}

// SetSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) {
	o.SnapshotVolumesSnapshotUUID = snapshotVolumesSnapshotUUID
}

// WithSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName)
	return o
}

// SetSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) {
	o.SnapshotVolumesVolumeName = snapshotVolumesVolumeName
}

// WithSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID)
	return o
}

// SetSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) {
	o.SnapshotVolumesVolumeUUID = snapshotVolumesVolumeUUID
}

// WithSvmName adds the svmName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSvmName(svmName *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithSvmUUID(svmUUID *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithUUID(uuid *string) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWriteFence adds the writeFence to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) WithWriteFence(writeFence *bool) *ConsistencyGroupSnapshotCollectionGetParams {
	o.SetWriteFence(writeFence)
	return o
}

// SetWriteFence adds the writeFence to the consistency group snapshot collection get params
func (o *ConsistencyGroupSnapshotCollectionGetParams) SetWriteFence(writeFence *bool) {
	o.WriteFence = writeFence
}

// WriteToRequest writes these params to a swagger request
func (o *ConsistencyGroupSnapshotCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupName != nil {

		// query param consistency_group.name
		var qrConsistencyGroupName string

		if o.ConsistencyGroupName != nil {
			qrConsistencyGroupName = *o.ConsistencyGroupName
		}
		qConsistencyGroupName := qrConsistencyGroupName
		if qConsistencyGroupName != "" {

			if err := r.SetQueryParam("consistency_group.name", qConsistencyGroupName); err != nil {
				return err
			}
		}
	}

	// path param consistency_group.uuid
	if err := r.SetPathParam("consistency_group.uuid", o.ConsistencyGroupUUID); err != nil {
		return err
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial bool

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := swag.FormatBool(qrIsPartial)
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.LunsName != nil {

		// query param luns.name
		var qrLunsName string

		if o.LunsName != nil {
			qrLunsName = *o.LunsName
		}
		qLunsName := qrLunsName
		if qLunsName != "" {

			if err := r.SetQueryParam("luns.name", qLunsName); err != nil {
				return err
			}
		}
	}

	if o.LunsUUID != nil {

		// query param luns.uuid
		var qrLunsUUID string

		if o.LunsUUID != nil {
			qrLunsUUID = *o.LunsUUID
		}
		qLunsUUID := qrLunsUUID
		if qLunsUUID != "" {

			if err := r.SetQueryParam("luns.uuid", qLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsName != nil {

		// query param missing_luns.name
		var qrMissingLunsName string

		if o.MissingLunsName != nil {
			qrMissingLunsName = *o.MissingLunsName
		}
		qMissingLunsName := qrMissingLunsName
		if qMissingLunsName != "" {

			if err := r.SetQueryParam("missing_luns.name", qMissingLunsName); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsUUID != nil {

		// query param missing_luns.uuid
		var qrMissingLunsUUID string

		if o.MissingLunsUUID != nil {
			qrMissingLunsUUID = *o.MissingLunsUUID
		}
		qMissingLunsUUID := qrMissingLunsUUID
		if qMissingLunsUUID != "" {

			if err := r.SetQueryParam("missing_luns.uuid", qMissingLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesName != nil {

		// query param missing_namespaces.name
		var qrMissingNamespacesName string

		if o.MissingNamespacesName != nil {
			qrMissingNamespacesName = *o.MissingNamespacesName
		}
		qMissingNamespacesName := qrMissingNamespacesName
		if qMissingNamespacesName != "" {

			if err := r.SetQueryParam("missing_namespaces.name", qMissingNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesUUID != nil {

		// query param missing_namespaces.uuid
		var qrMissingNamespacesUUID string

		if o.MissingNamespacesUUID != nil {
			qrMissingNamespacesUUID = *o.MissingNamespacesUUID
		}
		qMissingNamespacesUUID := qrMissingNamespacesUUID
		if qMissingNamespacesUUID != "" {

			if err := r.SetQueryParam("missing_namespaces.uuid", qMissingNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesName != nil {

		// query param missing_volumes.name
		var qrMissingVolumesName string

		if o.MissingVolumesName != nil {
			qrMissingVolumesName = *o.MissingVolumesName
		}
		qMissingVolumesName := qrMissingVolumesName
		if qMissingVolumesName != "" {

			if err := r.SetQueryParam("missing_volumes.name", qMissingVolumesName); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesUUID != nil {

		// query param missing_volumes.uuid
		var qrMissingVolumesUUID string

		if o.MissingVolumesUUID != nil {
			qrMissingVolumesUUID = *o.MissingVolumesUUID
		}
		qMissingVolumesUUID := qrMissingVolumesUUID
		if qMissingVolumesUUID != "" {

			if err := r.SetQueryParam("missing_volumes.uuid", qMissingVolumesUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesName != nil {

		// query param namespaces.name
		var qrNamespacesName string

		if o.NamespacesName != nil {
			qrNamespacesName = *o.NamespacesName
		}
		qNamespacesName := qrNamespacesName
		if qNamespacesName != "" {

			if err := r.SetQueryParam("namespaces.name", qNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesUUID != nil {

		// query param namespaces.uuid
		var qrNamespacesUUID string

		if o.NamespacesUUID != nil {
			qrNamespacesUUID = *o.NamespacesUUID
		}
		qNamespacesUUID := qrNamespacesUUID
		if qNamespacesUUID != "" {

			if err := r.SetQueryParam("namespaces.uuid", qNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReclaimableSpace != nil {

		// query param reclaimable_space
		var qrReclaimableSpace int64

		if o.ReclaimableSpace != nil {
			qrReclaimableSpace = *o.ReclaimableSpace
		}
		qReclaimableSpace := swag.FormatInt64(qrReclaimableSpace)
		if qReclaimableSpace != "" {

			if err := r.SetQueryParam("reclaimable_space", qReclaimableSpace); err != nil {
				return err
			}
		}
	}

	if o.RestoreSize != nil {

		// query param restore_size
		var qrRestoreSize int64

		if o.RestoreSize != nil {
			qrRestoreSize = *o.RestoreSize
		}
		qRestoreSize := swag.FormatInt64(qrRestoreSize)
		if qRestoreSize != "" {

			if err := r.SetQueryParam("restore_size", qRestoreSize); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpired != nil {

		// query param snaplock.expired
		var qrSnaplockExpired bool

		if o.SnaplockExpired != nil {
			qrSnaplockExpired = *o.SnaplockExpired
		}
		qSnaplockExpired := swag.FormatBool(qrSnaplockExpired)
		if qSnaplockExpired != "" {

			if err := r.SetQueryParam("snaplock.expired", qSnaplockExpired); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpiryTime != nil {

		// query param snaplock.expiry_time
		var qrSnaplockExpiryTime string

		if o.SnaplockExpiryTime != nil {
			qrSnaplockExpiryTime = *o.SnaplockExpiryTime
		}
		qSnaplockExpiryTime := qrSnaplockExpiryTime
		if qSnaplockExpiryTime != "" {

			if err := r.SetQueryParam("snaplock.expiry_time", qSnaplockExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.SnaplockTimeUntilExpiry != nil {

		// query param snaplock.time_until_expiry
		var qrSnaplockTimeUntilExpiry string

		if o.SnaplockTimeUntilExpiry != nil {
			qrSnaplockTimeUntilExpiry = *o.SnaplockTimeUntilExpiry
		}
		qSnaplockTimeUntilExpiry := qrSnaplockTimeUntilExpiry
		if qSnaplockTimeUntilExpiry != "" {

			if err := r.SetQueryParam("snaplock.time_until_expiry", qSnaplockTimeUntilExpiry); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorLabel != nil {

		// query param snapmirror_label
		var qrSnapmirrorLabel string

		if o.SnapmirrorLabel != nil {
			qrSnapmirrorLabel = *o.SnapmirrorLabel
		}
		qSnapmirrorLabel := qrSnapmirrorLabel
		if qSnapmirrorLabel != "" {

			if err := r.SetQueryParam("snapmirror_label", qSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotName != nil {

		// query param snapshot_volumes.snapshot.name
		var qrSnapshotVolumesSnapshotName string

		if o.SnapshotVolumesSnapshotName != nil {
			qrSnapshotVolumesSnapshotName = *o.SnapshotVolumesSnapshotName
		}
		qSnapshotVolumesSnapshotName := qrSnapshotVolumesSnapshotName
		if qSnapshotVolumesSnapshotName != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.name", qSnapshotVolumesSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotUUID != nil {

		// query param snapshot_volumes.snapshot.uuid
		var qrSnapshotVolumesSnapshotUUID string

		if o.SnapshotVolumesSnapshotUUID != nil {
			qrSnapshotVolumesSnapshotUUID = *o.SnapshotVolumesSnapshotUUID
		}
		qSnapshotVolumesSnapshotUUID := qrSnapshotVolumesSnapshotUUID
		if qSnapshotVolumesSnapshotUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.uuid", qSnapshotVolumesSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeName != nil {

		// query param snapshot_volumes.volume.name
		var qrSnapshotVolumesVolumeName string

		if o.SnapshotVolumesVolumeName != nil {
			qrSnapshotVolumesVolumeName = *o.SnapshotVolumesVolumeName
		}
		qSnapshotVolumesVolumeName := qrSnapshotVolumesVolumeName
		if qSnapshotVolumesVolumeName != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.name", qSnapshotVolumesVolumeName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeUUID != nil {

		// query param snapshot_volumes.volume.uuid
		var qrSnapshotVolumesVolumeUUID string

		if o.SnapshotVolumesVolumeUUID != nil {
			qrSnapshotVolumesVolumeUUID = *o.SnapshotVolumesVolumeUUID
		}
		qSnapshotVolumesVolumeUUID := qrSnapshotVolumesVolumeUUID
		if qSnapshotVolumesVolumeUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.uuid", qSnapshotVolumesVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WriteFence != nil {

		// query param write_fence
		var qrWriteFence bool

		if o.WriteFence != nil {
			qrWriteFence = *o.WriteFence
		}
		qWriteFence := swag.FormatBool(qrWriteFence)
		if qWriteFence != "" {

			if err := r.SetQueryParam("write_fence", qWriteFence); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamConsistencyGroupSnapshotCollectionGet binds the parameter fields
func (o *ConsistencyGroupSnapshotCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamConsistencyGroupSnapshotCollectionGet binds the parameter order_by
func (o *ConsistencyGroupSnapshotCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
