// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupSnapshotCollectionGetReader is a Reader for the ConsistencyGroupSnapshotCollectionGet structure.
type ConsistencyGroupSnapshotCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupSnapshotCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupSnapshotCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupSnapshotCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupSnapshotCollectionGetOK creates a ConsistencyGroupSnapshotCollectionGetOK with default headers values
func NewConsistencyGroupSnapshotCollectionGetOK() *ConsistencyGroupSnapshotCollectionGetOK {
	return &ConsistencyGroupSnapshotCollectionGetOK{}
}

/*
ConsistencyGroupSnapshotCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupSnapshotCollectionGetOK struct {
	Payload *models.ConsistencyGroupSnapshotResponse
}

// IsSuccess returns true when this consistency group snapshot collection get o k response has a 2xx status code
func (o *ConsistencyGroupSnapshotCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot collection get o k response has a 3xx status code
func (o *ConsistencyGroupSnapshotCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot collection get o k response has a 4xx status code
func (o *ConsistencyGroupSnapshotCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot collection get o k response has a 5xx status code
func (o *ConsistencyGroupSnapshotCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot collection get o k response a status code equal to that given
func (o *ConsistencyGroupSnapshotCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group snapshot collection get o k response
func (o *ConsistencyGroupSnapshotCollectionGetOK) Code() int {
	return 200
}

func (o *ConsistencyGroupSnapshotCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotCollectionGetOK %s", 200, payload)
}

func (o *ConsistencyGroupSnapshotCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotCollectionGetOK %s", 200, payload)
}

func (o *ConsistencyGroupSnapshotCollectionGetOK) GetPayload() *models.ConsistencyGroupSnapshotResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupSnapshotResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupSnapshotCollectionGetDefault creates a ConsistencyGroupSnapshotCollectionGetDefault with default headers values
func NewConsistencyGroupSnapshotCollectionGetDefault(code int) *ConsistencyGroupSnapshotCollectionGetDefault {
	return &ConsistencyGroupSnapshotCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ConsistencyGroupSnapshotCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ConsistencyGroupSnapshotCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group snapshot collection get default response has a 2xx status code
func (o *ConsistencyGroupSnapshotCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group snapshot collection get default response has a 3xx status code
func (o *ConsistencyGroupSnapshotCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group snapshot collection get default response has a 4xx status code
func (o *ConsistencyGroupSnapshotCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group snapshot collection get default response has a 5xx status code
func (o *ConsistencyGroupSnapshotCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group snapshot collection get default response a status code equal to that given
func (o *ConsistencyGroupSnapshotCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group snapshot collection get default response
func (o *ConsistencyGroupSnapshotCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupSnapshotCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_collection_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_collection_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
