// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConsistencyGroupSnapshotDeleteCollectionParams creates a new ConsistencyGroupSnapshotDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConsistencyGroupSnapshotDeleteCollectionParams() *ConsistencyGroupSnapshotDeleteCollectionParams {
	return &ConsistencyGroupSnapshotDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConsistencyGroupSnapshotDeleteCollectionParamsWithTimeout creates a new ConsistencyGroupSnapshotDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewConsistencyGroupSnapshotDeleteCollectionParamsWithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotDeleteCollectionParams {
	return &ConsistencyGroupSnapshotDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewConsistencyGroupSnapshotDeleteCollectionParamsWithContext creates a new ConsistencyGroupSnapshotDeleteCollectionParams object
// with the ability to set a context for a request.
func NewConsistencyGroupSnapshotDeleteCollectionParamsWithContext(ctx context.Context) *ConsistencyGroupSnapshotDeleteCollectionParams {
	return &ConsistencyGroupSnapshotDeleteCollectionParams{
		Context: ctx,
	}
}

// NewConsistencyGroupSnapshotDeleteCollectionParamsWithHTTPClient creates a new ConsistencyGroupSnapshotDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewConsistencyGroupSnapshotDeleteCollectionParamsWithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotDeleteCollectionParams {
	return &ConsistencyGroupSnapshotDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ConsistencyGroupSnapshotDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the consistency group snapshot delete collection operation.

	Typically these are written to a http.Request.
*/
type ConsistencyGroupSnapshotDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConsistencyGroupName.

	   Filter by consistency_group.name
	*/
	ConsistencyGroupName *string

	/* ConsistencyGroupUUID.

	   The unique identifier of the consistency group to retrieve.

	*/
	ConsistencyGroupUUID string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Info.

	   Info specification
	*/
	Info ConsistencyGroupSnapshotDeleteCollectionBody

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *bool

	/* LunsName.

	   Filter by luns.name
	*/
	LunsName *string

	/* LunsUUID.

	   Filter by luns.uuid
	*/
	LunsUUID *string

	/* MissingLunsName.

	   Filter by missing_luns.name
	*/
	MissingLunsName *string

	/* MissingLunsUUID.

	   Filter by missing_luns.uuid
	*/
	MissingLunsUUID *string

	/* MissingNamespacesName.

	   Filter by missing_namespaces.name
	*/
	MissingNamespacesName *string

	/* MissingNamespacesUUID.

	   Filter by missing_namespaces.uuid
	*/
	MissingNamespacesUUID *string

	/* MissingVolumesName.

	   Filter by missing_volumes.name
	*/
	MissingVolumesName *string

	/* MissingVolumesUUID.

	   Filter by missing_volumes.uuid
	*/
	MissingVolumesUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NamespacesName.

	   Filter by namespaces.name
	*/
	NamespacesName *string

	/* NamespacesUUID.

	   Filter by namespaces.uuid
	*/
	NamespacesUUID *string

	/* ReclaimableSpace.

	   Filter by reclaimable_space
	*/
	ReclaimableSpace *int64

	/* RestoreSize.

	   Filter by restore_size
	*/
	RestoreSize *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SnaplockExpired.

	   Filter by snaplock.expired
	*/
	SnaplockExpired *bool

	/* SnaplockExpiryTime.

	   Filter by snaplock.expiry_time
	*/
	SnaplockExpiryTime *string

	/* SnaplockTimeUntilExpiry.

	   Filter by snaplock.time_until_expiry
	*/
	SnaplockTimeUntilExpiry *string

	/* SnapmirrorLabel.

	   Filter by snapmirror_label
	*/
	SnapmirrorLabel *string

	/* SnapshotVolumesSnapshotName.

	   Filter by snapshot_volumes.snapshot.name
	*/
	SnapshotVolumesSnapshotName *string

	/* SnapshotVolumesSnapshotUUID.

	   Filter by snapshot_volumes.snapshot.uuid
	*/
	SnapshotVolumesSnapshotUUID *string

	/* SnapshotVolumesVolumeName.

	   Filter by snapshot_volumes.volume.name
	*/
	SnapshotVolumesVolumeName *string

	/* SnapshotVolumesVolumeUUID.

	   Filter by snapshot_volumes.volume.uuid
	*/
	SnapshotVolumesVolumeUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WriteFence.

	   Filter by write_fence
	*/
	WriteFence *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the consistency group snapshot delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithDefaults() *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the consistency group snapshot delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ConsistencyGroupSnapshotDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithContext(ctx context.Context) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithComment(comment *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithConsistencyGroupName(consistencyGroupName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetConsistencyGroupName(consistencyGroupName)
	return o
}

// SetConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetConsistencyGroupName(consistencyGroupName *string) {
	o.ConsistencyGroupName = consistencyGroupName
}

// WithConsistencyGroupUUID adds the consistencyGroupUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithConsistencyGroupUUID(consistencyGroupUUID string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetConsistencyGroupUUID(consistencyGroupUUID)
	return o
}

// SetConsistencyGroupUUID adds the consistencyGroupUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetConsistencyGroupUUID(consistencyGroupUUID string) {
	o.ConsistencyGroupUUID = consistencyGroupUUID
}

// WithConsistencyType adds the consistencyType to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithConsistencyType(consistencyType *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithContinueOnFailure adds the continueOnFailure to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithCreateTime(createTime *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithInfo adds the info to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithInfo(info ConsistencyGroupSnapshotDeleteCollectionBody) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetInfo(info ConsistencyGroupSnapshotDeleteCollectionBody) {
	o.Info = info
}

// WithIsPartial adds the isPartial to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithIsPartial(isPartial *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetIsPartial(isPartial *bool) {
	o.IsPartial = isPartial
}

// WithLunsName adds the lunsName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithLunsName(lunsName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetLunsName(lunsName)
	return o
}

// SetLunsName adds the lunsName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetLunsName(lunsName *string) {
	o.LunsName = lunsName
}

// WithLunsUUID adds the lunsUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithLunsUUID(lunsUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetLunsUUID(lunsUUID)
	return o
}

// SetLunsUUID adds the lunsUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetLunsUUID(lunsUUID *string) {
	o.LunsUUID = lunsUUID
}

// WithMissingLunsName adds the missingLunsName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingLunsName(missingLunsName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingLunsName(missingLunsName)
	return o
}

// SetMissingLunsName adds the missingLunsName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingLunsName(missingLunsName *string) {
	o.MissingLunsName = missingLunsName
}

// WithMissingLunsUUID adds the missingLunsUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingLunsUUID(missingLunsUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingLunsUUID(missingLunsUUID)
	return o
}

// SetMissingLunsUUID adds the missingLunsUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingLunsUUID(missingLunsUUID *string) {
	o.MissingLunsUUID = missingLunsUUID
}

// WithMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingNamespacesName(missingNamespacesName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingNamespacesName(missingNamespacesName)
	return o
}

// SetMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingNamespacesName(missingNamespacesName *string) {
	o.MissingNamespacesName = missingNamespacesName
}

// WithMissingNamespacesUUID adds the missingNamespacesUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingNamespacesUUID(missingNamespacesUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingNamespacesUUID(missingNamespacesUUID)
	return o
}

// SetMissingNamespacesUUID adds the missingNamespacesUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingNamespacesUUID(missingNamespacesUUID *string) {
	o.MissingNamespacesUUID = missingNamespacesUUID
}

// WithMissingVolumesName adds the missingVolumesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingVolumesName(missingVolumesName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingVolumesName(missingVolumesName)
	return o
}

// SetMissingVolumesName adds the missingVolumesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingVolumesName(missingVolumesName *string) {
	o.MissingVolumesName = missingVolumesName
}

// WithMissingVolumesUUID adds the missingVolumesUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithMissingVolumesUUID(missingVolumesUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetMissingVolumesUUID(missingVolumesUUID)
	return o
}

// SetMissingVolumesUUID adds the missingVolumesUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetMissingVolumesUUID(missingVolumesUUID *string) {
	o.MissingVolumesUUID = missingVolumesUUID
}

// WithName adds the name to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithName(name *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNamespacesName adds the namespacesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithNamespacesName(namespacesName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetNamespacesName(namespacesName)
	return o
}

// SetNamespacesName adds the namespacesName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetNamespacesName(namespacesName *string) {
	o.NamespacesName = namespacesName
}

// WithNamespacesUUID adds the namespacesUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithNamespacesUUID(namespacesUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetNamespacesUUID(namespacesUUID)
	return o
}

// SetNamespacesUUID adds the namespacesUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetNamespacesUUID(namespacesUUID *string) {
	o.NamespacesUUID = namespacesUUID
}

// WithReclaimableSpace adds the reclaimableSpace to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithReclaimableSpace(reclaimableSpace *int64) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetReclaimableSpace(reclaimableSpace)
	return o
}

// SetReclaimableSpace adds the reclaimableSpace to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetReclaimableSpace(reclaimableSpace *int64) {
	o.ReclaimableSpace = reclaimableSpace
}

// WithRestoreSize adds the restoreSize to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithRestoreSize(restoreSize *int64) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetRestoreSize(restoreSize)
	return o
}

// SetRestoreSize adds the restoreSize to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetRestoreSize(restoreSize *int64) {
	o.RestoreSize = restoreSize
}

// WithReturnRecords adds the returnRecords to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSnaplockExpired adds the snaplockExpired to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnaplockExpired(snaplockExpired *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnaplockExpired(snaplockExpired)
	return o
}

// SetSnaplockExpired adds the snaplockExpired to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnaplockExpired(snaplockExpired *bool) {
	o.SnaplockExpired = snaplockExpired
}

// WithSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnaplockExpiryTime(snaplockExpiryTime *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnaplockExpiryTime(snaplockExpiryTime)
	return o
}

// SetSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnaplockExpiryTime(snaplockExpiryTime *string) {
	o.SnaplockExpiryTime = snaplockExpiryTime
}

// WithSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry)
	return o
}

// SetSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) {
	o.SnaplockTimeUntilExpiry = snaplockTimeUntilExpiry
}

// WithSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnapmirrorLabel(snapmirrorLabel *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnapmirrorLabel(snapmirrorLabel)
	return o
}

// SetSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnapmirrorLabel(snapmirrorLabel *string) {
	o.SnapmirrorLabel = snapmirrorLabel
}

// WithSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName)
	return o
}

// SetSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) {
	o.SnapshotVolumesSnapshotName = snapshotVolumesSnapshotName
}

// WithSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID)
	return o
}

// SetSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) {
	o.SnapshotVolumesSnapshotUUID = snapshotVolumesSnapshotUUID
}

// WithSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName)
	return o
}

// SetSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) {
	o.SnapshotVolumesVolumeName = snapshotVolumesVolumeName
}

// WithSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID)
	return o
}

// SetSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) {
	o.SnapshotVolumesVolumeUUID = snapshotVolumesVolumeUUID
}

// WithSvmName adds the svmName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSvmName(svmName *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithSvmUUID(svmUUID *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithUUID(uuid *string) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWriteFence adds the writeFence to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WithWriteFence(writeFence *bool) *ConsistencyGroupSnapshotDeleteCollectionParams {
	o.SetWriteFence(writeFence)
	return o
}

// SetWriteFence adds the writeFence to the consistency group snapshot delete collection params
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) SetWriteFence(writeFence *bool) {
	o.WriteFence = writeFence
}

// WriteToRequest writes these params to a swagger request
func (o *ConsistencyGroupSnapshotDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupName != nil {

		// query param consistency_group.name
		var qrConsistencyGroupName string

		if o.ConsistencyGroupName != nil {
			qrConsistencyGroupName = *o.ConsistencyGroupName
		}
		qConsistencyGroupName := qrConsistencyGroupName
		if qConsistencyGroupName != "" {

			if err := r.SetQueryParam("consistency_group.name", qConsistencyGroupName); err != nil {
				return err
			}
		}
	}

	// path param consistency_group.uuid
	if err := r.SetPathParam("consistency_group.uuid", o.ConsistencyGroupUUID); err != nil {
		return err
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial bool

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := swag.FormatBool(qrIsPartial)
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.LunsName != nil {

		// query param luns.name
		var qrLunsName string

		if o.LunsName != nil {
			qrLunsName = *o.LunsName
		}
		qLunsName := qrLunsName
		if qLunsName != "" {

			if err := r.SetQueryParam("luns.name", qLunsName); err != nil {
				return err
			}
		}
	}

	if o.LunsUUID != nil {

		// query param luns.uuid
		var qrLunsUUID string

		if o.LunsUUID != nil {
			qrLunsUUID = *o.LunsUUID
		}
		qLunsUUID := qrLunsUUID
		if qLunsUUID != "" {

			if err := r.SetQueryParam("luns.uuid", qLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsName != nil {

		// query param missing_luns.name
		var qrMissingLunsName string

		if o.MissingLunsName != nil {
			qrMissingLunsName = *o.MissingLunsName
		}
		qMissingLunsName := qrMissingLunsName
		if qMissingLunsName != "" {

			if err := r.SetQueryParam("missing_luns.name", qMissingLunsName); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsUUID != nil {

		// query param missing_luns.uuid
		var qrMissingLunsUUID string

		if o.MissingLunsUUID != nil {
			qrMissingLunsUUID = *o.MissingLunsUUID
		}
		qMissingLunsUUID := qrMissingLunsUUID
		if qMissingLunsUUID != "" {

			if err := r.SetQueryParam("missing_luns.uuid", qMissingLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesName != nil {

		// query param missing_namespaces.name
		var qrMissingNamespacesName string

		if o.MissingNamespacesName != nil {
			qrMissingNamespacesName = *o.MissingNamespacesName
		}
		qMissingNamespacesName := qrMissingNamespacesName
		if qMissingNamespacesName != "" {

			if err := r.SetQueryParam("missing_namespaces.name", qMissingNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesUUID != nil {

		// query param missing_namespaces.uuid
		var qrMissingNamespacesUUID string

		if o.MissingNamespacesUUID != nil {
			qrMissingNamespacesUUID = *o.MissingNamespacesUUID
		}
		qMissingNamespacesUUID := qrMissingNamespacesUUID
		if qMissingNamespacesUUID != "" {

			if err := r.SetQueryParam("missing_namespaces.uuid", qMissingNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesName != nil {

		// query param missing_volumes.name
		var qrMissingVolumesName string

		if o.MissingVolumesName != nil {
			qrMissingVolumesName = *o.MissingVolumesName
		}
		qMissingVolumesName := qrMissingVolumesName
		if qMissingVolumesName != "" {

			if err := r.SetQueryParam("missing_volumes.name", qMissingVolumesName); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesUUID != nil {

		// query param missing_volumes.uuid
		var qrMissingVolumesUUID string

		if o.MissingVolumesUUID != nil {
			qrMissingVolumesUUID = *o.MissingVolumesUUID
		}
		qMissingVolumesUUID := qrMissingVolumesUUID
		if qMissingVolumesUUID != "" {

			if err := r.SetQueryParam("missing_volumes.uuid", qMissingVolumesUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesName != nil {

		// query param namespaces.name
		var qrNamespacesName string

		if o.NamespacesName != nil {
			qrNamespacesName = *o.NamespacesName
		}
		qNamespacesName := qrNamespacesName
		if qNamespacesName != "" {

			if err := r.SetQueryParam("namespaces.name", qNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesUUID != nil {

		// query param namespaces.uuid
		var qrNamespacesUUID string

		if o.NamespacesUUID != nil {
			qrNamespacesUUID = *o.NamespacesUUID
		}
		qNamespacesUUID := qrNamespacesUUID
		if qNamespacesUUID != "" {

			if err := r.SetQueryParam("namespaces.uuid", qNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.ReclaimableSpace != nil {

		// query param reclaimable_space
		var qrReclaimableSpace int64

		if o.ReclaimableSpace != nil {
			qrReclaimableSpace = *o.ReclaimableSpace
		}
		qReclaimableSpace := swag.FormatInt64(qrReclaimableSpace)
		if qReclaimableSpace != "" {

			if err := r.SetQueryParam("reclaimable_space", qReclaimableSpace); err != nil {
				return err
			}
		}
	}

	if o.RestoreSize != nil {

		// query param restore_size
		var qrRestoreSize int64

		if o.RestoreSize != nil {
			qrRestoreSize = *o.RestoreSize
		}
		qRestoreSize := swag.FormatInt64(qrRestoreSize)
		if qRestoreSize != "" {

			if err := r.SetQueryParam("restore_size", qRestoreSize); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpired != nil {

		// query param snaplock.expired
		var qrSnaplockExpired bool

		if o.SnaplockExpired != nil {
			qrSnaplockExpired = *o.SnaplockExpired
		}
		qSnaplockExpired := swag.FormatBool(qrSnaplockExpired)
		if qSnaplockExpired != "" {

			if err := r.SetQueryParam("snaplock.expired", qSnaplockExpired); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpiryTime != nil {

		// query param snaplock.expiry_time
		var qrSnaplockExpiryTime string

		if o.SnaplockExpiryTime != nil {
			qrSnaplockExpiryTime = *o.SnaplockExpiryTime
		}
		qSnaplockExpiryTime := qrSnaplockExpiryTime
		if qSnaplockExpiryTime != "" {

			if err := r.SetQueryParam("snaplock.expiry_time", qSnaplockExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.SnaplockTimeUntilExpiry != nil {

		// query param snaplock.time_until_expiry
		var qrSnaplockTimeUntilExpiry string

		if o.SnaplockTimeUntilExpiry != nil {
			qrSnaplockTimeUntilExpiry = *o.SnaplockTimeUntilExpiry
		}
		qSnaplockTimeUntilExpiry := qrSnaplockTimeUntilExpiry
		if qSnaplockTimeUntilExpiry != "" {

			if err := r.SetQueryParam("snaplock.time_until_expiry", qSnaplockTimeUntilExpiry); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorLabel != nil {

		// query param snapmirror_label
		var qrSnapmirrorLabel string

		if o.SnapmirrorLabel != nil {
			qrSnapmirrorLabel = *o.SnapmirrorLabel
		}
		qSnapmirrorLabel := qrSnapmirrorLabel
		if qSnapmirrorLabel != "" {

			if err := r.SetQueryParam("snapmirror_label", qSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotName != nil {

		// query param snapshot_volumes.snapshot.name
		var qrSnapshotVolumesSnapshotName string

		if o.SnapshotVolumesSnapshotName != nil {
			qrSnapshotVolumesSnapshotName = *o.SnapshotVolumesSnapshotName
		}
		qSnapshotVolumesSnapshotName := qrSnapshotVolumesSnapshotName
		if qSnapshotVolumesSnapshotName != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.name", qSnapshotVolumesSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotUUID != nil {

		// query param snapshot_volumes.snapshot.uuid
		var qrSnapshotVolumesSnapshotUUID string

		if o.SnapshotVolumesSnapshotUUID != nil {
			qrSnapshotVolumesSnapshotUUID = *o.SnapshotVolumesSnapshotUUID
		}
		qSnapshotVolumesSnapshotUUID := qrSnapshotVolumesSnapshotUUID
		if qSnapshotVolumesSnapshotUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.uuid", qSnapshotVolumesSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeName != nil {

		// query param snapshot_volumes.volume.name
		var qrSnapshotVolumesVolumeName string

		if o.SnapshotVolumesVolumeName != nil {
			qrSnapshotVolumesVolumeName = *o.SnapshotVolumesVolumeName
		}
		qSnapshotVolumesVolumeName := qrSnapshotVolumesVolumeName
		if qSnapshotVolumesVolumeName != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.name", qSnapshotVolumesVolumeName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeUUID != nil {

		// query param snapshot_volumes.volume.uuid
		var qrSnapshotVolumesVolumeUUID string

		if o.SnapshotVolumesVolumeUUID != nil {
			qrSnapshotVolumesVolumeUUID = *o.SnapshotVolumesVolumeUUID
		}
		qSnapshotVolumesVolumeUUID := qrSnapshotVolumesVolumeUUID
		if qSnapshotVolumesVolumeUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.uuid", qSnapshotVolumesVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WriteFence != nil {

		// query param write_fence
		var qrWriteFence bool

		if o.WriteFence != nil {
			qrWriteFence = *o.WriteFence
		}
		qWriteFence := swag.FormatBool(qrWriteFence)
		if qWriteFence != "" {

			if err := r.SetQueryParam("write_fence", qWriteFence); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
