// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupSnapshotDeleteCollectionReader is a Reader for the ConsistencyGroupSnapshotDeleteCollection structure.
type ConsistencyGroupSnapshotDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupSnapshotDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupSnapshotDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewConsistencyGroupSnapshotDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupSnapshotDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupSnapshotDeleteCollectionOK creates a ConsistencyGroupSnapshotDeleteCollectionOK with default headers values
func NewConsistencyGroupSnapshotDeleteCollectionOK() *ConsistencyGroupSnapshotDeleteCollectionOK {
	return &ConsistencyGroupSnapshotDeleteCollectionOK{}
}

/*
ConsistencyGroupSnapshotDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupSnapshotDeleteCollectionOK struct {
}

// IsSuccess returns true when this consistency group snapshot delete collection o k response has a 2xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot delete collection o k response has a 3xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot delete collection o k response has a 4xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot delete collection o k response has a 5xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot delete collection o k response a status code equal to that given
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group snapshot delete collection o k response
func (o *ConsistencyGroupSnapshotDeleteCollectionOK) Code() int {
	return 200
}

func (o *ConsistencyGroupSnapshotDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotDeleteCollectionOK", 200)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotDeleteCollectionOK", 200)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConsistencyGroupSnapshotDeleteCollectionAccepted creates a ConsistencyGroupSnapshotDeleteCollectionAccepted with default headers values
func NewConsistencyGroupSnapshotDeleteCollectionAccepted() *ConsistencyGroupSnapshotDeleteCollectionAccepted {
	return &ConsistencyGroupSnapshotDeleteCollectionAccepted{}
}

/*
ConsistencyGroupSnapshotDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ConsistencyGroupSnapshotDeleteCollectionAccepted struct {
	Payload *models.ConsistencyGroupSnapshotJobLinkResponse
}

// IsSuccess returns true when this consistency group snapshot delete collection accepted response has a 2xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot delete collection accepted response has a 3xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot delete collection accepted response has a 4xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot delete collection accepted response has a 5xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot delete collection accepted response a status code equal to that given
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the consistency group snapshot delete collection accepted response
func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) GetPayload() *models.ConsistencyGroupSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupSnapshotDeleteCollectionDefault creates a ConsistencyGroupSnapshotDeleteCollectionDefault with default headers values
func NewConsistencyGroupSnapshotDeleteCollectionDefault(code int) *ConsistencyGroupSnapshotDeleteCollectionDefault {
	return &ConsistencyGroupSnapshotDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ConsistencyGroupSnapshotDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 53412007 | Failed to delete the snapshot because it has not expired or is locked. |
| 53412008 | Failed to delete the consistency group snapshot because it is currently used as a reference for a replication relationship. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConsistencyGroupSnapshotDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group snapshot delete collection default response has a 2xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group snapshot delete collection default response has a 3xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group snapshot delete collection default response has a 4xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group snapshot delete collection default response has a 5xx status code
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group snapshot delete collection default response a status code equal to that given
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group snapshot delete collection default response
func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionBody consistency group snapshot delete collection body
swagger:model ConsistencyGroupSnapshotDeleteCollectionBody
*/
type ConsistencyGroupSnapshotDeleteCollectionBody struct {

	// consistency group snapshot response inline records
	ConsistencyGroupSnapshotResponseInlineRecords []*models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this consistency group snapshot delete collection body
func (o *ConsistencyGroupSnapshotDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConsistencyGroupSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionBody) validateConsistencyGroupSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroupSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ConsistencyGroupSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.ConsistencyGroupSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ConsistencyGroupSnapshotResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection body based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConsistencyGroupSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionBody) contextValidateConsistencyGroupSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroupSnapshotResponseInlineRecords); i++ {

		if o.ConsistencyGroupSnapshotResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0 A reference to a LUN.
//
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links `json:"_links,omitempty"`

	// The name of a LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 luns items0
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 luns items0 based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links consistency group snapshot delete collection params body records items0 luns items0 links
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 luns items0 links
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 luns items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 missing namespaces items0
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 missing namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links consistency group snapshot delete collection params body records items0 missing namespaces items0 links
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 missing namespaces items0 links
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 missing namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 namespaces items0
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links consistency group snapshot delete collection params body records items0 namespaces items0 links
swagger:model ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links
*/
type ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot delete collection params body records items0 namespaces items0 links
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot delete collection params body records items0 namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem consistency group snapshot response inline records inline array item
swagger:model consistency_group_snapshot_response_inline_records_inline_array_item
*/
type ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Comment for the snapshot.
	//
	// Example: My snapshot comment
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// Consistency type. This is for categorization purposes only. A snapshot should not be set to 'application consistent' unless the host application is quiesced for the snapshot. Valid in POST.
	//
	// Example: crash
	// Enum: ["crash","application"]
	ConsistencyType *string `json:"consistency_type,omitempty"`

	// Time the snapshot copy was created
	//
	// Example: 2020-10-25 11:20:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates whether the snapshot taken is partial or not.
	//
	// Example: false
	// Read Only: true
	IsPartial *bool `json:"is_partial,omitempty"`

	// The list of LUNs in this snapshot.
	//
	// Read Only: true
	Luns []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0 `json:"luns"`

	// List of LUNs that are not in the snapshot.
	//
	// Read Only: true
	MissingLuns []*models.LunReference `json:"missing_luns"`

	// List of NVMe namespaces that are not in the snapshot.
	//
	// Read Only: true
	MissingNamespaces []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0 `json:"missing_namespaces"`

	// List of volumes which are not in the snapshot.
	//
	// Read Only: true
	MissingVolumes []*models.VolumeReference `json:"missing_volumes"`

	// Name of the snapshot.
	//
	Name *string `json:"name,omitempty"`

	// The list of NVMe namespaces in this snapshot.
	//
	// Read Only: true
	Namespaces []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0 `json:"namespaces"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	// Read Only: true
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the consistency group if this snapshot is restored.
	// Example: 4096
	// Read Only: true
	RestoreSize *int64 `json:"restore_size,omitempty"`

	// snaplock
	Snaplock *models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// Snapmirror Label for the snapshot.
	//
	// Example: sm_label
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// List of volume and snapshot identifiers for each volume in the snapshot.
	//
	// Read Only: true
	SnapshotVolumes []*models.ConsistencyGroupVolumeSnapshot `json:"snapshot_volumes"`

	// The SVM in which the consistency group is located.
	//
	Svm *models.SvmReference `json:"svm,omitempty"`

	// The unique identifier of the snapshot. The UUID is generated
	// by ONTAP when the snapshot is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Specifies whether a write fence will be taken when creating the snapshot. The default is false if there is only one volume in the consistency group, otherwise the default is true.
	//
	WriteFence *bool `json:"write_fence,omitempty"`
}

// Validate validates this consistency group snapshot response inline records inline array item
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroup) { // not required
		return nil
	}

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupSnapshotResponseInlineRecordsInlineArrayItemTypeConsistencyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["crash","application"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupSnapshotResponseInlineRecordsInlineArrayItemTypeConsistencyTypePropEnum = append(consistencyGroupSnapshotResponseInlineRecordsInlineArrayItemTypeConsistencyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_snapshot_response_inline_records_inline_array_item
	// ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem
	// consistency_type
	// ConsistencyType
	// crash
	// END DEBUGGING
	// ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemConsistencyTypeCrash captures enum value "crash"
	ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemConsistencyTypeCrash string = "crash"

	// BEGIN DEBUGGING
	// consistency_group_snapshot_response_inline_records_inline_array_item
	// ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem
	// consistency_type
	// ConsistencyType
	// application
	// END DEBUGGING
	// ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemConsistencyTypeApplication captures enum value "application"
	ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemConsistencyTypeApplication string = "application"
)

// prop value enum
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateConsistencyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupSnapshotResponseInlineRecordsInlineArrayItemTypeConsistencyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateConsistencyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateConsistencyTypeEnum("consistency_type", "body", *o.ConsistencyType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateMissingLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingLuns) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingLuns); i++ {
		if swag.IsZero(o.MissingLuns[i]) { // not required
			continue
		}

		if o.MissingLuns[i] != nil {
			if err := o.MissingLuns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateMissingNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingNamespaces) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingNamespaces); i++ {
		if swag.IsZero(o.MissingNamespaces[i]) { // not required
			continue
		}

		if o.MissingNamespaces[i] != nil {
			if err := o.MissingNamespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateMissingVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingVolumes) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingVolumes); i++ {
		if swag.IsZero(o.MissingVolumes[i]) { // not required
			continue
		}

		if o.MissingVolumes[i] != nil {
			if err := o.MissingVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateSnapshotVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotVolumes) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapshotVolumes); i++ {
		if swag.IsZero(o.SnapshotVolumes[i]) { // not required
			continue
		}

		if o.SnapshotVolumes[i] != nil {
			if err := o.SnapshotVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("snapshot_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot response inline records inline array item based on the context it is used
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsPartial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReclaimableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateIsPartial(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_partial", "body", o.IsPartial); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "luns", "body", []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0LunsItems0(o.Luns)); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateMissingLuns(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "missing_luns", "body", []*models.LunReference(o.MissingLuns)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingLuns); i++ {

		if o.MissingLuns[i] != nil {
			if err := o.MissingLuns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateMissingNamespaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "missing_namespaces", "body", []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0MissingNamespacesItems0(o.MissingNamespaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingNamespaces); i++ {

		if o.MissingNamespaces[i] != nil {
			if err := o.MissingNamespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateMissingVolumes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "missing_volumes", "body", []*models.VolumeReference(o.MissingVolumes)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingVolumes); i++ {

		if o.MissingVolumes[i] != nil {
			if err := o.MissingVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("missing_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "namespaces", "body", []*ConsistencyGroupSnapshotDeleteCollectionParamsBodyRecordsItems0NamespacesItems0(o.Namespaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateReclaimableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reclaimable_space", "body", o.ReclaimableSpace); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateRestoreSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "restore_size", "body", o.RestoreSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateSnapshotVolumes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot_volumes", "body", []*models.ConsistencyGroupVolumeSnapshot(o.SnapshotVolumes)); err != nil {
		return err
	}

	for i := 0; i < len(o.SnapshotVolumes); i++ {

		if o.SnapshotVolumes[i] != nil {
			if err := o.SnapshotVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("snapshot_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup The consistency group of the snapshot.
//
swagger:model consistency_group_snapshot_response_inline_records_inline_array_item_inline_consistency_group
*/
type ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot response inline records inline array item inline consistency group
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot response inline records inline array item inline consistency group based on the context it is used
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock SnapLock Snapshot attributes.
swagger:model consistency_group_snapshot_response_inline_records_inline_array_item_inline_snaplock
*/
type ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock struct {

	// Indicates whether a SnapLock snapshot has expired.
	// Example: true
	// Read Only: true
	Expired *bool `json:"expired,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a consistency-group. A snapshot is not allowed to be deleted until the SnapLock ComplianceClock time goes beyond this expiry time.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates the remaining SnapLock expiry time of a locked snapshot, in iso8601 period format. This field is set only when the remaining time interval is less than 136 years.
	// Example: PT3H27M45S
	// Read Only: true
	TimeUntilExpiry *string `json:"time_until_expiry,omitempty"`
}

// Validate validates this consistency group snapshot response inline records inline array item inline snaplock
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group snapshot response inline records inline array item inline snaplock based on the context it is used
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimeUntilExpiry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expired", "body", o.Expired); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) contextValidateTimeUntilExpiry(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"time_until_expiry", "body", o.TimeUntilExpiry); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
