// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupSnapshotGetReader is a Reader for the ConsistencyGroupSnapshotGet structure.
type ConsistencyGroupSnapshotGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupSnapshotGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupSnapshotGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupSnapshotGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupSnapshotGetOK creates a ConsistencyGroupSnapshotGetOK with default headers values
func NewConsistencyGroupSnapshotGetOK() *ConsistencyGroupSnapshotGetOK {
	return &ConsistencyGroupSnapshotGetOK{}
}

/*
ConsistencyGroupSnapshotGetOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupSnapshotGetOK struct {
	Payload *models.ConsistencyGroupSnapshot
}

// IsSuccess returns true when this consistency group snapshot get o k response has a 2xx status code
func (o *ConsistencyGroupSnapshotGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot get o k response has a 3xx status code
func (o *ConsistencyGroupSnapshotGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot get o k response has a 4xx status code
func (o *ConsistencyGroupSnapshotGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot get o k response has a 5xx status code
func (o *ConsistencyGroupSnapshotGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot get o k response a status code equal to that given
func (o *ConsistencyGroupSnapshotGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group snapshot get o k response
func (o *ConsistencyGroupSnapshotGetOK) Code() int {
	return 200
}

func (o *ConsistencyGroupSnapshotGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}][%d] consistencyGroupSnapshotGetOK %s", 200, payload)
}

func (o *ConsistencyGroupSnapshotGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}][%d] consistencyGroupSnapshotGetOK %s", 200, payload)
}

func (o *ConsistencyGroupSnapshotGetOK) GetPayload() *models.ConsistencyGroupSnapshot {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupSnapshot)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupSnapshotGetDefault creates a ConsistencyGroupSnapshotGetDefault with default headers values
func NewConsistencyGroupSnapshotGetDefault(code int) *ConsistencyGroupSnapshotGetDefault {
	return &ConsistencyGroupSnapshotGetDefault{
		_statusCode: code,
	}
}

/*
ConsistencyGroupSnapshotGetDefault describes a response with status code -1, with default header values.

Error
*/
type ConsistencyGroupSnapshotGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group snapshot get default response has a 2xx status code
func (o *ConsistencyGroupSnapshotGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group snapshot get default response has a 3xx status code
func (o *ConsistencyGroupSnapshotGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group snapshot get default response has a 4xx status code
func (o *ConsistencyGroupSnapshotGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group snapshot get default response has a 5xx status code
func (o *ConsistencyGroupSnapshotGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group snapshot get default response a status code equal to that given
func (o *ConsistencyGroupSnapshotGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group snapshot get default response
func (o *ConsistencyGroupSnapshotGetDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupSnapshotGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}][%d] consistency_group_snapshot_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}][%d] consistency_group_snapshot_get default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
