// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConsistencyGroupSnapshotModifyCollectionParams creates a new ConsistencyGroupSnapshotModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConsistencyGroupSnapshotModifyCollectionParams() *ConsistencyGroupSnapshotModifyCollectionParams {
	return &ConsistencyGroupSnapshotModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConsistencyGroupSnapshotModifyCollectionParamsWithTimeout creates a new ConsistencyGroupSnapshotModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewConsistencyGroupSnapshotModifyCollectionParamsWithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotModifyCollectionParams {
	return &ConsistencyGroupSnapshotModifyCollectionParams{
		timeout: timeout,
	}
}

// NewConsistencyGroupSnapshotModifyCollectionParamsWithContext creates a new ConsistencyGroupSnapshotModifyCollectionParams object
// with the ability to set a context for a request.
func NewConsistencyGroupSnapshotModifyCollectionParamsWithContext(ctx context.Context) *ConsistencyGroupSnapshotModifyCollectionParams {
	return &ConsistencyGroupSnapshotModifyCollectionParams{
		Context: ctx,
	}
}

// NewConsistencyGroupSnapshotModifyCollectionParamsWithHTTPClient creates a new ConsistencyGroupSnapshotModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewConsistencyGroupSnapshotModifyCollectionParamsWithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotModifyCollectionParams {
	return &ConsistencyGroupSnapshotModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
ConsistencyGroupSnapshotModifyCollectionParams contains all the parameters to send to the API endpoint

	for the consistency group snapshot modify collection operation.

	Typically these are written to a http.Request.
*/
type ConsistencyGroupSnapshotModifyCollectionParams struct {

	/* Action.

	   Commits the snapshot. The commit must be called within the timeout value specified during POST. If the commit is not called within the specified time, then the snapshot create operation is aborted.

	*/
	Action *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConsistencyGroupName.

	   Filter by consistency_group.name
	*/
	ConsistencyGroupName *string

	/* ConsistencyGroupUUID.

	   The unique identifier of the consistency group to retrieve.

	*/
	ConsistencyGroupUUID string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Info.

	   Info specification
	*/
	Info ConsistencyGroupSnapshotModifyCollectionBody

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *bool

	/* LunsName.

	   Filter by luns.name
	*/
	LunsName *string

	/* LunsUUID.

	   Filter by luns.uuid
	*/
	LunsUUID *string

	/* MissingLunsName.

	   Filter by missing_luns.name
	*/
	MissingLunsName *string

	/* MissingLunsUUID.

	   Filter by missing_luns.uuid
	*/
	MissingLunsUUID *string

	/* MissingNamespacesName.

	   Filter by missing_namespaces.name
	*/
	MissingNamespacesName *string

	/* MissingNamespacesUUID.

	   Filter by missing_namespaces.uuid
	*/
	MissingNamespacesUUID *string

	/* MissingVolumesName.

	   Filter by missing_volumes.name
	*/
	MissingVolumesName *string

	/* MissingVolumesUUID.

	   Filter by missing_volumes.uuid
	*/
	MissingVolumesUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NamespacesName.

	   Filter by namespaces.name
	*/
	NamespacesName *string

	/* NamespacesUUID.

	   Filter by namespaces.uuid
	*/
	NamespacesUUID *string

	/* ReclaimableSpace.

	   Filter by reclaimable_space
	*/
	ReclaimableSpace *int64

	/* RestoreSize.

	   Filter by restore_size
	*/
	RestoreSize *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SnaplockExpired.

	   Filter by snaplock.expired
	*/
	SnaplockExpired *bool

	/* SnaplockExpiryTime.

	   Filter by snaplock.expiry_time
	*/
	SnaplockExpiryTime *string

	/* SnaplockTimeUntilExpiry.

	   Filter by snaplock.time_until_expiry
	*/
	SnaplockTimeUntilExpiry *string

	/* SnapmirrorLabel.

	   Filter by snapmirror_label
	*/
	SnapmirrorLabel *string

	/* SnapshotVolumesSnapshotName.

	   Filter by snapshot_volumes.snapshot.name
	*/
	SnapshotVolumesSnapshotName *string

	/* SnapshotVolumesSnapshotUUID.

	   Filter by snapshot_volumes.snapshot.uuid
	*/
	SnapshotVolumesSnapshotUUID *string

	/* SnapshotVolumesVolumeName.

	   Filter by snapshot_volumes.volume.name
	*/
	SnapshotVolumesVolumeName *string

	/* SnapshotVolumesVolumeUUID.

	   Filter by snapshot_volumes.volume.uuid
	*/
	SnapshotVolumesVolumeUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WriteFence.

	   Filter by write_fence
	*/
	WriteFence *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the consistency group snapshot modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithDefaults() *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the consistency group snapshot modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ConsistencyGroupSnapshotModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithTimeout(timeout time.Duration) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithContext(ctx context.Context) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithHTTPClient(client *http.Client) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithAction(action *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetAction(action *string) {
	o.Action = action
}

// WithComment adds the comment to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithComment(comment *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithConsistencyGroupName(consistencyGroupName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetConsistencyGroupName(consistencyGroupName)
	return o
}

// SetConsistencyGroupName adds the consistencyGroupName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetConsistencyGroupName(consistencyGroupName *string) {
	o.ConsistencyGroupName = consistencyGroupName
}

// WithConsistencyGroupUUID adds the consistencyGroupUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithConsistencyGroupUUID(consistencyGroupUUID string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetConsistencyGroupUUID(consistencyGroupUUID)
	return o
}

// SetConsistencyGroupUUID adds the consistencyGroupUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetConsistencyGroupUUID(consistencyGroupUUID string) {
	o.ConsistencyGroupUUID = consistencyGroupUUID
}

// WithConsistencyType adds the consistencyType to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithConsistencyType(consistencyType *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithContinueOnFailure adds the continueOnFailure to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithCreateTime(createTime *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithInfo adds the info to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithInfo(info ConsistencyGroupSnapshotModifyCollectionBody) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetInfo(info ConsistencyGroupSnapshotModifyCollectionBody) {
	o.Info = info
}

// WithIsPartial adds the isPartial to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithIsPartial(isPartial *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetIsPartial(isPartial *bool) {
	o.IsPartial = isPartial
}

// WithLunsName adds the lunsName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithLunsName(lunsName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetLunsName(lunsName)
	return o
}

// SetLunsName adds the lunsName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetLunsName(lunsName *string) {
	o.LunsName = lunsName
}

// WithLunsUUID adds the lunsUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithLunsUUID(lunsUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetLunsUUID(lunsUUID)
	return o
}

// SetLunsUUID adds the lunsUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetLunsUUID(lunsUUID *string) {
	o.LunsUUID = lunsUUID
}

// WithMissingLunsName adds the missingLunsName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingLunsName(missingLunsName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingLunsName(missingLunsName)
	return o
}

// SetMissingLunsName adds the missingLunsName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingLunsName(missingLunsName *string) {
	o.MissingLunsName = missingLunsName
}

// WithMissingLunsUUID adds the missingLunsUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingLunsUUID(missingLunsUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingLunsUUID(missingLunsUUID)
	return o
}

// SetMissingLunsUUID adds the missingLunsUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingLunsUUID(missingLunsUUID *string) {
	o.MissingLunsUUID = missingLunsUUID
}

// WithMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingNamespacesName(missingNamespacesName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingNamespacesName(missingNamespacesName)
	return o
}

// SetMissingNamespacesName adds the missingNamespacesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingNamespacesName(missingNamespacesName *string) {
	o.MissingNamespacesName = missingNamespacesName
}

// WithMissingNamespacesUUID adds the missingNamespacesUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingNamespacesUUID(missingNamespacesUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingNamespacesUUID(missingNamespacesUUID)
	return o
}

// SetMissingNamespacesUUID adds the missingNamespacesUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingNamespacesUUID(missingNamespacesUUID *string) {
	o.MissingNamespacesUUID = missingNamespacesUUID
}

// WithMissingVolumesName adds the missingVolumesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingVolumesName(missingVolumesName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingVolumesName(missingVolumesName)
	return o
}

// SetMissingVolumesName adds the missingVolumesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingVolumesName(missingVolumesName *string) {
	o.MissingVolumesName = missingVolumesName
}

// WithMissingVolumesUUID adds the missingVolumesUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithMissingVolumesUUID(missingVolumesUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetMissingVolumesUUID(missingVolumesUUID)
	return o
}

// SetMissingVolumesUUID adds the missingVolumesUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetMissingVolumesUUID(missingVolumesUUID *string) {
	o.MissingVolumesUUID = missingVolumesUUID
}

// WithName adds the name to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithName(name *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNamespacesName adds the namespacesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithNamespacesName(namespacesName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetNamespacesName(namespacesName)
	return o
}

// SetNamespacesName adds the namespacesName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetNamespacesName(namespacesName *string) {
	o.NamespacesName = namespacesName
}

// WithNamespacesUUID adds the namespacesUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithNamespacesUUID(namespacesUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetNamespacesUUID(namespacesUUID)
	return o
}

// SetNamespacesUUID adds the namespacesUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetNamespacesUUID(namespacesUUID *string) {
	o.NamespacesUUID = namespacesUUID
}

// WithReclaimableSpace adds the reclaimableSpace to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithReclaimableSpace(reclaimableSpace *int64) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetReclaimableSpace(reclaimableSpace)
	return o
}

// SetReclaimableSpace adds the reclaimableSpace to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetReclaimableSpace(reclaimableSpace *int64) {
	o.ReclaimableSpace = reclaimableSpace
}

// WithRestoreSize adds the restoreSize to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithRestoreSize(restoreSize *int64) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetRestoreSize(restoreSize)
	return o
}

// SetRestoreSize adds the restoreSize to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetRestoreSize(restoreSize *int64) {
	o.RestoreSize = restoreSize
}

// WithReturnRecords adds the returnRecords to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithReturnRecords(returnRecords *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSerialRecords(serialRecords *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSnaplockExpired adds the snaplockExpired to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnaplockExpired(snaplockExpired *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnaplockExpired(snaplockExpired)
	return o
}

// SetSnaplockExpired adds the snaplockExpired to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnaplockExpired(snaplockExpired *bool) {
	o.SnaplockExpired = snaplockExpired
}

// WithSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnaplockExpiryTime(snaplockExpiryTime *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnaplockExpiryTime(snaplockExpiryTime)
	return o
}

// SetSnaplockExpiryTime adds the snaplockExpiryTime to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnaplockExpiryTime(snaplockExpiryTime *string) {
	o.SnaplockExpiryTime = snaplockExpiryTime
}

// WithSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry)
	return o
}

// SetSnaplockTimeUntilExpiry adds the snaplockTimeUntilExpiry to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnaplockTimeUntilExpiry(snaplockTimeUntilExpiry *string) {
	o.SnaplockTimeUntilExpiry = snaplockTimeUntilExpiry
}

// WithSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnapmirrorLabel(snapmirrorLabel *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnapmirrorLabel(snapmirrorLabel)
	return o
}

// SetSnapmirrorLabel adds the snapmirrorLabel to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnapmirrorLabel(snapmirrorLabel *string) {
	o.SnapmirrorLabel = snapmirrorLabel
}

// WithSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName)
	return o
}

// SetSnapshotVolumesSnapshotName adds the snapshotVolumesSnapshotName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnapshotVolumesSnapshotName(snapshotVolumesSnapshotName *string) {
	o.SnapshotVolumesSnapshotName = snapshotVolumesSnapshotName
}

// WithSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID)
	return o
}

// SetSnapshotVolumesSnapshotUUID adds the snapshotVolumesSnapshotUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnapshotVolumesSnapshotUUID(snapshotVolumesSnapshotUUID *string) {
	o.SnapshotVolumesSnapshotUUID = snapshotVolumesSnapshotUUID
}

// WithSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName)
	return o
}

// SetSnapshotVolumesVolumeName adds the snapshotVolumesVolumeName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnapshotVolumesVolumeName(snapshotVolumesVolumeName *string) {
	o.SnapshotVolumesVolumeName = snapshotVolumesVolumeName
}

// WithSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID)
	return o
}

// SetSnapshotVolumesVolumeUUID adds the snapshotVolumesVolumeUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSnapshotVolumesVolumeUUID(snapshotVolumesVolumeUUID *string) {
	o.SnapshotVolumesVolumeUUID = snapshotVolumesVolumeUUID
}

// WithSvmName adds the svmName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSvmName(svmName *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithSvmUUID(svmUUID *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithUUID(uuid *string) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWriteFence adds the writeFence to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WithWriteFence(writeFence *bool) *ConsistencyGroupSnapshotModifyCollectionParams {
	o.SetWriteFence(writeFence)
	return o
}

// SetWriteFence adds the writeFence to the consistency group snapshot modify collection params
func (o *ConsistencyGroupSnapshotModifyCollectionParams) SetWriteFence(writeFence *bool) {
	o.WriteFence = writeFence
}

// WriteToRequest writes these params to a swagger request
func (o *ConsistencyGroupSnapshotModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupName != nil {

		// query param consistency_group.name
		var qrConsistencyGroupName string

		if o.ConsistencyGroupName != nil {
			qrConsistencyGroupName = *o.ConsistencyGroupName
		}
		qConsistencyGroupName := qrConsistencyGroupName
		if qConsistencyGroupName != "" {

			if err := r.SetQueryParam("consistency_group.name", qConsistencyGroupName); err != nil {
				return err
			}
		}
	}

	// path param consistency_group.uuid
	if err := r.SetPathParam("consistency_group.uuid", o.ConsistencyGroupUUID); err != nil {
		return err
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial bool

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := swag.FormatBool(qrIsPartial)
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.LunsName != nil {

		// query param luns.name
		var qrLunsName string

		if o.LunsName != nil {
			qrLunsName = *o.LunsName
		}
		qLunsName := qrLunsName
		if qLunsName != "" {

			if err := r.SetQueryParam("luns.name", qLunsName); err != nil {
				return err
			}
		}
	}

	if o.LunsUUID != nil {

		// query param luns.uuid
		var qrLunsUUID string

		if o.LunsUUID != nil {
			qrLunsUUID = *o.LunsUUID
		}
		qLunsUUID := qrLunsUUID
		if qLunsUUID != "" {

			if err := r.SetQueryParam("luns.uuid", qLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsName != nil {

		// query param missing_luns.name
		var qrMissingLunsName string

		if o.MissingLunsName != nil {
			qrMissingLunsName = *o.MissingLunsName
		}
		qMissingLunsName := qrMissingLunsName
		if qMissingLunsName != "" {

			if err := r.SetQueryParam("missing_luns.name", qMissingLunsName); err != nil {
				return err
			}
		}
	}

	if o.MissingLunsUUID != nil {

		// query param missing_luns.uuid
		var qrMissingLunsUUID string

		if o.MissingLunsUUID != nil {
			qrMissingLunsUUID = *o.MissingLunsUUID
		}
		qMissingLunsUUID := qrMissingLunsUUID
		if qMissingLunsUUID != "" {

			if err := r.SetQueryParam("missing_luns.uuid", qMissingLunsUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesName != nil {

		// query param missing_namespaces.name
		var qrMissingNamespacesName string

		if o.MissingNamespacesName != nil {
			qrMissingNamespacesName = *o.MissingNamespacesName
		}
		qMissingNamespacesName := qrMissingNamespacesName
		if qMissingNamespacesName != "" {

			if err := r.SetQueryParam("missing_namespaces.name", qMissingNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.MissingNamespacesUUID != nil {

		// query param missing_namespaces.uuid
		var qrMissingNamespacesUUID string

		if o.MissingNamespacesUUID != nil {
			qrMissingNamespacesUUID = *o.MissingNamespacesUUID
		}
		qMissingNamespacesUUID := qrMissingNamespacesUUID
		if qMissingNamespacesUUID != "" {

			if err := r.SetQueryParam("missing_namespaces.uuid", qMissingNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesName != nil {

		// query param missing_volumes.name
		var qrMissingVolumesName string

		if o.MissingVolumesName != nil {
			qrMissingVolumesName = *o.MissingVolumesName
		}
		qMissingVolumesName := qrMissingVolumesName
		if qMissingVolumesName != "" {

			if err := r.SetQueryParam("missing_volumes.name", qMissingVolumesName); err != nil {
				return err
			}
		}
	}

	if o.MissingVolumesUUID != nil {

		// query param missing_volumes.uuid
		var qrMissingVolumesUUID string

		if o.MissingVolumesUUID != nil {
			qrMissingVolumesUUID = *o.MissingVolumesUUID
		}
		qMissingVolumesUUID := qrMissingVolumesUUID
		if qMissingVolumesUUID != "" {

			if err := r.SetQueryParam("missing_volumes.uuid", qMissingVolumesUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesName != nil {

		// query param namespaces.name
		var qrNamespacesName string

		if o.NamespacesName != nil {
			qrNamespacesName = *o.NamespacesName
		}
		qNamespacesName := qrNamespacesName
		if qNamespacesName != "" {

			if err := r.SetQueryParam("namespaces.name", qNamespacesName); err != nil {
				return err
			}
		}
	}

	if o.NamespacesUUID != nil {

		// query param namespaces.uuid
		var qrNamespacesUUID string

		if o.NamespacesUUID != nil {
			qrNamespacesUUID = *o.NamespacesUUID
		}
		qNamespacesUUID := qrNamespacesUUID
		if qNamespacesUUID != "" {

			if err := r.SetQueryParam("namespaces.uuid", qNamespacesUUID); err != nil {
				return err
			}
		}
	}

	if o.ReclaimableSpace != nil {

		// query param reclaimable_space
		var qrReclaimableSpace int64

		if o.ReclaimableSpace != nil {
			qrReclaimableSpace = *o.ReclaimableSpace
		}
		qReclaimableSpace := swag.FormatInt64(qrReclaimableSpace)
		if qReclaimableSpace != "" {

			if err := r.SetQueryParam("reclaimable_space", qReclaimableSpace); err != nil {
				return err
			}
		}
	}

	if o.RestoreSize != nil {

		// query param restore_size
		var qrRestoreSize int64

		if o.RestoreSize != nil {
			qrRestoreSize = *o.RestoreSize
		}
		qRestoreSize := swag.FormatInt64(qrRestoreSize)
		if qRestoreSize != "" {

			if err := r.SetQueryParam("restore_size", qRestoreSize); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpired != nil {

		// query param snaplock.expired
		var qrSnaplockExpired bool

		if o.SnaplockExpired != nil {
			qrSnaplockExpired = *o.SnaplockExpired
		}
		qSnaplockExpired := swag.FormatBool(qrSnaplockExpired)
		if qSnaplockExpired != "" {

			if err := r.SetQueryParam("snaplock.expired", qSnaplockExpired); err != nil {
				return err
			}
		}
	}

	if o.SnaplockExpiryTime != nil {

		// query param snaplock.expiry_time
		var qrSnaplockExpiryTime string

		if o.SnaplockExpiryTime != nil {
			qrSnaplockExpiryTime = *o.SnaplockExpiryTime
		}
		qSnaplockExpiryTime := qrSnaplockExpiryTime
		if qSnaplockExpiryTime != "" {

			if err := r.SetQueryParam("snaplock.expiry_time", qSnaplockExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.SnaplockTimeUntilExpiry != nil {

		// query param snaplock.time_until_expiry
		var qrSnaplockTimeUntilExpiry string

		if o.SnaplockTimeUntilExpiry != nil {
			qrSnaplockTimeUntilExpiry = *o.SnaplockTimeUntilExpiry
		}
		qSnaplockTimeUntilExpiry := qrSnaplockTimeUntilExpiry
		if qSnaplockTimeUntilExpiry != "" {

			if err := r.SetQueryParam("snaplock.time_until_expiry", qSnaplockTimeUntilExpiry); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorLabel != nil {

		// query param snapmirror_label
		var qrSnapmirrorLabel string

		if o.SnapmirrorLabel != nil {
			qrSnapmirrorLabel = *o.SnapmirrorLabel
		}
		qSnapmirrorLabel := qrSnapmirrorLabel
		if qSnapmirrorLabel != "" {

			if err := r.SetQueryParam("snapmirror_label", qSnapmirrorLabel); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotName != nil {

		// query param snapshot_volumes.snapshot.name
		var qrSnapshotVolumesSnapshotName string

		if o.SnapshotVolumesSnapshotName != nil {
			qrSnapshotVolumesSnapshotName = *o.SnapshotVolumesSnapshotName
		}
		qSnapshotVolumesSnapshotName := qrSnapshotVolumesSnapshotName
		if qSnapshotVolumesSnapshotName != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.name", qSnapshotVolumesSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesSnapshotUUID != nil {

		// query param snapshot_volumes.snapshot.uuid
		var qrSnapshotVolumesSnapshotUUID string

		if o.SnapshotVolumesSnapshotUUID != nil {
			qrSnapshotVolumesSnapshotUUID = *o.SnapshotVolumesSnapshotUUID
		}
		qSnapshotVolumesSnapshotUUID := qrSnapshotVolumesSnapshotUUID
		if qSnapshotVolumesSnapshotUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.snapshot.uuid", qSnapshotVolumesSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeName != nil {

		// query param snapshot_volumes.volume.name
		var qrSnapshotVolumesVolumeName string

		if o.SnapshotVolumesVolumeName != nil {
			qrSnapshotVolumesVolumeName = *o.SnapshotVolumesVolumeName
		}
		qSnapshotVolumesVolumeName := qrSnapshotVolumesVolumeName
		if qSnapshotVolumesVolumeName != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.name", qSnapshotVolumesVolumeName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotVolumesVolumeUUID != nil {

		// query param snapshot_volumes.volume.uuid
		var qrSnapshotVolumesVolumeUUID string

		if o.SnapshotVolumesVolumeUUID != nil {
			qrSnapshotVolumesVolumeUUID = *o.SnapshotVolumesVolumeUUID
		}
		qSnapshotVolumesVolumeUUID := qrSnapshotVolumesVolumeUUID
		if qSnapshotVolumesVolumeUUID != "" {

			if err := r.SetQueryParam("snapshot_volumes.volume.uuid", qSnapshotVolumesVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WriteFence != nil {

		// query param write_fence
		var qrWriteFence bool

		if o.WriteFence != nil {
			qrWriteFence = *o.WriteFence
		}
		qWriteFence := swag.FormatBool(qrWriteFence)
		if qWriteFence != "" {

			if err := r.SetQueryParam("write_fence", qWriteFence); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
