// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ConsistencyGroupSnapshotModifyCollectionReader is a Reader for the ConsistencyGroupSnapshotModifyCollection structure.
type ConsistencyGroupSnapshotModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ConsistencyGroupSnapshotModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewConsistencyGroupSnapshotModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewConsistencyGroupSnapshotModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewConsistencyGroupSnapshotModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewConsistencyGroupSnapshotModifyCollectionOK creates a ConsistencyGroupSnapshotModifyCollectionOK with default headers values
func NewConsistencyGroupSnapshotModifyCollectionOK() *ConsistencyGroupSnapshotModifyCollectionOK {
	return &ConsistencyGroupSnapshotModifyCollectionOK{}
}

/*
ConsistencyGroupSnapshotModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ConsistencyGroupSnapshotModifyCollectionOK struct {
}

// IsSuccess returns true when this consistency group snapshot modify collection o k response has a 2xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot modify collection o k response has a 3xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot modify collection o k response has a 4xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot modify collection o k response has a 5xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot modify collection o k response a status code equal to that given
func (o *ConsistencyGroupSnapshotModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the consistency group snapshot modify collection o k response
func (o *ConsistencyGroupSnapshotModifyCollectionOK) Code() int {
	return 200
}

func (o *ConsistencyGroupSnapshotModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotModifyCollectionOK", 200)
}

func (o *ConsistencyGroupSnapshotModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotModifyCollectionOK", 200)
}

func (o *ConsistencyGroupSnapshotModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewConsistencyGroupSnapshotModifyCollectionAccepted creates a ConsistencyGroupSnapshotModifyCollectionAccepted with default headers values
func NewConsistencyGroupSnapshotModifyCollectionAccepted() *ConsistencyGroupSnapshotModifyCollectionAccepted {
	return &ConsistencyGroupSnapshotModifyCollectionAccepted{}
}

/*
ConsistencyGroupSnapshotModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ConsistencyGroupSnapshotModifyCollectionAccepted struct {
	Payload *models.ConsistencyGroupSnapshotJobLinkResponse
}

// IsSuccess returns true when this consistency group snapshot modify collection accepted response has a 2xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this consistency group snapshot modify collection accepted response has a 3xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this consistency group snapshot modify collection accepted response has a 4xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this consistency group snapshot modify collection accepted response has a 5xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this consistency group snapshot modify collection accepted response a status code equal to that given
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the consistency group snapshot modify collection accepted response
func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) Code() int {
	return 202
}

func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistencyGroupSnapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) GetPayload() *models.ConsistencyGroupSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyGroupSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewConsistencyGroupSnapshotModifyCollectionDefault creates a ConsistencyGroupSnapshotModifyCollectionDefault with default headers values
func NewConsistencyGroupSnapshotModifyCollectionDefault(code int) *ConsistencyGroupSnapshotModifyCollectionDefault {
	return &ConsistencyGroupSnapshotModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ConsistencyGroupSnapshotModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 53411925 | Failed to find a previously initiated two-phase snapshot operation for consistency group.<personalities supports=asar2> |
| 53412015 | SnapLock expiry time cannot be before the current expiry time. |
| 53412016 | Snapshot is not retained by SnapLock. |
| 53412017 | The operation is not supported on this platform.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ConsistencyGroupSnapshotModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this consistency group snapshot modify collection default response has a 2xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this consistency group snapshot modify collection default response has a 3xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this consistency group snapshot modify collection default response has a 4xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this consistency group snapshot modify collection default response has a 5xx status code
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this consistency group snapshot modify collection default response a status code equal to that given
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the consistency group snapshot modify collection default response
func (o *ConsistencyGroupSnapshotModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ConsistencyGroupSnapshotModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/consistency-groups/{consistency_group.uuid}/snapshots][%d] consistency_group_snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *ConsistencyGroupSnapshotModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ConsistencyGroupSnapshotModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionBody consistency group snapshot modify collection body
swagger:model ConsistencyGroupSnapshotModifyCollectionBody
*/
type ConsistencyGroupSnapshotModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Comment for the snapshot.
	//
	// Example: My snapshot comment
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// consistency group snapshot response inline records
	ConsistencyGroupSnapshotResponseInlineRecords []*models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Consistency type. This is for categorization purposes only. A snapshot should not be set to 'application consistent' unless the host application is quiesced for the snapshot. Valid in POST.
	//
	// Example: crash
	// Enum: ["crash","application"]
	ConsistencyType *string `json:"consistency_type,omitempty"`

	// Time the snapshot copy was created
	//
	// Example: 2020-10-25 11:20:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates whether the snapshot taken is partial or not.
	//
	// Example: false
	// Read Only: true
	IsPartial *bool `json:"is_partial,omitempty"`

	// The list of LUNs in this snapshot.
	//
	// Read Only: true
	Luns []*ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0 `json:"luns"`

	// List of LUNs that are not in the snapshot.
	//
	// Read Only: true
	MissingLuns []*models.LunReference `json:"missing_luns"`

	// List of NVMe namespaces that are not in the snapshot.
	//
	// Read Only: true
	MissingNamespaces []*ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0 `json:"missing_namespaces"`

	// List of volumes which are not in the snapshot.
	//
	// Read Only: true
	MissingVolumes []*models.VolumeReference `json:"missing_volumes"`

	// Name of the snapshot.
	//
	Name *string `json:"name,omitempty"`

	// The list of NVMe namespaces in this snapshot.
	//
	// Read Only: true
	Namespaces []*ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0 `json:"namespaces"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	// Read Only: true
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the consistency group if this snapshot is restored.
	// Example: 4096
	// Read Only: true
	RestoreSize *int64 `json:"restore_size,omitempty"`

	// snaplock
	Snaplock *models.ConsistencyGroupSnapshotResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// Snapmirror Label for the snapshot.
	//
	// Example: sm_label
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// List of volume and snapshot identifiers for each volume in the snapshot.
	//
	// Read Only: true
	SnapshotVolumes []*models.ConsistencyGroupVolumeSnapshot `json:"snapshot_volumes"`

	// The SVM in which the consistency group is located.
	//
	Svm *models.SvmReference `json:"svm,omitempty"`

	// The unique identifier of the snapshot. The UUID is generated
	// by ONTAP when the snapshot is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Specifies whether a write fence will be taken when creating the snapshot. The default is false if there is only one volume in the consistency group, otherwise the default is true.
	//
	WriteFence *bool `json:"write_fence,omitempty"`
}

// Validate validates this consistency group snapshot modify collection body
func (o *ConsistencyGroupSnapshotModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroupSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMissingVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroup) { // not required
		return nil
	}

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateConsistencyGroupSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroupSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ConsistencyGroupSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.ConsistencyGroupSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ConsistencyGroupSnapshotResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupSnapshotModifyCollectionBodyTypeConsistencyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["crash","application"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupSnapshotModifyCollectionBodyTypeConsistencyTypePropEnum = append(consistencyGroupSnapshotModifyCollectionBodyTypeConsistencyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupSnapshotModifyCollectionBody
	// ConsistencyGroupSnapshotModifyCollectionBody
	// consistency_type
	// ConsistencyType
	// crash
	// END DEBUGGING
	// ConsistencyGroupSnapshotModifyCollectionBodyConsistencyTypeCrash captures enum value "crash"
	ConsistencyGroupSnapshotModifyCollectionBodyConsistencyTypeCrash string = "crash"

	// BEGIN DEBUGGING
	// ConsistencyGroupSnapshotModifyCollectionBody
	// ConsistencyGroupSnapshotModifyCollectionBody
	// consistency_type
	// ConsistencyType
	// application
	// END DEBUGGING
	// ConsistencyGroupSnapshotModifyCollectionBodyConsistencyTypeApplication captures enum value "application"
	ConsistencyGroupSnapshotModifyCollectionBodyConsistencyTypeApplication string = "application"
)

// prop value enum
func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateConsistencyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupSnapshotModifyCollectionBodyTypeConsistencyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateConsistencyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateConsistencyTypeEnum("info"+"."+"consistency_type", "body", *o.ConsistencyType); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.Luns) { // not required
		return nil
	}

	for i := 0; i < len(o.Luns); i++ {
		if swag.IsZero(o.Luns[i]) { // not required
			continue
		}

		if o.Luns[i] != nil {
			if err := o.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateMissingLuns(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingLuns) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingLuns); i++ {
		if swag.IsZero(o.MissingLuns[i]) { // not required
			continue
		}

		if o.MissingLuns[i] != nil {
			if err := o.MissingLuns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateMissingNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingNamespaces) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingNamespaces); i++ {
		if swag.IsZero(o.MissingNamespaces[i]) { // not required
			continue
		}

		if o.MissingNamespaces[i] != nil {
			if err := o.MissingNamespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateMissingVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.MissingVolumes) { // not required
		return nil
	}

	for i := 0; i < len(o.MissingVolumes); i++ {
		if swag.IsZero(o.MissingVolumes[i]) { // not required
			continue
		}

		if o.MissingVolumes[i] != nil {
			if err := o.MissingVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespaces) { // not required
		return nil
	}

	for i := 0; i < len(o.Namespaces); i++ {
		if swag.IsZero(o.Namespaces[i]) { // not required
			continue
		}

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateSnapshotVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotVolumes) { // not required
		return nil
	}

	for i := 0; i < len(o.SnapshotVolumes); i++ {
		if swag.IsZero(o.SnapshotVolumes[i]) { // not required
			continue
		}

		if o.SnapshotVolumes[i] != nil {
			if err := o.SnapshotVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "snapshot_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection body based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroupSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsPartial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMissingVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReclaimableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestoreSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateConsistencyGroupSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ConsistencyGroupSnapshotResponseInlineRecords); i++ {

		if o.ConsistencyGroupSnapshotResponseInlineRecords[i] != nil {
			if err := o.ConsistencyGroupSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateIsPartial(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_partial", "body", o.IsPartial); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"luns", "body", []*ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0(o.Luns)); err != nil {
		return err
	}

	for i := 0; i < len(o.Luns); i++ {

		if o.Luns[i] != nil {
			if err := o.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateMissingLuns(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"missing_luns", "body", []*models.LunReference(o.MissingLuns)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingLuns); i++ {

		if o.MissingLuns[i] != nil {
			if err := o.MissingLuns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateMissingNamespaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"missing_namespaces", "body", []*ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0(o.MissingNamespaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingNamespaces); i++ {

		if o.MissingNamespaces[i] != nil {
			if err := o.MissingNamespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateMissingVolumes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"missing_volumes", "body", []*models.VolumeReference(o.MissingVolumes)); err != nil {
		return err
	}

	for i := 0; i < len(o.MissingVolumes); i++ {

		if o.MissingVolumes[i] != nil {
			if err := o.MissingVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "missing_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"namespaces", "body", []*ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0(o.Namespaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.Namespaces); i++ {

		if o.Namespaces[i] != nil {
			if err := o.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateReclaimableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reclaimable_space", "body", o.ReclaimableSpace); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateRestoreSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"restore_size", "body", o.RestoreSize); err != nil {
		return err
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateSnapshotVolumes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot_volumes", "body", []*models.ConsistencyGroupVolumeSnapshot(o.SnapshotVolumes)); err != nil {
		return err
	}

	for i := 0; i < len(o.SnapshotVolumes); i++ {

		if o.SnapshotVolumes[i] != nil {
			if err := o.SnapshotVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "snapshot_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0 A reference to a LUN.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links `json:"_links,omitempty"`

	// The name of a LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body luns items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body luns items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links consistency group snapshot modify collection params body luns items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body luns items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body luns items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyLunsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body missing namespaces items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body missing namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links consistency group snapshot modify collection params body missing namespaces items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body missing namespaces items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body missing namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyMissingNamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body namespaces items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links consistency group snapshot modify collection params body namespaces items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body namespaces items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyNamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0 A reference to a LUN.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links `json:"_links,omitempty"`

	// The name of a LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 luns items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 luns items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links consistency group snapshot modify collection params body records items0 luns items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 luns items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 luns items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0LunsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 missing namespaces items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 missing namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links consistency group snapshot modify collection params body records items0 missing namespaces items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 missing namespaces items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 missing namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0MissingNamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0 A reference to a namespace.
//
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0 struct {

	// links
	Links *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links `json:"_links,omitempty"`

	// The name of an NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 namespaces items0
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 namespaces items0 based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links consistency group snapshot modify collection params body records items0 namespaces items0 links
swagger:model ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links
*/
type ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this consistency group snapshot modify collection params body records items0 namespaces items0 links
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group snapshot modify collection params body records items0 namespaces items0 links based on the context it is used
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupSnapshotModifyCollectionParamsBodyRecordsItems0NamespacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
