// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ContainerCreateReader is a Reader for the ContainerCreate structure.
type ContainerCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewContainerCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewContainerCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		return nil, runtime.NewAPIError("[POST /application/containers] container_create", response, response.Code())
	}
}

// NewContainerCreateCreated creates a ContainerCreateCreated with default headers values
func NewContainerCreateCreated() *ContainerCreateCreated {
	return &ContainerCreateCreated{}
}

/*
ContainerCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ContainerCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ContainerResponse
}

// IsSuccess returns true when this container create created response has a 2xx status code
func (o *ContainerCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container create created response has a 3xx status code
func (o *ContainerCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create created response has a 4xx status code
func (o *ContainerCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this container create created response has a 5xx status code
func (o *ContainerCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this container create created response a status code equal to that given
func (o *ContainerCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the container create created response
func (o *ContainerCreateCreated) Code() int {
	return 201
}

func (o *ContainerCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/containers][%d] containerCreateCreated %s", 201, payload)
}

func (o *ContainerCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/containers][%d] containerCreateCreated %s", 201, payload)
}

func (o *ContainerCreateCreated) GetPayload() *models.ContainerResponse {
	return o.Payload
}

func (o *ContainerCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ContainerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerCreateAccepted creates a ContainerCreateAccepted with default headers values
func NewContainerCreateAccepted() *ContainerCreateAccepted {
	return &ContainerCreateAccepted{}
}

/*
ContainerCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ContainerCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ContainerJobLinkResponse
}

// IsSuccess returns true when this container create accepted response has a 2xx status code
func (o *ContainerCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container create accepted response has a 3xx status code
func (o *ContainerCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create accepted response has a 4xx status code
func (o *ContainerCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this container create accepted response has a 5xx status code
func (o *ContainerCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this container create accepted response a status code equal to that given
func (o *ContainerCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the container create accepted response
func (o *ContainerCreateAccepted) Code() int {
	return 202
}

func (o *ContainerCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/containers][%d] containerCreateAccepted %s", 202, payload)
}

func (o *ContainerCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/containers][%d] containerCreateAccepted %s", 202, payload)
}

func (o *ContainerCreateAccepted) GetPayload() *models.ContainerJobLinkResponse {
	return o.Payload
}

func (o *ContainerCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ContainerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
