// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudTargetCollectionGetParams creates a new CloudTargetCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudTargetCollectionGetParams() *CloudTargetCollectionGetParams {
	return &CloudTargetCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudTargetCollectionGetParamsWithTimeout creates a new CloudTargetCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCloudTargetCollectionGetParamsWithTimeout(timeout time.Duration) *CloudTargetCollectionGetParams {
	return &CloudTargetCollectionGetParams{
		timeout: timeout,
	}
}

// NewCloudTargetCollectionGetParamsWithContext creates a new CloudTargetCollectionGetParams object
// with the ability to set a context for a request.
func NewCloudTargetCollectionGetParamsWithContext(ctx context.Context) *CloudTargetCollectionGetParams {
	return &CloudTargetCollectionGetParams{
		Context: ctx,
	}
}

// NewCloudTargetCollectionGetParamsWithHTTPClient creates a new CloudTargetCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudTargetCollectionGetParamsWithHTTPClient(client *http.Client) *CloudTargetCollectionGetParams {
	return &CloudTargetCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CloudTargetCollectionGetParams contains all the parameters to send to the API endpoint

	for the cloud target collection get operation.

	Typically these are written to a http.Request.
*/
type CloudTargetCollectionGetParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* AuthenticationType.

	   Filter by authentication_type
	*/
	AuthenticationType *string

	/* AzureAccount.

	   Filter by azure_account
	*/
	AzureAccount *string

	/* CapURL.

	   Filter by cap_url
	*/
	CapURL *string

	/* CertificateValidationEnabled.

	   Filter by certificate_validation_enabled
	*/
	CertificateValidationEnabled *bool

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* Container.

	   Filter by container
	*/
	Container *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ProviderType.

	   Filter by provider_type
	*/
	ProviderType *string

	/* ReadLatencyWarningThreshold.

	   Filter by read_latency_warning_threshold
	*/
	ReadLatencyWarningThreshold *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Server.

	   Filter by server
	*/
	Server *string

	/* ServerSideEncryption.

	   Filter by server_side_encryption
	*/
	ServerSideEncryption *string

	/* SnapmirrorUse.

	   Filter by snapmirror_use
	*/
	SnapmirrorUse *string

	/* SslEnabled.

	   Filter by ssl_enabled
	*/
	SslEnabled *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* URLStyle.

	   Filter by url_style
	*/
	URLStyle *string

	/* UseHTTPProxy.

	   Filter by use_http_proxy
	*/
	UseHTTPProxy *bool

	/* Used.

	   Filter by used
	*/
	Used *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud target collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetCollectionGetParams) WithDefaults() *CloudTargetCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud target collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CloudTargetCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithTimeout(timeout time.Duration) *CloudTargetCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithContext(ctx context.Context) *CloudTargetCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithHTTPClient(client *http.Client) *CloudTargetCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithAccessKey(accessKey *string) *CloudTargetCollectionGetParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithAuthenticationType adds the authenticationType to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithAuthenticationType(authenticationType *string) *CloudTargetCollectionGetParams {
	o.SetAuthenticationType(authenticationType)
	return o
}

// SetAuthenticationType adds the authenticationType to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetAuthenticationType(authenticationType *string) {
	o.AuthenticationType = authenticationType
}

// WithAzureAccount adds the azureAccount to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithAzureAccount(azureAccount *string) *CloudTargetCollectionGetParams {
	o.SetAzureAccount(azureAccount)
	return o
}

// SetAzureAccount adds the azureAccount to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetAzureAccount(azureAccount *string) {
	o.AzureAccount = azureAccount
}

// WithCapURL adds the capURL to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithCapURL(capURL *string) *CloudTargetCollectionGetParams {
	o.SetCapURL(capURL)
	return o
}

// SetCapURL adds the capUrl to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetCapURL(capURL *string) {
	o.CapURL = capURL
}

// WithCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithCertificateValidationEnabled(certificateValidationEnabled *bool) *CloudTargetCollectionGetParams {
	o.SetCertificateValidationEnabled(certificateValidationEnabled)
	return o
}

// SetCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetCertificateValidationEnabled(certificateValidationEnabled *bool) {
	o.CertificateValidationEnabled = certificateValidationEnabled
}

// WithClusterName adds the clusterName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithClusterName(clusterName *string) *CloudTargetCollectionGetParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithClusterUUID(clusterUUID *string) *CloudTargetCollectionGetParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithContainer adds the container to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithContainer(container *string) *CloudTargetCollectionGetParams {
	o.SetContainer(container)
	return o
}

// SetContainer adds the container to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetContainer(container *string) {
	o.Container = container
}

// WithFields adds the fields to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithFields(fields []string) *CloudTargetCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIpspaceName adds the ipspaceName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithIpspaceName(ipspaceName *string) *CloudTargetCollectionGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithIpspaceUUID(ipspaceUUID *string) *CloudTargetCollectionGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMaxRecords adds the maxRecords to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithMaxRecords(maxRecords *int64) *CloudTargetCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithName(name *string) *CloudTargetCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithOrderBy(orderBy []string) *CloudTargetCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwner adds the owner to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithOwner(owner *string) *CloudTargetCollectionGetParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithPort adds the port to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithPort(port *int64) *CloudTargetCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithProviderType adds the providerType to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithProviderType(providerType *string) *CloudTargetCollectionGetParams {
	o.SetProviderType(providerType)
	return o
}

// SetProviderType adds the providerType to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetProviderType(providerType *string) {
	o.ProviderType = providerType
}

// WithReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) *CloudTargetCollectionGetParams {
	o.SetReadLatencyWarningThreshold(readLatencyWarningThreshold)
	return o
}

// SetReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) {
	o.ReadLatencyWarningThreshold = readLatencyWarningThreshold
}

// WithReturnRecords adds the returnRecords to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithReturnRecords(returnRecords *bool) *CloudTargetCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CloudTargetCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithScope(scope *string) *CloudTargetCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithServer adds the server to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithServer(server *string) *CloudTargetCollectionGetParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetServer(server *string) {
	o.Server = server
}

// WithServerSideEncryption adds the serverSideEncryption to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithServerSideEncryption(serverSideEncryption *string) *CloudTargetCollectionGetParams {
	o.SetServerSideEncryption(serverSideEncryption)
	return o
}

// SetServerSideEncryption adds the serverSideEncryption to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetServerSideEncryption(serverSideEncryption *string) {
	o.ServerSideEncryption = serverSideEncryption
}

// WithSnapmirrorUse adds the snapmirrorUse to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithSnapmirrorUse(snapmirrorUse *string) *CloudTargetCollectionGetParams {
	o.SetSnapmirrorUse(snapmirrorUse)
	return o
}

// SetSnapmirrorUse adds the snapmirrorUse to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetSnapmirrorUse(snapmirrorUse *string) {
	o.SnapmirrorUse = snapmirrorUse
}

// WithSslEnabled adds the sslEnabled to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithSslEnabled(sslEnabled *bool) *CloudTargetCollectionGetParams {
	o.SetSslEnabled(sslEnabled)
	return o
}

// SetSslEnabled adds the sslEnabled to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetSslEnabled(sslEnabled *bool) {
	o.SslEnabled = sslEnabled
}

// WithSvmName adds the svmName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithSvmName(svmName *string) *CloudTargetCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithSvmUUID(svmUUID *string) *CloudTargetCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithURLStyle adds the uRLStyle to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithURLStyle(uRLStyle *string) *CloudTargetCollectionGetParams {
	o.SetURLStyle(uRLStyle)
	return o
}

// SetURLStyle adds the urlStyle to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetURLStyle(uRLStyle *string) {
	o.URLStyle = uRLStyle
}

// WithUseHTTPProxy adds the useHTTPProxy to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithUseHTTPProxy(useHTTPProxy *bool) *CloudTargetCollectionGetParams {
	o.SetUseHTTPProxy(useHTTPProxy)
	return o
}

// SetUseHTTPProxy adds the useHttpProxy to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetUseHTTPProxy(useHTTPProxy *bool) {
	o.UseHTTPProxy = useHTTPProxy
}

// WithUsed adds the used to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithUsed(used *int64) *CloudTargetCollectionGetParams {
	o.SetUsed(used)
	return o
}

// SetUsed adds the used to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetUsed(used *int64) {
	o.Used = used
}

// WithUUID adds the uuid to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) WithUUID(uuid *string) *CloudTargetCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the cloud target collection get params
func (o *CloudTargetCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *CloudTargetCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.AuthenticationType != nil {

		// query param authentication_type
		var qrAuthenticationType string

		if o.AuthenticationType != nil {
			qrAuthenticationType = *o.AuthenticationType
		}
		qAuthenticationType := qrAuthenticationType
		if qAuthenticationType != "" {

			if err := r.SetQueryParam("authentication_type", qAuthenticationType); err != nil {
				return err
			}
		}
	}

	if o.AzureAccount != nil {

		// query param azure_account
		var qrAzureAccount string

		if o.AzureAccount != nil {
			qrAzureAccount = *o.AzureAccount
		}
		qAzureAccount := qrAzureAccount
		if qAzureAccount != "" {

			if err := r.SetQueryParam("azure_account", qAzureAccount); err != nil {
				return err
			}
		}
	}

	if o.CapURL != nil {

		// query param cap_url
		var qrCapURL string

		if o.CapURL != nil {
			qrCapURL = *o.CapURL
		}
		qCapURL := qrCapURL
		if qCapURL != "" {

			if err := r.SetQueryParam("cap_url", qCapURL); err != nil {
				return err
			}
		}
	}

	if o.CertificateValidationEnabled != nil {

		// query param certificate_validation_enabled
		var qrCertificateValidationEnabled bool

		if o.CertificateValidationEnabled != nil {
			qrCertificateValidationEnabled = *o.CertificateValidationEnabled
		}
		qCertificateValidationEnabled := swag.FormatBool(qrCertificateValidationEnabled)
		if qCertificateValidationEnabled != "" {

			if err := r.SetQueryParam("certificate_validation_enabled", qCertificateValidationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.Container != nil {

		// query param container
		var qrContainer string

		if o.Container != nil {
			qrContainer = *o.Container
		}
		qContainer := qrContainer
		if qContainer != "" {

			if err := r.SetQueryParam("container", qContainer); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ProviderType != nil {

		// query param provider_type
		var qrProviderType string

		if o.ProviderType != nil {
			qrProviderType = *o.ProviderType
		}
		qProviderType := qrProviderType
		if qProviderType != "" {

			if err := r.SetQueryParam("provider_type", qProviderType); err != nil {
				return err
			}
		}
	}

	if o.ReadLatencyWarningThreshold != nil {

		// query param read_latency_warning_threshold
		var qrReadLatencyWarningThreshold int64

		if o.ReadLatencyWarningThreshold != nil {
			qrReadLatencyWarningThreshold = *o.ReadLatencyWarningThreshold
		}
		qReadLatencyWarningThreshold := swag.FormatInt64(qrReadLatencyWarningThreshold)
		if qReadLatencyWarningThreshold != "" {

			if err := r.SetQueryParam("read_latency_warning_threshold", qReadLatencyWarningThreshold); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.ServerSideEncryption != nil {

		// query param server_side_encryption
		var qrServerSideEncryption string

		if o.ServerSideEncryption != nil {
			qrServerSideEncryption = *o.ServerSideEncryption
		}
		qServerSideEncryption := qrServerSideEncryption
		if qServerSideEncryption != "" {

			if err := r.SetQueryParam("server_side_encryption", qServerSideEncryption); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorUse != nil {

		// query param snapmirror_use
		var qrSnapmirrorUse string

		if o.SnapmirrorUse != nil {
			qrSnapmirrorUse = *o.SnapmirrorUse
		}
		qSnapmirrorUse := qrSnapmirrorUse
		if qSnapmirrorUse != "" {

			if err := r.SetQueryParam("snapmirror_use", qSnapmirrorUse); err != nil {
				return err
			}
		}
	}

	if o.SslEnabled != nil {

		// query param ssl_enabled
		var qrSslEnabled bool

		if o.SslEnabled != nil {
			qrSslEnabled = *o.SslEnabled
		}
		qSslEnabled := swag.FormatBool(qrSslEnabled)
		if qSslEnabled != "" {

			if err := r.SetQueryParam("ssl_enabled", qSslEnabled); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.URLStyle != nil {

		// query param url_style
		var qrURLStyle string

		if o.URLStyle != nil {
			qrURLStyle = *o.URLStyle
		}
		qURLStyle := qrURLStyle
		if qURLStyle != "" {

			if err := r.SetQueryParam("url_style", qURLStyle); err != nil {
				return err
			}
		}
	}

	if o.UseHTTPProxy != nil {

		// query param use_http_proxy
		var qrUseHTTPProxy bool

		if o.UseHTTPProxy != nil {
			qrUseHTTPProxy = *o.UseHTTPProxy
		}
		qUseHTTPProxy := swag.FormatBool(qrUseHTTPProxy)
		if qUseHTTPProxy != "" {

			if err := r.SetQueryParam("use_http_proxy", qUseHTTPProxy); err != nil {
				return err
			}
		}
	}

	if o.Used != nil {

		// query param used
		var qrUsed int64

		if o.Used != nil {
			qrUsed = *o.Used
		}
		qUsed := swag.FormatInt64(qrUsed)
		if qUsed != "" {

			if err := r.SetQueryParam("used", qUsed); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCloudTargetCollectionGet binds the parameter fields
func (o *CloudTargetCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCloudTargetCollectionGet binds the parameter order_by
func (o *CloudTargetCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
