// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudTargetDeleteCollectionParams creates a new CloudTargetDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudTargetDeleteCollectionParams() *CloudTargetDeleteCollectionParams {
	return &CloudTargetDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudTargetDeleteCollectionParamsWithTimeout creates a new CloudTargetDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewCloudTargetDeleteCollectionParamsWithTimeout(timeout time.Duration) *CloudTargetDeleteCollectionParams {
	return &CloudTargetDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewCloudTargetDeleteCollectionParamsWithContext creates a new CloudTargetDeleteCollectionParams object
// with the ability to set a context for a request.
func NewCloudTargetDeleteCollectionParamsWithContext(ctx context.Context) *CloudTargetDeleteCollectionParams {
	return &CloudTargetDeleteCollectionParams{
		Context: ctx,
	}
}

// NewCloudTargetDeleteCollectionParamsWithHTTPClient creates a new CloudTargetDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudTargetDeleteCollectionParamsWithHTTPClient(client *http.Client) *CloudTargetDeleteCollectionParams {
	return &CloudTargetDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
CloudTargetDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cloud target delete collection operation.

	Typically these are written to a http.Request.
*/
type CloudTargetDeleteCollectionParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* AuthenticationType.

	   Filter by authentication_type
	*/
	AuthenticationType *string

	/* AzureAccount.

	   Filter by azure_account
	*/
	AzureAccount *string

	/* CapURL.

	   Filter by cap_url
	*/
	CapURL *string

	/* CertificateValidationEnabled.

	   Filter by certificate_validation_enabled
	*/
	CertificateValidationEnabled *bool

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* Container.

	   Filter by container
	*/
	Container *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info CloudTargetDeleteCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ProviderType.

	   Filter by provider_type
	*/
	ProviderType *string

	/* ReadLatencyWarningThreshold.

	   Filter by read_latency_warning_threshold
	*/
	ReadLatencyWarningThreshold *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Server.

	   Filter by server
	*/
	Server *string

	/* ServerSideEncryption.

	   Filter by server_side_encryption
	*/
	ServerSideEncryption *string

	/* SnapmirrorUse.

	   Filter by snapmirror_use
	*/
	SnapmirrorUse *string

	/* SslEnabled.

	   Filter by ssl_enabled
	*/
	SslEnabled *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* URLStyle.

	   Filter by url_style
	*/
	URLStyle *string

	/* UseHTTPProxy.

	   Filter by use_http_proxy
	*/
	UseHTTPProxy *bool

	/* Used.

	   Filter by used
	*/
	Used *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud target delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetDeleteCollectionParams) WithDefaults() *CloudTargetDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud target delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CloudTargetDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithTimeout(timeout time.Duration) *CloudTargetDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithContext(ctx context.Context) *CloudTargetDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithHTTPClient(client *http.Client) *CloudTargetDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithAccessKey(accessKey *string) *CloudTargetDeleteCollectionParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithAuthenticationType adds the authenticationType to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithAuthenticationType(authenticationType *string) *CloudTargetDeleteCollectionParams {
	o.SetAuthenticationType(authenticationType)
	return o
}

// SetAuthenticationType adds the authenticationType to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetAuthenticationType(authenticationType *string) {
	o.AuthenticationType = authenticationType
}

// WithAzureAccount adds the azureAccount to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithAzureAccount(azureAccount *string) *CloudTargetDeleteCollectionParams {
	o.SetAzureAccount(azureAccount)
	return o
}

// SetAzureAccount adds the azureAccount to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetAzureAccount(azureAccount *string) {
	o.AzureAccount = azureAccount
}

// WithCapURL adds the capURL to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithCapURL(capURL *string) *CloudTargetDeleteCollectionParams {
	o.SetCapURL(capURL)
	return o
}

// SetCapURL adds the capUrl to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetCapURL(capURL *string) {
	o.CapURL = capURL
}

// WithCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithCertificateValidationEnabled(certificateValidationEnabled *bool) *CloudTargetDeleteCollectionParams {
	o.SetCertificateValidationEnabled(certificateValidationEnabled)
	return o
}

// SetCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetCertificateValidationEnabled(certificateValidationEnabled *bool) {
	o.CertificateValidationEnabled = certificateValidationEnabled
}

// WithClusterName adds the clusterName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithClusterName(clusterName *string) *CloudTargetDeleteCollectionParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithClusterUUID(clusterUUID *string) *CloudTargetDeleteCollectionParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithContainer adds the container to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithContainer(container *string) *CloudTargetDeleteCollectionParams {
	o.SetContainer(container)
	return o
}

// SetContainer adds the container to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetContainer(container *string) {
	o.Container = container
}

// WithContinueOnFailure adds the continueOnFailure to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CloudTargetDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithInfo(info CloudTargetDeleteCollectionBody) *CloudTargetDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetInfo(info CloudTargetDeleteCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithIpspaceName(ipspaceName *string) *CloudTargetDeleteCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *CloudTargetDeleteCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithName adds the name to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithName(name *string) *CloudTargetDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwner adds the owner to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithOwner(owner *string) *CloudTargetDeleteCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithPort adds the port to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithPort(port *int64) *CloudTargetDeleteCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithProviderType adds the providerType to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithProviderType(providerType *string) *CloudTargetDeleteCollectionParams {
	o.SetProviderType(providerType)
	return o
}

// SetProviderType adds the providerType to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetProviderType(providerType *string) {
	o.ProviderType = providerType
}

// WithReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) *CloudTargetDeleteCollectionParams {
	o.SetReadLatencyWarningThreshold(readLatencyWarningThreshold)
	return o
}

// SetReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) {
	o.ReadLatencyWarningThreshold = readLatencyWarningThreshold
}

// WithReturnRecords adds the returnRecords to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *CloudTargetDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *CloudTargetDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithScope(scope *string) *CloudTargetDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *CloudTargetDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServer adds the server to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithServer(server *string) *CloudTargetDeleteCollectionParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetServer(server *string) {
	o.Server = server
}

// WithServerSideEncryption adds the serverSideEncryption to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithServerSideEncryption(serverSideEncryption *string) *CloudTargetDeleteCollectionParams {
	o.SetServerSideEncryption(serverSideEncryption)
	return o
}

// SetServerSideEncryption adds the serverSideEncryption to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetServerSideEncryption(serverSideEncryption *string) {
	o.ServerSideEncryption = serverSideEncryption
}

// WithSnapmirrorUse adds the snapmirrorUse to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithSnapmirrorUse(snapmirrorUse *string) *CloudTargetDeleteCollectionParams {
	o.SetSnapmirrorUse(snapmirrorUse)
	return o
}

// SetSnapmirrorUse adds the snapmirrorUse to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetSnapmirrorUse(snapmirrorUse *string) {
	o.SnapmirrorUse = snapmirrorUse
}

// WithSslEnabled adds the sslEnabled to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithSslEnabled(sslEnabled *bool) *CloudTargetDeleteCollectionParams {
	o.SetSslEnabled(sslEnabled)
	return o
}

// SetSslEnabled adds the sslEnabled to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetSslEnabled(sslEnabled *bool) {
	o.SslEnabled = sslEnabled
}

// WithSvmName adds the svmName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithSvmName(svmName *string) *CloudTargetDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithSvmUUID(svmUUID *string) *CloudTargetDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithURLStyle adds the uRLStyle to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithURLStyle(uRLStyle *string) *CloudTargetDeleteCollectionParams {
	o.SetURLStyle(uRLStyle)
	return o
}

// SetURLStyle adds the urlStyle to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetURLStyle(uRLStyle *string) {
	o.URLStyle = uRLStyle
}

// WithUseHTTPProxy adds the useHTTPProxy to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithUseHTTPProxy(useHTTPProxy *bool) *CloudTargetDeleteCollectionParams {
	o.SetUseHTTPProxy(useHTTPProxy)
	return o
}

// SetUseHTTPProxy adds the useHttpProxy to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetUseHTTPProxy(useHTTPProxy *bool) {
	o.UseHTTPProxy = useHTTPProxy
}

// WithUsed adds the used to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithUsed(used *int64) *CloudTargetDeleteCollectionParams {
	o.SetUsed(used)
	return o
}

// SetUsed adds the used to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetUsed(used *int64) {
	o.Used = used
}

// WithUUID adds the uuid to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) WithUUID(uuid *string) *CloudTargetDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the cloud target delete collection params
func (o *CloudTargetDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *CloudTargetDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.AuthenticationType != nil {

		// query param authentication_type
		var qrAuthenticationType string

		if o.AuthenticationType != nil {
			qrAuthenticationType = *o.AuthenticationType
		}
		qAuthenticationType := qrAuthenticationType
		if qAuthenticationType != "" {

			if err := r.SetQueryParam("authentication_type", qAuthenticationType); err != nil {
				return err
			}
		}
	}

	if o.AzureAccount != nil {

		// query param azure_account
		var qrAzureAccount string

		if o.AzureAccount != nil {
			qrAzureAccount = *o.AzureAccount
		}
		qAzureAccount := qrAzureAccount
		if qAzureAccount != "" {

			if err := r.SetQueryParam("azure_account", qAzureAccount); err != nil {
				return err
			}
		}
	}

	if o.CapURL != nil {

		// query param cap_url
		var qrCapURL string

		if o.CapURL != nil {
			qrCapURL = *o.CapURL
		}
		qCapURL := qrCapURL
		if qCapURL != "" {

			if err := r.SetQueryParam("cap_url", qCapURL); err != nil {
				return err
			}
		}
	}

	if o.CertificateValidationEnabled != nil {

		// query param certificate_validation_enabled
		var qrCertificateValidationEnabled bool

		if o.CertificateValidationEnabled != nil {
			qrCertificateValidationEnabled = *o.CertificateValidationEnabled
		}
		qCertificateValidationEnabled := swag.FormatBool(qrCertificateValidationEnabled)
		if qCertificateValidationEnabled != "" {

			if err := r.SetQueryParam("certificate_validation_enabled", qCertificateValidationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.Container != nil {

		// query param container
		var qrContainer string

		if o.Container != nil {
			qrContainer = *o.Container
		}
		qContainer := qrContainer
		if qContainer != "" {

			if err := r.SetQueryParam("container", qContainer); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ProviderType != nil {

		// query param provider_type
		var qrProviderType string

		if o.ProviderType != nil {
			qrProviderType = *o.ProviderType
		}
		qProviderType := qrProviderType
		if qProviderType != "" {

			if err := r.SetQueryParam("provider_type", qProviderType); err != nil {
				return err
			}
		}
	}

	if o.ReadLatencyWarningThreshold != nil {

		// query param read_latency_warning_threshold
		var qrReadLatencyWarningThreshold int64

		if o.ReadLatencyWarningThreshold != nil {
			qrReadLatencyWarningThreshold = *o.ReadLatencyWarningThreshold
		}
		qReadLatencyWarningThreshold := swag.FormatInt64(qrReadLatencyWarningThreshold)
		if qReadLatencyWarningThreshold != "" {

			if err := r.SetQueryParam("read_latency_warning_threshold", qReadLatencyWarningThreshold); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.ServerSideEncryption != nil {

		// query param server_side_encryption
		var qrServerSideEncryption string

		if o.ServerSideEncryption != nil {
			qrServerSideEncryption = *o.ServerSideEncryption
		}
		qServerSideEncryption := qrServerSideEncryption
		if qServerSideEncryption != "" {

			if err := r.SetQueryParam("server_side_encryption", qServerSideEncryption); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorUse != nil {

		// query param snapmirror_use
		var qrSnapmirrorUse string

		if o.SnapmirrorUse != nil {
			qrSnapmirrorUse = *o.SnapmirrorUse
		}
		qSnapmirrorUse := qrSnapmirrorUse
		if qSnapmirrorUse != "" {

			if err := r.SetQueryParam("snapmirror_use", qSnapmirrorUse); err != nil {
				return err
			}
		}
	}

	if o.SslEnabled != nil {

		// query param ssl_enabled
		var qrSslEnabled bool

		if o.SslEnabled != nil {
			qrSslEnabled = *o.SslEnabled
		}
		qSslEnabled := swag.FormatBool(qrSslEnabled)
		if qSslEnabled != "" {

			if err := r.SetQueryParam("ssl_enabled", qSslEnabled); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.URLStyle != nil {

		// query param url_style
		var qrURLStyle string

		if o.URLStyle != nil {
			qrURLStyle = *o.URLStyle
		}
		qURLStyle := qrURLStyle
		if qURLStyle != "" {

			if err := r.SetQueryParam("url_style", qURLStyle); err != nil {
				return err
			}
		}
	}

	if o.UseHTTPProxy != nil {

		// query param use_http_proxy
		var qrUseHTTPProxy bool

		if o.UseHTTPProxy != nil {
			qrUseHTTPProxy = *o.UseHTTPProxy
		}
		qUseHTTPProxy := swag.FormatBool(qrUseHTTPProxy)
		if qUseHTTPProxy != "" {

			if err := r.SetQueryParam("use_http_proxy", qUseHTTPProxy); err != nil {
				return err
			}
		}
	}

	if o.Used != nil {

		// query param used
		var qrUsed int64

		if o.Used != nil {
			qrUsed = *o.Used
		}
		qUsed := swag.FormatInt64(qrUsed)
		if qUsed != "" {

			if err := r.SetQueryParam("used", qUsed); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
