// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudTargetDeleteCollectionReader is a Reader for the CloudTargetDeleteCollection structure.
type CloudTargetDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudTargetDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudTargetDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCloudTargetDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudTargetDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudTargetDeleteCollectionOK creates a CloudTargetDeleteCollectionOK with default headers values
func NewCloudTargetDeleteCollectionOK() *CloudTargetDeleteCollectionOK {
	return &CloudTargetDeleteCollectionOK{}
}

/*
CloudTargetDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CloudTargetDeleteCollectionOK struct {
	Payload *models.CloudTargetJobLinkResponse
}

// IsSuccess returns true when this cloud target delete collection o k response has a 2xx status code
func (o *CloudTargetDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud target delete collection o k response has a 3xx status code
func (o *CloudTargetDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud target delete collection o k response has a 4xx status code
func (o *CloudTargetDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud target delete collection o k response has a 5xx status code
func (o *CloudTargetDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud target delete collection o k response a status code equal to that given
func (o *CloudTargetDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud target delete collection o k response
func (o *CloudTargetDeleteCollectionOK) Code() int {
	return 200
}

func (o *CloudTargetDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloudTargetDeleteCollectionOK %s", 200, payload)
}

func (o *CloudTargetDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloudTargetDeleteCollectionOK %s", 200, payload)
}

func (o *CloudTargetDeleteCollectionOK) GetPayload() *models.CloudTargetJobLinkResponse {
	return o.Payload
}

func (o *CloudTargetDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudTargetJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudTargetDeleteCollectionAccepted creates a CloudTargetDeleteCollectionAccepted with default headers values
func NewCloudTargetDeleteCollectionAccepted() *CloudTargetDeleteCollectionAccepted {
	return &CloudTargetDeleteCollectionAccepted{}
}

/*
CloudTargetDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CloudTargetDeleteCollectionAccepted struct {
	Payload *models.CloudTargetJobLinkResponse
}

// IsSuccess returns true when this cloud target delete collection accepted response has a 2xx status code
func (o *CloudTargetDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud target delete collection accepted response has a 3xx status code
func (o *CloudTargetDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud target delete collection accepted response has a 4xx status code
func (o *CloudTargetDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud target delete collection accepted response has a 5xx status code
func (o *CloudTargetDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud target delete collection accepted response a status code equal to that given
func (o *CloudTargetDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cloud target delete collection accepted response
func (o *CloudTargetDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *CloudTargetDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloudTargetDeleteCollectionAccepted %s", 202, payload)
}

func (o *CloudTargetDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloudTargetDeleteCollectionAccepted %s", 202, payload)
}

func (o *CloudTargetDeleteCollectionAccepted) GetPayload() *models.CloudTargetJobLinkResponse {
	return o.Payload
}

func (o *CloudTargetDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudTargetJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudTargetDeleteCollectionDefault creates a CloudTargetDeleteCollectionDefault with default headers values
func NewCloudTargetDeleteCollectionDefault(code int) *CloudTargetDeleteCollectionDefault {
	return &CloudTargetDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	CloudTargetDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 787013 | Cannot delete object store configuration as the store is attached to one or more aggregates. |
| 787014 | Cannot delete object store configuration as there are objects in the store. |
| 787078 | Cannot delete object store configuration. |
| 787188 | Object store configuration belongs to another cluster and cannot be modified from the local cluster, unless the cluster is in switchover mode. |
| 787216 | Cannot perform object store configuration operations on a cluster that is waiting for switchback. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CloudTargetDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud target delete collection default response has a 2xx status code
func (o *CloudTargetDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud target delete collection default response has a 3xx status code
func (o *CloudTargetDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud target delete collection default response has a 4xx status code
func (o *CloudTargetDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud target delete collection default response has a 5xx status code
func (o *CloudTargetDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud target delete collection default response a status code equal to that given
func (o *CloudTargetDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud target delete collection default response
func (o *CloudTargetDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CloudTargetDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloud_target_delete_collection default %s", o._statusCode, payload)
}

func (o *CloudTargetDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloud/targets][%d] cloud_target_delete_collection default %s", o._statusCode, payload)
}

func (o *CloudTargetDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudTargetDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CloudTargetDeleteCollectionBody cloud target delete collection body
swagger:model CloudTargetDeleteCollectionBody
*/
type CloudTargetDeleteCollectionBody struct {

	// cloud target response inline records
	CloudTargetResponseInlineRecords []*models.CloudTarget `json:"records,omitempty"`
}

// Validate validates this cloud target delete collection body
func (o *CloudTargetDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCloudTargetResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetDeleteCollectionBody) validateCloudTargetResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudTargetResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CloudTargetResponseInlineRecords); i++ {
		if swag.IsZero(o.CloudTargetResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CloudTargetResponseInlineRecords[i] != nil {
			if err := o.CloudTargetResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cloud target delete collection body based on the context it is used
func (o *CloudTargetDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCloudTargetResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetDeleteCollectionBody) contextValidateCloudTargetResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CloudTargetResponseInlineRecords); i++ {

		if o.CloudTargetResponseInlineRecords[i] != nil {
			if err := o.CloudTargetResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CloudTargetDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
