// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudTargetGetReader is a Reader for the CloudTargetGet structure.
type CloudTargetGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudTargetGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudTargetGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudTargetGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudTargetGetOK creates a CloudTargetGetOK with default headers values
func NewCloudTargetGetOK() *CloudTargetGetOK {
	return &CloudTargetGetOK{}
}

/*
CloudTargetGetOK describes a response with status code 200, with default header values.

OK
*/
type CloudTargetGetOK struct {
	Payload *models.CloudTarget
}

// IsSuccess returns true when this cloud target get o k response has a 2xx status code
func (o *CloudTargetGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud target get o k response has a 3xx status code
func (o *CloudTargetGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud target get o k response has a 4xx status code
func (o *CloudTargetGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud target get o k response has a 5xx status code
func (o *CloudTargetGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud target get o k response a status code equal to that given
func (o *CloudTargetGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud target get o k response
func (o *CloudTargetGetOK) Code() int {
	return 200
}

func (o *CloudTargetGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloud/targets/{uuid}][%d] cloudTargetGetOK %s", 200, payload)
}

func (o *CloudTargetGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloud/targets/{uuid}][%d] cloudTargetGetOK %s", 200, payload)
}

func (o *CloudTargetGetOK) GetPayload() *models.CloudTarget {
	return o.Payload
}

func (o *CloudTargetGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudTarget)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudTargetGetDefault creates a CloudTargetGetDefault with default headers values
func NewCloudTargetGetDefault(code int) *CloudTargetGetDefault {
	return &CloudTargetGetDefault{
		_statusCode: code,
	}
}

/*
CloudTargetGetDefault describes a response with status code -1, with default header values.

Error
*/
type CloudTargetGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud target get default response has a 2xx status code
func (o *CloudTargetGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud target get default response has a 3xx status code
func (o *CloudTargetGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud target get default response has a 4xx status code
func (o *CloudTargetGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud target get default response has a 5xx status code
func (o *CloudTargetGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud target get default response a status code equal to that given
func (o *CloudTargetGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud target get default response
func (o *CloudTargetGetDefault) Code() int {
	return o._statusCode
}

func (o *CloudTargetGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloud/targets/{uuid}][%d] cloud_target_get default %s", o._statusCode, payload)
}

func (o *CloudTargetGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloud/targets/{uuid}][%d] cloud_target_get default %s", o._statusCode, payload)
}

func (o *CloudTargetGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudTargetGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
