// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudTargetModifyCollectionParams creates a new CloudTargetModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudTargetModifyCollectionParams() *CloudTargetModifyCollectionParams {
	return &CloudTargetModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudTargetModifyCollectionParamsWithTimeout creates a new CloudTargetModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewCloudTargetModifyCollectionParamsWithTimeout(timeout time.Duration) *CloudTargetModifyCollectionParams {
	return &CloudTargetModifyCollectionParams{
		timeout: timeout,
	}
}

// NewCloudTargetModifyCollectionParamsWithContext creates a new CloudTargetModifyCollectionParams object
// with the ability to set a context for a request.
func NewCloudTargetModifyCollectionParamsWithContext(ctx context.Context) *CloudTargetModifyCollectionParams {
	return &CloudTargetModifyCollectionParams{
		Context: ctx,
	}
}

// NewCloudTargetModifyCollectionParamsWithHTTPClient creates a new CloudTargetModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudTargetModifyCollectionParamsWithHTTPClient(client *http.Client) *CloudTargetModifyCollectionParams {
	return &CloudTargetModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
CloudTargetModifyCollectionParams contains all the parameters to send to the API endpoint

	for the cloud target modify collection operation.

	Typically these are written to a http.Request.
*/
type CloudTargetModifyCollectionParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* AuthenticationType.

	   Filter by authentication_type
	*/
	AuthenticationType *string

	/* AzureAccount.

	   Filter by azure_account
	*/
	AzureAccount *string

	/* CapURL.

	   Filter by cap_url
	*/
	CapURL *string

	/* CertificateValidationEnabled.

	   Filter by certificate_validation_enabled
	*/
	CertificateValidationEnabled *bool

	/* CheckOnly.

	   Do not modify the configuration, only check that the PATCH request succeeds.
	*/
	CheckOnly *bool

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* Container.

	   Filter by container
	*/
	Container *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* IgnoreWarnings.

	   Specifies whether or not warnings should be ignored.
	*/
	IgnoreWarnings *bool

	/* Info.

	   Info specification
	*/
	Info CloudTargetModifyCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ProviderType.

	   Filter by provider_type
	*/
	ProviderType *string

	/* ReadLatencyWarningThreshold.

	   Filter by read_latency_warning_threshold
	*/
	ReadLatencyWarningThreshold *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Server.

	   Filter by server
	*/
	Server *string

	/* ServerSideEncryption.

	   Filter by server_side_encryption
	*/
	ServerSideEncryption *string

	/* SnapmirrorUse.

	   Filter by snapmirror_use
	*/
	SnapmirrorUse *string

	/* SslEnabled.

	   Filter by ssl_enabled
	*/
	SslEnabled *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* URLStyle.

	   Filter by url_style
	*/
	URLStyle *string

	/* UseHTTPProxy.

	   Filter by use_http_proxy
	*/
	UseHTTPProxy *bool

	/* Used.

	   Filter by used
	*/
	Used *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud target modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetModifyCollectionParams) WithDefaults() *CloudTargetModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud target modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudTargetModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CloudTargetModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithTimeout(timeout time.Duration) *CloudTargetModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithContext(ctx context.Context) *CloudTargetModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithHTTPClient(client *http.Client) *CloudTargetModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithAccessKey(accessKey *string) *CloudTargetModifyCollectionParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithAuthenticationType adds the authenticationType to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithAuthenticationType(authenticationType *string) *CloudTargetModifyCollectionParams {
	o.SetAuthenticationType(authenticationType)
	return o
}

// SetAuthenticationType adds the authenticationType to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetAuthenticationType(authenticationType *string) {
	o.AuthenticationType = authenticationType
}

// WithAzureAccount adds the azureAccount to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithAzureAccount(azureAccount *string) *CloudTargetModifyCollectionParams {
	o.SetAzureAccount(azureAccount)
	return o
}

// SetAzureAccount adds the azureAccount to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetAzureAccount(azureAccount *string) {
	o.AzureAccount = azureAccount
}

// WithCapURL adds the capURL to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithCapURL(capURL *string) *CloudTargetModifyCollectionParams {
	o.SetCapURL(capURL)
	return o
}

// SetCapURL adds the capUrl to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetCapURL(capURL *string) {
	o.CapURL = capURL
}

// WithCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithCertificateValidationEnabled(certificateValidationEnabled *bool) *CloudTargetModifyCollectionParams {
	o.SetCertificateValidationEnabled(certificateValidationEnabled)
	return o
}

// SetCertificateValidationEnabled adds the certificateValidationEnabled to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetCertificateValidationEnabled(certificateValidationEnabled *bool) {
	o.CertificateValidationEnabled = certificateValidationEnabled
}

// WithCheckOnly adds the checkOnly to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithCheckOnly(checkOnly *bool) *CloudTargetModifyCollectionParams {
	o.SetCheckOnly(checkOnly)
	return o
}

// SetCheckOnly adds the checkOnly to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetCheckOnly(checkOnly *bool) {
	o.CheckOnly = checkOnly
}

// WithClusterName adds the clusterName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithClusterName(clusterName *string) *CloudTargetModifyCollectionParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithClusterUUID(clusterUUID *string) *CloudTargetModifyCollectionParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithContainer adds the container to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithContainer(container *string) *CloudTargetModifyCollectionParams {
	o.SetContainer(container)
	return o
}

// SetContainer adds the container to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetContainer(container *string) {
	o.Container = container
}

// WithContinueOnFailure adds the continueOnFailure to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CloudTargetModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIgnoreWarnings adds the ignoreWarnings to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithIgnoreWarnings(ignoreWarnings *bool) *CloudTargetModifyCollectionParams {
	o.SetIgnoreWarnings(ignoreWarnings)
	return o
}

// SetIgnoreWarnings adds the ignoreWarnings to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetIgnoreWarnings(ignoreWarnings *bool) {
	o.IgnoreWarnings = ignoreWarnings
}

// WithInfo adds the info to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithInfo(info CloudTargetModifyCollectionBody) *CloudTargetModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetInfo(info CloudTargetModifyCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithIpspaceName(ipspaceName *string) *CloudTargetModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *CloudTargetModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithName adds the name to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithName(name *string) *CloudTargetModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwner adds the owner to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithOwner(owner *string) *CloudTargetModifyCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithPort adds the port to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithPort(port *int64) *CloudTargetModifyCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithProviderType adds the providerType to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithProviderType(providerType *string) *CloudTargetModifyCollectionParams {
	o.SetProviderType(providerType)
	return o
}

// SetProviderType adds the providerType to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetProviderType(providerType *string) {
	o.ProviderType = providerType
}

// WithReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) *CloudTargetModifyCollectionParams {
	o.SetReadLatencyWarningThreshold(readLatencyWarningThreshold)
	return o
}

// SetReadLatencyWarningThreshold adds the readLatencyWarningThreshold to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetReadLatencyWarningThreshold(readLatencyWarningThreshold *int64) {
	o.ReadLatencyWarningThreshold = readLatencyWarningThreshold
}

// WithReturnRecords adds the returnRecords to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithReturnRecords(returnRecords *bool) *CloudTargetModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *CloudTargetModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithScope(scope *string) *CloudTargetModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithSerialRecords(serialRecords *bool) *CloudTargetModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServer adds the server to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithServer(server *string) *CloudTargetModifyCollectionParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetServer(server *string) {
	o.Server = server
}

// WithServerSideEncryption adds the serverSideEncryption to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithServerSideEncryption(serverSideEncryption *string) *CloudTargetModifyCollectionParams {
	o.SetServerSideEncryption(serverSideEncryption)
	return o
}

// SetServerSideEncryption adds the serverSideEncryption to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetServerSideEncryption(serverSideEncryption *string) {
	o.ServerSideEncryption = serverSideEncryption
}

// WithSnapmirrorUse adds the snapmirrorUse to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithSnapmirrorUse(snapmirrorUse *string) *CloudTargetModifyCollectionParams {
	o.SetSnapmirrorUse(snapmirrorUse)
	return o
}

// SetSnapmirrorUse adds the snapmirrorUse to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetSnapmirrorUse(snapmirrorUse *string) {
	o.SnapmirrorUse = snapmirrorUse
}

// WithSslEnabled adds the sslEnabled to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithSslEnabled(sslEnabled *bool) *CloudTargetModifyCollectionParams {
	o.SetSslEnabled(sslEnabled)
	return o
}

// SetSslEnabled adds the sslEnabled to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetSslEnabled(sslEnabled *bool) {
	o.SslEnabled = sslEnabled
}

// WithSvmName adds the svmName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithSvmName(svmName *string) *CloudTargetModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithSvmUUID(svmUUID *string) *CloudTargetModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithURLStyle adds the uRLStyle to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithURLStyle(uRLStyle *string) *CloudTargetModifyCollectionParams {
	o.SetURLStyle(uRLStyle)
	return o
}

// SetURLStyle adds the urlStyle to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetURLStyle(uRLStyle *string) {
	o.URLStyle = uRLStyle
}

// WithUseHTTPProxy adds the useHTTPProxy to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithUseHTTPProxy(useHTTPProxy *bool) *CloudTargetModifyCollectionParams {
	o.SetUseHTTPProxy(useHTTPProxy)
	return o
}

// SetUseHTTPProxy adds the useHttpProxy to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetUseHTTPProxy(useHTTPProxy *bool) {
	o.UseHTTPProxy = useHTTPProxy
}

// WithUsed adds the used to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithUsed(used *int64) *CloudTargetModifyCollectionParams {
	o.SetUsed(used)
	return o
}

// SetUsed adds the used to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetUsed(used *int64) {
	o.Used = used
}

// WithUUID adds the uuid to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) WithUUID(uuid *string) *CloudTargetModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the cloud target modify collection params
func (o *CloudTargetModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *CloudTargetModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.AuthenticationType != nil {

		// query param authentication_type
		var qrAuthenticationType string

		if o.AuthenticationType != nil {
			qrAuthenticationType = *o.AuthenticationType
		}
		qAuthenticationType := qrAuthenticationType
		if qAuthenticationType != "" {

			if err := r.SetQueryParam("authentication_type", qAuthenticationType); err != nil {
				return err
			}
		}
	}

	if o.AzureAccount != nil {

		// query param azure_account
		var qrAzureAccount string

		if o.AzureAccount != nil {
			qrAzureAccount = *o.AzureAccount
		}
		qAzureAccount := qrAzureAccount
		if qAzureAccount != "" {

			if err := r.SetQueryParam("azure_account", qAzureAccount); err != nil {
				return err
			}
		}
	}

	if o.CapURL != nil {

		// query param cap_url
		var qrCapURL string

		if o.CapURL != nil {
			qrCapURL = *o.CapURL
		}
		qCapURL := qrCapURL
		if qCapURL != "" {

			if err := r.SetQueryParam("cap_url", qCapURL); err != nil {
				return err
			}
		}
	}

	if o.CertificateValidationEnabled != nil {

		// query param certificate_validation_enabled
		var qrCertificateValidationEnabled bool

		if o.CertificateValidationEnabled != nil {
			qrCertificateValidationEnabled = *o.CertificateValidationEnabled
		}
		qCertificateValidationEnabled := swag.FormatBool(qrCertificateValidationEnabled)
		if qCertificateValidationEnabled != "" {

			if err := r.SetQueryParam("certificate_validation_enabled", qCertificateValidationEnabled); err != nil {
				return err
			}
		}
	}

	if o.CheckOnly != nil {

		// query param check_only
		var qrCheckOnly bool

		if o.CheckOnly != nil {
			qrCheckOnly = *o.CheckOnly
		}
		qCheckOnly := swag.FormatBool(qrCheckOnly)
		if qCheckOnly != "" {

			if err := r.SetQueryParam("check_only", qCheckOnly); err != nil {
				return err
			}
		}
	}

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.Container != nil {

		// query param container
		var qrContainer string

		if o.Container != nil {
			qrContainer = *o.Container
		}
		qContainer := qrContainer
		if qContainer != "" {

			if err := r.SetQueryParam("container", qContainer); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.IgnoreWarnings != nil {

		// query param ignore_warnings
		var qrIgnoreWarnings bool

		if o.IgnoreWarnings != nil {
			qrIgnoreWarnings = *o.IgnoreWarnings
		}
		qIgnoreWarnings := swag.FormatBool(qrIgnoreWarnings)
		if qIgnoreWarnings != "" {

			if err := r.SetQueryParam("ignore_warnings", qIgnoreWarnings); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ProviderType != nil {

		// query param provider_type
		var qrProviderType string

		if o.ProviderType != nil {
			qrProviderType = *o.ProviderType
		}
		qProviderType := qrProviderType
		if qProviderType != "" {

			if err := r.SetQueryParam("provider_type", qProviderType); err != nil {
				return err
			}
		}
	}

	if o.ReadLatencyWarningThreshold != nil {

		// query param read_latency_warning_threshold
		var qrReadLatencyWarningThreshold int64

		if o.ReadLatencyWarningThreshold != nil {
			qrReadLatencyWarningThreshold = *o.ReadLatencyWarningThreshold
		}
		qReadLatencyWarningThreshold := swag.FormatInt64(qrReadLatencyWarningThreshold)
		if qReadLatencyWarningThreshold != "" {

			if err := r.SetQueryParam("read_latency_warning_threshold", qReadLatencyWarningThreshold); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.ServerSideEncryption != nil {

		// query param server_side_encryption
		var qrServerSideEncryption string

		if o.ServerSideEncryption != nil {
			qrServerSideEncryption = *o.ServerSideEncryption
		}
		qServerSideEncryption := qrServerSideEncryption
		if qServerSideEncryption != "" {

			if err := r.SetQueryParam("server_side_encryption", qServerSideEncryption); err != nil {
				return err
			}
		}
	}

	if o.SnapmirrorUse != nil {

		// query param snapmirror_use
		var qrSnapmirrorUse string

		if o.SnapmirrorUse != nil {
			qrSnapmirrorUse = *o.SnapmirrorUse
		}
		qSnapmirrorUse := qrSnapmirrorUse
		if qSnapmirrorUse != "" {

			if err := r.SetQueryParam("snapmirror_use", qSnapmirrorUse); err != nil {
				return err
			}
		}
	}

	if o.SslEnabled != nil {

		// query param ssl_enabled
		var qrSslEnabled bool

		if o.SslEnabled != nil {
			qrSslEnabled = *o.SslEnabled
		}
		qSslEnabled := swag.FormatBool(qrSslEnabled)
		if qSslEnabled != "" {

			if err := r.SetQueryParam("ssl_enabled", qSslEnabled); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.URLStyle != nil {

		// query param url_style
		var qrURLStyle string

		if o.URLStyle != nil {
			qrURLStyle = *o.URLStyle
		}
		qURLStyle := qrURLStyle
		if qURLStyle != "" {

			if err := r.SetQueryParam("url_style", qURLStyle); err != nil {
				return err
			}
		}
	}

	if o.UseHTTPProxy != nil {

		// query param use_http_proxy
		var qrUseHTTPProxy bool

		if o.UseHTTPProxy != nil {
			qrUseHTTPProxy = *o.UseHTTPProxy
		}
		qUseHTTPProxy := swag.FormatBool(qrUseHTTPProxy)
		if qUseHTTPProxy != "" {

			if err := r.SetQueryParam("use_http_proxy", qUseHTTPProxy); err != nil {
				return err
			}
		}
	}

	if o.Used != nil {

		// query param used
		var qrUsed int64

		if o.Used != nil {
			qrUsed = *o.Used
		}
		qUsed := swag.FormatInt64(qrUsed)
		if qUsed != "" {

			if err := r.SetQueryParam("used", qUsed); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
