// Code generated by go-swagger; DO NOT EDIT.

package cloud

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudTargetModifyCollectionReader is a Reader for the CloudTargetModifyCollection structure.
type CloudTargetModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudTargetModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudTargetModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCloudTargetModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudTargetModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudTargetModifyCollectionOK creates a CloudTargetModifyCollectionOK with default headers values
func NewCloudTargetModifyCollectionOK() *CloudTargetModifyCollectionOK {
	return &CloudTargetModifyCollectionOK{}
}

/*
CloudTargetModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CloudTargetModifyCollectionOK struct {
	Payload *models.CloudTargetJobLinkResponse
}

// IsSuccess returns true when this cloud target modify collection o k response has a 2xx status code
func (o *CloudTargetModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud target modify collection o k response has a 3xx status code
func (o *CloudTargetModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud target modify collection o k response has a 4xx status code
func (o *CloudTargetModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud target modify collection o k response has a 5xx status code
func (o *CloudTargetModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud target modify collection o k response a status code equal to that given
func (o *CloudTargetModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud target modify collection o k response
func (o *CloudTargetModifyCollectionOK) Code() int {
	return 200
}

func (o *CloudTargetModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloudTargetModifyCollectionOK %s", 200, payload)
}

func (o *CloudTargetModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloudTargetModifyCollectionOK %s", 200, payload)
}

func (o *CloudTargetModifyCollectionOK) GetPayload() *models.CloudTargetJobLinkResponse {
	return o.Payload
}

func (o *CloudTargetModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudTargetJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudTargetModifyCollectionAccepted creates a CloudTargetModifyCollectionAccepted with default headers values
func NewCloudTargetModifyCollectionAccepted() *CloudTargetModifyCollectionAccepted {
	return &CloudTargetModifyCollectionAccepted{}
}

/*
CloudTargetModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CloudTargetModifyCollectionAccepted struct {
	Payload *models.CloudTargetJobLinkResponse
}

// IsSuccess returns true when this cloud target modify collection accepted response has a 2xx status code
func (o *CloudTargetModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud target modify collection accepted response has a 3xx status code
func (o *CloudTargetModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud target modify collection accepted response has a 4xx status code
func (o *CloudTargetModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud target modify collection accepted response has a 5xx status code
func (o *CloudTargetModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud target modify collection accepted response a status code equal to that given
func (o *CloudTargetModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cloud target modify collection accepted response
func (o *CloudTargetModifyCollectionAccepted) Code() int {
	return 202
}

func (o *CloudTargetModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloudTargetModifyCollectionAccepted %s", 202, payload)
}

func (o *CloudTargetModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloudTargetModifyCollectionAccepted %s", 202, payload)
}

func (o *CloudTargetModifyCollectionAccepted) GetPayload() *models.CloudTargetJobLinkResponse {
	return o.Payload
}

func (o *CloudTargetModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudTargetJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudTargetModifyCollectionDefault creates a CloudTargetModifyCollectionDefault with default headers values
func NewCloudTargetModifyCollectionDefault(code int) *CloudTargetModifyCollectionDefault {
	return &CloudTargetModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CloudTargetModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 786436 | VLDB is not running. |
| 786908 | Capability check failed. |
| 787016 | An object store configuration with the same combination of server and container name already exists. |
| 787036 | Server name is invalid. A valid server name must be a fully qualified domain name. |
| 787038 | Object store provider type requires a FabricPool license. |
| 787039 | Failed to retrieve FabricPool capacity license information. |
| 787054 | An object store configuration with the same combination of server, azure account and container name already exists. |
| 787064 | Object store server provider type does not match object store provider type. Use the provider type that matches the server. |
| 787065 | Certificate validation must be enabled for the object store provider. |
| 787066 | Certificate validation cannot be specified when the \"-is-ssl-enabled\" parameter is false. |
| 787068 | Disabling certificate validation requires an effective cluster version of ONTAP 9.4.0 or later. |
| 787089 | The object store provider supports the virtual hosted-style, and the specified \"-server\" contains the container name.  The container specified in the \"-server\" parameter must be the same as the name of the container specified in the \"-container\" parameter. |
| 787133 | Could not retrieve temporary credentials from the CAP server. |
| 787134 | Could not retrieve temporary credentials from the CAP server due to an unexpected response. |
| 787136 | Specifying \"CAP\" as the \"-auth-type\" requires an effective cluster version of ONTAP 9.5.0 or later. |
| 787148 | The clock on the node is behind by more than the maximum of 5 minutes. |
| 787149 | The clock on the node is ahead by more than the maximum of 5 minutes. |
| 787184 | Using HTTP proxies with FabricPool requires an effective cluster version of ONTAP 9.7.0 or later. |
| 787185 | There is no HTTP proxy for IPspace. Refer to the \"vserver http-proxy\" man page for details. |
| 787188 | Object store configuration belongs to cluster and cannot be modified from the local cluster, unless the cluster is in switchover mode. |
| 787209 | Object store is not accessible from the partner cluster in a MetroCluster configuration. |
| 787216 | Cannot perform object store configuration operations on a cluster that is waiting for switchback. |
| 787223 | Specifying \"GCP_SA\" as the \"-auth-type\" requires an effective cluster version of ONTAP 9.7.0 or later. |
| 787227 | Specifying \"Azure_MSI\" as the \"-auth-type\" requires an effective cluster version of ONTAP 9.7 or later. |
| 787228 | SSL is required for this configuration. |
| 787229 | Cannot perform operation as URL style is not supported with object store provider type. |
| 787233 | The hash key for enabling this FabricPool feature is not present on the cluster. |
| 787234 | The hash key provided for the node to enable this FabricPool feature is not valid. |
| 787254 | The parameter is not supported on this system. |
| 787257 | The parameter \"-encryption-context\" is only applicable for AWS object store provider. |
| 787301 | ONTAP S3 Bucket is of type NAS and is not supported as a target for FabricPool. |
| 787302 | Cannot use HTTP port with \"-is-ssl-enabled\" set to true. |
| 787303 | Cannot use HTTPS port with \"-is-ssl-enabled\" set to false. |
| 787306 | Object store is not accessible from the partner cluster in a MetroCluster configuration. |
| 787325 | FabricPool is not supported on this platform. |
| 787350 | Modifying an object store configuration with a Managed Service Identity (MSI) token is only supported on Azure NetApp Files. |
| 787351 | Internal Error. Invalid authentication type. |
| 787352 | Modifying an object store configuration with a Managed Service Identity (MSI) token requires an effective cluster version of ONTAP 9.16.1 or later. |
| 787353 | Modifying an object store configuration with a Managed Service Identity (MSI) token is not supported for this owner. |
| 787354 | The specified properties are mutually exclusive. |
| 787355 | _azure_msi_ `authentication-type` is only supported with _Azure_Cloud_ `provider-type`. |
| 787394 | Modifying the \"-new-object-store-name\\\" or \"-server\\\" without providing a Managed Identity (MI) token is not supported for this configuration. |
| 45940761 | Hostname cannot be resolved. Check the spelling of the hostname and check the system DNS availability using the \"vserver services name-service dns check\" command. |
| 45940778 | Bucket already exists. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CloudTargetModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud target modify collection default response has a 2xx status code
func (o *CloudTargetModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud target modify collection default response has a 3xx status code
func (o *CloudTargetModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud target modify collection default response has a 4xx status code
func (o *CloudTargetModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud target modify collection default response has a 5xx status code
func (o *CloudTargetModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud target modify collection default response a status code equal to that given
func (o *CloudTargetModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud target modify collection default response
func (o *CloudTargetModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CloudTargetModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloud_target_modify_collection default %s", o._statusCode, payload)
}

func (o *CloudTargetModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cloud/targets][%d] cloud_target_modify_collection default %s", o._statusCode, payload)
}

func (o *CloudTargetModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudTargetModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CloudTargetModifyCollectionBody cloud target modify collection body
swagger:model CloudTargetModifyCollectionBody
*/
type CloudTargetModifyCollectionBody struct {

	// links
	Links *models.CloudTargetInlineLinks `json:"_links,omitempty"`

	// Access key ID for AWS_S3 and other S3 compatible provider types.
	AccessKey *string `json:"access_key,omitempty"`

	// Authentication used to access the target. SnapMirror does not yet support CAP. Required in POST.
	// Enum: ["key","cap","ec2_iam","gcp_sa","azure_msi"]
	AuthenticationType *string `json:"authentication_type,omitempty"`

	// Azure account
	AzureAccount *string `json:"azure_account,omitempty"`

	// Managed Service Identity (MSI) token required to authenticate to the Azure object store. This form of authentication is only supported on Azure NetApp Files.
	// Format: password
	AzureMsiToken *strfmt.Password `json:"azure_msi_token,omitempty"`

	// Azure access key
	// Format: password
	AzurePrivateKey *strfmt.Password `json:"azure_private_key,omitempty"`

	// Shared access signature token to access Azure containers and blobs.
	// Format: password
	AzureSasToken *strfmt.Password `json:"azure_sas_token,omitempty"`

	// This parameter is available only when auth-type is CAP. It specifies a full URL of the request to a CAP server for retrieving temporary credentials (access-key, secret-password, and session token) for accessing the object store.
	// Example: https://123.45.67.89:1234/CAP/api/v1/credentials?agency=myagency\u0026mission=mymission\u0026role=myrole
	CapURL *string `json:"cap_url,omitempty"`

	// Is SSL/TLS certificate validation enabled? The default value is true. This can only be modified for SGWS, IBM_COS, and ONTAP_S3 provider types.
	CertificateValidationEnabled *bool `json:"certificate_validation_enabled,omitempty"`

	// cloud target response inline records
	CloudTargetResponseInlineRecords []*models.CloudTarget `json:"records,omitempty"`

	// cluster
	Cluster *models.CloudTargetInlineCluster `json:"cluster,omitempty"`

	// Data bucket/container name. For FabricLink, a wildcard character "*" can also be specified to indicate that all the buckets in an SVM can use the same target information. However, for containers other than ONTAP, an exact name should be specified.
	// Example: bucket1
	Container *string `json:"container,omitempty"`

	// ipspace
	Ipspace *models.CloudTargetInlineIpspace `json:"ipspace,omitempty"`

	// Cloud target name
	Name *string `json:"name,omitempty"`

	// Owner of the target. Allowed values are <personalities supports=unified> FabricPool, </personalities> SnapMirror or S3_SnapMirror. A target can be used by only one feature.
	// Enum: ["fabricpool","snapmirror","s3_snapmirror"]
	Owner *string `json:"owner,omitempty"`

	// Port number of the object store that ONTAP uses when establishing a connection. Required in POST.
	Port *int64 `json:"port,omitempty"`

	// Type of cloud provider. Allowed values depend on owner type. <personalities supports=unified> For FabricPool, AliCloud, AWS_S3, Azure_Cloud, GoogleCloud, IBM_COS, SGWS, and ONTAP_S3 are allowed. </personalities> For SnapMirror, the valid values are AWS_S3 or SGWS. For FabricLink, AWS_S3, SGWS, S3_Compatible, S3EMU, LOOPBACK and ONTAP_S3 are allowed.
	ProviderType *string `json:"provider_type,omitempty"`

	// The warning threshold for read latency that is used to determine when an alert ems for a read operation from an object store should be issued.
	ReadLatencyWarningThreshold *int64 `json:"read_latency_warning_threshold,omitempty"`

	// If the cloud target is owned by a data SVM, then the scope is set to svm. Otherwise it will be set to cluster.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// Secret access key for AWS_S3 and other S3 compatible provider types.
	// Format: password
	SecretPassword *strfmt.Password `json:"secret_password,omitempty"`

	// Fully qualified domain name of the object store server. Required on POST.  For Amazon S3, server name must be an AWS regional endpoint in the format s3.amazonaws.com or s3-<region>.amazonaws.com, for example, s3-us-west-2.amazonaws.com. The region of the server and the bucket must match. For Azure, if the server is a "blob.core.windows.net" or a "blob.core.usgovcloudapi.net", then a value of azure-account followed by a period is added in front of the server.
	Server *string `json:"server,omitempty"`

	// Encryption of data at rest by the object store server for AWS_S3 and other S3 compatible provider types. In most cases it is best not to change default value of "sse_s3" for object store servers which support SSE-S3 encryption. The encryption is in addition to any encryption done by ONTAP at a volume or at an aggregate level. Note that changing this option does not change encryption of data which already exist in the object store.
	// Enum: ["none","sse_s3","sse_kms","dsse_kms"]
	ServerSideEncryption *string `json:"server_side_encryption,omitempty"`

	// Use of the cloud target by SnapMirror.
	// Enum: ["data","metadata"]
	SnapmirrorUse *string `json:"snapmirror_use,omitempty"`

	// SSL/HTTPS enabled or not
	SslEnabled *bool `json:"ssl_enabled,omitempty"`

	// svm
	Svm *models.CloudTargetInlineSvm `json:"svm,omitempty"`

	// URL style used to access S3 bucket.
	// Enum: ["path_style","virtual_hosted_style"]
	URLStyle *string `json:"url_style,omitempty"`

	// Use HTTP proxy when connecting to the object store.
	UseHTTPProxy *bool `json:"use_http_proxy,omitempty"`

	// The amount of cloud space used by all the aggregates attached to the target, in bytes. This field is only populated for FabricPool targets. The value is recalculated once every 5 minutes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Cloud target UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target modify collection body
func (o *CloudTargetModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAzureMsiToken(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAzurePrivateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAzureSasToken(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloudTargetResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecretPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServerSideEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorUse(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateURLStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeAuthenticationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["key","cap","ec2_iam","gcp_sa","azure_msi"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeAuthenticationTypePropEnum = append(cloudTargetModifyCollectionBodyTypeAuthenticationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// authentication_type
	// AuthenticationType
	// key
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyAuthenticationTypeKey captures enum value "key"
	CloudTargetModifyCollectionBodyAuthenticationTypeKey string = "key"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// authentication_type
	// AuthenticationType
	// cap
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyAuthenticationTypeCap captures enum value "cap"
	CloudTargetModifyCollectionBodyAuthenticationTypeCap string = "cap"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// authentication_type
	// AuthenticationType
	// ec2_iam
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyAuthenticationTypeEc2Iam captures enum value "ec2_iam"
	CloudTargetModifyCollectionBodyAuthenticationTypeEc2Iam string = "ec2_iam"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// authentication_type
	// AuthenticationType
	// gcp_sa
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyAuthenticationTypeGcpSa captures enum value "gcp_sa"
	CloudTargetModifyCollectionBodyAuthenticationTypeGcpSa string = "gcp_sa"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// authentication_type
	// AuthenticationType
	// azure_msi
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyAuthenticationTypeAzureMsi captures enum value "azure_msi"
	CloudTargetModifyCollectionBodyAuthenticationTypeAzureMsi string = "azure_msi"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateAuthenticationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeAuthenticationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateAuthenticationType(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationType) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationTypeEnum("info"+"."+"authentication_type", "body", *o.AuthenticationType); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateAzureMsiToken(formats strfmt.Registry) error {
	if swag.IsZero(o.AzureMsiToken) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"azure_msi_token", "body", "password", o.AzureMsiToken.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateAzurePrivateKey(formats strfmt.Registry) error {
	if swag.IsZero(o.AzurePrivateKey) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"azure_private_key", "body", "password", o.AzurePrivateKey.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateAzureSasToken(formats strfmt.Registry) error {
	if swag.IsZero(o.AzureSasToken) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"azure_sas_token", "body", "password", o.AzureSasToken.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateCloudTargetResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudTargetResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CloudTargetResponseInlineRecords); i++ {
		if swag.IsZero(o.CloudTargetResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CloudTargetResponseInlineRecords[i] != nil {
			if err := o.CloudTargetResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(o.Cluster) { // not required
		return nil
	}

	if o.Cluster != nil {
		if err := o.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeOwnerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fabricpool","snapmirror","s3_snapmirror"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeOwnerPropEnum = append(cloudTargetModifyCollectionBodyTypeOwnerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// owner
	// Owner
	// fabricpool
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyOwnerFabricpool captures enum value "fabricpool"
	CloudTargetModifyCollectionBodyOwnerFabricpool string = "fabricpool"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// owner
	// Owner
	// snapmirror
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyOwnerSnapmirror captures enum value "snapmirror"
	CloudTargetModifyCollectionBodyOwnerSnapmirror string = "snapmirror"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// owner
	// Owner
	// s3_snapmirror
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyOwnerS3Snapmirror captures enum value "s3_snapmirror"
	CloudTargetModifyCollectionBodyOwnerS3Snapmirror string = "s3_snapmirror"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateOwnerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeOwnerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	// value enum
	if err := o.validateOwnerEnum("info"+"."+"owner", "body", *o.Owner); err != nil {
		return err
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeScopePropEnum = append(cloudTargetModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyScopeCluster captures enum value "cluster"
	CloudTargetModifyCollectionBodyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyScopeSvm captures enum value "svm"
	CloudTargetModifyCollectionBodyScopeSvm string = "svm"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateSecretPassword(formats strfmt.Registry) error {
	if swag.IsZero(o.SecretPassword) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"secret_password", "body", "password", o.SecretPassword.String(), formats); err != nil {
		return err
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeServerSideEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sse_s3","sse_kms","dsse_kms"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeServerSideEncryptionPropEnum = append(cloudTargetModifyCollectionBodyTypeServerSideEncryptionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// server_side_encryption
	// ServerSideEncryption
	// none
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyServerSideEncryptionNone captures enum value "none"
	CloudTargetModifyCollectionBodyServerSideEncryptionNone string = "none"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// server_side_encryption
	// ServerSideEncryption
	// sse_s3
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyServerSideEncryptionSseS3 captures enum value "sse_s3"
	CloudTargetModifyCollectionBodyServerSideEncryptionSseS3 string = "sse_s3"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// server_side_encryption
	// ServerSideEncryption
	// sse_kms
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyServerSideEncryptionSseKms captures enum value "sse_kms"
	CloudTargetModifyCollectionBodyServerSideEncryptionSseKms string = "sse_kms"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// server_side_encryption
	// ServerSideEncryption
	// dsse_kms
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyServerSideEncryptionDsseKms captures enum value "dsse_kms"
	CloudTargetModifyCollectionBodyServerSideEncryptionDsseKms string = "dsse_kms"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateServerSideEncryptionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeServerSideEncryptionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateServerSideEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.ServerSideEncryption) { // not required
		return nil
	}

	// value enum
	if err := o.validateServerSideEncryptionEnum("info"+"."+"server_side_encryption", "body", *o.ServerSideEncryption); err != nil {
		return err
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeSnapmirrorUsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","metadata"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeSnapmirrorUsePropEnum = append(cloudTargetModifyCollectionBodyTypeSnapmirrorUsePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// snapmirror_use
	// SnapmirrorUse
	// data
	// END DEBUGGING
	// CloudTargetModifyCollectionBodySnapmirrorUseData captures enum value "data"
	CloudTargetModifyCollectionBodySnapmirrorUseData string = "data"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// snapmirror_use
	// SnapmirrorUse
	// metadata
	// END DEBUGGING
	// CloudTargetModifyCollectionBodySnapmirrorUseMetadata captures enum value "metadata"
	CloudTargetModifyCollectionBodySnapmirrorUseMetadata string = "metadata"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateSnapmirrorUseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeSnapmirrorUsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateSnapmirrorUse(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorUse) { // not required
		return nil
	}

	// value enum
	if err := o.validateSnapmirrorUseEnum("info"+"."+"snapmirror_use", "body", *o.SnapmirrorUse); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var cloudTargetModifyCollectionBodyTypeURLStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["path_style","virtual_hosted_style"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetModifyCollectionBodyTypeURLStylePropEnum = append(cloudTargetModifyCollectionBodyTypeURLStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// url_style
	// URLStyle
	// path_style
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyURLStylePathStyle captures enum value "path_style"
	CloudTargetModifyCollectionBodyURLStylePathStyle string = "path_style"

	// BEGIN DEBUGGING
	// CloudTargetModifyCollectionBody
	// CloudTargetModifyCollectionBody
	// url_style
	// URLStyle
	// virtual_hosted_style
	// END DEBUGGING
	// CloudTargetModifyCollectionBodyURLStyleVirtualHostedStyle captures enum value "virtual_hosted_style"
	CloudTargetModifyCollectionBodyURLStyleVirtualHostedStyle string = "virtual_hosted_style"
)

// prop value enum
func (o *CloudTargetModifyCollectionBody) validateURLStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetModifyCollectionBodyTypeURLStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) validateURLStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.URLStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateURLStyleEnum("info"+"."+"url_style", "body", *o.URLStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cloud target modify collection body based on the context it is used
func (o *CloudTargetModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloudTargetResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateCloudTargetResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CloudTargetResponseInlineRecords); i++ {

		if o.CloudTargetResponseInlineRecords[i] != nil {
			if err := o.CloudTargetResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if o.Cluster != nil {
		if err := o.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *CloudTargetModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CloudTargetModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineLinks cloud target inline links
swagger:model cloud_target_inline__links
*/
type CloudTargetInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline links
func (o *CloudTargetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline links based on the context it is used
func (o *CloudTargetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineCluster cloud target inline cluster
swagger:model cloud_target_inline_cluster
*/
type CloudTargetInlineCluster struct {

	// The name of the cluster that owns the cloud target. For POST, this accepts the name of the peer cluster only if the cluster is in switchover state.
	Name *string `json:"name,omitempty"`

	// The UUID of the cluster that owns the cloud target. For POST, this accepts the UUID of the peer cluster only if the cluster is in switchover state.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline cluster
func (o *CloudTargetInlineCluster) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cloud target inline cluster based on context it is used
func (o *CloudTargetInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineCluster) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineCluster) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineIpspace IPspace to use in order to reach the cloud target.
swagger:model cloud_target_inline_ipspace
*/
type CloudTargetInlineIpspace struct {

	// links
	Links *models.CloudTargetInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline ipspace
func (o *CloudTargetInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline ipspace based on the context it is used
func (o *CloudTargetInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineIpspace) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineIpspaceInlineLinks cloud target inline ipspace inline links
swagger:model cloud_target_inline_ipspace_inline__links
*/
type CloudTargetInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline ipspace inline links
func (o *CloudTargetInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline ipspace inline links based on the context it is used
func (o *CloudTargetInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineSvm This field is only applicable when used for SnapMirror and FabricLink. For POST and PATCH, SVM information is required for SnapMirror and FabricLink targets when the scope is svm and is not allowed for FabricPool targets. For GET, this field is not set if the scope of the cloud target is "cluster".
swagger:model cloud_target_inline_svm
*/
type CloudTargetInlineSvm struct {

	// links
	Links *models.CloudTargetInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline svm
func (o *CloudTargetInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline svm based on the context it is used
func (o *CloudTargetInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineSvm) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudTargetInlineSvmInlineLinks cloud target inline svm inline links
swagger:model cloud_target_inline_svm_inline__links
*/
type CloudTargetInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline svm inline links
func (o *CloudTargetInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline svm inline links based on the context it is used
func (o *CloudTargetInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudTargetInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudTargetInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudTargetInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
