// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCapacityPoolCollectionGetParams creates a new CapacityPoolCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCapacityPoolCollectionGetParams() *CapacityPoolCollectionGetParams {
	return &CapacityPoolCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCapacityPoolCollectionGetParamsWithTimeout creates a new CapacityPoolCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCapacityPoolCollectionGetParamsWithTimeout(timeout time.Duration) *CapacityPoolCollectionGetParams {
	return &CapacityPoolCollectionGetParams{
		timeout: timeout,
	}
}

// NewCapacityPoolCollectionGetParamsWithContext creates a new CapacityPoolCollectionGetParams object
// with the ability to set a context for a request.
func NewCapacityPoolCollectionGetParamsWithContext(ctx context.Context) *CapacityPoolCollectionGetParams {
	return &CapacityPoolCollectionGetParams{
		Context: ctx,
	}
}

// NewCapacityPoolCollectionGetParamsWithHTTPClient creates a new CapacityPoolCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCapacityPoolCollectionGetParamsWithHTTPClient(client *http.Client) *CapacityPoolCollectionGetParams {
	return &CapacityPoolCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CapacityPoolCollectionGetParams contains all the parameters to send to the API endpoint

	for the capacity pool collection get operation.

	Typically these are written to a http.Request.
*/
type CapacityPoolCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LicenseManagerUUID.

	   Filter by license_manager.uuid
	*/
	LicenseManagerUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodesNodeName.

	   Filter by nodes.node.name
	*/
	NodesNodeName *string

	/* NodesNodeUUID.

	   Filter by nodes.node.uuid
	*/
	NodesNodeUUID *string

	/* NodesUsedSize.

	   Filter by nodes.used_size
	*/
	NodesUsedSize *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the capacity pool collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CapacityPoolCollectionGetParams) WithDefaults() *CapacityPoolCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the capacity pool collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CapacityPoolCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CapacityPoolCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithTimeout(timeout time.Duration) *CapacityPoolCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithContext(ctx context.Context) *CapacityPoolCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithHTTPClient(client *http.Client) *CapacityPoolCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithFields(fields []string) *CapacityPoolCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLicenseManagerUUID adds the licenseManagerUUID to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithLicenseManagerUUID(licenseManagerUUID *string) *CapacityPoolCollectionGetParams {
	o.SetLicenseManagerUUID(licenseManagerUUID)
	return o
}

// SetLicenseManagerUUID adds the licenseManagerUuid to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetLicenseManagerUUID(licenseManagerUUID *string) {
	o.LicenseManagerUUID = licenseManagerUUID
}

// WithMaxRecords adds the maxRecords to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithMaxRecords(maxRecords *int64) *CapacityPoolCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodesNodeName adds the nodesNodeName to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithNodesNodeName(nodesNodeName *string) *CapacityPoolCollectionGetParams {
	o.SetNodesNodeName(nodesNodeName)
	return o
}

// SetNodesNodeName adds the nodesNodeName to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetNodesNodeName(nodesNodeName *string) {
	o.NodesNodeName = nodesNodeName
}

// WithNodesNodeUUID adds the nodesNodeUUID to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithNodesNodeUUID(nodesNodeUUID *string) *CapacityPoolCollectionGetParams {
	o.SetNodesNodeUUID(nodesNodeUUID)
	return o
}

// SetNodesNodeUUID adds the nodesNodeUuid to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetNodesNodeUUID(nodesNodeUUID *string) {
	o.NodesNodeUUID = nodesNodeUUID
}

// WithNodesUsedSize adds the nodesUsedSize to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithNodesUsedSize(nodesUsedSize *int64) *CapacityPoolCollectionGetParams {
	o.SetNodesUsedSize(nodesUsedSize)
	return o
}

// SetNodesUsedSize adds the nodesUsedSize to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetNodesUsedSize(nodesUsedSize *int64) {
	o.NodesUsedSize = nodesUsedSize
}

// WithOrderBy adds the orderBy to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithOrderBy(orderBy []string) *CapacityPoolCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithReturnRecords(returnRecords *bool) *CapacityPoolCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CapacityPoolCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) WithSerialNumber(serialNumber *string) *CapacityPoolCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the capacity pool collection get params
func (o *CapacityPoolCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WriteToRequest writes these params to a swagger request
func (o *CapacityPoolCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LicenseManagerUUID != nil {

		// query param license_manager.uuid
		var qrLicenseManagerUUID string

		if o.LicenseManagerUUID != nil {
			qrLicenseManagerUUID = *o.LicenseManagerUUID
		}
		qLicenseManagerUUID := qrLicenseManagerUUID
		if qLicenseManagerUUID != "" {

			if err := r.SetQueryParam("license_manager.uuid", qLicenseManagerUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodesNodeName != nil {

		// query param nodes.node.name
		var qrNodesNodeName string

		if o.NodesNodeName != nil {
			qrNodesNodeName = *o.NodesNodeName
		}
		qNodesNodeName := qrNodesNodeName
		if qNodesNodeName != "" {

			if err := r.SetQueryParam("nodes.node.name", qNodesNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodesNodeUUID != nil {

		// query param nodes.node.uuid
		var qrNodesNodeUUID string

		if o.NodesNodeUUID != nil {
			qrNodesNodeUUID = *o.NodesNodeUUID
		}
		qNodesNodeUUID := qrNodesNodeUUID
		if qNodesNodeUUID != "" {

			if err := r.SetQueryParam("nodes.node.uuid", qNodesNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.NodesUsedSize != nil {

		// query param nodes.used_size
		var qrNodesUsedSize int64

		if o.NodesUsedSize != nil {
			qrNodesUsedSize = *o.NodesUsedSize
		}
		qNodesUsedSize := swag.FormatInt64(qrNodesUsedSize)
		if qNodesUsedSize != "" {

			if err := r.SetQueryParam("nodes.used_size", qNodesUsedSize); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCapacityPoolCollectionGet binds the parameter fields
func (o *CapacityPoolCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCapacityPoolCollectionGet binds the parameter order_by
func (o *CapacityPoolCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
