// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCapacityPoolGetParams creates a new CapacityPoolGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCapacityPoolGetParams() *CapacityPoolGetParams {
	return &CapacityPoolGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCapacityPoolGetParamsWithTimeout creates a new CapacityPoolGetParams object
// with the ability to set a timeout on a request.
func NewCapacityPoolGetParamsWithTimeout(timeout time.Duration) *CapacityPoolGetParams {
	return &CapacityPoolGetParams{
		timeout: timeout,
	}
}

// NewCapacityPoolGetParamsWithContext creates a new CapacityPoolGetParams object
// with the ability to set a context for a request.
func NewCapacityPoolGetParamsWithContext(ctx context.Context) *CapacityPoolGetParams {
	return &CapacityPoolGetParams{
		Context: ctx,
	}
}

// NewCapacityPoolGetParamsWithHTTPClient creates a new CapacityPoolGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCapacityPoolGetParamsWithHTTPClient(client *http.Client) *CapacityPoolGetParams {
	return &CapacityPoolGetParams{
		HTTPClient: client,
	}
}

/*
CapacityPoolGetParams contains all the parameters to send to the API endpoint

	for the capacity pool get operation.

	Typically these are written to a http.Request.
*/
type CapacityPoolGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LicenseManagerUUID.

	   Filter by license_manager.uuid
	*/
	LicenseManagerUUID *string

	/* NodesNodeName.

	   Filter by nodes.node.name
	*/
	NodesNodeName *string

	/* NodesNodeUUID.

	   Filter by nodes.node.uuid
	*/
	NodesNodeUUID *string

	/* NodesUsedSize.

	   Filter by nodes.used_size
	*/
	NodesUsedSize *int64

	/* SerialNumber.

	   Serial number of the capacity pool license.
	*/
	SerialNumber string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the capacity pool get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CapacityPoolGetParams) WithDefaults() *CapacityPoolGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the capacity pool get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CapacityPoolGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the capacity pool get params
func (o *CapacityPoolGetParams) WithTimeout(timeout time.Duration) *CapacityPoolGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the capacity pool get params
func (o *CapacityPoolGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the capacity pool get params
func (o *CapacityPoolGetParams) WithContext(ctx context.Context) *CapacityPoolGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the capacity pool get params
func (o *CapacityPoolGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the capacity pool get params
func (o *CapacityPoolGetParams) WithHTTPClient(client *http.Client) *CapacityPoolGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the capacity pool get params
func (o *CapacityPoolGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the capacity pool get params
func (o *CapacityPoolGetParams) WithFields(fields []string) *CapacityPoolGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the capacity pool get params
func (o *CapacityPoolGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLicenseManagerUUID adds the licenseManagerUUID to the capacity pool get params
func (o *CapacityPoolGetParams) WithLicenseManagerUUID(licenseManagerUUID *string) *CapacityPoolGetParams {
	o.SetLicenseManagerUUID(licenseManagerUUID)
	return o
}

// SetLicenseManagerUUID adds the licenseManagerUuid to the capacity pool get params
func (o *CapacityPoolGetParams) SetLicenseManagerUUID(licenseManagerUUID *string) {
	o.LicenseManagerUUID = licenseManagerUUID
}

// WithNodesNodeName adds the nodesNodeName to the capacity pool get params
func (o *CapacityPoolGetParams) WithNodesNodeName(nodesNodeName *string) *CapacityPoolGetParams {
	o.SetNodesNodeName(nodesNodeName)
	return o
}

// SetNodesNodeName adds the nodesNodeName to the capacity pool get params
func (o *CapacityPoolGetParams) SetNodesNodeName(nodesNodeName *string) {
	o.NodesNodeName = nodesNodeName
}

// WithNodesNodeUUID adds the nodesNodeUUID to the capacity pool get params
func (o *CapacityPoolGetParams) WithNodesNodeUUID(nodesNodeUUID *string) *CapacityPoolGetParams {
	o.SetNodesNodeUUID(nodesNodeUUID)
	return o
}

// SetNodesNodeUUID adds the nodesNodeUuid to the capacity pool get params
func (o *CapacityPoolGetParams) SetNodesNodeUUID(nodesNodeUUID *string) {
	o.NodesNodeUUID = nodesNodeUUID
}

// WithNodesUsedSize adds the nodesUsedSize to the capacity pool get params
func (o *CapacityPoolGetParams) WithNodesUsedSize(nodesUsedSize *int64) *CapacityPoolGetParams {
	o.SetNodesUsedSize(nodesUsedSize)
	return o
}

// SetNodesUsedSize adds the nodesUsedSize to the capacity pool get params
func (o *CapacityPoolGetParams) SetNodesUsedSize(nodesUsedSize *int64) {
	o.NodesUsedSize = nodesUsedSize
}

// WithSerialNumber adds the serialNumber to the capacity pool get params
func (o *CapacityPoolGetParams) WithSerialNumber(serialNumber string) *CapacityPoolGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the capacity pool get params
func (o *CapacityPoolGetParams) SetSerialNumber(serialNumber string) {
	o.SerialNumber = serialNumber
}

// WriteToRequest writes these params to a swagger request
func (o *CapacityPoolGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LicenseManagerUUID != nil {

		// query param license_manager.uuid
		var qrLicenseManagerUUID string

		if o.LicenseManagerUUID != nil {
			qrLicenseManagerUUID = *o.LicenseManagerUUID
		}
		qLicenseManagerUUID := qrLicenseManagerUUID
		if qLicenseManagerUUID != "" {

			if err := r.SetQueryParam("license_manager.uuid", qLicenseManagerUUID); err != nil {
				return err
			}
		}
	}

	if o.NodesNodeName != nil {

		// query param nodes.node.name
		var qrNodesNodeName string

		if o.NodesNodeName != nil {
			qrNodesNodeName = *o.NodesNodeName
		}
		qNodesNodeName := qrNodesNodeName
		if qNodesNodeName != "" {

			if err := r.SetQueryParam("nodes.node.name", qNodesNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodesNodeUUID != nil {

		// query param nodes.node.uuid
		var qrNodesNodeUUID string

		if o.NodesNodeUUID != nil {
			qrNodesNodeUUID = *o.NodesNodeUUID
		}
		qNodesNodeUUID := qrNodesNodeUUID
		if qNodesNodeUUID != "" {

			if err := r.SetQueryParam("nodes.node.uuid", qNodesNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.NodesUsedSize != nil {

		// query param nodes.used_size
		var qrNodesUsedSize int64

		if o.NodesUsedSize != nil {
			qrNodesUsedSize = *o.NodesUsedSize
		}
		qNodesUsedSize := swag.FormatInt64(qrNodesUsedSize)
		if qNodesUsedSize != "" {

			if err := r.SetQueryParam("nodes.used_size", qNodesUsedSize); err != nil {
				return err
			}
		}
	}

	// path param serial_number
	if err := r.SetPathParam("serial_number", o.SerialNumber); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCapacityPoolGet binds the parameter fields
func (o *CapacityPoolGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
