// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new cluster API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for cluster API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	MediatorPing(params *MediatorPingParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorPingOK, error)

	CapacityPoolCollectionGet(params *CapacityPoolCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CapacityPoolCollectionGetOK, error)

	CapacityPoolGet(params *CapacityPoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CapacityPoolGetOK, error)

	ChassisCollectionGet(params *ChassisCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ChassisCollectionGetOK, error)

	ChassisGet(params *ChassisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ChassisGetOK, error)

	ClusterCollectionPerformanceMetricsGet(params *ClusterCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterCollectionPerformanceMetricsGetOK, error)

	ClusterCreate(params *ClusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterCreateCreated, *ClusterCreateAccepted, error)

	ClusterGet(params *ClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterGetOK, error)

	ClusterModify(params *ClusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterModifyOK, *ClusterModifyAccepted, error)

	ClusterNtpKeysCollectionGet(params *ClusterNtpKeysCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysCollectionGetOK, error)

	ClusterNtpKeysCreate(params *ClusterNtpKeysCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysCreateCreated, error)

	ClusterNtpKeysDelete(params *ClusterNtpKeysDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysDeleteOK, error)

	ClusterNtpKeysDeleteCollection(params *ClusterNtpKeysDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysDeleteCollectionOK, error)

	ClusterNtpKeysGet(params *ClusterNtpKeysGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysGetOK, error)

	ClusterNtpKeysModify(params *ClusterNtpKeysModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysModifyOK, error)

	ClusterNtpKeysModifyCollection(params *ClusterNtpKeysModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysModifyCollectionOK, error)

	ClusterNtpServersCollectionGet(params *ClusterNtpServersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersCollectionGetOK, error)

	ClusterNtpServersCreate(params *ClusterNtpServersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersCreateCreated, *ClusterNtpServersCreateAccepted, error)

	ClusterNtpServersDelete(params *ClusterNtpServersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersDeleteOK, *ClusterNtpServersDeleteAccepted, error)

	ClusterNtpServersDeleteCollection(params *ClusterNtpServersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersDeleteCollectionOK, *ClusterNtpServersDeleteCollectionAccepted, error)

	ClusterNtpServersGet(params *ClusterNtpServersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersGetOK, error)

	ClusterNtpServersModify(params *ClusterNtpServersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersModifyOK, *ClusterNtpServersModifyAccepted, error)

	ClusterNtpServersModifyCollection(params *ClusterNtpServersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersModifyCollectionOK, *ClusterNtpServersModifyCollectionAccepted, error)

	ClusterPeerCollectionGet(params *ClusterPeerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerCollectionGetOK, error)

	ClusterPeerCreate(params *ClusterPeerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerCreateCreated, error)

	ClusterPeerDelete(params *ClusterPeerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerDeleteOK, error)

	ClusterPeerDeleteCollection(params *ClusterPeerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerDeleteCollectionOK, error)

	ClusterPeerGet(params *ClusterPeerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerGetOK, error)

	ClusterPeerModify(params *ClusterPeerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerModifyOK, error)

	ClusterPeerModifyCollection(params *ClusterPeerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerModifyCollectionOK, error)

	CounterRowCollectionGet(params *CounterRowCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterRowCollectionGetOK, error)

	CounterRowGet(params *CounterRowGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterRowGetOK, error)

	CounterTableCollectionGet(params *CounterTableCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterTableCollectionGetOK, error)

	CounterTableGet(params *CounterTableGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterTableGetOK, error)

	FirmwareHistoryCollectionGet(params *FirmwareHistoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FirmwareHistoryCollectionGetOK, error)

	JobCollectionGet(params *JobCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobCollectionGetOK, error)

	JobGet(params *JobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobGetOK, error)

	JobModify(params *JobModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobModifyOK, error)

	JobModifyCollection(params *JobModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobModifyCollectionOK, error)

	LicenseCreate(params *LicenseCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseCreateCreated, error)

	LicenseDelete(params *LicenseDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseDeleteOK, error)

	LicenseDeleteCollection(params *LicenseDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseDeleteCollectionOK, error)

	LicenseGet(params *LicenseGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseGetOK, error)

	LicenseManagerCollectionGet(params *LicenseManagerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerCollectionGetOK, error)

	LicenseManagerGet(params *LicenseManagerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerGetOK, error)

	LicenseManagerModify(params *LicenseManagerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerModifyOK, *LicenseManagerModifyAccepted, error)

	LicenseManagerModifyCollection(params *LicenseManagerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerModifyCollectionOK, *LicenseManagerModifyCollectionAccepted, error)

	LicensesGet(params *LicensesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicensesGetOK, error)

	MediatorCollectionGet(params *MediatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorCollectionGetOK, error)

	MediatorCreate(params *MediatorCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorCreateCreated, *MediatorCreateAccepted, error)

	MediatorDelete(params *MediatorDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorDeleteOK, *MediatorDeleteAccepted, error)

	MediatorDeleteCollection(params *MediatorDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorDeleteCollectionOK, *MediatorDeleteCollectionAccepted, error)

	MediatorGet(params *MediatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorGetOK, error)

	MediatorModify(params *MediatorModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorModifyOK, *MediatorModifyAccepted, error)

	MediatorModifyCollection(params *MediatorModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorModifyCollectionOK, *MediatorModifyCollectionAccepted, error)

	MetroclusterCreate(params *MetroclusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterCreateCreated, *MetroclusterCreateAccepted, error)

	MetroclusterDiagnosticsCreate(params *MetroclusterDiagnosticsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDiagnosticsCreateCreated, *MetroclusterDiagnosticsCreateAccepted, error)

	MetroclusterDiagnosticsGet(params *MetroclusterDiagnosticsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDiagnosticsGetOK, error)

	MetroclusterDrGroupCollectionGet(params *MetroclusterDrGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupCollectionGetOK, error)

	MetroclusterDrGroupCreate(params *MetroclusterDrGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupCreateCreated, *MetroclusterDrGroupCreateAccepted, error)

	MetroclusterDrGroupDelete(params *MetroclusterDrGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupDeleteOK, *MetroclusterDrGroupDeleteAccepted, error)

	MetroclusterDrGroupDeleteCollection(params *MetroclusterDrGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupDeleteCollectionOK, *MetroclusterDrGroupDeleteCollectionAccepted, error)

	MetroclusterDrGroupGet(params *MetroclusterDrGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupGetOK, error)

	MetroclusterGet(params *MetroclusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterGetOK, error)

	MetroclusterInterconnectCollectionGet(params *MetroclusterInterconnectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectCollectionGetOK, error)

	MetroclusterInterconnectGet(params *MetroclusterInterconnectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectGetOK, error)

	MetroclusterInterconnectModify(params *MetroclusterInterconnectModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectModifyOK, *MetroclusterInterconnectModifyAccepted, error)

	MetroclusterInterconnectModifyCollection(params *MetroclusterInterconnectModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectModifyCollectionOK, *MetroclusterInterconnectModifyCollectionAccepted, error)

	MetroclusterModify(params *MetroclusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterModifyOK, *MetroclusterModifyAccepted, error)

	MetroclusterNodeCollectionGet(params *MetroclusterNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterNodeCollectionGetOK, error)

	MetroclusterNodeGet(params *MetroclusterNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterNodeGetOK, error)

	MetroclusterOperationCollectionGet(params *MetroclusterOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterOperationCollectionGetOK, error)

	MetroclusterOperationGet(params *MetroclusterOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterOperationGetOK, error)

	MetroclusterSvmCollectionGet(params *MetroclusterSvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterSvmCollectionGetOK, error)

	MetroclusterSvmGet(params *MetroclusterSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterSvmGetOK, error)

	NodeDelete(params *NodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeDeleteOK, *NodeDeleteAccepted, error)

	NodeDeleteCollection(params *NodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeDeleteCollectionOK, *NodeDeleteCollectionAccepted, error)

	NodeGet(params *NodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeGetOK, error)

	NodeMetricsCollectionGet(params *NodeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeMetricsCollectionGetOK, error)

	NodeModify(params *NodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeModifyOK, *NodeModifyAccepted, error)

	NodeModifyCollection(params *NodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeModifyCollectionOK, *NodeModifyCollectionAccepted, error)

	NodesCreate(params *NodesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodesCreateCreated, *NodesCreateAccepted, error)

	NodesGet(params *NodesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodesGetOK, error)

	ResourceTagCollectionGet(params *ResourceTagCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagCollectionGetOK, error)

	ResourceTagGet(params *ResourceTagGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagGetOK, error)

	ResourceTagResourceCollectionGet(params *ResourceTagResourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceCollectionGetOK, error)

	ResourceTagResourceCreate(params *ResourceTagResourceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceCreateCreated, error)

	ResourceTagResourceDelete(params *ResourceTagResourceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceDeleteOK, error)

	ResourceTagResourceDeleteCollection(params *ResourceTagResourceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceDeleteCollectionOK, error)

	ResourceTagResourceGet(params *ResourceTagResourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceGetOK, error)

	ScheduleCollectionGet(params *ScheduleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleCollectionGetOK, error)

	ScheduleCreate(params *ScheduleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleCreateCreated, error)

	ScheduleDelete(params *ScheduleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleDeleteOK, error)

	ScheduleDeleteCollection(params *ScheduleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleDeleteCollectionOK, error)

	ScheduleGet(params *ScheduleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleGetOK, error)

	ScheduleModify(params *ScheduleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleModifyOK, error)

	ScheduleModifyCollection(params *ScheduleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleModifyCollectionOK, error)

	SensorsCollectionGet(params *SensorsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SensorsCollectionGetOK, error)

	SensorsGet(params *SensorsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SensorsGetOK, error)

	SoftwareDownloadGet(params *SoftwareDownloadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareDownloadGetOK, error)

	SoftwareGet(params *SoftwareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareGetOK, error)

	SoftwareHistoryCollectionGet(params *SoftwareHistoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareHistoryCollectionGetOK, error)

	SoftwareModify(params *SoftwareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareModifyOK, *SoftwareModifyAccepted, error)

	SoftwarePackageCreate(params *SoftwarePackageCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageCreateCreated, *SoftwarePackageCreateAccepted, error)

	SoftwarePackageDelete(params *SoftwarePackageDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageDeleteOK, *SoftwarePackageDeleteAccepted, error)

	SoftwarePackageDeleteCollection(params *SoftwarePackageDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageDeleteCollectionOK, *SoftwarePackageDeleteCollectionAccepted, error)

	SoftwarePackageGet(params *SoftwarePackageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageGetOK, error)

	SoftwarePackagesCollectionGet(params *SoftwarePackagesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackagesCollectionGetOK, error)

	SoftwareUpload(params *SoftwareUploadParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareUploadCreated, *SoftwareUploadAccepted, error)

	WebGet(params *WebGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebGetOK, error)

	WebModify(params *WebModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebModifyOK, *WebModifyAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
MediatorPing Pings BlueXP cloud service.
*/
func (a *Client) MediatorPing(params *MediatorPingParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorPingOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorPingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "_mediator_ping_",
		Method:             "POST",
		PathPattern:        "/cluster/mediator-ping",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorPingReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MediatorPingOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorPingDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CapacityPoolCollectionGet Retrieves a collection of capacity pools.

### Learn more
* [`DOC /cluster/licensing/capacity-pools`](#docs-cluster-cluster_licensing_capacity-pools)
### Related ONTAP commands
* `system license show-status`
* `system license show`
*/
func (a *Client) CapacityPoolCollectionGet(params *CapacityPoolCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CapacityPoolCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCapacityPoolCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "capacity_pool_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/capacity-pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CapacityPoolCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CapacityPoolCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CapacityPoolCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CapacityPoolGet Retrieves information about the capacity pool.

### Learn more
* [`DOC /cluster/licensing/capacity-pools`](#docs-cluster-cluster_licensing_capacity-pools)
### Related ONTAP commands
* `system license show-status`
* `system license show`
*/
func (a *Client) CapacityPoolGet(params *CapacityPoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CapacityPoolGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCapacityPoolGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "capacity_pool_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/capacity-pools/{serial_number}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CapacityPoolGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CapacityPoolGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CapacityPoolGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ChassisCollectionGet Retrieves a collection of chassis.

### Related ONTAP commands
* `system chassis show`
* `system chassis fru show`
### Learn more
* [`DOC /cluster/chassis`](#docs-cluster-cluster_chassis)
*/
func (a *Client) ChassisCollectionGet(params *ChassisCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ChassisCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewChassisCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "chassis_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/chassis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ChassisCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ChassisCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ChassisCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ChassisGet Retrieves a specific chassis.

### Related ONTAP commands
* `system chassis show`
* `system chassis fru show`
### Learn more
* [`DOC /cluster/chassis`](#docs-cluster-cluster_chassis)
*/
func (a *Client) ChassisGet(params *ChassisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ChassisGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewChassisGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "chassis_get",
		Method:             "GET",
		PathPattern:        "/cluster/chassis/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ChassisGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ChassisGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ChassisGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterCollectionPerformanceMetricsGet Retrieves historical performance metrics for the cluster.
*/
func (a *Client) ClusterCollectionPerformanceMetricsGet(params *ClusterCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterCollectionPerformanceMetricsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterCollectionPerformanceMetricsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_collection_performance_metrics_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterCollectionPerformanceMetricsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterCollectionPerformanceMetricsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterCollectionPerformanceMetricsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterCreate Creates a cluster.

### Required properties
* `name`
* `password`
### Recommended optional properties
* `location`
* `contact`
* `dns_domains`
* `name_servers`
* `ntp_servers`
* `license`
* `configuration_backup`
* `management_interface`
* `nodes`
* `timezone`
### Learn more
* [`DOC /cluster`](#docs-cluster-cluster)
*/
func (a *Client) ClusterCreate(params *ClusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterCreateCreated, *ClusterCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_create",
		Method:             "POST",
		PathPattern:        "/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterCreateCreated:
		return value, nil, nil
	case *ClusterCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterGet Retrieves the cluster configuration.
*/
func (a *Client) ClusterGet(params *ClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_get",
		Method:             "GET",
		PathPattern:        "/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterModify Updates the cluster configuration after the cluster is created.

### Related ONTAP commands
* `cluster identity modify`
* `system node modify`
* `vserver services dns modify`
* `vserver services name-service dns modify`
* `timezone`
* `vserver active-directory create`
* `vserver active-directory modify`
* `vserver active-directory delete`
* `vserver cifs security modify`
*/
func (a *Client) ClusterModify(params *ClusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterModifyOK, *ClusterModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterModifyOK:
		return value, nil, nil
	case *ClusterModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpKeysCollectionGet Retrieves the collection of NTP symmetric authentication keys known by ONTAP that

are uniquely indexed by an identifier.
### Related ONTAP commands
* `cluster time-service ntp key show`
### Learn more
* [`DOC /cluster/ntp/keys`](#docs-cluster-cluster_ntp_keys)
*/
func (a *Client) ClusterNtpKeysCollectionGet(params *ClusterNtpKeysCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/ntp/keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpKeysCreate Creates an NTP symmetric authentication key entry including the type of key

using an unused identifier or index number (ID).
### Required properties
* `id` - Shared symmetric key number (ID).
* `digest_type` - Shared private key cryptographic hash type.
* `value` - Value of shared private key.
### Related ONTAP commands
* `cluster time-service ntp key create`
### Learn more
* [`DOC /cluster/ntp/keys`](#docs-cluster-cluster_ntp_keys)
*/
func (a *Client) ClusterNtpKeysCreate(params *ClusterNtpKeysCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_create",
		Method:             "POST",
		PathPattern:        "/cluster/ntp/keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpKeysDelete Deletes an NTP key.

### Related ONTAP commands
* `cluster time-service ntp key delete`
### Learn more
* [`DOC /cluster/ntp/keys`](#docs-cluster-cluster_ntp_keys)
*/
func (a *Client) ClusterNtpKeysDelete(params *ClusterNtpKeysDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/ntp/keys/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNtpKeysDeleteCollection cluster ntp keys delete collection API
*/
func (a *Client) ClusterNtpKeysDeleteCollection(params *ClusterNtpKeysDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/ntp/keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpKeysGet Retrieves the details of a specific NTP symmetric authentication key by numeric identifier or index (ID).

### Related ONTAP commands
* `cluster time-service ntp key show`
### Learn more
* [`DOC /cluster/ntp/keys`](#docs-cluster-cluster_ntp_keys)
*/
func (a *Client) ClusterNtpKeysGet(params *ClusterNtpKeysGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_get",
		Method:             "GET",
		PathPattern:        "/cluster/ntp/keys/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpKeysModify Updates the details of a specific NTP symmetric authentication key by numeric

identifier or index (ID).
### Required properties
* `digest_type` - Shared private key cryptographic hash type.
* `value` - Value of shared private key.
### Related ONTAP commands
* `cluster time-service ntp key modify`
### Learn more
* [`DOC /cluster/ntp/keys`](#docs-cluster-cluster_ntp_keys)
*/
func (a *Client) ClusterNtpKeysModify(params *ClusterNtpKeysModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/ntp/keys/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNtpKeysModifyCollection cluster ntp keys modify collection API
*/
func (a *Client) ClusterNtpKeysModifyCollection(params *ClusterNtpKeysModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpKeysModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpKeysModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_keys_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/ntp/keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpKeysModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpKeysModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpKeysModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpServersCollectionGet Retrieves the collection of external NTP time servers ONTAP uses for time adjustment and correction.

### Related ONTAP commands
* `cluster time-service ntp server show`
### Learn more
* [`DOC /cluster/ntp/servers`](#docs-cluster-cluster_ntp_servers)
*/
func (a *Client) ClusterNtpServersCollectionGet(params *ClusterNtpServersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/ntp/servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpServersCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpServersCreate Validates the provided external NTP time server for usage and configures ONTAP so that all nodes in the cluster use it.

The required fields are:
* `server`
### Default property values
If not specified in POST, the following default property values are assigned:
* `version` - auto
* `key` - not set
###
If the key is provided in POST, `authentication_enabled` is set to `true` by default.
### Related ONTAP commands
* `cluster time-service ntp server create`
### Learn more
* [`DOC /cluster/ntp/servers`](#docs-cluster-cluster_ntp_servers)
*/
func (a *Client) ClusterNtpServersCreate(params *ClusterNtpServersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersCreateCreated, *ClusterNtpServersCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_create",
		Method:             "POST",
		PathPattern:        "/cluster/ntp/servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterNtpServersCreateCreated:
		return value, nil, nil
	case *ClusterNtpServersCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpServersDelete Deletes an external NTP server used by ONTAP.

### Related ONTAP commands
* `cluster time-service ntp server delete`
### Learn more
* [`DOC /cluster/ntp/servers`](#docs-cluster-cluster_ntp_servers)
*/
func (a *Client) ClusterNtpServersDelete(params *ClusterNtpServersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersDeleteOK, *ClusterNtpServersDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/ntp/servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterNtpServersDeleteOK:
		return value, nil, nil
	case *ClusterNtpServersDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNtpServersDeleteCollection cluster ntp servers delete collection API
*/
func (a *Client) ClusterNtpServersDeleteCollection(params *ClusterNtpServersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersDeleteCollectionOK, *ClusterNtpServersDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/ntp/servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterNtpServersDeleteCollectionOK:
		return value, nil, nil
	case *ClusterNtpServersDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpServersGet Retrieves the configuration of an external NTP server used by ONTAP.

### Related ONTAP commands
* `cluster time-service ntp server show`
### Learn more
* [`DOC /cluster/ntp/servers`](#docs-cluster-cluster_ntp_servers)
*/
func (a *Client) ClusterNtpServersGet(params *ClusterNtpServersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_get",
		Method:             "GET",
		PathPattern:        "/cluster/ntp/servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNtpServersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNtpServersModify Updates the configuration of an NTP server used by the ONTAP cluster after validation.

Patchable fields are:
* `version`
* `key.id`
* `authentication_enabled`
</br>
If `authentication_enabled` is modified to `false`, the associated NTP key is removed from the server instance.
If `authentication_enabled` is modified to `true`, you must provide an NTP key ID in the PATCH body.
### Related ONTAP commands
* `cluster time-service ntp server modify`
### Learn more
* [`DOC /cluster/ntp/servers`](#docs-cluster-cluster_ntp_servers)
*/
func (a *Client) ClusterNtpServersModify(params *ClusterNtpServersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersModifyOK, *ClusterNtpServersModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/ntp/servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterNtpServersModifyOK:
		return value, nil, nil
	case *ClusterNtpServersModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNtpServersModifyCollection cluster ntp servers modify collection API
*/
func (a *Client) ClusterNtpServersModifyCollection(params *ClusterNtpServersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNtpServersModifyCollectionOK, *ClusterNtpServersModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNtpServersModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ntp_servers_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/ntp/servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNtpServersModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ClusterNtpServersModifyCollectionOK:
		return value, nil, nil
	case *ClusterNtpServersModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNtpServersModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerCollectionGet Retrieves the collection of cluster peers.
*/
func (a *Client) ClusterPeerCollectionGet(params *ClusterPeerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterPeerCreate Creates a peering relationship and, optionally, the IP interfaces it will use. There are two methods used to create a peering relationship:

* Provide a remote IP address - Used when creating a new cluster peer relationship with a specific remote cluster. This requires at least one remote intercluster IP address from the remote cluster.
* Do not provide a remote IP address - Used when the remote IP address is not provided and when the storage system is ready to accept peering requests from foreign clusters.
### Required properties
* `remote.ip_addresses` - Addresses of the remote peers. The local peer must be able to reach and connect to these addresses for the request to succeed in creating a peer. Only required when creating a peering relationship by providing a remote IP address.
* Either set `generate_passphrase` to "true" or provide a passphrase in the body of the request. Only one of these options is required.
### Recommended optional properties
* `name` - Name of the peering relationship or name of the remote peer.
* `passphrase` - User generated passphrase for use in authentication.
* `generate_passphrase` (true/false) - When "true", ONTAP automatically generates a passphrase to authenticate cluster peers.
* `ipspace` - IPspace of the local intercluster LIFs. Assumes Default IPspace if not provided.
* `initial_allowed_svms` - Local SVMs allowed to peer with the peer cluster's SVMs. Can be modified until the remote cluster accepts this cluster peering relationship.
* `local_network` - Fields to create a local intercluster LIF.
* `expiry_time` - Duration in ISO 8601 format for which the user-supplied or auto-generated passphrase is valid. Expiration time must not be greater than seven days into the future. ISO 8601 duration format is "PnDTnHnMnS" or "PnW" where n is a positive integer. The "nD", "nH", "nM" and "nS" fields can be dropped if zero. "P" must always be present and "T" must be present if there are any hours, minutes, or seconds fields.
* `encryption_proposed` (none/tls-psk) - Encryption mechanism of the communication channel between the two peers.
* `peer_applications` - SVM peering applications (SnapMirror, FlexCache or both) for which the SVM peering relationship is set up.
### Additional information
As with creating a cluster peer through the CLI, the combinations of options must be valid in order for the create operation to succeed. The following list shows the combinations that will succeed and those that will fail:
* A passphrase only (fail)
* A peer IP address (fail)
* A passphrase with an expiration time > 7 days into the future (fail)
* A peer IP address and a passphrase (OK)
* generate_passphrase=true (OK)
* Any proposed encryption protocol (OK)
* An IPspace name or UUID (OK)
* A passphrase, peer IP address, and any proposed encryption protocol (OK)
* A non empty list of initial allowed SVM peer names or UUIDs. (OK)
*/
func (a *Client) ClusterPeerCreate(params *ClusterPeerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_create",
		Method:             "POST",
		PathPattern:        "/cluster/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerDelete Deletes a cluster peer.
*/
func (a *Client) ClusterPeerDelete(params *ClusterPeerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerDeleteCollection cluster peer delete collection API
*/
func (a *Client) ClusterPeerDeleteCollection(params *ClusterPeerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerGet Retrieves a specific cluster peer instance.
*/
func (a *Client) ClusterPeerGet(params *ClusterPeerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_get",
		Method:             "GET",
		PathPattern:        "/cluster/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerModify Updates a cluster peer instance.
*/
func (a *Client) ClusterPeerModify(params *ClusterPeerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterPeerModifyCollection cluster peer modify collection API
*/
func (a *Client) ClusterPeerModifyCollection(params *ClusterPeerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterPeerModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterPeerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_peer_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterPeerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterPeerModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterPeerModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CounterRowCollectionGet Returns a collection of counter rows.
*/
func (a *Client) CounterRowCollectionGet(params *CounterRowCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterRowCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCounterRowCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "counter_row_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/counter/tables/{counter_table.name}/rows",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CounterRowCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CounterRowCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CounterRowCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CounterRowGet Returns a single counter row.
*/
func (a *Client) CounterRowGet(params *CounterRowGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterRowGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCounterRowGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "counter_row_get",
		Method:             "GET",
		PathPattern:        "/cluster/counter/tables/{counter_table.name}/rows/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CounterRowGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CounterRowGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CounterRowGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CounterTableCollectionGet Returns a collection of counter tables and their schema definitions.
*/
func (a *Client) CounterTableCollectionGet(params *CounterTableCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterTableCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCounterTableCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "counter_table_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/counter/tables",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CounterTableCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CounterTableCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CounterTableCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CounterTableGet Returns the information about a single counter table.
*/
func (a *Client) CounterTableGet(params *CounterTableGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CounterTableGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCounterTableGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "counter_table_get",
		Method:             "GET",
		PathPattern:        "/cluster/counter/tables/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CounterTableGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CounterTableGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CounterTableGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FirmwareHistoryCollectionGet Retrieves the history details for firmware update requests.

### Learn more
* [`DOC /cluster/firmware/history`](#docs-cluster-cluster_firmware_history)
*/
func (a *Client) FirmwareHistoryCollectionGet(params *FirmwareHistoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FirmwareHistoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFirmwareHistoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "firmware_history_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/firmware/history",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FirmwareHistoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FirmwareHistoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FirmwareHistoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
JobCollectionGet Retrieves a list of recently running asynchronous jobs. After a job transitions to a failure or success state, it is deleted after a default time of 300 seconds.
*/
func (a *Client) JobCollectionGet(params *JobCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewJobCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "job_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/jobs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &JobCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*JobCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*JobCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
JobGet Retrieves the details of a specific asynchronous job. After a job transitions to a failure or success state, it is deleted after a default time of 300 seconds.
*/
func (a *Client) JobGet(params *JobGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewJobGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "job_get",
		Method:             "GET",
		PathPattern:        "/cluster/jobs/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &JobGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*JobGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*JobGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
JobModify Updates the state of a specific asynchronous job.
*/
func (a *Client) JobModify(params *JobModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewJobModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "job_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/jobs/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &JobModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*JobModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*JobModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
JobModifyCollection job modify collection API
*/
func (a *Client) JobModifyCollection(params *JobModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*JobModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewJobModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "job_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/jobs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &JobModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*JobModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*JobModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseCreate Installs one or more feature licenses.

### Required properties
* `keys` - Array containing a list of NLF or 28-character license keys.
### Related ONTAP commands
* `system license add`
*/
func (a *Client) LicenseCreate(params *LicenseCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_create",
		Method:             "POST",
		PathPattern:        "/cluster/licensing/licenses",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseDelete Deletes a license.

### Related ONTAP commands
* `system license delete`
*/
func (a *Client) LicenseDelete(params *LicenseDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/licensing/licenses/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LicenseDeleteCollection license delete collection API
*/
func (a *Client) LicenseDeleteCollection(params *LicenseDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/licensing/licenses",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseGet Retrieves a specific license package.

####
**Note:** By default, the GET method only returns licensed packages. You must provide the following query "state=unlicensed" to retrieve unlicensed packages.
### Related ONTAP commands
* `system license show`
* `system license show-status`
*/
func (a *Client) LicenseGet(params *LicenseGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/licenses/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseManagerCollectionGet Retrieves a collection of license managers.

### Learn more
* [`DOC /cluster/licensing/license-managers`](#docs-cluster-cluster_licensing_license-managers)
### Related ONTAP commands
* `system license license-manager show`
*/
func (a *Client) LicenseManagerCollectionGet(params *LicenseManagerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseManagerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_manager_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/license-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseManagerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseManagerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseManagerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseManagerGet Retrieves information about the license manager.

### Learn more
* [`DOC /cluster/licensing/license-managers`](#docs-cluster-cluster_licensing_license-managers)
### Related ONTAP commands
* `system license license-manager show`
*/
func (a *Client) LicenseManagerGet(params *LicenseManagerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseManagerGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_manager_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/license-managers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseManagerGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicenseManagerGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseManagerGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicenseManagerModify Updates the license manager configuration.

### Learn more
* [`DOC /cluster/licensing/license-managers`](#docs-cluster-cluster_licensing_license-managers)
### Related ONTAP commands
* `system license license-manager modify`
*/
func (a *Client) LicenseManagerModify(params *LicenseManagerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerModifyOK, *LicenseManagerModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseManagerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_manager_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/licensing/license-managers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseManagerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LicenseManagerModifyOK:
		return value, nil, nil
	case *LicenseManagerModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseManagerModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LicenseManagerModifyCollection license manager modify collection API
*/
func (a *Client) LicenseManagerModifyCollection(params *LicenseManagerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicenseManagerModifyCollectionOK, *LicenseManagerModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicenseManagerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "license_manager_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/licensing/license-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicenseManagerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LicenseManagerModifyCollectionOK:
		return value, nil, nil
	case *LicenseManagerModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicenseManagerModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LicensesGet Retrieves a collection of license packages.

####
**Note:** By default, the GET method only returns licensed packages. You must provide the following query "state=unlicensed" to retrieve unlicensed packages.
**Note:** Starting with ONTAP 9.11.1, the GET method no longer returns the Base license record.
### Related ONTAP commands
* `system license show-status`
* `system license show`
*/
func (a *Client) LicensesGet(params *LicensesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LicensesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLicensesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "licenses_get",
		Method:             "GET",
		PathPattern:        "/cluster/licensing/licenses",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LicensesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LicensesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LicensesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MediatorCollectionGet "Retrieves a Mediator configured in the cluster."

### Related ONTAP commands
* `storage iscsi-initiator show`
*/
func (a *Client) MediatorCollectionGet(params *MediatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/mediators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MediatorCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MediatorCreate Creates and connect a mediator.
*/
func (a *Client) MediatorCreate(params *MediatorCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorCreateCreated, *MediatorCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_create",
		Method:             "POST",
		PathPattern:        "/cluster/mediators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MediatorCreateCreated:
		return value, nil, nil
	case *MediatorCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MediatorDelete Deletes the mediator.
*/
func (a *Client) MediatorDelete(params *MediatorDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorDeleteOK, *MediatorDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/mediators/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MediatorDeleteOK:
		return value, nil, nil
	case *MediatorDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MediatorDeleteCollection mediator delete collection API
*/
func (a *Client) MediatorDeleteCollection(params *MediatorDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorDeleteCollectionOK, *MediatorDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/mediators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MediatorDeleteCollectionOK:
		return value, nil, nil
	case *MediatorDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MediatorGet "Retrieves the Mediator state and configuration."

### Related ONTAP commands
* `storage iscsi-initiator show`
*/
func (a *Client) MediatorGet(params *MediatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_get",
		Method:             "GET",
		PathPattern:        "/cluster/mediators/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MediatorGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MediatorModify Modifies the mediator configuration.
*/
func (a *Client) MediatorModify(params *MediatorModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorModifyOK, *MediatorModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/mediators/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MediatorModifyOK:
		return value, nil, nil
	case *MediatorModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MediatorModifyCollection mediator modify collection API
*/
func (a *Client) MediatorModifyCollection(params *MediatorModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MediatorModifyCollectionOK, *MediatorModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMediatorModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "mediator_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/mediators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MediatorModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MediatorModifyCollectionOK:
		return value, nil, nil
	case *MediatorModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MediatorModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterCreate Sets up a MetroCluster.

### Required properties
* `partner_cluster.name`
* `dr_pairs`
### Recommended optional properties
* `mediator.*`
* `mccip_ports`
### Learn more
* [`DOC /cluster/metrocluster`](#docs-cluster-cluster_metrocluster)
### Related ONTAP commands
* `metrocluster configuration-settings dr-group create`
* `metrocluster configuration-settings interface create`
* `metrocluster configuration-settings connection connect`
* `metrocluster configuration-settings mediator add`
* `storage aggregate create`
* `storage aggregate mirror`
* `metrocluster configure`
*/
func (a *Client) MetroclusterCreate(params *MetroclusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterCreateCreated, *MetroclusterCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_create",
		Method:             "POST",
		PathPattern:        "/cluster/metrocluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterCreateCreated:
		return value, nil, nil
	case *MetroclusterCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterDiagnosticsCreate Start a MetroCluster diagnostic operation or set up a schedule for the diagnostics to be run periodically.
*/
func (a *Client) MetroclusterDiagnosticsCreate(params *MetroclusterDiagnosticsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDiagnosticsCreateCreated, *MetroclusterDiagnosticsCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDiagnosticsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_diagnostics_create",
		Method:             "POST",
		PathPattern:        "/cluster/metrocluster/diagnostics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDiagnosticsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterDiagnosticsCreateCreated:
		return value, nil, nil
	case *MetroclusterDiagnosticsCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDiagnosticsCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterDiagnosticsGet Retrieves the results of a completed diagnostic operation for the MetroCluster configuration.
*/
func (a *Client) MetroclusterDiagnosticsGet(params *MetroclusterDiagnosticsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDiagnosticsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDiagnosticsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_diagnostics_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/diagnostics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDiagnosticsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterDiagnosticsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDiagnosticsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterDrGroupCollectionGet Retrieves all the DR group in the MetroCluster over IP configuration.

### Related ONTAP commands
* `metrocluster configuration-settings dr-group show`
*/
func (a *Client) MetroclusterDrGroupCollectionGet(params *MetroclusterDrGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDrGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_dr_group_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/dr-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDrGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterDrGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDrGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterDrGroupCreate Creates a new DR group in the MetroCluster over IP configuration.

### Required properties
* `partner_cluster.name`
* `dr_pairs`
### Recommended optional properties
* `mccip_ports`
### Learn more
* [`DOC /cluster/metrocluster/dr-groups`](#docs-cluster-cluster_metrocluster_dr-groups)
### Related ONTAP commands
* `metrocluster configuration-settings dr-group create`
*/
func (a *Client) MetroclusterDrGroupCreate(params *MetroclusterDrGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupCreateCreated, *MetroclusterDrGroupCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDrGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_dr_group_create",
		Method:             "POST",
		PathPattern:        "/cluster/metrocluster/dr-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDrGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterDrGroupCreateCreated:
		return value, nil, nil
	case *MetroclusterDrGroupCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDrGroupCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterDrGroupDelete Remove the DR group from the current MetroCluster over IP configuration specified by the DR group id.

### Related ONTAP commands
* `metrocluster configuration-settings dr-group delete`
*/
func (a *Client) MetroclusterDrGroupDelete(params *MetroclusterDrGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupDeleteOK, *MetroclusterDrGroupDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDrGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_dr_group_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/metrocluster/dr-groups/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDrGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterDrGroupDeleteOK:
		return value, nil, nil
	case *MetroclusterDrGroupDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDrGroupDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterDrGroupDeleteCollection metrocluster dr group delete collection API
*/
func (a *Client) MetroclusterDrGroupDeleteCollection(params *MetroclusterDrGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupDeleteCollectionOK, *MetroclusterDrGroupDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDrGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_dr_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/metrocluster/dr-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDrGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterDrGroupDeleteCollectionOK:
		return value, nil, nil
	case *MetroclusterDrGroupDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDrGroupDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterDrGroupGet Retrieves the DR group information specified by the DR group id.

### Related ONTAP commands
* `metrocluster configuration-settings dr-group show`
*/
func (a *Client) MetroclusterDrGroupGet(params *MetroclusterDrGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterDrGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterDrGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_dr_group_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/dr-groups/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterDrGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterDrGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterDrGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterGet Retrieves MetroCluster status and configuration details.

### Related ONTAP commands
* `metrocluster show`
* `metrocluster node show`
*/
func (a *Client) MetroclusterGet(params *MetroclusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterInterconnectCollectionGet Retrieves a list of interconnect adapter information for nodes in the MetroCluster.

### Related ONTAP Commands
* `metrocluster interconnect show`
### Learn more
* [`DOC /cluster/metrocluster/interconnects`](#docs-cluster-cluster_metrocluster_interconnects)
*/
func (a *Client) MetroclusterInterconnectCollectionGet(params *MetroclusterInterconnectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterInterconnectCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_interconnect_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/interconnects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterInterconnectCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterInterconnectCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterInterconnectCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterInterconnectGet Retrieves information about a MetroCluster Interconnect for a specific partner type and adapter.

### Related ONTAP Commands
* `metrocluster interconnect show`
*/
func (a *Client) MetroclusterInterconnectGet(params *MetroclusterInterconnectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterInterconnectGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_interconnect_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/interconnects/{node.uuid}/{partner_type}/{adapter}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterInterconnectGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterInterconnectGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterInterconnectGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterInterconnectModify Updates a MetroCluster interconnect interface.

### Related ONTAP commands
* `metrocluster configuration-settings interface modify`
*/
func (a *Client) MetroclusterInterconnectModify(params *MetroclusterInterconnectModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectModifyOK, *MetroclusterInterconnectModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterInterconnectModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_interconnect_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/metrocluster/interconnects/{node.uuid}/{partner_type}/{adapter}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterInterconnectModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterInterconnectModifyOK:
		return value, nil, nil
	case *MetroclusterInterconnectModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterInterconnectModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterInterconnectModifyCollection metrocluster interconnect modify collection API
*/
func (a *Client) MetroclusterInterconnectModifyCollection(params *MetroclusterInterconnectModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterInterconnectModifyCollectionOK, *MetroclusterInterconnectModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterInterconnectModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_interconnect_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/metrocluster/interconnects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterInterconnectModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterInterconnectModifyCollectionOK:
		return value, nil, nil
	case *MetroclusterInterconnectModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterInterconnectModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterModify Initiates a switchover, heal or switchback operation.

### Related ONTAP commands
* `metrocluster switchover`
* `metrocluster switchback`
* `metrocluster heal`
* `metrocluster modify`
*/
func (a *Client) MetroclusterModify(params *MetroclusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterModifyOK, *MetroclusterModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/metrocluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *MetroclusterModifyOK:
		return value, nil, nil
	case *MetroclusterModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterNodeCollectionGet Retrieves MetroCluster nodes and their configurations.

### Related ONTAP Commands
* `metrocluster node show`
### Learn more
* [`DOC /cluster/metrocluster/nodes`](#docs-cluster-cluster_metrocluster_nodes)
*/
func (a *Client) MetroclusterNodeCollectionGet(params *MetroclusterNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterNodeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterNodeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_node_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterNodeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterNodeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterNodeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterNodeGet Retrieves the node configuration in the MetroCluster.

### Related ONTAP Commands
* `metrocluster node show`
*/
func (a *Client) MetroclusterNodeGet(params *MetroclusterNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterNodeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterNodeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_node_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/nodes/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterNodeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterNodeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterNodeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterOperationCollectionGet Retrieves the list of MetroCluster operations on the local cluster.

### Related ONTAP Commands
* `metrocluster operation history show`
### Learn more
* [`DOC /cluster/metrocluster/operations`](#docs-cluster-cluster_metrocluster_operations)
*/
func (a *Client) MetroclusterOperationCollectionGet(params *MetroclusterOperationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterOperationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterOperationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_operation_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/operations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterOperationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterOperationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterOperationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	MetroclusterOperationGet Retrieves information about a specific MetroCluster operation.

### Related ONTAP Commands
* `metrocluster operation show`
*/
func (a *Client) MetroclusterOperationGet(params *MetroclusterOperationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterOperationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterOperationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_operation_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/operations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterOperationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterOperationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterOperationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterSvmCollectionGet Retrieves configuration information for all pairs of SVMs in MetroCluster. REST /api/cluster/metrocluster/svms/?
*/
func (a *Client) MetroclusterSvmCollectionGet(params *MetroclusterSvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterSvmCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterSvmCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_svm_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterSvmCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterSvmCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterSvmCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MetroclusterSvmGet Retrieves configuration information for an SVM in a MetroCluster relationship.
*/
func (a *Client) MetroclusterSvmGet(params *MetroclusterSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MetroclusterSvmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMetroclusterSvmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "metrocluster_svm_get",
		Method:             "GET",
		PathPattern:        "/cluster/metrocluster/svms/{cluster.uuid}/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MetroclusterSvmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MetroclusterSvmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MetroclusterSvmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NodeDelete Deletes a node from the cluster.

Note that before deleting a node from the cluster, you must shut down all of the node's shared resources, such as virtual interfaces to clients. If any of the node's shared resources are still active, the command fails.
### Optional parameters:
* `force` - Forcibly removes a node that is down and cannot be brought online to remove its shared resources. This flag is set to "false" by default.
### Related ONTAP commands
* `cluster remove-node`
### Learn more
* [`DOC /cluster/nodes`](#docs-cluster-cluster_nodes)
*/
func (a *Client) NodeDelete(params *NodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeDeleteOK, *NodeDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NodeDeleteOK:
		return value, nil, nil
	case *NodeDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NodeDeleteCollection node delete collection API
*/
func (a *Client) NodeDeleteCollection(params *NodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeDeleteCollectionOK, *NodeDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NodeDeleteCollectionOK:
		return value, nil, nil
	case *NodeDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NodeGet Retrieves information for the node.

### Related ONTAP commands
* `cluster add-node-status`
* `cluster date show`
* `cluster ha show`
* `network interface show`
* `network port show`
* `storage failover show`
* `system controller show`
* `system node show`
* `system node show-discovered`
* `system service-processor network show`
* `system service-processor show`
* `system service-processor ssh show`
* `system service-processor image show`
* `version`
* `system service-processor api-service show`
* `system service-processor network auto-configuration show`
*/
func (a *Client) NodeGet(params *NodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_get",
		Method:             "GET",
		PathPattern:        "/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NodeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NodeMetricsCollectionGet Retrieves historical performance metrics for a node.
*/
func (a *Client) NodeMetricsCollectionGet(params *NodeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/nodes/{uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NodeMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NodeModify Updates the node information or performs shutdown/reboot actions on a node.

### Related ONTAP commands
* `cluster ha modify`
* `storage failover modify`
* `system node modify`
* `system node reboot`
* `system node power off`
* `system node power on`
* `system service-processor network modify`
* `system service-processor reboot-sp`
* `system service-processor image modify`
* `system service-processor network auto-configuration enable`
* `system service-processor network auto-configuration disable`
*/
func (a *Client) NodeModify(params *NodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeModifyOK, *NodeModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NodeModifyOK:
		return value, nil, nil
	case *NodeModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NodeModifyCollection node modify collection API
*/
func (a *Client) NodeModifyCollection(params *NodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodeModifyCollectionOK, *NodeModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "node_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NodeModifyCollectionOK:
		return value, nil, nil
	case *NodeModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodeModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NodesCreate Adds a node or nodes to the cluster.

### Required properties
* `cluster_interface.ip.address`
### Related ONTAP commands
* `cluster add-node`
* `network interface create`
* `storage aggregate auto-provision`
* `system node modify`
* `system service-processor network modify`
*/
func (a *Client) NodesCreate(params *NodesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodesCreateCreated, *NodesCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nodes_create",
		Method:             "POST",
		PathPattern:        "/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NodesCreateCreated:
		return value, nil, nil
	case *NodesCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodesCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NodesGet Retrieves the nodes in the cluster.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `system node show`
*/
func (a *Client) NodesGet(params *NodesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NodesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNodesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nodes_get",
		Method:             "GET",
		PathPattern:        "/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NodesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NodesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NodesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagCollectionGet Retrieves the tags currently being used for resources in the API.
*/
func (a *Client) ResourceTagCollectionGet(params *ResourceTagCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_collection_get",
		Method:             "GET",
		PathPattern:        "/resource-tags",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagGet Retrieves a specific resource tag.
*/
func (a *Client) ResourceTagGet(params *ResourceTagGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_get",
		Method:             "GET",
		PathPattern:        "/resource-tags/{value}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagResourceCollectionGet Retrieves the resources for a specific tag
*/
func (a *Client) ResourceTagResourceCollectionGet(params *ResourceTagResourceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagResourceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_resource_collection_get",
		Method:             "GET",
		PathPattern:        "/resource-tags/{resource_tag.value}/resources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagResourceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagResourceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagResourceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagResourceCreate Creates a new tag on a specific resource.
*/
func (a *Client) ResourceTagResourceCreate(params *ResourceTagResourceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagResourceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_resource_create",
		Method:             "POST",
		PathPattern:        "/resource-tags/{resource_tag.value}/resources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagResourceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagResourceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagResourceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagResourceDelete Deletes a specific tag on a specific resource.
*/
func (a *Client) ResourceTagResourceDelete(params *ResourceTagResourceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagResourceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_resource_delete",
		Method:             "DELETE",
		PathPattern:        "/resource-tags/{resource_tag.value}/resources/{href}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagResourceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagResourceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagResourceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagResourceDeleteCollection resource tag resource delete collection API
*/
func (a *Client) ResourceTagResourceDeleteCollection(params *ResourceTagResourceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagResourceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_resource_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/resource-tags/{resource_tag.value}/resources",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagResourceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagResourceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagResourceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceTagResourceGet Retrieves a specific resource for a specific tag.
*/
func (a *Client) ResourceTagResourceGet(params *ResourceTagResourceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceTagResourceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceTagResourceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "resource_tag_resource_get",
		Method:             "GET",
		PathPattern:        "/resource-tags/{resource_tag.value}/resources/{href}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ResourceTagResourceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceTagResourceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceTagResourceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleCollectionGet Retrieves a schedule.
*/
func (a *Client) ScheduleCollectionGet(params *ScheduleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ScheduleCreate Creates a schedule.

### Required Fields
* name - Name of the job schedule.
You must provide a minutes field for a cron schedule and an interval field for an interval schedule. Do not provide both a cron field and an interval field.
*/
func (a *Client) ScheduleCreate(params *ScheduleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_create",
		Method:             "POST",
		PathPattern:        "/cluster/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleDelete Deletes a schedule.
*/
func (a *Client) ScheduleDelete(params *ScheduleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/schedules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleDeleteCollection schedule delete collection API
*/
func (a *Client) ScheduleDeleteCollection(params *ScheduleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleGet Retrieves a schedule.
*/
func (a *Client) ScheduleGet(params *ScheduleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_get",
		Method:             "GET",
		PathPattern:        "/cluster/schedules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleModify Updates a schedule. Note that you cannot modify a cron field of an interval schedule, or the interval field of a cron schedule.
*/
func (a *Client) ScheduleModify(params *ScheduleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/schedules/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ScheduleModifyCollection schedule modify collection API
*/
func (a *Client) ScheduleModifyCollection(params *ScheduleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ScheduleModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "schedule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/cluster/schedules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduleModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ScheduleModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SensorsCollectionGet Retrieves Environment Sensors

### Related ONTAP commands
* `system node environment sensors show`
*/
func (a *Client) SensorsCollectionGet(params *SensorsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SensorsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSensorsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "sensors_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/sensors",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SensorsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SensorsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SensorsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SensorsGet Retrieve Environment Sensors
*/
func (a *Client) SensorsGet(params *SensorsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SensorsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSensorsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "sensors_get",
		Method:             "GET",
		PathPattern:        "/cluster/sensors/{node.uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SensorsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SensorsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SensorsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwareDownloadGet Retrieves the software or firmware download status.

### Learn more
* [`DOC /cluster/software/download`](#docs-cluster-cluster_software_download)
*/
func (a *Client) SoftwareDownloadGet(params *SoftwareDownloadGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareDownloadGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwareDownloadGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_download_get",
		Method:             "GET",
		PathPattern:        "/cluster/software/download",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwareDownloadGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SoftwareDownloadGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwareDownloadGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwareGet Retrieves the software profile of a cluster.

### Related ONTAP commands
* `cluster image show`
* `cluster image show-update-progress`
* `system node image package show`
### Learn more
* [`DOC /cluster/software`](#docs-cluster-cluster_software)
*/
func (a *Client) SoftwareGet(params *SoftwareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwareGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_get",
		Method:             "GET",
		PathPattern:        "/cluster/software",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwareGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SoftwareGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwareGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwareHistoryCollectionGet Retrieves the history details for software installation requests.

### Related ONTAP commands
* `cluster image show-update-history`
### Learn more
* [`DOC /cluster/software/history`](#docs-cluster-cluster_software_history)
*/
func (a *Client) SoftwareHistoryCollectionGet(params *SoftwareHistoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareHistoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwareHistoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_history_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/software/history",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwareHistoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SoftwareHistoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwareHistoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwareModify Updates the cluster software version.

Important note:
  - Setting 'version' triggers the package installation.
  - To validate the package for installation but not perform the installation, use the `validate_only` field on the request.

### Required properties
* `version` - Software version to be installed on the cluster.
### Recommended optional parameters
* `validate_only` - Required to validate a software package before an upgrade.
* `skip_warnings` - Used to skip validation warnings when starting a software upgrade.
* `action` - Used to pause, resume, or cancel an ongoing software upgrade.
* `stabilize_minutes` - Specifies a custom value between 1 to 60 minutes that allows each node a specified amount of time to stabilize after a reboot; the default is 8 minutes.
* `estimate_only` - Estimates the time duration; does not perform any update.
* `nodes_to_update` - Specifies a subset of the cluster's nodes for update.
* `show_validation_details` - If the value is set to true, then all validation details will be shown in the output.
* `skip_nodes_at_target_version` - If the value is set to true, then nodes already at the target version will not be upgraded. Defaults to true in non-MetroCluster configurations. Setting this option to false will force all the selected nodes of the cluster to undergo upgrade.
### Related ONTAP commands
* `cluster image validate`
* `cluster image update`
* `cluster image pause-update`
* `cluster image resume-update`
* `cluster image cancel-update`
### Learn more
* [`DOC /cluster/software`](#docs-cluster-cluster_software)
*/
func (a *Client) SoftwareModify(params *SoftwareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareModifyOK, *SoftwareModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwareModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/software",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwareModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SoftwareModifyOK:
		return value, nil, nil
	case *SoftwareModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwareModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwarePackageCreate Downloads a software or firmware package from the server.

### Required properties
* `url` - URL location of the software package
### Recommended optional parameters
* `username` - Username of HTTPS/FTP server
* `password` - Password of HTTPS/FTP server
### Related ONTAP commands
* `cluster image package get`
### Learn more
* [`DOC /cluster/software/download`](#docs-cluster-cluster_software_download)
*/
func (a *Client) SoftwarePackageCreate(params *SoftwarePackageCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageCreateCreated, *SoftwarePackageCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwarePackageCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_package_create",
		Method:             "POST",
		PathPattern:        "/cluster/software/download",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwarePackageCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SoftwarePackageCreateCreated:
		return value, nil, nil
	case *SoftwarePackageCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwarePackageCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwarePackageDelete Deletes a software package from the cluster. The delete operation fails if the package is currently installed.

### Related ONTAP commands
* `cluster image package delete`
### Learn more
* [`DOC /cluster/software/packages`](#docs-cluster-cluster_software_packages)
*/
func (a *Client) SoftwarePackageDelete(params *SoftwarePackageDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageDeleteOK, *SoftwarePackageDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwarePackageDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_package_delete",
		Method:             "DELETE",
		PathPattern:        "/cluster/software/packages/{version}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwarePackageDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SoftwarePackageDeleteOK:
		return value, nil, nil
	case *SoftwarePackageDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwarePackageDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SoftwarePackageDeleteCollection software package delete collection API
*/
func (a *Client) SoftwarePackageDeleteCollection(params *SoftwarePackageDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageDeleteCollectionOK, *SoftwarePackageDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwarePackageDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_package_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/cluster/software/packages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwarePackageDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SoftwarePackageDeleteCollectionOK:
		return value, nil, nil
	case *SoftwarePackageDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwarePackageDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwarePackageGet Retrieves the software package information.

### Related ONTAP commands
* `cluster image package show-repository`
### Learn more
* [`DOC /cluster/software/packages`](#docs-cluster-cluster_software_packages)
*/
func (a *Client) SoftwarePackageGet(params *SoftwarePackageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackageGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwarePackageGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_package_get",
		Method:             "GET",
		PathPattern:        "/cluster/software/packages/{version}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwarePackageGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SoftwarePackageGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwarePackageGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwarePackagesCollectionGet Retrieves the software packages for a cluster.

### Related ONTAP commands
* `cluster image package show-repository`
### Learn more
* [`DOC /cluster/software/packages`](#docs-cluster-cluster_software_packages)
*/
func (a *Client) SoftwarePackagesCollectionGet(params *SoftwarePackagesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwarePackagesCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwarePackagesCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_packages_collection_get",
		Method:             "GET",
		PathPattern:        "/cluster/software/packages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwarePackagesCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SoftwarePackagesCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwarePackagesCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SoftwareUpload Uploads a software or firmware package located on the local filesystem.

### Related ONTAP commands
* `cluster image package get`
### Learn more
* [`DOC /cluster/software`](#docs-cluster-cluster_software)
*/
func (a *Client) SoftwareUpload(params *SoftwareUploadParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SoftwareUploadCreated, *SoftwareUploadAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSoftwareUploadParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "software_upload",
		Method:             "POST",
		PathPattern:        "/cluster/software/upload",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SoftwareUploadReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SoftwareUploadCreated:
		return value, nil, nil
	case *SoftwareUploadAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SoftwareUploadDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebGet Retrieves the web services configuration.

### Related ONTAP commands
* `system services web show`
* `security ssl show`
*/
func (a *Client) WebGet(params *WebGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "web_get",
		Method:             "GET",
		PathPattern:        "/cluster/web",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebModify Updates the web services configuration.

### Related ONTAP commands
* `system services web modify`
* `security ssl modify`
*/
func (a *Client) WebModify(params *WebModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebModifyOK, *WebModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "web_modify",
		Method:             "PATCH",
		PathPattern:        "/cluster/web",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WebModifyOK:
		return value, nil, nil
	case *WebModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
