// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewClusterCreateParams creates a new ClusterCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterCreateParams() *ClusterCreateParams {
	return &ClusterCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterCreateParamsWithTimeout creates a new ClusterCreateParams object
// with the ability to set a timeout on a request.
func NewClusterCreateParamsWithTimeout(timeout time.Duration) *ClusterCreateParams {
	return &ClusterCreateParams{
		timeout: timeout,
	}
}

// NewClusterCreateParamsWithContext creates a new ClusterCreateParams object
// with the ability to set a context for a request.
func NewClusterCreateParamsWithContext(ctx context.Context) *ClusterCreateParams {
	return &ClusterCreateParams{
		Context: ctx,
	}
}

// NewClusterCreateParamsWithHTTPClient creates a new ClusterCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterCreateParamsWithHTTPClient(client *http.Client) *ClusterCreateParams {
	return &ClusterCreateParams{
		HTTPClient: client,
	}
}

/*
ClusterCreateParams contains all the parameters to send to the API endpoint

	for the cluster create operation.

	Typically these are written to a http.Request.
*/
type ClusterCreateParams struct {

	/* CreateRecommendedAggregates.

	   Create aggregates based on an optimal layout recommended by the system.
	*/
	CreateRecommendedAggregates *bool

	/* Info.

	   Cluster information
	*/
	Info *models.Cluster

	/* KeepPreclusterConfig.

	     This is used to keep temporary configuration settings that allow initial setup including a node scoped certificate and possibly an automatically created node management interface. This is useful when creating a GUI that does not replace the node management interface using POST on /api/cluster, but instead creates the interface at another time. The certificate also relates to creating a web based GUI so that the certificate lasts through the entire workflow.
	To remove the temporary configuration settings when a custom setup workflow is complete, set the remove_precluster_config query parameter in a PATCH on /api/cluster.

	*/
	KeepPreclusterConfig *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* SingleNodeCluster.

	   Configures a single node cluster.  All cluster ports are reassigned to the default network. The storage failover settings are configured to non-HA. The node reboots during this operation.
	*/
	SingleNodeCluster *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterCreateParams) WithDefaults() *ClusterCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterCreateParams) SetDefaults() {
	var (
		createRecommendedAggregatesDefault = bool(false)

		keepPreclusterConfigDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := ClusterCreateParams{
		CreateRecommendedAggregates: &createRecommendedAggregatesDefault,
		KeepPreclusterConfig:        &keepPreclusterConfigDefault,
		ReturnTimeout:               &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster create params
func (o *ClusterCreateParams) WithTimeout(timeout time.Duration) *ClusterCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster create params
func (o *ClusterCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster create params
func (o *ClusterCreateParams) WithContext(ctx context.Context) *ClusterCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster create params
func (o *ClusterCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster create params
func (o *ClusterCreateParams) WithHTTPClient(client *http.Client) *ClusterCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster create params
func (o *ClusterCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateRecommendedAggregates adds the createRecommendedAggregates to the cluster create params
func (o *ClusterCreateParams) WithCreateRecommendedAggregates(createRecommendedAggregates *bool) *ClusterCreateParams {
	o.SetCreateRecommendedAggregates(createRecommendedAggregates)
	return o
}

// SetCreateRecommendedAggregates adds the createRecommendedAggregates to the cluster create params
func (o *ClusterCreateParams) SetCreateRecommendedAggregates(createRecommendedAggregates *bool) {
	o.CreateRecommendedAggregates = createRecommendedAggregates
}

// WithInfo adds the info to the cluster create params
func (o *ClusterCreateParams) WithInfo(info *models.Cluster) *ClusterCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster create params
func (o *ClusterCreateParams) SetInfo(info *models.Cluster) {
	o.Info = info
}

// WithKeepPreclusterConfig adds the keepPreclusterConfig to the cluster create params
func (o *ClusterCreateParams) WithKeepPreclusterConfig(keepPreclusterConfig *bool) *ClusterCreateParams {
	o.SetKeepPreclusterConfig(keepPreclusterConfig)
	return o
}

// SetKeepPreclusterConfig adds the keepPreclusterConfig to the cluster create params
func (o *ClusterCreateParams) SetKeepPreclusterConfig(keepPreclusterConfig *bool) {
	o.KeepPreclusterConfig = keepPreclusterConfig
}

// WithReturnTimeout adds the returnTimeout to the cluster create params
func (o *ClusterCreateParams) WithReturnTimeout(returnTimeout *int64) *ClusterCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster create params
func (o *ClusterCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSingleNodeCluster adds the singleNodeCluster to the cluster create params
func (o *ClusterCreateParams) WithSingleNodeCluster(singleNodeCluster *bool) *ClusterCreateParams {
	o.SetSingleNodeCluster(singleNodeCluster)
	return o
}

// SetSingleNodeCluster adds the singleNodeCluster to the cluster create params
func (o *ClusterCreateParams) SetSingleNodeCluster(singleNodeCluster *bool) {
	o.SingleNodeCluster = singleNodeCluster
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateRecommendedAggregates != nil {

		// query param create_recommended_aggregates
		var qrCreateRecommendedAggregates bool

		if o.CreateRecommendedAggregates != nil {
			qrCreateRecommendedAggregates = *o.CreateRecommendedAggregates
		}
		qCreateRecommendedAggregates := swag.FormatBool(qrCreateRecommendedAggregates)
		if qCreateRecommendedAggregates != "" {

			if err := r.SetQueryParam("create_recommended_aggregates", qCreateRecommendedAggregates); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.KeepPreclusterConfig != nil {

		// query param keep_precluster_config
		var qrKeepPreclusterConfig bool

		if o.KeepPreclusterConfig != nil {
			qrKeepPreclusterConfig = *o.KeepPreclusterConfig
		}
		qKeepPreclusterConfig := swag.FormatBool(qrKeepPreclusterConfig)
		if qKeepPreclusterConfig != "" {

			if err := r.SetQueryParam("keep_precluster_config", qKeepPreclusterConfig); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SingleNodeCluster != nil {

		// query param single_node_cluster
		var qrSingleNodeCluster bool

		if o.SingleNodeCluster != nil {
			qrSingleNodeCluster = *o.SingleNodeCluster
		}
		qSingleNodeCluster := swag.FormatBool(qrSingleNodeCluster)
		if qSingleNodeCluster != "" {

			if err := r.SetQueryParam("single_node_cluster", qSingleNodeCluster); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
