// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewClusterNtpKeysCollectionGetParams creates a new ClusterNtpKeysCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpKeysCollectionGetParams() *ClusterNtpKeysCollectionGetParams {
	return &ClusterNtpKeysCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpKeysCollectionGetParamsWithTimeout creates a new ClusterNtpKeysCollectionGetParams object
// with the ability to set a timeout on a request.
func NewClusterNtpKeysCollectionGetParamsWithTimeout(timeout time.Duration) *ClusterNtpKeysCollectionGetParams {
	return &ClusterNtpKeysCollectionGetParams{
		timeout: timeout,
	}
}

// NewClusterNtpKeysCollectionGetParamsWithContext creates a new ClusterNtpKeysCollectionGetParams object
// with the ability to set a context for a request.
func NewClusterNtpKeysCollectionGetParamsWithContext(ctx context.Context) *ClusterNtpKeysCollectionGetParams {
	return &ClusterNtpKeysCollectionGetParams{
		Context: ctx,
	}
}

// NewClusterNtpKeysCollectionGetParamsWithHTTPClient creates a new ClusterNtpKeysCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpKeysCollectionGetParamsWithHTTPClient(client *http.Client) *ClusterNtpKeysCollectionGetParams {
	return &ClusterNtpKeysCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpKeysCollectionGetParams contains all the parameters to send to the API endpoint

	for the cluster ntp keys collection get operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpKeysCollectionGetParams struct {

	/* DigestType.

	   Filter by digest_type
	*/
	DigestType *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Value.

	   Filter by value
	*/
	Value *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp keys collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpKeysCollectionGetParams) WithDefaults() *ClusterNtpKeysCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp keys collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpKeysCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ClusterNtpKeysCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithTimeout(timeout time.Duration) *ClusterNtpKeysCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithContext(ctx context.Context) *ClusterNtpKeysCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithHTTPClient(client *http.Client) *ClusterNtpKeysCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDigestType adds the digestType to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithDigestType(digestType *string) *ClusterNtpKeysCollectionGetParams {
	o.SetDigestType(digestType)
	return o
}

// SetDigestType adds the digestType to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetDigestType(digestType *string) {
	o.DigestType = digestType
}

// WithFields adds the fields to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithFields(fields []string) *ClusterNtpKeysCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithID(id *int64) *ClusterNtpKeysCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithMaxRecords(maxRecords *int64) *ClusterNtpKeysCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithOrderBy(orderBy []string) *ClusterNtpKeysCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithReturnRecords(returnRecords *bool) *ClusterNtpKeysCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ClusterNtpKeysCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithValue adds the value to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) WithValue(value *string) *ClusterNtpKeysCollectionGetParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the cluster ntp keys collection get params
func (o *ClusterNtpKeysCollectionGetParams) SetValue(value *string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpKeysCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DigestType != nil {

		// query param digest_type
		var qrDigestType string

		if o.DigestType != nil {
			qrDigestType = *o.DigestType
		}
		qDigestType := qrDigestType
		if qDigestType != "" {

			if err := r.SetQueryParam("digest_type", qDigestType); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamClusterNtpKeysCollectionGet binds the parameter fields
func (o *ClusterNtpKeysCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamClusterNtpKeysCollectionGet binds the parameter order_by
func (o *ClusterNtpKeysCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
