// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNtpKeysCreateReader is a Reader for the ClusterNtpKeysCreate structure.
type ClusterNtpKeysCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNtpKeysCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewClusterNtpKeysCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNtpKeysCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNtpKeysCreateCreated creates a ClusterNtpKeysCreateCreated with default headers values
func NewClusterNtpKeysCreateCreated() *ClusterNtpKeysCreateCreated {
	return &ClusterNtpKeysCreateCreated{}
}

/*
ClusterNtpKeysCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ClusterNtpKeysCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this cluster ntp keys create created response has a 2xx status code
func (o *ClusterNtpKeysCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ntp keys create created response has a 3xx status code
func (o *ClusterNtpKeysCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ntp keys create created response has a 4xx status code
func (o *ClusterNtpKeysCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ntp keys create created response has a 5xx status code
func (o *ClusterNtpKeysCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ntp keys create created response a status code equal to that given
func (o *ClusterNtpKeysCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the cluster ntp keys create created response
func (o *ClusterNtpKeysCreateCreated) Code() int {
	return 201
}

func (o *ClusterNtpKeysCreateCreated) Error() string {
	return fmt.Sprintf("[POST /cluster/ntp/keys][%d] clusterNtpKeysCreateCreated", 201)
}

func (o *ClusterNtpKeysCreateCreated) String() string {
	return fmt.Sprintf("[POST /cluster/ntp/keys][%d] clusterNtpKeysCreateCreated", 201)
}

func (o *ClusterNtpKeysCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewClusterNtpKeysCreateDefault creates a ClusterNtpKeysCreateDefault with default headers values
func NewClusterNtpKeysCreateDefault(code int) *ClusterNtpKeysCreateDefault {
	return &ClusterNtpKeysCreateDefault{
		_statusCode: code,
	}
}

/*
	ClusterNtpKeysCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2097187 | Invalid value for an NTP symmetric authentication key. A SHA1 key must be exactly 40 hexadecimal digits. |
| 2097189 | Too many NTP keys have been configured. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterNtpKeysCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ntp keys create default response has a 2xx status code
func (o *ClusterNtpKeysCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ntp keys create default response has a 3xx status code
func (o *ClusterNtpKeysCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ntp keys create default response has a 4xx status code
func (o *ClusterNtpKeysCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ntp keys create default response has a 5xx status code
func (o *ClusterNtpKeysCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ntp keys create default response a status code equal to that given
func (o *ClusterNtpKeysCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ntp keys create default response
func (o *ClusterNtpKeysCreateDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNtpKeysCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/ntp/keys][%d] cluster_ntp_keys_create default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/ntp/keys][%d] cluster_ntp_keys_create default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNtpKeysCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
