// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewClusterNtpKeysDeleteCollectionParams creates a new ClusterNtpKeysDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpKeysDeleteCollectionParams() *ClusterNtpKeysDeleteCollectionParams {
	return &ClusterNtpKeysDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpKeysDeleteCollectionParamsWithTimeout creates a new ClusterNtpKeysDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewClusterNtpKeysDeleteCollectionParamsWithTimeout(timeout time.Duration) *ClusterNtpKeysDeleteCollectionParams {
	return &ClusterNtpKeysDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewClusterNtpKeysDeleteCollectionParamsWithContext creates a new ClusterNtpKeysDeleteCollectionParams object
// with the ability to set a context for a request.
func NewClusterNtpKeysDeleteCollectionParamsWithContext(ctx context.Context) *ClusterNtpKeysDeleteCollectionParams {
	return &ClusterNtpKeysDeleteCollectionParams{
		Context: ctx,
	}
}

// NewClusterNtpKeysDeleteCollectionParamsWithHTTPClient creates a new ClusterNtpKeysDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpKeysDeleteCollectionParamsWithHTTPClient(client *http.Client) *ClusterNtpKeysDeleteCollectionParams {
	return &ClusterNtpKeysDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpKeysDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the cluster ntp keys delete collection operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpKeysDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DigestType.

	   Filter by digest_type
	*/
	DigestType *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info ClusterNtpKeysDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Value.

	   Filter by value
	*/
	Value *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp keys delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpKeysDeleteCollectionParams) WithDefaults() *ClusterNtpKeysDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp keys delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpKeysDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ClusterNtpKeysDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithTimeout(timeout time.Duration) *ClusterNtpKeysDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithContext(ctx context.Context) *ClusterNtpKeysDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithHTTPClient(client *http.Client) *ClusterNtpKeysDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ClusterNtpKeysDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDigestType adds the digestType to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithDigestType(digestType *string) *ClusterNtpKeysDeleteCollectionParams {
	o.SetDigestType(digestType)
	return o
}

// SetDigestType adds the digestType to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetDigestType(digestType *string) {
	o.DigestType = digestType
}

// WithID adds the id to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithID(id *int64) *ClusterNtpKeysDeleteCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithInfo(info ClusterNtpKeysDeleteCollectionBody) *ClusterNtpKeysDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetInfo(info ClusterNtpKeysDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ClusterNtpKeysDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ClusterNtpKeysDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ClusterNtpKeysDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithValue adds the value to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) WithValue(value *string) *ClusterNtpKeysDeleteCollectionParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the cluster ntp keys delete collection params
func (o *ClusterNtpKeysDeleteCollectionParams) SetValue(value *string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpKeysDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DigestType != nil {

		// query param digest_type
		var qrDigestType string

		if o.DigestType != nil {
			qrDigestType = *o.DigestType
		}
		qDigestType := qrDigestType
		if qDigestType != "" {

			if err := r.SetQueryParam("digest_type", qDigestType); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
