// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNtpKeysDeleteCollectionReader is a Reader for the ClusterNtpKeysDeleteCollection structure.
type ClusterNtpKeysDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNtpKeysDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterNtpKeysDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNtpKeysDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNtpKeysDeleteCollectionOK creates a ClusterNtpKeysDeleteCollectionOK with default headers values
func NewClusterNtpKeysDeleteCollectionOK() *ClusterNtpKeysDeleteCollectionOK {
	return &ClusterNtpKeysDeleteCollectionOK{}
}

/*
ClusterNtpKeysDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ClusterNtpKeysDeleteCollectionOK struct {
}

// IsSuccess returns true when this cluster ntp keys delete collection o k response has a 2xx status code
func (o *ClusterNtpKeysDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ntp keys delete collection o k response has a 3xx status code
func (o *ClusterNtpKeysDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ntp keys delete collection o k response has a 4xx status code
func (o *ClusterNtpKeysDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ntp keys delete collection o k response has a 5xx status code
func (o *ClusterNtpKeysDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ntp keys delete collection o k response a status code equal to that given
func (o *ClusterNtpKeysDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster ntp keys delete collection o k response
func (o *ClusterNtpKeysDeleteCollectionOK) Code() int {
	return 200
}

func (o *ClusterNtpKeysDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /cluster/ntp/keys][%d] clusterNtpKeysDeleteCollectionOK", 200)
}

func (o *ClusterNtpKeysDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /cluster/ntp/keys][%d] clusterNtpKeysDeleteCollectionOK", 200)
}

func (o *ClusterNtpKeysDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterNtpKeysDeleteCollectionDefault creates a ClusterNtpKeysDeleteCollectionDefault with default headers values
func NewClusterNtpKeysDeleteCollectionDefault(code int) *ClusterNtpKeysDeleteCollectionDefault {
	return &ClusterNtpKeysDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ClusterNtpKeysDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2097186 | The key cannot be deleted because it is being used by an NTP server. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterNtpKeysDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ntp keys delete collection default response has a 2xx status code
func (o *ClusterNtpKeysDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ntp keys delete collection default response has a 3xx status code
func (o *ClusterNtpKeysDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ntp keys delete collection default response has a 4xx status code
func (o *ClusterNtpKeysDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ntp keys delete collection default response has a 5xx status code
func (o *ClusterNtpKeysDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ntp keys delete collection default response a status code equal to that given
func (o *ClusterNtpKeysDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ntp keys delete collection default response
func (o *ClusterNtpKeysDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNtpKeysDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/ntp/keys][%d] cluster_ntp_keys_delete_collection default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/ntp/keys][%d] cluster_ntp_keys_delete_collection default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNtpKeysDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ClusterNtpKeysDeleteCollectionBody cluster ntp keys delete collection body
swagger:model ClusterNtpKeysDeleteCollectionBody
*/
type ClusterNtpKeysDeleteCollectionBody struct {

	// ntp key response inline records
	NtpKeyResponseInlineRecords []*models.NtpKey `json:"records,omitempty"`
}

// Validate validates this cluster ntp keys delete collection body
func (o *ClusterNtpKeysDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNtpKeyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterNtpKeysDeleteCollectionBody) validateNtpKeyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NtpKeyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NtpKeyResponseInlineRecords); i++ {
		if swag.IsZero(o.NtpKeyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NtpKeyResponseInlineRecords[i] != nil {
			if err := o.NtpKeyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster ntp keys delete collection body based on the context it is used
func (o *ClusterNtpKeysDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNtpKeyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterNtpKeysDeleteCollectionBody) contextValidateNtpKeyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NtpKeyResponseInlineRecords); i++ {

		if o.NtpKeyResponseInlineRecords[i] != nil {
			if err := o.NtpKeyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterNtpKeysDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterNtpKeysDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ClusterNtpKeysDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
