// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNtpKeysDeleteReader is a Reader for the ClusterNtpKeysDelete structure.
type ClusterNtpKeysDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNtpKeysDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterNtpKeysDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNtpKeysDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNtpKeysDeleteOK creates a ClusterNtpKeysDeleteOK with default headers values
func NewClusterNtpKeysDeleteOK() *ClusterNtpKeysDeleteOK {
	return &ClusterNtpKeysDeleteOK{}
}

/*
ClusterNtpKeysDeleteOK describes a response with status code 200, with default header values.

OK
*/
type ClusterNtpKeysDeleteOK struct {
}

// IsSuccess returns true when this cluster ntp keys delete o k response has a 2xx status code
func (o *ClusterNtpKeysDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ntp keys delete o k response has a 3xx status code
func (o *ClusterNtpKeysDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ntp keys delete o k response has a 4xx status code
func (o *ClusterNtpKeysDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ntp keys delete o k response has a 5xx status code
func (o *ClusterNtpKeysDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ntp keys delete o k response a status code equal to that given
func (o *ClusterNtpKeysDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster ntp keys delete o k response
func (o *ClusterNtpKeysDeleteOK) Code() int {
	return 200
}

func (o *ClusterNtpKeysDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /cluster/ntp/keys/{id}][%d] clusterNtpKeysDeleteOK", 200)
}

func (o *ClusterNtpKeysDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /cluster/ntp/keys/{id}][%d] clusterNtpKeysDeleteOK", 200)
}

func (o *ClusterNtpKeysDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterNtpKeysDeleteDefault creates a ClusterNtpKeysDeleteDefault with default headers values
func NewClusterNtpKeysDeleteDefault(code int) *ClusterNtpKeysDeleteDefault {
	return &ClusterNtpKeysDeleteDefault{
		_statusCode: code,
	}
}

/*
	ClusterNtpKeysDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2097186 | The key cannot be deleted because it is being used by an NTP server. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterNtpKeysDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ntp keys delete default response has a 2xx status code
func (o *ClusterNtpKeysDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ntp keys delete default response has a 3xx status code
func (o *ClusterNtpKeysDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ntp keys delete default response has a 4xx status code
func (o *ClusterNtpKeysDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ntp keys delete default response has a 5xx status code
func (o *ClusterNtpKeysDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ntp keys delete default response a status code equal to that given
func (o *ClusterNtpKeysDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ntp keys delete default response
func (o *ClusterNtpKeysDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNtpKeysDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/ntp/keys/{id}][%d] cluster_ntp_keys_delete default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/ntp/keys/{id}][%d] cluster_ntp_keys_delete default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNtpKeysDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
