// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNtpKeysModifyCollectionReader is a Reader for the ClusterNtpKeysModifyCollection structure.
type ClusterNtpKeysModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNtpKeysModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterNtpKeysModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNtpKeysModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNtpKeysModifyCollectionOK creates a ClusterNtpKeysModifyCollectionOK with default headers values
func NewClusterNtpKeysModifyCollectionOK() *ClusterNtpKeysModifyCollectionOK {
	return &ClusterNtpKeysModifyCollectionOK{}
}

/*
ClusterNtpKeysModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ClusterNtpKeysModifyCollectionOK struct {
}

// IsSuccess returns true when this cluster ntp keys modify collection o k response has a 2xx status code
func (o *ClusterNtpKeysModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ntp keys modify collection o k response has a 3xx status code
func (o *ClusterNtpKeysModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ntp keys modify collection o k response has a 4xx status code
func (o *ClusterNtpKeysModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ntp keys modify collection o k response has a 5xx status code
func (o *ClusterNtpKeysModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ntp keys modify collection o k response a status code equal to that given
func (o *ClusterNtpKeysModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster ntp keys modify collection o k response
func (o *ClusterNtpKeysModifyCollectionOK) Code() int {
	return 200
}

func (o *ClusterNtpKeysModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /cluster/ntp/keys][%d] clusterNtpKeysModifyCollectionOK", 200)
}

func (o *ClusterNtpKeysModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /cluster/ntp/keys][%d] clusterNtpKeysModifyCollectionOK", 200)
}

func (o *ClusterNtpKeysModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterNtpKeysModifyCollectionDefault creates a ClusterNtpKeysModifyCollectionDefault with default headers values
func NewClusterNtpKeysModifyCollectionDefault(code int) *ClusterNtpKeysModifyCollectionDefault {
	return &ClusterNtpKeysModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ClusterNtpKeysModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2097187 | An invalid SHA1 key was provided. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterNtpKeysModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ntp keys modify collection default response has a 2xx status code
func (o *ClusterNtpKeysModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ntp keys modify collection default response has a 3xx status code
func (o *ClusterNtpKeysModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ntp keys modify collection default response has a 4xx status code
func (o *ClusterNtpKeysModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ntp keys modify collection default response has a 5xx status code
func (o *ClusterNtpKeysModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ntp keys modify collection default response a status code equal to that given
func (o *ClusterNtpKeysModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ntp keys modify collection default response
func (o *ClusterNtpKeysModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNtpKeysModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/ntp/keys][%d] cluster_ntp_keys_modify_collection default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/ntp/keys][%d] cluster_ntp_keys_modify_collection default %s", o._statusCode, payload)
}

func (o *ClusterNtpKeysModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNtpKeysModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ClusterNtpKeysModifyCollectionBody cluster ntp keys modify collection body
swagger:model ClusterNtpKeysModifyCollectionBody
*/
type ClusterNtpKeysModifyCollectionBody struct {

	// links
	Links *models.NtpKeyInlineLinks `json:"_links,omitempty"`

	// The type of cryptographic hash used to create and verify the NTP's message authentication code appended to each NTP packet header.
	//
	// Example: sha1
	// Enum: ["sha1"]
	DigestType *string `json:"digest_type,omitempty"`

	// NTP symmetric authentication key identifier or index number (ID). This ID is included
	// in the NTP cryptographic hash encoded header.
	//
	// Example: 10
	// Maximum: 65535
	// Minimum: 1
	ID *int64 `json:"id,omitempty"`

	// ntp key response inline records
	NtpKeyResponseInlineRecords []*models.NtpKey `json:"records,omitempty"`

	// A hexadecimal digit string that represents the cryptographic key that is shared with the remote NTP server.
	// The current expected length is 40 characters.
	// </br>
	// Use the cryptographic key and key ID to create a unique hash value used to authenticate the rest of the NTP data.
	//
	// Example: da39a3ee5e6b4b0d3255bfef95601890afd80709
	Value *string `json:"value,omitempty"`
}

// Validate validates this cluster ntp keys modify collection body
func (o *ClusterNtpKeysModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDigestType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNtpKeyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var clusterNtpKeysModifyCollectionBodyTypeDigestTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha1"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNtpKeysModifyCollectionBodyTypeDigestTypePropEnum = append(clusterNtpKeysModifyCollectionBodyTypeDigestTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNtpKeysModifyCollectionBody
	// ClusterNtpKeysModifyCollectionBody
	// digest_type
	// DigestType
	// sha1
	// END DEBUGGING
	// ClusterNtpKeysModifyCollectionBodyDigestTypeSha1 captures enum value "sha1"
	ClusterNtpKeysModifyCollectionBodyDigestTypeSha1 string = "sha1"
)

// prop value enum
func (o *ClusterNtpKeysModifyCollectionBody) validateDigestTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNtpKeysModifyCollectionBodyTypeDigestTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) validateDigestType(formats strfmt.Registry) error {
	if swag.IsZero(o.DigestType) { // not required
		return nil
	}

	// value enum
	if err := o.validateDigestTypeEnum("info"+"."+"digest_type", "body", *o.DigestType); err != nil {
		return err
	}

	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) validateID(formats strfmt.Registry) error {
	if swag.IsZero(o.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"id", "body", *o.ID, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"id", "body", *o.ID, 65535, false); err != nil {
		return err
	}

	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) validateNtpKeyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NtpKeyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NtpKeyResponseInlineRecords); i++ {
		if swag.IsZero(o.NtpKeyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NtpKeyResponseInlineRecords[i] != nil {
			if err := o.NtpKeyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster ntp keys modify collection body based on the context it is used
func (o *ClusterNtpKeysModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNtpKeyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterNtpKeysModifyCollectionBody) contextValidateNtpKeyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NtpKeyResponseInlineRecords); i++ {

		if o.NtpKeyResponseInlineRecords[i] != nil {
			if err := o.NtpKeyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterNtpKeysModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterNtpKeysModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ClusterNtpKeysModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NtpKeyInlineLinks ntp key inline links
swagger:model ntp_key_inline__links
*/
type NtpKeyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ntp key inline links
func (o *NtpKeyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NtpKeyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ntp key inline links based on the context it is used
func (o *NtpKeyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NtpKeyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NtpKeyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NtpKeyInlineLinks) UnmarshalBinary(b []byte) error {
	var res NtpKeyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
