// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewClusterNtpServersDeleteParams creates a new ClusterNtpServersDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpServersDeleteParams() *ClusterNtpServersDeleteParams {
	return &ClusterNtpServersDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpServersDeleteParamsWithTimeout creates a new ClusterNtpServersDeleteParams object
// with the ability to set a timeout on a request.
func NewClusterNtpServersDeleteParamsWithTimeout(timeout time.Duration) *ClusterNtpServersDeleteParams {
	return &ClusterNtpServersDeleteParams{
		timeout: timeout,
	}
}

// NewClusterNtpServersDeleteParamsWithContext creates a new ClusterNtpServersDeleteParams object
// with the ability to set a context for a request.
func NewClusterNtpServersDeleteParamsWithContext(ctx context.Context) *ClusterNtpServersDeleteParams {
	return &ClusterNtpServersDeleteParams{
		Context: ctx,
	}
}

// NewClusterNtpServersDeleteParamsWithHTTPClient creates a new ClusterNtpServersDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpServersDeleteParamsWithHTTPClient(client *http.Client) *ClusterNtpServersDeleteParams {
	return &ClusterNtpServersDeleteParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpServersDeleteParams contains all the parameters to send to the API endpoint

	for the cluster ntp servers delete operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpServersDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* Server.

	   Server address or host name
	*/
	Server string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp servers delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersDeleteParams) WithDefaults() *ClusterNtpServersDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp servers delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := ClusterNtpServersDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) WithTimeout(timeout time.Duration) *ClusterNtpServersDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) WithContext(ctx context.Context) *ClusterNtpServersDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) WithHTTPClient(client *http.Client) *ClusterNtpServersDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) WithReturnTimeout(returnTimeout *int64) *ClusterNtpServersDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServer adds the server to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) WithServer(server string) *ClusterNtpServersDeleteParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cluster ntp servers delete params
func (o *ClusterNtpServersDeleteParams) SetServer(server string) {
	o.Server = server
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpServersDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param server
	if err := r.SetPathParam("server", o.Server); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
