// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewClusterNtpServersGetParams creates a new ClusterNtpServersGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpServersGetParams() *ClusterNtpServersGetParams {
	return &ClusterNtpServersGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpServersGetParamsWithTimeout creates a new ClusterNtpServersGetParams object
// with the ability to set a timeout on a request.
func NewClusterNtpServersGetParamsWithTimeout(timeout time.Duration) *ClusterNtpServersGetParams {
	return &ClusterNtpServersGetParams{
		timeout: timeout,
	}
}

// NewClusterNtpServersGetParamsWithContext creates a new ClusterNtpServersGetParams object
// with the ability to set a context for a request.
func NewClusterNtpServersGetParamsWithContext(ctx context.Context) *ClusterNtpServersGetParams {
	return &ClusterNtpServersGetParams{
		Context: ctx,
	}
}

// NewClusterNtpServersGetParamsWithHTTPClient creates a new ClusterNtpServersGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpServersGetParamsWithHTTPClient(client *http.Client) *ClusterNtpServersGetParams {
	return &ClusterNtpServersGetParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpServersGetParams contains all the parameters to send to the API endpoint

	for the cluster ntp servers get operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpServersGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Server.

	   NTP server host name, IPv4, or IPv6 address.
	*/
	Server string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp servers get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersGetParams) WithDefaults() *ClusterNtpServersGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp servers get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) WithTimeout(timeout time.Duration) *ClusterNtpServersGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) WithContext(ctx context.Context) *ClusterNtpServersGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) WithHTTPClient(client *http.Client) *ClusterNtpServersGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) WithFields(fields []string) *ClusterNtpServersGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithServer adds the server to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) WithServer(server string) *ClusterNtpServersGetParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cluster ntp servers get params
func (o *ClusterNtpServersGetParams) SetServer(server string) {
	o.Server = server
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpServersGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param server
	if err := r.SetPathParam("server", o.Server); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamClusterNtpServersGet binds the parameter fields
func (o *ClusterNtpServersGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
