// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNtpServersGetReader is a Reader for the ClusterNtpServersGet structure.
type ClusterNtpServersGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNtpServersGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterNtpServersGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNtpServersGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNtpServersGetOK creates a ClusterNtpServersGetOK with default headers values
func NewClusterNtpServersGetOK() *ClusterNtpServersGetOK {
	return &ClusterNtpServersGetOK{}
}

/*
ClusterNtpServersGetOK describes a response with status code 200, with default header values.

OK
*/
type ClusterNtpServersGetOK struct {
	Payload *models.NtpServer
}

// IsSuccess returns true when this cluster ntp servers get o k response has a 2xx status code
func (o *ClusterNtpServersGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ntp servers get o k response has a 3xx status code
func (o *ClusterNtpServersGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ntp servers get o k response has a 4xx status code
func (o *ClusterNtpServersGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ntp servers get o k response has a 5xx status code
func (o *ClusterNtpServersGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ntp servers get o k response a status code equal to that given
func (o *ClusterNtpServersGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster ntp servers get o k response
func (o *ClusterNtpServersGetOK) Code() int {
	return 200
}

func (o *ClusterNtpServersGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/ntp/servers/{server}][%d] clusterNtpServersGetOK %s", 200, payload)
}

func (o *ClusterNtpServersGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/ntp/servers/{server}][%d] clusterNtpServersGetOK %s", 200, payload)
}

func (o *ClusterNtpServersGetOK) GetPayload() *models.NtpServer {
	return o.Payload
}

func (o *ClusterNtpServersGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NtpServer)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterNtpServersGetDefault creates a ClusterNtpServersGetDefault with default headers values
func NewClusterNtpServersGetDefault(code int) *ClusterNtpServersGetDefault {
	return &ClusterNtpServersGetDefault{
		_statusCode: code,
	}
}

/*
ClusterNtpServersGetDefault describes a response with status code -1, with default header values.

Error
*/
type ClusterNtpServersGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ntp servers get default response has a 2xx status code
func (o *ClusterNtpServersGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ntp servers get default response has a 3xx status code
func (o *ClusterNtpServersGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ntp servers get default response has a 4xx status code
func (o *ClusterNtpServersGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ntp servers get default response has a 5xx status code
func (o *ClusterNtpServersGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ntp servers get default response a status code equal to that given
func (o *ClusterNtpServersGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ntp servers get default response
func (o *ClusterNtpServersGetDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNtpServersGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/ntp/servers/{server}][%d] cluster_ntp_servers_get default %s", o._statusCode, payload)
}

func (o *ClusterNtpServersGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/ntp/servers/{server}][%d] cluster_ntp_servers_get default %s", o._statusCode, payload)
}

func (o *ClusterNtpServersGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNtpServersGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
