// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewClusterNtpServersModifyCollectionParams creates a new ClusterNtpServersModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpServersModifyCollectionParams() *ClusterNtpServersModifyCollectionParams {
	return &ClusterNtpServersModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpServersModifyCollectionParamsWithTimeout creates a new ClusterNtpServersModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewClusterNtpServersModifyCollectionParamsWithTimeout(timeout time.Duration) *ClusterNtpServersModifyCollectionParams {
	return &ClusterNtpServersModifyCollectionParams{
		timeout: timeout,
	}
}

// NewClusterNtpServersModifyCollectionParamsWithContext creates a new ClusterNtpServersModifyCollectionParams object
// with the ability to set a context for a request.
func NewClusterNtpServersModifyCollectionParamsWithContext(ctx context.Context) *ClusterNtpServersModifyCollectionParams {
	return &ClusterNtpServersModifyCollectionParams{
		Context: ctx,
	}
}

// NewClusterNtpServersModifyCollectionParamsWithHTTPClient creates a new ClusterNtpServersModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpServersModifyCollectionParamsWithHTTPClient(client *http.Client) *ClusterNtpServersModifyCollectionParams {
	return &ClusterNtpServersModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpServersModifyCollectionParams contains all the parameters to send to the API endpoint

	for the cluster ntp servers modify collection operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpServersModifyCollectionParams struct {

	/* AuthenticationEnabled.

	   Filter by authentication_enabled
	*/
	AuthenticationEnabled *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info ClusterNtpServersModifyCollectionBody

	/* KeyID.

	   Filter by key.id
	*/
	KeyID *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Server.

	   Filter by server
	*/
	Server *string

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp servers modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersModifyCollectionParams) WithDefaults() *ClusterNtpServersModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp servers modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ClusterNtpServersModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithTimeout(timeout time.Duration) *ClusterNtpServersModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithContext(ctx context.Context) *ClusterNtpServersModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithHTTPClient(client *http.Client) *ClusterNtpServersModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationEnabled adds the authenticationEnabled to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithAuthenticationEnabled(authenticationEnabled *bool) *ClusterNtpServersModifyCollectionParams {
	o.SetAuthenticationEnabled(authenticationEnabled)
	return o
}

// SetAuthenticationEnabled adds the authenticationEnabled to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetAuthenticationEnabled(authenticationEnabled *bool) {
	o.AuthenticationEnabled = authenticationEnabled
}

// WithContinueOnFailure adds the continueOnFailure to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ClusterNtpServersModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithInfo(info ClusterNtpServersModifyCollectionBody) *ClusterNtpServersModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetInfo(info ClusterNtpServersModifyCollectionBody) {
	o.Info = info
}

// WithKeyID adds the keyID to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithKeyID(keyID *int64) *ClusterNtpServersModifyCollectionParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetKeyID(keyID *int64) {
	o.KeyID = keyID
}

// WithReturnRecords adds the returnRecords to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithReturnRecords(returnRecords *bool) *ClusterNtpServersModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *ClusterNtpServersModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithSerialRecords(serialRecords *bool) *ClusterNtpServersModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServer adds the server to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithServer(server *string) *ClusterNtpServersModifyCollectionParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetServer(server *string) {
	o.Server = server
}

// WithVersion adds the version to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) WithVersion(version *string) *ClusterNtpServersModifyCollectionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the cluster ntp servers modify collection params
func (o *ClusterNtpServersModifyCollectionParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpServersModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationEnabled != nil {

		// query param authentication_enabled
		var qrAuthenticationEnabled bool

		if o.AuthenticationEnabled != nil {
			qrAuthenticationEnabled = *o.AuthenticationEnabled
		}
		qAuthenticationEnabled := swag.FormatBool(qrAuthenticationEnabled)
		if qAuthenticationEnabled != "" {

			if err := r.SetQueryParam("authentication_enabled", qAuthenticationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyID != nil {

		// query param key.id
		var qrKeyID int64

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := swag.FormatInt64(qrKeyID)
		if qKeyID != "" {

			if err := r.SetQueryParam("key.id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
