// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewClusterNtpServersModifyParams creates a new ClusterNtpServersModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterNtpServersModifyParams() *ClusterNtpServersModifyParams {
	return &ClusterNtpServersModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterNtpServersModifyParamsWithTimeout creates a new ClusterNtpServersModifyParams object
// with the ability to set a timeout on a request.
func NewClusterNtpServersModifyParamsWithTimeout(timeout time.Duration) *ClusterNtpServersModifyParams {
	return &ClusterNtpServersModifyParams{
		timeout: timeout,
	}
}

// NewClusterNtpServersModifyParamsWithContext creates a new ClusterNtpServersModifyParams object
// with the ability to set a context for a request.
func NewClusterNtpServersModifyParamsWithContext(ctx context.Context) *ClusterNtpServersModifyParams {
	return &ClusterNtpServersModifyParams{
		Context: ctx,
	}
}

// NewClusterNtpServersModifyParamsWithHTTPClient creates a new ClusterNtpServersModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterNtpServersModifyParamsWithHTTPClient(client *http.Client) *ClusterNtpServersModifyParams {
	return &ClusterNtpServersModifyParams{
		HTTPClient: client,
	}
}

/*
ClusterNtpServersModifyParams contains all the parameters to send to the API endpoint

	for the cluster ntp servers modify operation.

	Typically these are written to a http.Request.
*/
type ClusterNtpServersModifyParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.NtpServer

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* Server.

	   Server address or host name
	*/
	Server string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster ntp servers modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersModifyParams) WithDefaults() *ClusterNtpServersModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster ntp servers modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterNtpServersModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := ClusterNtpServersModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithTimeout(timeout time.Duration) *ClusterNtpServersModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithContext(ctx context.Context) *ClusterNtpServersModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithHTTPClient(client *http.Client) *ClusterNtpServersModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithInfo(info *models.NtpServer) *ClusterNtpServersModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetInfo(info *models.NtpServer) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithReturnTimeout(returnTimeout *int64) *ClusterNtpServersModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServer adds the server to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) WithServer(server string) *ClusterNtpServersModifyParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the cluster ntp servers modify params
func (o *ClusterNtpServersModifyParams) SetServer(server string) {
	o.Server = server
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterNtpServersModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param server
	if err := r.SetPathParam("server", o.Server); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
