// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewClusterPeerCreateParams creates a new ClusterPeerCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterPeerCreateParams() *ClusterPeerCreateParams {
	return &ClusterPeerCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterPeerCreateParamsWithTimeout creates a new ClusterPeerCreateParams object
// with the ability to set a timeout on a request.
func NewClusterPeerCreateParamsWithTimeout(timeout time.Duration) *ClusterPeerCreateParams {
	return &ClusterPeerCreateParams{
		timeout: timeout,
	}
}

// NewClusterPeerCreateParamsWithContext creates a new ClusterPeerCreateParams object
// with the ability to set a context for a request.
func NewClusterPeerCreateParamsWithContext(ctx context.Context) *ClusterPeerCreateParams {
	return &ClusterPeerCreateParams{
		Context: ctx,
	}
}

// NewClusterPeerCreateParamsWithHTTPClient creates a new ClusterPeerCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterPeerCreateParamsWithHTTPClient(client *http.Client) *ClusterPeerCreateParams {
	return &ClusterPeerCreateParams{
		HTTPClient: client,
	}
}

/*
ClusterPeerCreateParams contains all the parameters to send to the API endpoint

	for the cluster peer create operation.

	Typically these are written to a http.Request.
*/
type ClusterPeerCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ClusterPeer

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster peer create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterPeerCreateParams) WithDefaults() *ClusterPeerCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster peer create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterPeerCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ClusterPeerCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster peer create params
func (o *ClusterPeerCreateParams) WithTimeout(timeout time.Duration) *ClusterPeerCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster peer create params
func (o *ClusterPeerCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster peer create params
func (o *ClusterPeerCreateParams) WithContext(ctx context.Context) *ClusterPeerCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster peer create params
func (o *ClusterPeerCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster peer create params
func (o *ClusterPeerCreateParams) WithHTTPClient(client *http.Client) *ClusterPeerCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster peer create params
func (o *ClusterPeerCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the cluster peer create params
func (o *ClusterPeerCreateParams) WithInfo(info *models.ClusterPeer) *ClusterPeerCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster peer create params
func (o *ClusterPeerCreateParams) SetInfo(info *models.ClusterPeer) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the cluster peer create params
func (o *ClusterPeerCreateParams) WithReturnRecords(returnRecords *bool) *ClusterPeerCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cluster peer create params
func (o *ClusterPeerCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterPeerCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
