// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterPeerCreateReader is a Reader for the ClusterPeerCreate structure.
type ClusterPeerCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterPeerCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewClusterPeerCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterPeerCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterPeerCreateCreated creates a ClusterPeerCreateCreated with default headers values
func NewClusterPeerCreateCreated() *ClusterPeerCreateCreated {
	return &ClusterPeerCreateCreated{}
}

/*
ClusterPeerCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ClusterPeerCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.ClusterPeerResponse
}

// IsSuccess returns true when this cluster peer create created response has a 2xx status code
func (o *ClusterPeerCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster peer create created response has a 3xx status code
func (o *ClusterPeerCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster peer create created response has a 4xx status code
func (o *ClusterPeerCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster peer create created response has a 5xx status code
func (o *ClusterPeerCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster peer create created response a status code equal to that given
func (o *ClusterPeerCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the cluster peer create created response
func (o *ClusterPeerCreateCreated) Code() int {
	return 201
}

func (o *ClusterPeerCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/peers][%d] clusterPeerCreateCreated %s", 201, payload)
}

func (o *ClusterPeerCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/peers][%d] clusterPeerCreateCreated %s", 201, payload)
}

func (o *ClusterPeerCreateCreated) GetPayload() *models.ClusterPeerResponse {
	return o.Payload
}

func (o *ClusterPeerCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.ClusterPeerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterPeerCreateDefault creates a ClusterPeerCreateDefault with default headers values
func NewClusterPeerCreateDefault(code int) *ClusterPeerCreateDefault {
	return &ClusterPeerCreateDefault{
		_statusCode: code,
	}
}

/*
	ClusterPeerCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966366 | The system SVM of the cluster IPspace hosts cluster LIFs only. |
| 4653058 | Cannot peer with self. |
| 4653075 | Cannot peer with two clusters using the same cluster peer relationship name. |
| 4653075 | Cannot peer two clusters with the same name. |
| 4653076 | Cannot peer two clusters with the same UUID. |
| 4653229 | Value for \"expiry_time\" is obsolete. |
| 4653236 | The specified passphrase is too short. |
| 4653365 | IPspaces are unavailable with cluster peering: {ipspace}. |
| 4653368 | Invalid peer address passed in \"ip_addresses\": Verify that the peer address is correct, and then try the operation again. |
| 4653419 | An unencrypted peering relationship is not supported because the cluster peering policy requires the use of encryption. |
| 4653708 | The specified addresses must be of the same address family. |
| 4656069 | Specifying a passphrase without remote IP addresses is not supported. |
| 4656070 | The encryption protocol is meaningful only with authenticated cluster peer relationships. |
| 4656071 | Cannot peer with a cluster bearing the same name as the local cluster. |
| 4656072 | The name must conform to the same rules as a cluster name. |
| 4656074 | Cannot check whether all nodes of this cluster support encryption. |
| 4656075 | Cannot specify encryption: this operation requires an ECV of 9.6.0 or later. |
| 4656077 | Specify either remote IP addresses or generate_passphrase. |
| 4656079 | No cluster nodes were found. Check your cluster configuration. |
| 4656081 | Creating an intercluster LIF requires a list of local IP addresses. |
| 4656085 | Cannot create an intercluster LIF with an empty list of local IP addresses. |
| 4656086 | Creating an intercluster LIF requires a broadcast domain that is in use within the IPspace. |
| 4656087 | The number of local intercluster IP addresses must be less than or equal to the number of available nodes. |
| 4656088 | Found no ports matching the IPspace and the broadcast domain. |
| 4656089 | Found no matching entry for IPspace. |
| 4656090 | The given IPspace differs from the IPspace entry found. |
| 4656091 | Creating an intercluster LIF requires a subnet mask or a subnet mask length. |
| 4656094 | Found no ports to bind to intercluster LIFs. Check your network configuration. |
| 4656095 | The address family of the specified peer addresses is not valid in IPspace. Use /api/network/ip/interfaces/ to verify that required LIFs are present and operational on each cluster node. |
| 4656096 | Creating an intercluster LIF requires an IPv4 or IPv6 address of the default router. |
| 4656100 | Cannot use peer address \"ip_addresses\" because it is already in use on the local cluster. Use /api/network/ip/interfaces to view the address in use. |
| 4656101 | Cannot specify a remote IP that resolves to both IPv4 and IPv6. Specify an IPv4 or IPv6 address. |
| 8847365 | Unknown Host |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterPeerCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster peer create default response has a 2xx status code
func (o *ClusterPeerCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster peer create default response has a 3xx status code
func (o *ClusterPeerCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster peer create default response has a 4xx status code
func (o *ClusterPeerCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster peer create default response has a 5xx status code
func (o *ClusterPeerCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster peer create default response a status code equal to that given
func (o *ClusterPeerCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster peer create default response
func (o *ClusterPeerCreateDefault) Code() int {
	return o._statusCode
}

func (o *ClusterPeerCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/peers][%d] cluster_peer_create default %s", o._statusCode, payload)
}

func (o *ClusterPeerCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/peers][%d] cluster_peer_create default %s", o._statusCode, payload)
}

func (o *ClusterPeerCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterPeerCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
