// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterPeerDeleteReader is a Reader for the ClusterPeerDelete structure.
type ClusterPeerDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterPeerDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterPeerDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterPeerDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterPeerDeleteOK creates a ClusterPeerDeleteOK with default headers values
func NewClusterPeerDeleteOK() *ClusterPeerDeleteOK {
	return &ClusterPeerDeleteOK{}
}

/*
ClusterPeerDeleteOK describes a response with status code 200, with default header values.

OK
*/
type ClusterPeerDeleteOK struct {
}

// IsSuccess returns true when this cluster peer delete o k response has a 2xx status code
func (o *ClusterPeerDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster peer delete o k response has a 3xx status code
func (o *ClusterPeerDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster peer delete o k response has a 4xx status code
func (o *ClusterPeerDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster peer delete o k response has a 5xx status code
func (o *ClusterPeerDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster peer delete o k response a status code equal to that given
func (o *ClusterPeerDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster peer delete o k response
func (o *ClusterPeerDeleteOK) Code() int {
	return 200
}

func (o *ClusterPeerDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /cluster/peers/{uuid}][%d] clusterPeerDeleteOK", 200)
}

func (o *ClusterPeerDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /cluster/peers/{uuid}][%d] clusterPeerDeleteOK", 200)
}

func (o *ClusterPeerDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterPeerDeleteDefault creates a ClusterPeerDeleteDefault with default headers values
func NewClusterPeerDeleteDefault(code int) *ClusterPeerDeleteDefault {
	return &ClusterPeerDeleteDefault{
		_statusCode: code,
	}
}

/*
	ClusterPeerDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4653079 | Unable to delete peer relationship. |
| 4663070 | Unable to delete cluster peer relationship due to an ongoing Vserver migration. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterPeerDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster peer delete default response has a 2xx status code
func (o *ClusterPeerDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster peer delete default response has a 3xx status code
func (o *ClusterPeerDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster peer delete default response has a 4xx status code
func (o *ClusterPeerDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster peer delete default response has a 5xx status code
func (o *ClusterPeerDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster peer delete default response a status code equal to that given
func (o *ClusterPeerDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster peer delete default response
func (o *ClusterPeerDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ClusterPeerDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/peers/{uuid}][%d] cluster_peer_delete default %s", o._statusCode, payload)
}

func (o *ClusterPeerDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/peers/{uuid}][%d] cluster_peer_delete default %s", o._statusCode, payload)
}

func (o *ClusterPeerDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterPeerDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
