// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterPeerModifyCollectionReader is a Reader for the ClusterPeerModifyCollection structure.
type ClusterPeerModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterPeerModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterPeerModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterPeerModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterPeerModifyCollectionOK creates a ClusterPeerModifyCollectionOK with default headers values
func NewClusterPeerModifyCollectionOK() *ClusterPeerModifyCollectionOK {
	return &ClusterPeerModifyCollectionOK{}
}

/*
ClusterPeerModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ClusterPeerModifyCollectionOK struct {
	Payload *models.ClusterPeer
}

// IsSuccess returns true when this cluster peer modify collection o k response has a 2xx status code
func (o *ClusterPeerModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster peer modify collection o k response has a 3xx status code
func (o *ClusterPeerModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster peer modify collection o k response has a 4xx status code
func (o *ClusterPeerModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster peer modify collection o k response has a 5xx status code
func (o *ClusterPeerModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster peer modify collection o k response a status code equal to that given
func (o *ClusterPeerModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster peer modify collection o k response
func (o *ClusterPeerModifyCollectionOK) Code() int {
	return 200
}

func (o *ClusterPeerModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/peers][%d] clusterPeerModifyCollectionOK %s", 200, payload)
}

func (o *ClusterPeerModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/peers][%d] clusterPeerModifyCollectionOK %s", 200, payload)
}

func (o *ClusterPeerModifyCollectionOK) GetPayload() *models.ClusterPeer {
	return o.Payload
}

func (o *ClusterPeerModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClusterPeer)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterPeerModifyCollectionDefault creates a ClusterPeerModifyCollectionDefault with default headers values
func NewClusterPeerModifyCollectionDefault(code int) *ClusterPeerModifyCollectionDefault {
	return &ClusterPeerModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ClusterPeerModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | SVM name does not exist. |
| 4653061 | The specified remote cluster is invalid. |
| 4653215 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653216 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653217 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653218 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653219 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653220 | An introductory RPC to the peer address failed to connect. Verify that the peer address is correct, and then try the operation again. |
| 4653229 | Specified value for \"-offer-expiration\" is obsolete. |
| 4653236 | The specified passphrase is too short. |
| 4653257 | The vifmgr process is not running. |
| 4653261 | Error finding IPspace. |
| 4653671 | No operational intercluster LIFs of the IPv4 address family is available on this node for the specified IPspace. |
| 4655058 | Expiration time cannot be more than 7 days in the future. |
| 4655061 | SVM does not exist in the IPspace. |
| 4656070 | The encryption protocol is meaningful only with authenticated cluster peer relationships. |
| 4656072 | The name must conform to the same rules as a cluster name. |
| 4656073 | Changing the encryption state requires the refreshing of the authentication passphrase. |
| 4656075 | Cannot specify encryption: this operation requires an ECV of ONTAP 9.6.0 or later. |
| 4656076 | Cluster peer modify was attempted with mismatched IPv4 and IPv6 addresses. |
| 4656080 | Specify either a passphrase or set \"generate-passphrase\" to true. |
| 4656081 | The remote IP address list is empty. |
| 4656083 | Cannot auto-generate a passphrase when \"generate-passphrase\" is false. Modifying a passphrase using an auto-generated passphrase requires \"generate-passphrase\" be true. |
| 4656084 | Passphrase can only be modified with an authenticated cluster peer relationship. |
| 4656092 | Cluster peer modify was attempted with a host name that did not resolve to an IPv4 or IPv6 address. |
| 4656095 | The address family of the specified peer addresses is not valid in this IPspace. Use /api/network/interfaces/ to verify that required LIFs are present and operational on each cluster node. |
| 8847365 | Unknown Host |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterPeerModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster peer modify collection default response has a 2xx status code
func (o *ClusterPeerModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster peer modify collection default response has a 3xx status code
func (o *ClusterPeerModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster peer modify collection default response has a 4xx status code
func (o *ClusterPeerModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster peer modify collection default response has a 5xx status code
func (o *ClusterPeerModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster peer modify collection default response a status code equal to that given
func (o *ClusterPeerModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster peer modify collection default response
func (o *ClusterPeerModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ClusterPeerModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/peers][%d] cluster_peer_modify_collection default %s", o._statusCode, payload)
}

func (o *ClusterPeerModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/peers][%d] cluster_peer_modify_collection default %s", o._statusCode, payload)
}

func (o *ClusterPeerModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterPeerModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ClusterPeerModifyCollectionBody cluster peer modify collection body
swagger:model ClusterPeerModifyCollectionBody
*/
type ClusterPeerModifyCollectionBody struct {

	// links
	Links *models.ClusterPeerInlineLinks `json:"_links,omitempty"`

	// authentication
	Authentication *models.ClusterPeerInlineAuthentication `json:"authentication,omitempty"`

	// The local SVMs allowed to peer with the peer cluster's SVMs. This list can be modified until the remote cluster accepts this cluster peering relationship.
	ClusterPeerInlineInitialAllowedSvms []*models.ClusterPeerInlineInitialAllowedSvmsInlineArrayItem `json:"initial_allowed_svms,omitempty"`

	// Peering applications against which allowed SVMs are configured.
	// Example: ["snapmirror","flexcache"]
	ClusterPeerInlinePeerApplications []*models.SvmPeerPermissionApplications `json:"peer_applications,omitempty"`

	// cluster peer response inline records
	ClusterPeerResponseInlineRecords []*models.ClusterPeer `json:"records,omitempty"`

	// encryption
	Encryption *models.ClusterPeerInlineEncryption `json:"encryption,omitempty"`

	// A local intercluster IP address that a remote cluster can use, together with the passphrase, to create a cluster peer relationship with the local cluster.
	// Read Only: true
	IPAddress *models.IPAddress `json:"ip_address,omitempty"`

	// ipspace
	Ipspace *models.ClusterPeerInlineIpspace `json:"ipspace,omitempty"`

	// local network
	LocalNetwork *models.ClusterPeerInlineLocalNetwork `json:"local_network,omitempty"`

	// Optional name for the cluster peer relationship. By default, it is the name of the remote cluster, or a temporary name might be autogenerated for anonymous cluster peer offers.
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// remote
	Remote *models.ClusterPeerInlineRemote `json:"remote,omitempty"`

	// status
	Status *models.ClusterPeerInlineStatus `json:"status,omitempty"`

	// UUID of the cluster peer relationship. For anonymous cluster peer offers, the UUID will change when the remote cluster accepts the relationship.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// version
	Version *models.ClusterPeerInlineVersion `json:"version,omitempty"`
}

// Validate validates this cluster peer modify collection body
func (o *ClusterPeerModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterPeerInlineInitialAllowedSvms(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterPeerInlinePeerApplications(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterPeerResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocalNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateAuthentication(formats strfmt.Registry) error {
	if swag.IsZero(o.Authentication) { // not required
		return nil
	}

	if o.Authentication != nil {
		if err := o.Authentication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "authentication")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateClusterPeerInlineInitialAllowedSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterPeerInlineInitialAllowedSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.ClusterPeerInlineInitialAllowedSvms); i++ {
		if swag.IsZero(o.ClusterPeerInlineInitialAllowedSvms[i]) { // not required
			continue
		}

		if o.ClusterPeerInlineInitialAllowedSvms[i] != nil {
			if err := o.ClusterPeerInlineInitialAllowedSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "initial_allowed_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateClusterPeerInlinePeerApplications(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterPeerInlinePeerApplications) { // not required
		return nil
	}

	for i := 0; i < len(o.ClusterPeerInlinePeerApplications); i++ {
		if swag.IsZero(o.ClusterPeerInlinePeerApplications[i]) { // not required
			continue
		}

		if o.ClusterPeerInlinePeerApplications[i] != nil {
			if err := o.ClusterPeerInlinePeerApplications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "peer_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateClusterPeerResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterPeerResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ClusterPeerResponseInlineRecords); i++ {
		if swag.IsZero(o.ClusterPeerResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ClusterPeerResponseInlineRecords[i] != nil {
			if err := o.ClusterPeerResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateIPAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.IPAddress) { // not required
		return nil
	}

	if o.IPAddress != nil {
		if err := o.IPAddress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip_address")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateLocalNetwork(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalNetwork) { // not required
		return nil
	}

	if o.LocalNetwork != nil {
		if err := o.LocalNetwork.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local_network")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(o.Remote) { // not required
		return nil
	}

	if o.Remote != nil {
		if err := o.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer modify collection body based on the context it is used
func (o *ClusterPeerModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAuthentication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterPeerInlineInitialAllowedSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterPeerInlinePeerApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterPeerResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalNetwork(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateAuthentication(ctx context.Context, formats strfmt.Registry) error {

	if o.Authentication != nil {
		if err := o.Authentication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "authentication")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateClusterPeerInlineInitialAllowedSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ClusterPeerInlineInitialAllowedSvms); i++ {

		if o.ClusterPeerInlineInitialAllowedSvms[i] != nil {
			if err := o.ClusterPeerInlineInitialAllowedSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "initial_allowed_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateClusterPeerInlinePeerApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ClusterPeerInlinePeerApplications); i++ {

		if o.ClusterPeerInlinePeerApplications[i] != nil {
			if err := o.ClusterPeerInlinePeerApplications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "peer_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateClusterPeerResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ClusterPeerResponseInlineRecords); i++ {

		if o.ClusterPeerResponseInlineRecords[i] != nil {
			if err := o.ClusterPeerResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateIPAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.IPAddress != nil {
		if err := o.IPAddress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip_address")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateLocalNetwork(ctx context.Context, formats strfmt.Registry) error {

	if o.LocalNetwork != nil {
		if err := o.LocalNetwork.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local_network")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if o.Remote != nil {
		if err := o.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ClusterPeerModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0 cluster peer modify collection params body local network interfaces items0
swagger:model ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0
*/
type ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0 struct {

	// List of local intercluster IP addresses.
	IPAddress *models.IPAddress `json:"ip_address,omitempty"`
}

// Validate validates this cluster peer modify collection params body local network interfaces items0
func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) validateIPAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.IPAddress) { // not required
		return nil
	}

	if o.IPAddress != nil {
		if err := o.IPAddress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer modify collection params body local network interfaces items0 based on the context it is used
func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIPAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) contextValidateIPAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.IPAddress != nil {
		if err := o.IPAddress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineLinks cluster peer inline links
swagger:model cluster_peer_inline__links
*/
type ClusterPeerInlineLinks struct {

	// interfaces
	Interfaces *models.Href `json:"interfaces,omitempty"`

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline links
func (o *ClusterPeerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineLinks) validateInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Interfaces) { // not required
		return nil
	}

	if o.Interfaces != nil {
		if err := o.Interfaces.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "interfaces")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline links based on the context it is used
func (o *ClusterPeerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineLinks) contextValidateInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if o.Interfaces != nil {
		if err := o.Interfaces.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "interfaces")
			}
			return err
		}
	}

	return nil
}

func (o *ClusterPeerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineAuthentication cluster peer inline authentication
swagger:model cluster_peer_inline_authentication
*/
type ClusterPeerInlineAuthentication struct {

	// The time when the passphrase will expire, in ISO 8601 duration format or date and time format.  The default is 1 hour.
	// Example: P1DT2H3M4S or '2017-01-25T11:20:13Z'
	ExpiryTime *string `json:"expiry_time,omitempty"`

	// Auto generate a passphrase when true.
	GeneratePassphrase *bool `json:"generate_passphrase,omitempty"`

	// in use
	// Enum: ["ok","absent","revoked"]
	InUse *string `json:"in_use,omitempty"`

	// A password to authenticate the cluster peer relationship.
	Passphrase *string `json:"passphrase,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","absent","pending","problem"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster peer inline authentication
func (o *ClusterPeerInlineAuthentication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInUse(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineAuthenticationTypeInUsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","absent","revoked"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineAuthenticationTypeInUsePropEnum = append(clusterPeerInlineAuthenticationTypeInUsePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// ok
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseOk captures enum value "ok"
	ClusterPeerInlineAuthenticationInUseOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// absent
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseAbsent captures enum value "absent"
	ClusterPeerInlineAuthenticationInUseAbsent string = "absent"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// revoked
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseRevoked captures enum value "revoked"
	ClusterPeerInlineAuthenticationInUseRevoked string = "revoked"
)

// prop value enum
func (o *ClusterPeerInlineAuthentication) validateInUseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineAuthenticationTypeInUsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterPeerInlineAuthentication) validateInUse(formats strfmt.Registry) error {
	if swag.IsZero(o.InUse) { // not required
		return nil
	}

	// value enum
	if err := o.validateInUseEnum("info"+"."+"authentication"+"."+"in_use", "body", *o.InUse); err != nil {
		return err
	}

	return nil
}

var clusterPeerInlineAuthenticationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","absent","pending","problem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineAuthenticationTypeStatePropEnum = append(clusterPeerInlineAuthenticationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// ok
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateOk captures enum value "ok"
	ClusterPeerInlineAuthenticationStateOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// absent
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateAbsent captures enum value "absent"
	ClusterPeerInlineAuthenticationStateAbsent string = "absent"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// pending
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStatePending captures enum value "pending"
	ClusterPeerInlineAuthenticationStatePending string = "pending"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// problem
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateProblem captures enum value "problem"
	ClusterPeerInlineAuthenticationStateProblem string = "problem"
)

// prop value enum
func (o *ClusterPeerInlineAuthentication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineAuthenticationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterPeerInlineAuthentication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"authentication"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline authentication based on the context it is used
func (o *ClusterPeerInlineAuthentication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineAuthentication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"authentication"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineAuthentication) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineAuthentication) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineAuthentication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineEncryption cluster peer inline encryption
swagger:model cluster_peer_inline_encryption
*/
type ClusterPeerInlineEncryption struct {

	// proposed
	// Enum: ["none","tls_psk"]
	Proposed *string `json:"proposed,omitempty"`

	// state
	// Read Only: true
	// Enum: ["none","tls_psk"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster peer inline encryption
func (o *ClusterPeerInlineEncryption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateProposed(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineEncryptionTypeProposedPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","tls_psk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineEncryptionTypeProposedPropEnum = append(clusterPeerInlineEncryptionTypeProposedPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// proposed
	// Proposed
	// none
	// END DEBUGGING
	// ClusterPeerInlineEncryptionProposedNone captures enum value "none"
	ClusterPeerInlineEncryptionProposedNone string = "none"

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// proposed
	// Proposed
	// tls_psk
	// END DEBUGGING
	// ClusterPeerInlineEncryptionProposedTLSPsk captures enum value "tls_psk"
	ClusterPeerInlineEncryptionProposedTLSPsk string = "tls_psk"
)

// prop value enum
func (o *ClusterPeerInlineEncryption) validateProposedEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineEncryptionTypeProposedPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterPeerInlineEncryption) validateProposed(formats strfmt.Registry) error {
	if swag.IsZero(o.Proposed) { // not required
		return nil
	}

	// value enum
	if err := o.validateProposedEnum("info"+"."+"encryption"+"."+"proposed", "body", *o.Proposed); err != nil {
		return err
	}

	return nil
}

var clusterPeerInlineEncryptionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","tls_psk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineEncryptionTypeStatePropEnum = append(clusterPeerInlineEncryptionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// state
	// State
	// none
	// END DEBUGGING
	// ClusterPeerInlineEncryptionStateNone captures enum value "none"
	ClusterPeerInlineEncryptionStateNone string = "none"

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// state
	// State
	// tls_psk
	// END DEBUGGING
	// ClusterPeerInlineEncryptionStateTLSPsk captures enum value "tls_psk"
	ClusterPeerInlineEncryptionStateTLSPsk string = "tls_psk"
)

// prop value enum
func (o *ClusterPeerInlineEncryption) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineEncryptionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterPeerInlineEncryption) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"encryption"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline encryption based on the context it is used
func (o *ClusterPeerInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineEncryption) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineEncryption) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineInitialAllowedSvmsInlineArrayItem SVM, applies only to SVM-scoped objects.
swagger:model cluster_peer_inline_initial_allowed_svms_inline_array_item
*/
type ClusterPeerInlineInitialAllowedSvmsInlineArrayItem struct {

	// links
	Links *models.ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster peer inline initial allowed svms inline array item
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline initial allowed svms inline array item based on the context it is used
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineInitialAllowedSvmsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks cluster peer inline initial allowed svms inline array item inline links
swagger:model cluster_peer_inline_initial_allowed_svms_inline_array_item_inline__links
*/
type ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline initial allowed svms inline array item inline links
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline initial allowed svms inline array item inline links based on the context it is used
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineIpspace The IPspace of the local intercluster LIFs.
swagger:model cluster_peer_inline_ipspace
*/
type ClusterPeerInlineIpspace struct {

	// links
	Links *models.ClusterPeerInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster peer inline ipspace
func (o *ClusterPeerInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline ipspace based on the context it is used
func (o *ClusterPeerInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineIpspace) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineIpspaceInlineLinks cluster peer inline ipspace inline links
swagger:model cluster_peer_inline_ipspace_inline__links
*/
type ClusterPeerInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline ipspace inline links
func (o *ClusterPeerInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline ipspace inline links based on the context it is used
func (o *ClusterPeerInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineLocalNetwork Cluster peering requires an intercluster LIF on each local node. These can be optionally created by specifying a list of IP addresses corresponding to each node.
swagger:model cluster_peer_inline_local_network
*/
type ClusterPeerInlineLocalNetwork struct {

	// Broadcast domain that is in use within the IPspace.
	// Example: bd1
	BroadcastDomain *string `json:"broadcast_domain,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// interfaces
	Interfaces []*ClusterPeerModifyCollectionParamsBodyLocalNetworkInterfacesItems0 `json:"interfaces,omitempty"`

	// IPv4 mask or netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`
}

// Validate validates this cluster peer inline local network
func (o *ClusterPeerInlineLocalNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineLocalNetwork) validateInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.Interfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.Interfaces); i++ {
		if swag.IsZero(o.Interfaces[i]) { // not required
			continue
		}

		if o.Interfaces[i] != nil {
			if err := o.Interfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "local_network" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster peer inline local network based on the context it is used
func (o *ClusterPeerInlineLocalNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineLocalNetwork) contextValidateInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Interfaces); i++ {

		if o.Interfaces[i] != nil {
			if err := o.Interfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "local_network" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineLocalNetwork) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineLocalNetwork) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineLocalNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineRemote cluster peer inline remote
swagger:model cluster_peer_inline_remote
*/
type ClusterPeerInlineRemote struct {

	// The IPv4 addresses, IPv6 addresses, or hostnames of the peers.
	IPAddresses []*models.IPAddress `json:"ip_addresses,omitempty"`

	// The name of the remote cluster.
	// Example: cluster2
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The serial number of the remote cluster.
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this cluster peer inline remote
func (o *ClusterPeerInlineRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineRemote) validateIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(o.IPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(o.IPAddresses); i++ {
		if swag.IsZero(o.IPAddresses[i]) { // not required
			continue
		}

		if o.IPAddresses[i] != nil {
			if err := o.IPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "remote" + "." + "ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster peer inline remote based on the context it is used
func (o *ClusterPeerInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineRemote) contextValidateIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPAddresses); i++ {

		if o.IPAddresses[i] != nil {
			if err := o.IPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "remote" + "." + "ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ClusterPeerInlineRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"remote"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineRemote) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"remote"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineRemote) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineRemote) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineStatus cluster peer inline status
swagger:model cluster_peer_inline_status
*/
type ClusterPeerInlineStatus struct {

	// state
	// Example: available
	// Read Only: true
	// Enum: ["available","partial","unavailable","pending","unidentified"]
	State *string `json:"state,omitempty"`

	// The last time the state was updated.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`
}

// Validate validates this cluster peer inline status
func (o *ClusterPeerInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","partial","unavailable","pending","unidentified"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineStatusTypeStatePropEnum = append(clusterPeerInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// available
	// END DEBUGGING
	// ClusterPeerInlineStatusStateAvailable captures enum value "available"
	ClusterPeerInlineStatusStateAvailable string = "available"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// partial
	// END DEBUGGING
	// ClusterPeerInlineStatusStatePartial captures enum value "partial"
	ClusterPeerInlineStatusStatePartial string = "partial"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// unavailable
	// END DEBUGGING
	// ClusterPeerInlineStatusStateUnavailable captures enum value "unavailable"
	ClusterPeerInlineStatusStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// pending
	// END DEBUGGING
	// ClusterPeerInlineStatusStatePending captures enum value "pending"
	ClusterPeerInlineStatusStatePending string = "pending"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// unidentified
	// END DEBUGGING
	// ClusterPeerInlineStatusStateUnidentified captures enum value "unidentified"
	ClusterPeerInlineStatusStateUnidentified string = "unidentified"
)

// prop value enum
func (o *ClusterPeerInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ClusterPeerInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineStatus) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"status"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline status based on the context it is used
func (o *ClusterPeerInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineStatus) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineStatus) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ClusterPeerInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
swagger:model cluster_peer_inline_version
*/
type ClusterPeerInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this cluster peer inline version
func (o *ClusterPeerInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster peer inline version based on the context it is used
func (o *ClusterPeerInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ClusterPeerInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version"+"."+"full", "body", o.Full); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version"+"."+"generation", "body", o.Generation); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version"+"."+"major", "body", o.Major); err != nil {
		return err
	}

	return nil
}

func (o *ClusterPeerInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version"+"."+"minor", "body", o.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ClusterPeerInlineVersion) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ClusterPeerInlineVersion) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
