// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCounterRowCollectionGetParams creates a new CounterRowCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCounterRowCollectionGetParams() *CounterRowCollectionGetParams {
	return &CounterRowCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCounterRowCollectionGetParamsWithTimeout creates a new CounterRowCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCounterRowCollectionGetParamsWithTimeout(timeout time.Duration) *CounterRowCollectionGetParams {
	return &CounterRowCollectionGetParams{
		timeout: timeout,
	}
}

// NewCounterRowCollectionGetParamsWithContext creates a new CounterRowCollectionGetParams object
// with the ability to set a context for a request.
func NewCounterRowCollectionGetParamsWithContext(ctx context.Context) *CounterRowCollectionGetParams {
	return &CounterRowCollectionGetParams{
		Context: ctx,
	}
}

// NewCounterRowCollectionGetParamsWithHTTPClient creates a new CounterRowCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCounterRowCollectionGetParamsWithHTTPClient(client *http.Client) *CounterRowCollectionGetParams {
	return &CounterRowCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CounterRowCollectionGetParams contains all the parameters to send to the API endpoint

	for the counter row collection get operation.

	Typically these are written to a http.Request.
*/
type CounterRowCollectionGetParams struct {

	/* AggregationComplete.

	   Filter by aggregation.complete
	*/
	AggregationComplete *bool

	/* AggregationCount.

	   Filter by aggregation.count
	*/
	AggregationCount *int64

	/* CounterTableName.

	   Counter table name.
	*/
	CounterTableName string

	/* CountersCountersLabel.

	   Filter by counters.counters.label
	*/
	CountersCountersLabel *string

	/* CountersCountersValues.

	   Filter by counters.counters.values
	*/
	CountersCountersValues *int64

	/* CountersLabels.

	   Filter by counters.labels
	*/
	CountersLabels *string

	/* CountersName.

	   Filter by counters.name
	*/
	CountersName *string

	/* CountersValue.

	   Filter by counters.value
	*/
	CountersValue *int64

	/* CountersValues.

	   Filter by counters.values
	*/
	CountersValues *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PropertiesName.

	   Filter by properties.name
	*/
	PropertiesName *string

	/* PropertiesValue.

	   Filter by properties.value
	*/
	PropertiesValue *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the counter row collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CounterRowCollectionGetParams) WithDefaults() *CounterRowCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the counter row collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CounterRowCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CounterRowCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithTimeout(timeout time.Duration) *CounterRowCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithContext(ctx context.Context) *CounterRowCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithHTTPClient(client *http.Client) *CounterRowCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregationComplete adds the aggregationComplete to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithAggregationComplete(aggregationComplete *bool) *CounterRowCollectionGetParams {
	o.SetAggregationComplete(aggregationComplete)
	return o
}

// SetAggregationComplete adds the aggregationComplete to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetAggregationComplete(aggregationComplete *bool) {
	o.AggregationComplete = aggregationComplete
}

// WithAggregationCount adds the aggregationCount to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithAggregationCount(aggregationCount *int64) *CounterRowCollectionGetParams {
	o.SetAggregationCount(aggregationCount)
	return o
}

// SetAggregationCount adds the aggregationCount to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetAggregationCount(aggregationCount *int64) {
	o.AggregationCount = aggregationCount
}

// WithCounterTableName adds the counterTableName to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCounterTableName(counterTableName string) *CounterRowCollectionGetParams {
	o.SetCounterTableName(counterTableName)
	return o
}

// SetCounterTableName adds the counterTableName to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCounterTableName(counterTableName string) {
	o.CounterTableName = counterTableName
}

// WithCountersCountersLabel adds the countersCountersLabel to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersCountersLabel(countersCountersLabel *string) *CounterRowCollectionGetParams {
	o.SetCountersCountersLabel(countersCountersLabel)
	return o
}

// SetCountersCountersLabel adds the countersCountersLabel to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersCountersLabel(countersCountersLabel *string) {
	o.CountersCountersLabel = countersCountersLabel
}

// WithCountersCountersValues adds the countersCountersValues to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersCountersValues(countersCountersValues *int64) *CounterRowCollectionGetParams {
	o.SetCountersCountersValues(countersCountersValues)
	return o
}

// SetCountersCountersValues adds the countersCountersValues to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersCountersValues(countersCountersValues *int64) {
	o.CountersCountersValues = countersCountersValues
}

// WithCountersLabels adds the countersLabels to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersLabels(countersLabels *string) *CounterRowCollectionGetParams {
	o.SetCountersLabels(countersLabels)
	return o
}

// SetCountersLabels adds the countersLabels to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersLabels(countersLabels *string) {
	o.CountersLabels = countersLabels
}

// WithCountersName adds the countersName to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersName(countersName *string) *CounterRowCollectionGetParams {
	o.SetCountersName(countersName)
	return o
}

// SetCountersName adds the countersName to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersName(countersName *string) {
	o.CountersName = countersName
}

// WithCountersValue adds the countersValue to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersValue(countersValue *int64) *CounterRowCollectionGetParams {
	o.SetCountersValue(countersValue)
	return o
}

// SetCountersValue adds the countersValue to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersValue(countersValue *int64) {
	o.CountersValue = countersValue
}

// WithCountersValues adds the countersValues to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithCountersValues(countersValues *int64) *CounterRowCollectionGetParams {
	o.SetCountersValues(countersValues)
	return o
}

// SetCountersValues adds the countersValues to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetCountersValues(countersValues *int64) {
	o.CountersValues = countersValues
}

// WithFields adds the fields to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithFields(fields []string) *CounterRowCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithID(id *string) *CounterRowCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetID(id *string) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithMaxRecords(maxRecords *int64) *CounterRowCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithOrderBy(orderBy []string) *CounterRowCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPropertiesName adds the propertiesName to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithPropertiesName(propertiesName *string) *CounterRowCollectionGetParams {
	o.SetPropertiesName(propertiesName)
	return o
}

// SetPropertiesName adds the propertiesName to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetPropertiesName(propertiesName *string) {
	o.PropertiesName = propertiesName
}

// WithPropertiesValue adds the propertiesValue to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithPropertiesValue(propertiesValue *string) *CounterRowCollectionGetParams {
	o.SetPropertiesValue(propertiesValue)
	return o
}

// SetPropertiesValue adds the propertiesValue to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetPropertiesValue(propertiesValue *string) {
	o.PropertiesValue = propertiesValue
}

// WithReturnRecords adds the returnRecords to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithReturnRecords(returnRecords *bool) *CounterRowCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the counter row collection get params
func (o *CounterRowCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CounterRowCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the counter row collection get params
func (o *CounterRowCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *CounterRowCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggregationComplete != nil {

		// query param aggregation.complete
		var qrAggregationComplete bool

		if o.AggregationComplete != nil {
			qrAggregationComplete = *o.AggregationComplete
		}
		qAggregationComplete := swag.FormatBool(qrAggregationComplete)
		if qAggregationComplete != "" {

			if err := r.SetQueryParam("aggregation.complete", qAggregationComplete); err != nil {
				return err
			}
		}
	}

	if o.AggregationCount != nil {

		// query param aggregation.count
		var qrAggregationCount int64

		if o.AggregationCount != nil {
			qrAggregationCount = *o.AggregationCount
		}
		qAggregationCount := swag.FormatInt64(qrAggregationCount)
		if qAggregationCount != "" {

			if err := r.SetQueryParam("aggregation.count", qAggregationCount); err != nil {
				return err
			}
		}
	}

	// path param counter_table.name
	if err := r.SetPathParam("counter_table.name", o.CounterTableName); err != nil {
		return err
	}

	if o.CountersCountersLabel != nil {

		// query param counters.counters.label
		var qrCountersCountersLabel string

		if o.CountersCountersLabel != nil {
			qrCountersCountersLabel = *o.CountersCountersLabel
		}
		qCountersCountersLabel := qrCountersCountersLabel
		if qCountersCountersLabel != "" {

			if err := r.SetQueryParam("counters.counters.label", qCountersCountersLabel); err != nil {
				return err
			}
		}
	}

	if o.CountersCountersValues != nil {

		// query param counters.counters.values
		var qrCountersCountersValues int64

		if o.CountersCountersValues != nil {
			qrCountersCountersValues = *o.CountersCountersValues
		}
		qCountersCountersValues := swag.FormatInt64(qrCountersCountersValues)
		if qCountersCountersValues != "" {

			if err := r.SetQueryParam("counters.counters.values", qCountersCountersValues); err != nil {
				return err
			}
		}
	}

	if o.CountersLabels != nil {

		// query param counters.labels
		var qrCountersLabels string

		if o.CountersLabels != nil {
			qrCountersLabels = *o.CountersLabels
		}
		qCountersLabels := qrCountersLabels
		if qCountersLabels != "" {

			if err := r.SetQueryParam("counters.labels", qCountersLabels); err != nil {
				return err
			}
		}
	}

	if o.CountersName != nil {

		// query param counters.name
		var qrCountersName string

		if o.CountersName != nil {
			qrCountersName = *o.CountersName
		}
		qCountersName := qrCountersName
		if qCountersName != "" {

			if err := r.SetQueryParam("counters.name", qCountersName); err != nil {
				return err
			}
		}
	}

	if o.CountersValue != nil {

		// query param counters.value
		var qrCountersValue int64

		if o.CountersValue != nil {
			qrCountersValue = *o.CountersValue
		}
		qCountersValue := swag.FormatInt64(qrCountersValue)
		if qCountersValue != "" {

			if err := r.SetQueryParam("counters.value", qCountersValue); err != nil {
				return err
			}
		}
	}

	if o.CountersValues != nil {

		// query param counters.values
		var qrCountersValues int64

		if o.CountersValues != nil {
			qrCountersValues = *o.CountersValues
		}
		qCountersValues := swag.FormatInt64(qrCountersValues)
		if qCountersValues != "" {

			if err := r.SetQueryParam("counters.values", qCountersValues); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PropertiesName != nil {

		// query param properties.name
		var qrPropertiesName string

		if o.PropertiesName != nil {
			qrPropertiesName = *o.PropertiesName
		}
		qPropertiesName := qrPropertiesName
		if qPropertiesName != "" {

			if err := r.SetQueryParam("properties.name", qPropertiesName); err != nil {
				return err
			}
		}
	}

	if o.PropertiesValue != nil {

		// query param properties.value
		var qrPropertiesValue string

		if o.PropertiesValue != nil {
			qrPropertiesValue = *o.PropertiesValue
		}
		qPropertiesValue := qrPropertiesValue
		if qPropertiesValue != "" {

			if err := r.SetQueryParam("properties.value", qPropertiesValue); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCounterRowCollectionGet binds the parameter fields
func (o *CounterRowCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCounterRowCollectionGet binds the parameter order_by
func (o *CounterRowCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
