// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCounterTableCollectionGetParams creates a new CounterTableCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCounterTableCollectionGetParams() *CounterTableCollectionGetParams {
	return &CounterTableCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCounterTableCollectionGetParamsWithTimeout creates a new CounterTableCollectionGetParams object
// with the ability to set a timeout on a request.
func NewCounterTableCollectionGetParamsWithTimeout(timeout time.Duration) *CounterTableCollectionGetParams {
	return &CounterTableCollectionGetParams{
		timeout: timeout,
	}
}

// NewCounterTableCollectionGetParamsWithContext creates a new CounterTableCollectionGetParams object
// with the ability to set a context for a request.
func NewCounterTableCollectionGetParamsWithContext(ctx context.Context) *CounterTableCollectionGetParams {
	return &CounterTableCollectionGetParams{
		Context: ctx,
	}
}

// NewCounterTableCollectionGetParamsWithHTTPClient creates a new CounterTableCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCounterTableCollectionGetParamsWithHTTPClient(client *http.Client) *CounterTableCollectionGetParams {
	return &CounterTableCollectionGetParams{
		HTTPClient: client,
	}
}

/*
CounterTableCollectionGetParams contains all the parameters to send to the API endpoint

	for the counter table collection get operation.

	Typically these are written to a http.Request.
*/
type CounterTableCollectionGetParams struct {

	/* CounterSchemasDenominatorName.

	   Filter by counter_schemas.denominator.name
	*/
	CounterSchemasDenominatorName *string

	/* CounterSchemasDescription.

	   Filter by counter_schemas.description
	*/
	CounterSchemasDescription *string

	/* CounterSchemasName.

	   Filter by counter_schemas.name
	*/
	CounterSchemasName *string

	/* CounterSchemasType.

	   Filter by counter_schemas.type
	*/
	CounterSchemasType *string

	/* CounterSchemasUnit.

	   Filter by counter_schemas.unit
	*/
	CounterSchemasUnit *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the counter table collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CounterTableCollectionGetParams) WithDefaults() *CounterTableCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the counter table collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CounterTableCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := CounterTableCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithTimeout(timeout time.Duration) *CounterTableCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithContext(ctx context.Context) *CounterTableCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithHTTPClient(client *http.Client) *CounterTableCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCounterSchemasDenominatorName adds the counterSchemasDenominatorName to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithCounterSchemasDenominatorName(counterSchemasDenominatorName *string) *CounterTableCollectionGetParams {
	o.SetCounterSchemasDenominatorName(counterSchemasDenominatorName)
	return o
}

// SetCounterSchemasDenominatorName adds the counterSchemasDenominatorName to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetCounterSchemasDenominatorName(counterSchemasDenominatorName *string) {
	o.CounterSchemasDenominatorName = counterSchemasDenominatorName
}

// WithCounterSchemasDescription adds the counterSchemasDescription to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithCounterSchemasDescription(counterSchemasDescription *string) *CounterTableCollectionGetParams {
	o.SetCounterSchemasDescription(counterSchemasDescription)
	return o
}

// SetCounterSchemasDescription adds the counterSchemasDescription to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetCounterSchemasDescription(counterSchemasDescription *string) {
	o.CounterSchemasDescription = counterSchemasDescription
}

// WithCounterSchemasName adds the counterSchemasName to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithCounterSchemasName(counterSchemasName *string) *CounterTableCollectionGetParams {
	o.SetCounterSchemasName(counterSchemasName)
	return o
}

// SetCounterSchemasName adds the counterSchemasName to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetCounterSchemasName(counterSchemasName *string) {
	o.CounterSchemasName = counterSchemasName
}

// WithCounterSchemasType adds the counterSchemasType to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithCounterSchemasType(counterSchemasType *string) *CounterTableCollectionGetParams {
	o.SetCounterSchemasType(counterSchemasType)
	return o
}

// SetCounterSchemasType adds the counterSchemasType to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetCounterSchemasType(counterSchemasType *string) {
	o.CounterSchemasType = counterSchemasType
}

// WithCounterSchemasUnit adds the counterSchemasUnit to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithCounterSchemasUnit(counterSchemasUnit *string) *CounterTableCollectionGetParams {
	o.SetCounterSchemasUnit(counterSchemasUnit)
	return o
}

// SetCounterSchemasUnit adds the counterSchemasUnit to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetCounterSchemasUnit(counterSchemasUnit *string) {
	o.CounterSchemasUnit = counterSchemasUnit
}

// WithDescription adds the description to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithDescription(description *string) *CounterTableCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithFields adds the fields to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithFields(fields []string) *CounterTableCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithMaxRecords(maxRecords *int64) *CounterTableCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithName(name *string) *CounterTableCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithOrderBy(orderBy []string) *CounterTableCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithReturnRecords(returnRecords *bool) *CounterTableCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the counter table collection get params
func (o *CounterTableCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *CounterTableCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the counter table collection get params
func (o *CounterTableCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *CounterTableCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CounterSchemasDenominatorName != nil {

		// query param counter_schemas.denominator.name
		var qrCounterSchemasDenominatorName string

		if o.CounterSchemasDenominatorName != nil {
			qrCounterSchemasDenominatorName = *o.CounterSchemasDenominatorName
		}
		qCounterSchemasDenominatorName := qrCounterSchemasDenominatorName
		if qCounterSchemasDenominatorName != "" {

			if err := r.SetQueryParam("counter_schemas.denominator.name", qCounterSchemasDenominatorName); err != nil {
				return err
			}
		}
	}

	if o.CounterSchemasDescription != nil {

		// query param counter_schemas.description
		var qrCounterSchemasDescription string

		if o.CounterSchemasDescription != nil {
			qrCounterSchemasDescription = *o.CounterSchemasDescription
		}
		qCounterSchemasDescription := qrCounterSchemasDescription
		if qCounterSchemasDescription != "" {

			if err := r.SetQueryParam("counter_schemas.description", qCounterSchemasDescription); err != nil {
				return err
			}
		}
	}

	if o.CounterSchemasName != nil {

		// query param counter_schemas.name
		var qrCounterSchemasName string

		if o.CounterSchemasName != nil {
			qrCounterSchemasName = *o.CounterSchemasName
		}
		qCounterSchemasName := qrCounterSchemasName
		if qCounterSchemasName != "" {

			if err := r.SetQueryParam("counter_schemas.name", qCounterSchemasName); err != nil {
				return err
			}
		}
	}

	if o.CounterSchemasType != nil {

		// query param counter_schemas.type
		var qrCounterSchemasType string

		if o.CounterSchemasType != nil {
			qrCounterSchemasType = *o.CounterSchemasType
		}
		qCounterSchemasType := qrCounterSchemasType
		if qCounterSchemasType != "" {

			if err := r.SetQueryParam("counter_schemas.type", qCounterSchemasType); err != nil {
				return err
			}
		}
	}

	if o.CounterSchemasUnit != nil {

		// query param counter_schemas.unit
		var qrCounterSchemasUnit string

		if o.CounterSchemasUnit != nil {
			qrCounterSchemasUnit = *o.CounterSchemasUnit
		}
		qCounterSchemasUnit := qrCounterSchemasUnit
		if qCounterSchemasUnit != "" {

			if err := r.SetQueryParam("counter_schemas.unit", qCounterSchemasUnit); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCounterTableCollectionGet binds the parameter fields
func (o *CounterTableCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamCounterTableCollectionGet binds the parameter order_by
func (o *CounterTableCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
