// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CounterTableGetReader is a Reader for the CounterTableGet structure.
type CounterTableGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CounterTableGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCounterTableGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCounterTableGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCounterTableGetOK creates a CounterTableGetOK with default headers values
func NewCounterTableGetOK() *CounterTableGetOK {
	return &CounterTableGetOK{}
}

/*
CounterTableGetOK describes a response with status code 200, with default header values.

OK
*/
type CounterTableGetOK struct {
	Payload *models.CounterTable
}

// IsSuccess returns true when this counter table get o k response has a 2xx status code
func (o *CounterTableGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this counter table get o k response has a 3xx status code
func (o *CounterTableGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this counter table get o k response has a 4xx status code
func (o *CounterTableGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this counter table get o k response has a 5xx status code
func (o *CounterTableGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this counter table get o k response a status code equal to that given
func (o *CounterTableGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the counter table get o k response
func (o *CounterTableGetOK) Code() int {
	return 200
}

func (o *CounterTableGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/counter/tables/{name}][%d] counterTableGetOK %s", 200, payload)
}

func (o *CounterTableGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/counter/tables/{name}][%d] counterTableGetOK %s", 200, payload)
}

func (o *CounterTableGetOK) GetPayload() *models.CounterTable {
	return o.Payload
}

func (o *CounterTableGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CounterTable)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCounterTableGetDefault creates a CounterTableGetDefault with default headers values
func NewCounterTableGetDefault(code int) *CounterTableGetDefault {
	return &CounterTableGetDefault{
		_statusCode: code,
	}
}

/*
	CounterTableGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585320 | Table requested is not found |
| 8585368 | The system has not completed it's initialization |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CounterTableGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this counter table get default response has a 2xx status code
func (o *CounterTableGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this counter table get default response has a 3xx status code
func (o *CounterTableGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this counter table get default response has a 4xx status code
func (o *CounterTableGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this counter table get default response has a 5xx status code
func (o *CounterTableGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this counter table get default response a status code equal to that given
func (o *CounterTableGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the counter table get default response
func (o *CounterTableGetDefault) Code() int {
	return o._statusCode
}

func (o *CounterTableGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/counter/tables/{name}][%d] counter_table_get default %s", o._statusCode, payload)
}

func (o *CounterTableGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/counter/tables/{name}][%d] counter_table_get default %s", o._statusCode, payload)
}

func (o *CounterTableGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CounterTableGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
