// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFirmwareHistoryCollectionGetParams creates a new FirmwareHistoryCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFirmwareHistoryCollectionGetParams() *FirmwareHistoryCollectionGetParams {
	return &FirmwareHistoryCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFirmwareHistoryCollectionGetParamsWithTimeout creates a new FirmwareHistoryCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFirmwareHistoryCollectionGetParamsWithTimeout(timeout time.Duration) *FirmwareHistoryCollectionGetParams {
	return &FirmwareHistoryCollectionGetParams{
		timeout: timeout,
	}
}

// NewFirmwareHistoryCollectionGetParamsWithContext creates a new FirmwareHistoryCollectionGetParams object
// with the ability to set a context for a request.
func NewFirmwareHistoryCollectionGetParamsWithContext(ctx context.Context) *FirmwareHistoryCollectionGetParams {
	return &FirmwareHistoryCollectionGetParams{
		Context: ctx,
	}
}

// NewFirmwareHistoryCollectionGetParamsWithHTTPClient creates a new FirmwareHistoryCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFirmwareHistoryCollectionGetParamsWithHTTPClient(client *http.Client) *FirmwareHistoryCollectionGetParams {
	return &FirmwareHistoryCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FirmwareHistoryCollectionGetParams contains all the parameters to send to the API endpoint

	for the firmware history collection get operation.

	Typically these are written to a http.Request.
*/
type FirmwareHistoryCollectionGetParams struct {

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FwFileName.

	   Filter by fw_file_name
	*/
	FwFileName *string

	/* FwUpdateState.

	   Filter by fw_update_state
	*/
	FwUpdateState *string

	/* JobUUID.

	   Filter by job.uuid
	*/
	JobUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	/* UpdateStatusWorkerErrorCode.

	   Filter by update_status.worker.error.code
	*/
	UpdateStatusWorkerErrorCode *int64

	/* UpdateStatusWorkerErrorMessage.

	   Filter by update_status.worker.error.message
	*/
	UpdateStatusWorkerErrorMessage *string

	/* UpdateStatusWorkerNodeName.

	   Filter by update_status.worker.node.name
	*/
	UpdateStatusWorkerNodeName *string

	/* UpdateStatusWorkerNodeUUID.

	   Filter by update_status.worker.node.uuid
	*/
	UpdateStatusWorkerNodeUUID *string

	/* UpdateStatusWorkerState.

	   Filter by update_status.worker.state
	*/
	UpdateStatusWorkerState *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the firmware history collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FirmwareHistoryCollectionGetParams) WithDefaults() *FirmwareHistoryCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the firmware history collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FirmwareHistoryCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FirmwareHistoryCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithTimeout(timeout time.Duration) *FirmwareHistoryCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithContext(ctx context.Context) *FirmwareHistoryCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithHTTPClient(client *http.Client) *FirmwareHistoryCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEndTime adds the endTime to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithEndTime(endTime *string) *FirmwareHistoryCollectionGetParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithFields adds the fields to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithFields(fields []string) *FirmwareHistoryCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFwFileName adds the fwFileName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithFwFileName(fwFileName *string) *FirmwareHistoryCollectionGetParams {
	o.SetFwFileName(fwFileName)
	return o
}

// SetFwFileName adds the fwFileName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetFwFileName(fwFileName *string) {
	o.FwFileName = fwFileName
}

// WithFwUpdateState adds the fwUpdateState to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithFwUpdateState(fwUpdateState *string) *FirmwareHistoryCollectionGetParams {
	o.SetFwUpdateState(fwUpdateState)
	return o
}

// SetFwUpdateState adds the fwUpdateState to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetFwUpdateState(fwUpdateState *string) {
	o.FwUpdateState = fwUpdateState
}

// WithJobUUID adds the jobUUID to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithJobUUID(jobUUID *string) *FirmwareHistoryCollectionGetParams {
	o.SetJobUUID(jobUUID)
	return o
}

// SetJobUUID adds the jobUuid to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetJobUUID(jobUUID *string) {
	o.JobUUID = jobUUID
}

// WithMaxRecords adds the maxRecords to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithMaxRecords(maxRecords *int64) *FirmwareHistoryCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithNodeName(nodeName *string) *FirmwareHistoryCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithNodeUUID(nodeUUID *string) *FirmwareHistoryCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithOrderBy(orderBy []string) *FirmwareHistoryCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithReturnRecords(returnRecords *bool) *FirmwareHistoryCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FirmwareHistoryCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStartTime adds the startTime to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithStartTime(startTime *string) *FirmwareHistoryCollectionGetParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WithUpdateStatusWorkerErrorCode adds the updateStatusWorkerErrorCode to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithUpdateStatusWorkerErrorCode(updateStatusWorkerErrorCode *int64) *FirmwareHistoryCollectionGetParams {
	o.SetUpdateStatusWorkerErrorCode(updateStatusWorkerErrorCode)
	return o
}

// SetUpdateStatusWorkerErrorCode adds the updateStatusWorkerErrorCode to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetUpdateStatusWorkerErrorCode(updateStatusWorkerErrorCode *int64) {
	o.UpdateStatusWorkerErrorCode = updateStatusWorkerErrorCode
}

// WithUpdateStatusWorkerErrorMessage adds the updateStatusWorkerErrorMessage to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithUpdateStatusWorkerErrorMessage(updateStatusWorkerErrorMessage *string) *FirmwareHistoryCollectionGetParams {
	o.SetUpdateStatusWorkerErrorMessage(updateStatusWorkerErrorMessage)
	return o
}

// SetUpdateStatusWorkerErrorMessage adds the updateStatusWorkerErrorMessage to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetUpdateStatusWorkerErrorMessage(updateStatusWorkerErrorMessage *string) {
	o.UpdateStatusWorkerErrorMessage = updateStatusWorkerErrorMessage
}

// WithUpdateStatusWorkerNodeName adds the updateStatusWorkerNodeName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithUpdateStatusWorkerNodeName(updateStatusWorkerNodeName *string) *FirmwareHistoryCollectionGetParams {
	o.SetUpdateStatusWorkerNodeName(updateStatusWorkerNodeName)
	return o
}

// SetUpdateStatusWorkerNodeName adds the updateStatusWorkerNodeName to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetUpdateStatusWorkerNodeName(updateStatusWorkerNodeName *string) {
	o.UpdateStatusWorkerNodeName = updateStatusWorkerNodeName
}

// WithUpdateStatusWorkerNodeUUID adds the updateStatusWorkerNodeUUID to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithUpdateStatusWorkerNodeUUID(updateStatusWorkerNodeUUID *string) *FirmwareHistoryCollectionGetParams {
	o.SetUpdateStatusWorkerNodeUUID(updateStatusWorkerNodeUUID)
	return o
}

// SetUpdateStatusWorkerNodeUUID adds the updateStatusWorkerNodeUuid to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetUpdateStatusWorkerNodeUUID(updateStatusWorkerNodeUUID *string) {
	o.UpdateStatusWorkerNodeUUID = updateStatusWorkerNodeUUID
}

// WithUpdateStatusWorkerState adds the updateStatusWorkerState to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) WithUpdateStatusWorkerState(updateStatusWorkerState *string) *FirmwareHistoryCollectionGetParams {
	o.SetUpdateStatusWorkerState(updateStatusWorkerState)
	return o
}

// SetUpdateStatusWorkerState adds the updateStatusWorkerState to the firmware history collection get params
func (o *FirmwareHistoryCollectionGetParams) SetUpdateStatusWorkerState(updateStatusWorkerState *string) {
	o.UpdateStatusWorkerState = updateStatusWorkerState
}

// WriteToRequest writes these params to a swagger request
func (o *FirmwareHistoryCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FwFileName != nil {

		// query param fw_file_name
		var qrFwFileName string

		if o.FwFileName != nil {
			qrFwFileName = *o.FwFileName
		}
		qFwFileName := qrFwFileName
		if qFwFileName != "" {

			if err := r.SetQueryParam("fw_file_name", qFwFileName); err != nil {
				return err
			}
		}
	}

	if o.FwUpdateState != nil {

		// query param fw_update_state
		var qrFwUpdateState string

		if o.FwUpdateState != nil {
			qrFwUpdateState = *o.FwUpdateState
		}
		qFwUpdateState := qrFwUpdateState
		if qFwUpdateState != "" {

			if err := r.SetQueryParam("fw_update_state", qFwUpdateState); err != nil {
				return err
			}
		}
	}

	if o.JobUUID != nil {

		// query param job.uuid
		var qrJobUUID string

		if o.JobUUID != nil {
			qrJobUUID = *o.JobUUID
		}
		qJobUUID := qrJobUUID
		if qJobUUID != "" {

			if err := r.SetQueryParam("job.uuid", qJobUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if o.UpdateStatusWorkerErrorCode != nil {

		// query param update_status.worker.error.code
		var qrUpdateStatusWorkerErrorCode int64

		if o.UpdateStatusWorkerErrorCode != nil {
			qrUpdateStatusWorkerErrorCode = *o.UpdateStatusWorkerErrorCode
		}
		qUpdateStatusWorkerErrorCode := swag.FormatInt64(qrUpdateStatusWorkerErrorCode)
		if qUpdateStatusWorkerErrorCode != "" {

			if err := r.SetQueryParam("update_status.worker.error.code", qUpdateStatusWorkerErrorCode); err != nil {
				return err
			}
		}
	}

	if o.UpdateStatusWorkerErrorMessage != nil {

		// query param update_status.worker.error.message
		var qrUpdateStatusWorkerErrorMessage string

		if o.UpdateStatusWorkerErrorMessage != nil {
			qrUpdateStatusWorkerErrorMessage = *o.UpdateStatusWorkerErrorMessage
		}
		qUpdateStatusWorkerErrorMessage := qrUpdateStatusWorkerErrorMessage
		if qUpdateStatusWorkerErrorMessage != "" {

			if err := r.SetQueryParam("update_status.worker.error.message", qUpdateStatusWorkerErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.UpdateStatusWorkerNodeName != nil {

		// query param update_status.worker.node.name
		var qrUpdateStatusWorkerNodeName string

		if o.UpdateStatusWorkerNodeName != nil {
			qrUpdateStatusWorkerNodeName = *o.UpdateStatusWorkerNodeName
		}
		qUpdateStatusWorkerNodeName := qrUpdateStatusWorkerNodeName
		if qUpdateStatusWorkerNodeName != "" {

			if err := r.SetQueryParam("update_status.worker.node.name", qUpdateStatusWorkerNodeName); err != nil {
				return err
			}
		}
	}

	if o.UpdateStatusWorkerNodeUUID != nil {

		// query param update_status.worker.node.uuid
		var qrUpdateStatusWorkerNodeUUID string

		if o.UpdateStatusWorkerNodeUUID != nil {
			qrUpdateStatusWorkerNodeUUID = *o.UpdateStatusWorkerNodeUUID
		}
		qUpdateStatusWorkerNodeUUID := qrUpdateStatusWorkerNodeUUID
		if qUpdateStatusWorkerNodeUUID != "" {

			if err := r.SetQueryParam("update_status.worker.node.uuid", qUpdateStatusWorkerNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.UpdateStatusWorkerState != nil {

		// query param update_status.worker.state
		var qrUpdateStatusWorkerState string

		if o.UpdateStatusWorkerState != nil {
			qrUpdateStatusWorkerState = *o.UpdateStatusWorkerState
		}
		qUpdateStatusWorkerState := qrUpdateStatusWorkerState
		if qUpdateStatusWorkerState != "" {

			if err := r.SetQueryParam("update_status.worker.state", qUpdateStatusWorkerState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFirmwareHistoryCollectionGet binds the parameter fields
func (o *FirmwareHistoryCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFirmwareHistoryCollectionGet binds the parameter order_by
func (o *FirmwareHistoryCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
