// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FirmwareHistoryCollectionGetReader is a Reader for the FirmwareHistoryCollectionGet structure.
type FirmwareHistoryCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FirmwareHistoryCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFirmwareHistoryCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFirmwareHistoryCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFirmwareHistoryCollectionGetOK creates a FirmwareHistoryCollectionGetOK with default headers values
func NewFirmwareHistoryCollectionGetOK() *FirmwareHistoryCollectionGetOK {
	return &FirmwareHistoryCollectionGetOK{}
}

/*
FirmwareHistoryCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type FirmwareHistoryCollectionGetOK struct {
	Payload *models.FirmwareHistoryResponse
}

// IsSuccess returns true when this firmware history collection get o k response has a 2xx status code
func (o *FirmwareHistoryCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this firmware history collection get o k response has a 3xx status code
func (o *FirmwareHistoryCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this firmware history collection get o k response has a 4xx status code
func (o *FirmwareHistoryCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this firmware history collection get o k response has a 5xx status code
func (o *FirmwareHistoryCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this firmware history collection get o k response a status code equal to that given
func (o *FirmwareHistoryCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the firmware history collection get o k response
func (o *FirmwareHistoryCollectionGetOK) Code() int {
	return 200
}

func (o *FirmwareHistoryCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/firmware/history][%d] firmwareHistoryCollectionGetOK %s", 200, payload)
}

func (o *FirmwareHistoryCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/firmware/history][%d] firmwareHistoryCollectionGetOK %s", 200, payload)
}

func (o *FirmwareHistoryCollectionGetOK) GetPayload() *models.FirmwareHistoryResponse {
	return o.Payload
}

func (o *FirmwareHistoryCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FirmwareHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFirmwareHistoryCollectionGetDefault creates a FirmwareHistoryCollectionGetDefault with default headers values
func NewFirmwareHistoryCollectionGetDefault(code int) *FirmwareHistoryCollectionGetDefault {
	return &FirmwareHistoryCollectionGetDefault{
		_statusCode: code,
	}
}

/*
FirmwareHistoryCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type FirmwareHistoryCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this firmware history collection get default response has a 2xx status code
func (o *FirmwareHistoryCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this firmware history collection get default response has a 3xx status code
func (o *FirmwareHistoryCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this firmware history collection get default response has a 4xx status code
func (o *FirmwareHistoryCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this firmware history collection get default response has a 5xx status code
func (o *FirmwareHistoryCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this firmware history collection get default response a status code equal to that given
func (o *FirmwareHistoryCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the firmware history collection get default response
func (o *FirmwareHistoryCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *FirmwareHistoryCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/firmware/history][%d] firmware_history_collection_get default %s", o._statusCode, payload)
}

func (o *FirmwareHistoryCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/firmware/history][%d] firmware_history_collection_get default %s", o._statusCode, payload)
}

func (o *FirmwareHistoryCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FirmwareHistoryCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
