// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewJobModifyCollectionParams creates a new JobModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewJobModifyCollectionParams() *JobModifyCollectionParams {
	return &JobModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewJobModifyCollectionParamsWithTimeout creates a new JobModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewJobModifyCollectionParamsWithTimeout(timeout time.Duration) *JobModifyCollectionParams {
	return &JobModifyCollectionParams{
		timeout: timeout,
	}
}

// NewJobModifyCollectionParamsWithContext creates a new JobModifyCollectionParams object
// with the ability to set a context for a request.
func NewJobModifyCollectionParamsWithContext(ctx context.Context) *JobModifyCollectionParams {
	return &JobModifyCollectionParams{
		Context: ctx,
	}
}

// NewJobModifyCollectionParamsWithHTTPClient creates a new JobModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewJobModifyCollectionParamsWithHTTPClient(client *http.Client) *JobModifyCollectionParams {
	return &JobModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
JobModifyCollectionParams contains all the parameters to send to the API endpoint

	for the job modify collection operation.

	Typically these are written to a http.Request.
*/
type JobModifyCollectionParams struct {

	/* Action.

	   Requests a job to pause, resume, or cancel. Note that not all jobs support these actions. A job can only be resumed if it is in a paused state. After you successfully request a job to be cancelled, the job state changes to either success or failure.

	*/
	Action *string

	/* Code.

	   Filter by code
	*/
	Code *int64

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* ErrorArgumentsCode.

	   Filter by error.arguments.code
	*/
	ErrorArgumentsCode *string

	/* ErrorArgumentsMessage.

	   Filter by error.arguments.message
	*/
	ErrorArgumentsMessage *string

	/* ErrorCode.

	   Filter by error.code
	*/
	ErrorCode *string

	/* ErrorMessage.

	   Filter by error.message
	*/
	ErrorMessage *string

	/* Info.

	   Info specification
	*/
	Info JobModifyCollectionBody

	/* Message.

	   Filter by message
	*/
	Message *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the job modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *JobModifyCollectionParams) WithDefaults() *JobModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the job modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *JobModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := JobModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the job modify collection params
func (o *JobModifyCollectionParams) WithTimeout(timeout time.Duration) *JobModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the job modify collection params
func (o *JobModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the job modify collection params
func (o *JobModifyCollectionParams) WithContext(ctx context.Context) *JobModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the job modify collection params
func (o *JobModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the job modify collection params
func (o *JobModifyCollectionParams) WithHTTPClient(client *http.Client) *JobModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the job modify collection params
func (o *JobModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the job modify collection params
func (o *JobModifyCollectionParams) WithAction(action *string) *JobModifyCollectionParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the job modify collection params
func (o *JobModifyCollectionParams) SetAction(action *string) {
	o.Action = action
}

// WithCode adds the code to the job modify collection params
func (o *JobModifyCollectionParams) WithCode(code *int64) *JobModifyCollectionParams {
	o.SetCode(code)
	return o
}

// SetCode adds the code to the job modify collection params
func (o *JobModifyCollectionParams) SetCode(code *int64) {
	o.Code = code
}

// WithContinueOnFailure adds the continueOnFailure to the job modify collection params
func (o *JobModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *JobModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the job modify collection params
func (o *JobModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDescription adds the description to the job modify collection params
func (o *JobModifyCollectionParams) WithDescription(description *string) *JobModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the job modify collection params
func (o *JobModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEndTime adds the endTime to the job modify collection params
func (o *JobModifyCollectionParams) WithEndTime(endTime *string) *JobModifyCollectionParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the job modify collection params
func (o *JobModifyCollectionParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithErrorArgumentsCode adds the errorArgumentsCode to the job modify collection params
func (o *JobModifyCollectionParams) WithErrorArgumentsCode(errorArgumentsCode *string) *JobModifyCollectionParams {
	o.SetErrorArgumentsCode(errorArgumentsCode)
	return o
}

// SetErrorArgumentsCode adds the errorArgumentsCode to the job modify collection params
func (o *JobModifyCollectionParams) SetErrorArgumentsCode(errorArgumentsCode *string) {
	o.ErrorArgumentsCode = errorArgumentsCode
}

// WithErrorArgumentsMessage adds the errorArgumentsMessage to the job modify collection params
func (o *JobModifyCollectionParams) WithErrorArgumentsMessage(errorArgumentsMessage *string) *JobModifyCollectionParams {
	o.SetErrorArgumentsMessage(errorArgumentsMessage)
	return o
}

// SetErrorArgumentsMessage adds the errorArgumentsMessage to the job modify collection params
func (o *JobModifyCollectionParams) SetErrorArgumentsMessage(errorArgumentsMessage *string) {
	o.ErrorArgumentsMessage = errorArgumentsMessage
}

// WithErrorCode adds the errorCode to the job modify collection params
func (o *JobModifyCollectionParams) WithErrorCode(errorCode *string) *JobModifyCollectionParams {
	o.SetErrorCode(errorCode)
	return o
}

// SetErrorCode adds the errorCode to the job modify collection params
func (o *JobModifyCollectionParams) SetErrorCode(errorCode *string) {
	o.ErrorCode = errorCode
}

// WithErrorMessage adds the errorMessage to the job modify collection params
func (o *JobModifyCollectionParams) WithErrorMessage(errorMessage *string) *JobModifyCollectionParams {
	o.SetErrorMessage(errorMessage)
	return o
}

// SetErrorMessage adds the errorMessage to the job modify collection params
func (o *JobModifyCollectionParams) SetErrorMessage(errorMessage *string) {
	o.ErrorMessage = errorMessage
}

// WithInfo adds the info to the job modify collection params
func (o *JobModifyCollectionParams) WithInfo(info JobModifyCollectionBody) *JobModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the job modify collection params
func (o *JobModifyCollectionParams) SetInfo(info JobModifyCollectionBody) {
	o.Info = info
}

// WithMessage adds the message to the job modify collection params
func (o *JobModifyCollectionParams) WithMessage(message *string) *JobModifyCollectionParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the job modify collection params
func (o *JobModifyCollectionParams) SetMessage(message *string) {
	o.Message = message
}

// WithNodeName adds the nodeName to the job modify collection params
func (o *JobModifyCollectionParams) WithNodeName(nodeName *string) *JobModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the job modify collection params
func (o *JobModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithReturnRecords adds the returnRecords to the job modify collection params
func (o *JobModifyCollectionParams) WithReturnRecords(returnRecords *bool) *JobModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the job modify collection params
func (o *JobModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the job modify collection params
func (o *JobModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *JobModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the job modify collection params
func (o *JobModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the job modify collection params
func (o *JobModifyCollectionParams) WithSerialRecords(serialRecords *bool) *JobModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the job modify collection params
func (o *JobModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStartTime adds the startTime to the job modify collection params
func (o *JobModifyCollectionParams) WithStartTime(startTime *string) *JobModifyCollectionParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the job modify collection params
func (o *JobModifyCollectionParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WithState adds the state to the job modify collection params
func (o *JobModifyCollectionParams) WithState(state *string) *JobModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the job modify collection params
func (o *JobModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithSvmName adds the svmName to the job modify collection params
func (o *JobModifyCollectionParams) WithSvmName(svmName *string) *JobModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the job modify collection params
func (o *JobModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the job modify collection params
func (o *JobModifyCollectionParams) WithSvmUUID(svmUUID *string) *JobModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the job modify collection params
func (o *JobModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the job modify collection params
func (o *JobModifyCollectionParams) WithUUID(uuid *string) *JobModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the job modify collection params
func (o *JobModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *JobModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.Code != nil {

		// query param code
		var qrCode int64

		if o.Code != nil {
			qrCode = *o.Code
		}
		qCode := swag.FormatInt64(qrCode)
		if qCode != "" {

			if err := r.SetQueryParam("code", qCode); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}

	if o.ErrorArgumentsCode != nil {

		// query param error.arguments.code
		var qrErrorArgumentsCode string

		if o.ErrorArgumentsCode != nil {
			qrErrorArgumentsCode = *o.ErrorArgumentsCode
		}
		qErrorArgumentsCode := qrErrorArgumentsCode
		if qErrorArgumentsCode != "" {

			if err := r.SetQueryParam("error.arguments.code", qErrorArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorArgumentsMessage != nil {

		// query param error.arguments.message
		var qrErrorArgumentsMessage string

		if o.ErrorArgumentsMessage != nil {
			qrErrorArgumentsMessage = *o.ErrorArgumentsMessage
		}
		qErrorArgumentsMessage := qrErrorArgumentsMessage
		if qErrorArgumentsMessage != "" {

			if err := r.SetQueryParam("error.arguments.message", qErrorArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorCode != nil {

		// query param error.code
		var qrErrorCode string

		if o.ErrorCode != nil {
			qrErrorCode = *o.ErrorCode
		}
		qErrorCode := qrErrorCode
		if qErrorCode != "" {

			if err := r.SetQueryParam("error.code", qErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorMessage != nil {

		// query param error.message
		var qrErrorMessage string

		if o.ErrorMessage != nil {
			qrErrorMessage = *o.ErrorMessage
		}
		qErrorMessage := qrErrorMessage
		if qErrorMessage != "" {

			if err := r.SetQueryParam("error.message", qErrorMessage); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
