// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// JobModifyCollectionReader is a Reader for the JobModifyCollection structure.
type JobModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *JobModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewJobModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewJobModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewJobModifyCollectionOK creates a JobModifyCollectionOK with default headers values
func NewJobModifyCollectionOK() *JobModifyCollectionOK {
	return &JobModifyCollectionOK{}
}

/*
JobModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type JobModifyCollectionOK struct {
}

// IsSuccess returns true when this job modify collection o k response has a 2xx status code
func (o *JobModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this job modify collection o k response has a 3xx status code
func (o *JobModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this job modify collection o k response has a 4xx status code
func (o *JobModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this job modify collection o k response has a 5xx status code
func (o *JobModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this job modify collection o k response a status code equal to that given
func (o *JobModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the job modify collection o k response
func (o *JobModifyCollectionOK) Code() int {
	return 200
}

func (o *JobModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /cluster/jobs][%d] jobModifyCollectionOK", 200)
}

func (o *JobModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /cluster/jobs][%d] jobModifyCollectionOK", 200)
}

func (o *JobModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewJobModifyCollectionDefault creates a JobModifyCollectionDefault with default headers values
func NewJobModifyCollectionDefault(code int) *JobModifyCollectionDefault {
	return &JobModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	JobModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description                                                  |
| ---------- | -----------                                                  |
|     458762 | Job is already in a terminal state.                          |
|     458773 | The Job Manager is not initialized.                          |
|     458771 | The specified job is running.                                |
|     458776 | The specified job is not currently running.                  |
|     458783 | This job does not support pause.                             |
|     458784 | This job does not support cancel.                            |
*/
type JobModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this job modify collection default response has a 2xx status code
func (o *JobModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this job modify collection default response has a 3xx status code
func (o *JobModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this job modify collection default response has a 4xx status code
func (o *JobModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this job modify collection default response has a 5xx status code
func (o *JobModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this job modify collection default response a status code equal to that given
func (o *JobModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the job modify collection default response
func (o *JobModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *JobModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/jobs][%d] job_modify_collection default %s", o._statusCode, payload)
}

func (o *JobModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/jobs][%d] job_modify_collection default %s", o._statusCode, payload)
}

func (o *JobModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *JobModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
JobModifyCollectionBody job modify collection body
swagger:model JobModifyCollectionBody
*/
type JobModifyCollectionBody struct {

	// links
	Links *models.JobInlineLinks `json:"_links,omitempty"`

	// If the state indicates "failure", this is the final error code.
	// Example: 0
	// Read Only: true
	Code *int64 `json:"code,omitempty"`

	// The description of the job to help identify it independent of the UUID.
	// Example: App Snapshot Job
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The time the job ended.
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// error
	Error *models.JobInlineError `json:"error,omitempty"`

	// job response inline records
	JobResponseInlineRecords []*models.Job `json:"records,omitempty"`

	// A message corresponding to the state of the job providing additional details about the current state.
	// Example: Complete: Successful
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// node
	Node *models.JobInlineNode `json:"node,omitempty"`

	// The time the job started.
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// The state of the job.
	// Read Only: true
	// Enum: ["queued","running","paused","success","failure"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *models.JobInlineSvm `json:"svm,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this job modify collection body
func (o *JobModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJobResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(o.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"end_time", "body", "date-time", o.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) validateJobResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.JobResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.JobResponseInlineRecords); i++ {
		if swag.IsZero(o.JobResponseInlineRecords[i]) { // not required
			continue
		}

		if o.JobResponseInlineRecords[i] != nil {
			if err := o.JobResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *JobModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var jobModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["queued","running","paused","success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		jobModifyCollectionBodyTypeStatePropEnum = append(jobModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// JobModifyCollectionBody
	// JobModifyCollectionBody
	// state
	// State
	// queued
	// END DEBUGGING
	// JobModifyCollectionBodyStateQueued captures enum value "queued"
	JobModifyCollectionBodyStateQueued string = "queued"

	// BEGIN DEBUGGING
	// JobModifyCollectionBody
	// JobModifyCollectionBody
	// state
	// State
	// running
	// END DEBUGGING
	// JobModifyCollectionBodyStateRunning captures enum value "running"
	JobModifyCollectionBodyStateRunning string = "running"

	// BEGIN DEBUGGING
	// JobModifyCollectionBody
	// JobModifyCollectionBody
	// state
	// State
	// paused
	// END DEBUGGING
	// JobModifyCollectionBodyStatePaused captures enum value "paused"
	JobModifyCollectionBodyStatePaused string = "paused"

	// BEGIN DEBUGGING
	// JobModifyCollectionBody
	// JobModifyCollectionBody
	// state
	// State
	// success
	// END DEBUGGING
	// JobModifyCollectionBodyStateSuccess captures enum value "success"
	JobModifyCollectionBodyStateSuccess string = "success"

	// BEGIN DEBUGGING
	// JobModifyCollectionBody
	// JobModifyCollectionBody
	// state
	// State
	// failure
	// END DEBUGGING
	// JobModifyCollectionBodyStateFailure captures enum value "failure"
	JobModifyCollectionBodyStateFailure string = "failure"
)

// prop value enum
func (o *JobModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, jobModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *JobModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this job modify collection body based on the context it is used
func (o *JobModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJobResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"end_time", "body", o.EndTime); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateJobResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.JobResponseInlineRecords); i++ {

		if o.JobResponseInlineRecords[i] != nil {
			if err := o.JobResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *JobModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *JobModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res JobModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
JobInlineLinks job inline links
swagger:model job_inline__links
*/
type JobInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this job inline links
func (o *JobInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this job inline links based on the context it is used
func (o *JobInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *JobInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobInlineLinks) UnmarshalBinary(b []byte) error {
	var res JobInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
JobInlineError The error that caused the job to fail. This property is only populated when the job fails and it matches the API response error structure used by all APIs. The message and code match the dedicated message and code properties once the job has failed.
swagger:model job_inline_error
*/
type JobInlineError struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this job inline error
func (o *JobInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineError) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this job inline error based on the context it is used
func (o *JobInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineError) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *JobInlineError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *JobInlineError) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *JobInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobInlineError) UnmarshalBinary(b []byte) error {
	var res JobInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
JobInlineNode The node where this job was run
swagger:model job_inline_node
*/
type JobInlineNode struct {

	// The name of the node
	Name *string `json:"name,omitempty"`
}

// Validate validates this job inline node
func (o *JobInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this job inline node based on the context it is used
func (o *JobInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *JobInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobInlineNode) UnmarshalBinary(b []byte) error {
	var res JobInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
JobInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model job_inline_svm
*/
type JobInlineSvm struct {

	// links
	Links *models.JobInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this job inline svm
func (o *JobInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this job inline svm based on the context it is used
func (o *JobInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *JobInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobInlineSvm) UnmarshalBinary(b []byte) error {
	var res JobInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
JobInlineSvmInlineLinks job inline svm inline links
swagger:model job_inline_svm_inline__links
*/
type JobInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this job inline svm inline links
func (o *JobInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this job inline svm inline links based on the context it is used
func (o *JobInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *JobInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *JobInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *JobInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res JobInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
