// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewJobModifyParams creates a new JobModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewJobModifyParams() *JobModifyParams {
	return &JobModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewJobModifyParamsWithTimeout creates a new JobModifyParams object
// with the ability to set a timeout on a request.
func NewJobModifyParamsWithTimeout(timeout time.Duration) *JobModifyParams {
	return &JobModifyParams{
		timeout: timeout,
	}
}

// NewJobModifyParamsWithContext creates a new JobModifyParams object
// with the ability to set a context for a request.
func NewJobModifyParamsWithContext(ctx context.Context) *JobModifyParams {
	return &JobModifyParams{
		Context: ctx,
	}
}

// NewJobModifyParamsWithHTTPClient creates a new JobModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewJobModifyParamsWithHTTPClient(client *http.Client) *JobModifyParams {
	return &JobModifyParams{
		HTTPClient: client,
	}
}

/*
JobModifyParams contains all the parameters to send to the API endpoint

	for the job modify operation.

	Typically these are written to a http.Request.
*/
type JobModifyParams struct {

	/* Action.

	   Requests a job to pause, resume, or cancel. Note that not all jobs support these actions. A job can only be resumed if it is in a paused state. After you successfully request a job to be cancelled, the job state changes to either success or failure.

	*/
	Action *string

	/* UUID.

	   Job UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the job modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *JobModifyParams) WithDefaults() *JobModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the job modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *JobModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the job modify params
func (o *JobModifyParams) WithTimeout(timeout time.Duration) *JobModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the job modify params
func (o *JobModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the job modify params
func (o *JobModifyParams) WithContext(ctx context.Context) *JobModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the job modify params
func (o *JobModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the job modify params
func (o *JobModifyParams) WithHTTPClient(client *http.Client) *JobModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the job modify params
func (o *JobModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the job modify params
func (o *JobModifyParams) WithAction(action *string) *JobModifyParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the job modify params
func (o *JobModifyParams) SetAction(action *string) {
	o.Action = action
}

// WithUUID adds the uuid to the job modify params
func (o *JobModifyParams) WithUUID(uuid string) *JobModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the job modify params
func (o *JobModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *JobModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
