// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// JobModifyReader is a Reader for the JobModify structure.
type JobModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *JobModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewJobModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewJobModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewJobModifyOK creates a JobModifyOK with default headers values
func NewJobModifyOK() *JobModifyOK {
	return &JobModifyOK{}
}

/*
JobModifyOK describes a response with status code 200, with default header values.

OK
*/
type JobModifyOK struct {
}

// IsSuccess returns true when this job modify o k response has a 2xx status code
func (o *JobModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this job modify o k response has a 3xx status code
func (o *JobModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this job modify o k response has a 4xx status code
func (o *JobModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this job modify o k response has a 5xx status code
func (o *JobModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this job modify o k response a status code equal to that given
func (o *JobModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the job modify o k response
func (o *JobModifyOK) Code() int {
	return 200
}

func (o *JobModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /cluster/jobs/{uuid}][%d] jobModifyOK", 200)
}

func (o *JobModifyOK) String() string {
	return fmt.Sprintf("[PATCH /cluster/jobs/{uuid}][%d] jobModifyOK", 200)
}

func (o *JobModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewJobModifyDefault creates a JobModifyDefault with default headers values
func NewJobModifyDefault(code int) *JobModifyDefault {
	return &JobModifyDefault{
		_statusCode: code,
	}
}

/*
	JobModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description                                                  |
| ---------- | -----------                                                  |
|     458762 | Job is already in a terminal state.                          |
|     458773 | The Job Manager is not initialized.                          |
|     458771 | The specified job is running.                                |
|     458776 | The specified job is not currently running.                  |
|     458783 | This job does not support pause.                             |
|     458784 | This job does not support cancel.                            |
*/
type JobModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this job modify default response has a 2xx status code
func (o *JobModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this job modify default response has a 3xx status code
func (o *JobModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this job modify default response has a 4xx status code
func (o *JobModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this job modify default response has a 5xx status code
func (o *JobModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this job modify default response a status code equal to that given
func (o *JobModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the job modify default response
func (o *JobModifyDefault) Code() int {
	return o._statusCode
}

func (o *JobModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/jobs/{uuid}][%d] job_modify default %s", o._statusCode, payload)
}

func (o *JobModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/jobs/{uuid}][%d] job_modify default %s", o._statusCode, payload)
}

func (o *JobModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *JobModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
