// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLicenseDeleteCollectionParams creates a new LicenseDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLicenseDeleteCollectionParams() *LicenseDeleteCollectionParams {
	return &LicenseDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLicenseDeleteCollectionParamsWithTimeout creates a new LicenseDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewLicenseDeleteCollectionParamsWithTimeout(timeout time.Duration) *LicenseDeleteCollectionParams {
	return &LicenseDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewLicenseDeleteCollectionParamsWithContext creates a new LicenseDeleteCollectionParams object
// with the ability to set a context for a request.
func NewLicenseDeleteCollectionParamsWithContext(ctx context.Context) *LicenseDeleteCollectionParams {
	return &LicenseDeleteCollectionParams{
		Context: ctx,
	}
}

// NewLicenseDeleteCollectionParamsWithHTTPClient creates a new LicenseDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewLicenseDeleteCollectionParamsWithHTTPClient(client *http.Client) *LicenseDeleteCollectionParams {
	return &LicenseDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
LicenseDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the license delete collection operation.

	Typically these are written to a http.Request.
*/
type LicenseDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EntitlementAction.

	   Filter by entitlement.action
	*/
	EntitlementAction *string

	/* EntitlementRisk.

	   Filter by entitlement.risk
	*/
	EntitlementRisk *string

	/* Info.

	   Info specification
	*/
	Info LicenseDeleteCollectionBody

	/* LicensesActive.

	   Filter by licenses.active
	*/
	LicensesActive *bool

	/* LicensesCapacityDisabledSize.

	   Filter by licenses.capacity.disabled_size
	*/
	LicensesCapacityDisabledSize *int64

	/* LicensesCapacityMaximumSize.

	   Filter by licenses.capacity.maximum_size
	*/
	LicensesCapacityMaximumSize *int64

	/* LicensesCapacityMeasurementUnit.

	   Filter by licenses.capacity.measurement_unit
	*/
	LicensesCapacityMeasurementUnit *string

	/* LicensesCapacityUsedSize.

	   Filter by licenses.capacity.used_size
	*/
	LicensesCapacityUsedSize *int64

	/* LicensesComplianceState.

	   Filter by licenses.compliance.state
	*/
	LicensesComplianceState *string

	/* LicensesEvaluation.

	   Filter by licenses.evaluation
	*/
	LicensesEvaluation *bool

	/* LicensesExpiryTime.

	   Filter by licenses.expiry_time
	*/
	LicensesExpiryTime *string

	/* LicensesHostID.

	   Filter by licenses.host_id
	*/
	LicensesHostID *string

	/* LicensesInstalledLicense.

	   Filter by licenses.installed_license
	*/
	LicensesInstalledLicense *string

	/* LicensesOwner.

	   Filter by licenses.owner
	*/
	LicensesOwner *string

	/* LicensesSerialNumber.

	   Filter by licenses.serial_number
	*/
	LicensesSerialNumber *string

	/* LicensesShutdownImminent.

	   Filter by licenses.shutdown_imminent
	*/
	LicensesShutdownImminent *bool

	/* LicensesStartTime.

	   Filter by licenses.start_time
	*/
	LicensesStartTime *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialNumber.

	   Serial number of the license to delete.
	*/
	SerialNumber string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* State.

	   Filter by state
	*/
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the license delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseDeleteCollectionParams) WithDefaults() *LicenseDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the license delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := LicenseDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithTimeout(timeout time.Duration) *LicenseDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithContext(ctx context.Context) *LicenseDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithHTTPClient(client *http.Client) *LicenseDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *LicenseDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDescription adds the description to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithDescription(description *string) *LicenseDeleteCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEntitlementAction adds the entitlementAction to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithEntitlementAction(entitlementAction *string) *LicenseDeleteCollectionParams {
	o.SetEntitlementAction(entitlementAction)
	return o
}

// SetEntitlementAction adds the entitlementAction to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetEntitlementAction(entitlementAction *string) {
	o.EntitlementAction = entitlementAction
}

// WithEntitlementRisk adds the entitlementRisk to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithEntitlementRisk(entitlementRisk *string) *LicenseDeleteCollectionParams {
	o.SetEntitlementRisk(entitlementRisk)
	return o
}

// SetEntitlementRisk adds the entitlementRisk to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetEntitlementRisk(entitlementRisk *string) {
	o.EntitlementRisk = entitlementRisk
}

// WithInfo adds the info to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithInfo(info LicenseDeleteCollectionBody) *LicenseDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetInfo(info LicenseDeleteCollectionBody) {
	o.Info = info
}

// WithLicensesActive adds the licensesActive to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesActive(licensesActive *bool) *LicenseDeleteCollectionParams {
	o.SetLicensesActive(licensesActive)
	return o
}

// SetLicensesActive adds the licensesActive to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesActive(licensesActive *bool) {
	o.LicensesActive = licensesActive
}

// WithLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) *LicenseDeleteCollectionParams {
	o.SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize)
	return o
}

// SetLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) {
	o.LicensesCapacityDisabledSize = licensesCapacityDisabledSize
}

// WithLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) *LicenseDeleteCollectionParams {
	o.SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize)
	return o
}

// SetLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) {
	o.LicensesCapacityMaximumSize = licensesCapacityMaximumSize
}

// WithLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) *LicenseDeleteCollectionParams {
	o.SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit)
	return o
}

// SetLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) {
	o.LicensesCapacityMeasurementUnit = licensesCapacityMeasurementUnit
}

// WithLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) *LicenseDeleteCollectionParams {
	o.SetLicensesCapacityUsedSize(licensesCapacityUsedSize)
	return o
}

// SetLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) {
	o.LicensesCapacityUsedSize = licensesCapacityUsedSize
}

// WithLicensesComplianceState adds the licensesComplianceState to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesComplianceState(licensesComplianceState *string) *LicenseDeleteCollectionParams {
	o.SetLicensesComplianceState(licensesComplianceState)
	return o
}

// SetLicensesComplianceState adds the licensesComplianceState to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesComplianceState(licensesComplianceState *string) {
	o.LicensesComplianceState = licensesComplianceState
}

// WithLicensesEvaluation adds the licensesEvaluation to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesEvaluation(licensesEvaluation *bool) *LicenseDeleteCollectionParams {
	o.SetLicensesEvaluation(licensesEvaluation)
	return o
}

// SetLicensesEvaluation adds the licensesEvaluation to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesEvaluation(licensesEvaluation *bool) {
	o.LicensesEvaluation = licensesEvaluation
}

// WithLicensesExpiryTime adds the licensesExpiryTime to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesExpiryTime(licensesExpiryTime *string) *LicenseDeleteCollectionParams {
	o.SetLicensesExpiryTime(licensesExpiryTime)
	return o
}

// SetLicensesExpiryTime adds the licensesExpiryTime to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesExpiryTime(licensesExpiryTime *string) {
	o.LicensesExpiryTime = licensesExpiryTime
}

// WithLicensesHostID adds the licensesHostID to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesHostID(licensesHostID *string) *LicenseDeleteCollectionParams {
	o.SetLicensesHostID(licensesHostID)
	return o
}

// SetLicensesHostID adds the licensesHostId to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesHostID(licensesHostID *string) {
	o.LicensesHostID = licensesHostID
}

// WithLicensesInstalledLicense adds the licensesInstalledLicense to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesInstalledLicense(licensesInstalledLicense *string) *LicenseDeleteCollectionParams {
	o.SetLicensesInstalledLicense(licensesInstalledLicense)
	return o
}

// SetLicensesInstalledLicense adds the licensesInstalledLicense to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesInstalledLicense(licensesInstalledLicense *string) {
	o.LicensesInstalledLicense = licensesInstalledLicense
}

// WithLicensesOwner adds the licensesOwner to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesOwner(licensesOwner *string) *LicenseDeleteCollectionParams {
	o.SetLicensesOwner(licensesOwner)
	return o
}

// SetLicensesOwner adds the licensesOwner to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesOwner(licensesOwner *string) {
	o.LicensesOwner = licensesOwner
}

// WithLicensesSerialNumber adds the licensesSerialNumber to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesSerialNumber(licensesSerialNumber *string) *LicenseDeleteCollectionParams {
	o.SetLicensesSerialNumber(licensesSerialNumber)
	return o
}

// SetLicensesSerialNumber adds the licensesSerialNumber to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesSerialNumber(licensesSerialNumber *string) {
	o.LicensesSerialNumber = licensesSerialNumber
}

// WithLicensesShutdownImminent adds the licensesShutdownImminent to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesShutdownImminent(licensesShutdownImminent *bool) *LicenseDeleteCollectionParams {
	o.SetLicensesShutdownImminent(licensesShutdownImminent)
	return o
}

// SetLicensesShutdownImminent adds the licensesShutdownImminent to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesShutdownImminent(licensesShutdownImminent *bool) {
	o.LicensesShutdownImminent = licensesShutdownImminent
}

// WithLicensesStartTime adds the licensesStartTime to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithLicensesStartTime(licensesStartTime *string) *LicenseDeleteCollectionParams {
	o.SetLicensesStartTime(licensesStartTime)
	return o
}

// SetLicensesStartTime adds the licensesStartTime to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetLicensesStartTime(licensesStartTime *string) {
	o.LicensesStartTime = licensesStartTime
}

// WithName adds the name to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithName(name *string) *LicenseDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *LicenseDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *LicenseDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithScope(scope *string) *LicenseDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialNumber adds the serialNumber to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithSerialNumber(serialNumber string) *LicenseDeleteCollectionParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetSerialNumber(serialNumber string) {
	o.SerialNumber = serialNumber
}

// WithSerialRecords adds the serialRecords to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *LicenseDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithState adds the state to the license delete collection params
func (o *LicenseDeleteCollectionParams) WithState(state *string) *LicenseDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the license delete collection params
func (o *LicenseDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *LicenseDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EntitlementAction != nil {

		// query param entitlement.action
		var qrEntitlementAction string

		if o.EntitlementAction != nil {
			qrEntitlementAction = *o.EntitlementAction
		}
		qEntitlementAction := qrEntitlementAction
		if qEntitlementAction != "" {

			if err := r.SetQueryParam("entitlement.action", qEntitlementAction); err != nil {
				return err
			}
		}
	}

	if o.EntitlementRisk != nil {

		// query param entitlement.risk
		var qrEntitlementRisk string

		if o.EntitlementRisk != nil {
			qrEntitlementRisk = *o.EntitlementRisk
		}
		qEntitlementRisk := qrEntitlementRisk
		if qEntitlementRisk != "" {

			if err := r.SetQueryParam("entitlement.risk", qEntitlementRisk); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LicensesActive != nil {

		// query param licenses.active
		var qrLicensesActive bool

		if o.LicensesActive != nil {
			qrLicensesActive = *o.LicensesActive
		}
		qLicensesActive := swag.FormatBool(qrLicensesActive)
		if qLicensesActive != "" {

			if err := r.SetQueryParam("licenses.active", qLicensesActive); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityDisabledSize != nil {

		// query param licenses.capacity.disabled_size
		var qrLicensesCapacityDisabledSize int64

		if o.LicensesCapacityDisabledSize != nil {
			qrLicensesCapacityDisabledSize = *o.LicensesCapacityDisabledSize
		}
		qLicensesCapacityDisabledSize := swag.FormatInt64(qrLicensesCapacityDisabledSize)
		if qLicensesCapacityDisabledSize != "" {

			if err := r.SetQueryParam("licenses.capacity.disabled_size", qLicensesCapacityDisabledSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMaximumSize != nil {

		// query param licenses.capacity.maximum_size
		var qrLicensesCapacityMaximumSize int64

		if o.LicensesCapacityMaximumSize != nil {
			qrLicensesCapacityMaximumSize = *o.LicensesCapacityMaximumSize
		}
		qLicensesCapacityMaximumSize := swag.FormatInt64(qrLicensesCapacityMaximumSize)
		if qLicensesCapacityMaximumSize != "" {

			if err := r.SetQueryParam("licenses.capacity.maximum_size", qLicensesCapacityMaximumSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMeasurementUnit != nil {

		// query param licenses.capacity.measurement_unit
		var qrLicensesCapacityMeasurementUnit string

		if o.LicensesCapacityMeasurementUnit != nil {
			qrLicensesCapacityMeasurementUnit = *o.LicensesCapacityMeasurementUnit
		}
		qLicensesCapacityMeasurementUnit := qrLicensesCapacityMeasurementUnit
		if qLicensesCapacityMeasurementUnit != "" {

			if err := r.SetQueryParam("licenses.capacity.measurement_unit", qLicensesCapacityMeasurementUnit); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityUsedSize != nil {

		// query param licenses.capacity.used_size
		var qrLicensesCapacityUsedSize int64

		if o.LicensesCapacityUsedSize != nil {
			qrLicensesCapacityUsedSize = *o.LicensesCapacityUsedSize
		}
		qLicensesCapacityUsedSize := swag.FormatInt64(qrLicensesCapacityUsedSize)
		if qLicensesCapacityUsedSize != "" {

			if err := r.SetQueryParam("licenses.capacity.used_size", qLicensesCapacityUsedSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesComplianceState != nil {

		// query param licenses.compliance.state
		var qrLicensesComplianceState string

		if o.LicensesComplianceState != nil {
			qrLicensesComplianceState = *o.LicensesComplianceState
		}
		qLicensesComplianceState := qrLicensesComplianceState
		if qLicensesComplianceState != "" {

			if err := r.SetQueryParam("licenses.compliance.state", qLicensesComplianceState); err != nil {
				return err
			}
		}
	}

	if o.LicensesEvaluation != nil {

		// query param licenses.evaluation
		var qrLicensesEvaluation bool

		if o.LicensesEvaluation != nil {
			qrLicensesEvaluation = *o.LicensesEvaluation
		}
		qLicensesEvaluation := swag.FormatBool(qrLicensesEvaluation)
		if qLicensesEvaluation != "" {

			if err := r.SetQueryParam("licenses.evaluation", qLicensesEvaluation); err != nil {
				return err
			}
		}
	}

	if o.LicensesExpiryTime != nil {

		// query param licenses.expiry_time
		var qrLicensesExpiryTime string

		if o.LicensesExpiryTime != nil {
			qrLicensesExpiryTime = *o.LicensesExpiryTime
		}
		qLicensesExpiryTime := qrLicensesExpiryTime
		if qLicensesExpiryTime != "" {

			if err := r.SetQueryParam("licenses.expiry_time", qLicensesExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.LicensesHostID != nil {

		// query param licenses.host_id
		var qrLicensesHostID string

		if o.LicensesHostID != nil {
			qrLicensesHostID = *o.LicensesHostID
		}
		qLicensesHostID := qrLicensesHostID
		if qLicensesHostID != "" {

			if err := r.SetQueryParam("licenses.host_id", qLicensesHostID); err != nil {
				return err
			}
		}
	}

	if o.LicensesInstalledLicense != nil {

		// query param licenses.installed_license
		var qrLicensesInstalledLicense string

		if o.LicensesInstalledLicense != nil {
			qrLicensesInstalledLicense = *o.LicensesInstalledLicense
		}
		qLicensesInstalledLicense := qrLicensesInstalledLicense
		if qLicensesInstalledLicense != "" {

			if err := r.SetQueryParam("licenses.installed_license", qLicensesInstalledLicense); err != nil {
				return err
			}
		}
	}

	if o.LicensesOwner != nil {

		// query param licenses.owner
		var qrLicensesOwner string

		if o.LicensesOwner != nil {
			qrLicensesOwner = *o.LicensesOwner
		}
		qLicensesOwner := qrLicensesOwner
		if qLicensesOwner != "" {

			if err := r.SetQueryParam("licenses.owner", qLicensesOwner); err != nil {
				return err
			}
		}
	}

	if o.LicensesSerialNumber != nil {

		// query param licenses.serial_number
		var qrLicensesSerialNumber string

		if o.LicensesSerialNumber != nil {
			qrLicensesSerialNumber = *o.LicensesSerialNumber
		}
		qLicensesSerialNumber := qrLicensesSerialNumber
		if qLicensesSerialNumber != "" {

			if err := r.SetQueryParam("licenses.serial_number", qLicensesSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.LicensesShutdownImminent != nil {

		// query param licenses.shutdown_imminent
		var qrLicensesShutdownImminent bool

		if o.LicensesShutdownImminent != nil {
			qrLicensesShutdownImminent = *o.LicensesShutdownImminent
		}
		qLicensesShutdownImminent := swag.FormatBool(qrLicensesShutdownImminent)
		if qLicensesShutdownImminent != "" {

			if err := r.SetQueryParam("licenses.shutdown_imminent", qLicensesShutdownImminent); err != nil {
				return err
			}
		}
	}

	if o.LicensesStartTime != nil {

		// query param licenses.start_time
		var qrLicensesStartTime string

		if o.LicensesStartTime != nil {
			qrLicensesStartTime = *o.LicensesStartTime
		}
		qLicensesStartTime := qrLicensesStartTime
		if qLicensesStartTime != "" {

			if err := r.SetQueryParam("licenses.start_time", qLicensesStartTime); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	// query param serial_number
	qrSerialNumber := o.SerialNumber
	qSerialNumber := qrSerialNumber
	if qSerialNumber != "" {

		if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
			return err
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
