// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LicenseDeleteCollectionReader is a Reader for the LicenseDeleteCollection structure.
type LicenseDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LicenseDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLicenseDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLicenseDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLicenseDeleteCollectionOK creates a LicenseDeleteCollectionOK with default headers values
func NewLicenseDeleteCollectionOK() *LicenseDeleteCollectionOK {
	return &LicenseDeleteCollectionOK{}
}

/*
LicenseDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LicenseDeleteCollectionOK struct {
}

// IsSuccess returns true when this license delete collection o k response has a 2xx status code
func (o *LicenseDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this license delete collection o k response has a 3xx status code
func (o *LicenseDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this license delete collection o k response has a 4xx status code
func (o *LicenseDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this license delete collection o k response has a 5xx status code
func (o *LicenseDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this license delete collection o k response a status code equal to that given
func (o *LicenseDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the license delete collection o k response
func (o *LicenseDeleteCollectionOK) Code() int {
	return 200
}

func (o *LicenseDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /cluster/licensing/licenses][%d] licenseDeleteCollectionOK", 200)
}

func (o *LicenseDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /cluster/licensing/licenses][%d] licenseDeleteCollectionOK", 200)
}

func (o *LicenseDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLicenseDeleteCollectionDefault creates a LicenseDeleteCollectionDefault with default headers values
func NewLicenseDeleteCollectionDefault(code int) *LicenseDeleteCollectionDefault {
	return &LicenseDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LicenseDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 525028 | Error during volume limit check, cannot remove license |
| 525029 | Current volume use will exceed limits if license is removed |
| 1115137 | Cluster license requires a base license to be installed |
| 1115144 | Cloud licenses cannot be deleted |
| 1115178 | A tier license that is still in use cannot be deleted |
| 1115213 | License is still in use and cannot be removed |
| 1115406 | Capacity pool licenses cannot be deleted |
| 1115564 | Package is part of a NLFv2 license and cannot be removed individually |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LicenseDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this license delete collection default response has a 2xx status code
func (o *LicenseDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this license delete collection default response has a 3xx status code
func (o *LicenseDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this license delete collection default response has a 4xx status code
func (o *LicenseDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this license delete collection default response has a 5xx status code
func (o *LicenseDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this license delete collection default response a status code equal to that given
func (o *LicenseDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the license delete collection default response
func (o *LicenseDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LicenseDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/licensing/licenses][%d] license_delete_collection default %s", o._statusCode, payload)
}

func (o *LicenseDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/licensing/licenses][%d] license_delete_collection default %s", o._statusCode, payload)
}

func (o *LicenseDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LicenseDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LicenseDeleteCollectionBody license delete collection body
swagger:model LicenseDeleteCollectionBody
*/
type LicenseDeleteCollectionBody struct {

	// license package response inline records
	LicensePackageResponseInlineRecords []*models.LicensePackageResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this license delete collection body
func (o *LicenseDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLicensePackageResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionBody) validateLicensePackageResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LicensePackageResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LicensePackageResponseInlineRecords); i++ {
		if swag.IsZero(o.LicensePackageResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LicensePackageResponseInlineRecords[i] != nil {
			if err := o.LicensePackageResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this license delete collection body based on the context it is used
func (o *LicenseDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLicensePackageResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionBody) contextValidateLicensePackageResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LicensePackageResponseInlineRecords); i++ {

		if o.LicensePackageResponseInlineRecords[i] != nil {
			if err := o.LicensePackageResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicenseDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicenseDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LicenseDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0 license delete collection params body records items0 licenses items0
swagger:model LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0
*/
type LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0 struct {

	// A flag indicating whether the license is currently being enforced.
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// capacity
	Capacity *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity `json:"capacity,omitempty"`

	// compliance
	Compliance *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance `json:"compliance,omitempty"`

	// A flag indicating whether the license is in evaluation mode.
	// Read Only: true
	Evaluation *bool `json:"evaluation,omitempty"`

	// Date and time when the license expires.
	// Example: 2019-03-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// A string that associates the license with a node or cluster.
	// Example: 456-44-1234
	// Read Only: true
	HostID *string `json:"host_id,omitempty"`

	// Name of license that enabled the feature.
	// Example: Core Bundle
	// Read Only: true
	InstalledLicense *string `json:"installed_license,omitempty"`

	// Cluster, node or license manager that owns the license.
	// Example: cluster1
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// Serial number of the license.
	// Example: 123456789
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// A flag indicating whether the Cloud ONTAP system is going to shutdown as the Cloud platform license has already expired.
	// Read Only: true
	ShutdownImminent *bool `json:"shutdown_imminent,omitempty"`

	// Date and time when the license starts.
	// Example: 2019-02-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this license delete collection params body records items0 licenses items0
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCompliance(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) validateCapacity(formats strfmt.Registry) error {
	if swag.IsZero(o.Capacity) { // not required
		return nil
	}

	if o.Capacity != nil {
		if err := o.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) validateCompliance(formats strfmt.Registry) error {
	if swag.IsZero(o.Compliance) { // not required
		return nil
	}

	if o.Compliance != nil {
		if err := o.Compliance.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license delete collection params body records items0 licenses items0 based on the context it is used
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCompliance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEvaluation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHostID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInstalledLicense(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShutdownImminent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "active", "body", o.Active); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if o.Capacity != nil {
		if err := o.Capacity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateCompliance(ctx context.Context, formats strfmt.Registry) error {

	if o.Compliance != nil {
		if err := o.Compliance.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateEvaluation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "evaluation", "body", o.Evaluation); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expiry_time", "body", o.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateHostID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_id", "body", o.HostID); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateInstalledLicense(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "installed_license", "body", o.InstalledLicense); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner", "body", o.Owner); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateShutdownImminent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "shutdown_imminent", "body", o.ShutdownImminent); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0) UnmarshalBinary(b []byte) error {
	var res LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity license delete collection params body records items0 licenses items0 capacity
swagger:model LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
*/
type LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity struct {

	// Capacity that is currently disabled due to license limits. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	DisabledSize *int64 `json:"disabled_size,omitempty"`

	// Licensed capacity size that can be used. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	MaximumSize *int64 `json:"maximum_size,omitempty"`

	// Unit of measure for capacity based licenses.
	// Read Only: true
	// Enum: ["bytes","gpu_count"]
	MeasurementUnit *string `json:"measurement_unit,omitempty"`

	// Specifies the total number of GPUs in the system when measurement_unit is GPUs, else specifies the bytes used.
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this license delete collection params body records items0 licenses items0 capacity
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMeasurementUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bytes","gpu_count"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum = append(licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
	// measurement_unit
	// MeasurementUnit
	// bytes
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityMeasurementUnitBytes captures enum value "bytes"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityMeasurementUnitBytes string = "bytes"

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
	// measurement_unit
	// MeasurementUnit
	// gpu_count
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityMeasurementUnitGpuCount captures enum value "gpu_count"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityMeasurementUnitGpuCount string = "gpu_count"
)

// prop value enum
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) validateMeasurementUnitEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) validateMeasurementUnit(formats strfmt.Registry) error {
	if swag.IsZero(o.MeasurementUnit) { // not required
		return nil
	}

	// value enum
	if err := o.validateMeasurementUnitEnum("capacity"+"."+"measurement_unit", "body", *o.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license delete collection params body records items0 licenses items0 capacity based on the context it is used
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDisabledSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaximumSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMeasurementUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) contextValidateDisabledSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"disabled_size", "body", o.DisabledSize); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) contextValidateMaximumSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"maximum_size", "body", o.MaximumSize); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) contextValidateMeasurementUnit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"measurement_unit", "body", o.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"used_size", "body", o.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity) UnmarshalBinary(b []byte) error {
	var res LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Capacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance license delete collection params body records items0 licenses items0 compliance
swagger:model LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
*/
type LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance struct {

	// Compliance state of the license.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license delete collection params body records items0 licenses items0 compliance
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceTypeStatePropEnum = append(licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateCompliant captures enum value "compliant"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateNoncompliant captures enum value "noncompliant"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateUnlicensed captures enum value "unlicensed"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateUnknown captures enum value "unknown"
	LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceStateUnknown string = "unknown"
)

// prop value enum
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0ComplianceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("compliance"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license delete collection params body records items0 licenses items0 compliance based on the context it is used
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compliance"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance) UnmarshalBinary(b []byte) error {
	var res LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0Compliance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicensePackageResponseInlineRecordsInlineArrayItem license package response inline records inline array item
swagger:model license_package_response_inline_records_inline_array_item
*/
type LicensePackageResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// License description
	// Example: NFS License
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// entitlement
	Entitlement *models.LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement `json:"entitlement,omitempty"`

	// keys
	Keys []*string `json:"keys"`

	// Installed licenses of the package.
	// Read Only: true
	Licenses []*LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0 `json:"licenses"`

	// Name of the license.
	// Example: NFS
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Scope of the license.
	// Read Only: true
	// Enum: ["not_available","site","cluster","node"]
	Scope *string `json:"scope,omitempty"`

	// Summary state of package based on all installed licenses.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license package response inline records inline array item
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEntitlement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLicenses(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateEntitlement(formats strfmt.Registry) error {
	if swag.IsZero(o.Entitlement) { // not required
		return nil
	}

	if o.Entitlement != nil {
		if err := o.Entitlement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateLicenses(formats strfmt.Registry) error {
	if swag.IsZero(o.Licenses) { // not required
		return nil
	}

	for i := 0; i < len(o.Licenses); i++ {
		if swag.IsZero(o.Licenses[i]) { // not required
			continue
		}

		if o.Licenses[i] != nil {
			if err := o.Licenses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_available","site","cluster","node"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// not_available
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeNotAvailable captures enum value "not_available"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeNotAvailable string = "not_available"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// site
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeSite captures enum value "site"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeSite string = "site"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeCluster captures enum value "cluster"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// node
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeNode captures enum value "node"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeNode string = "node"
)

// prop value enum
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateCompliant captures enum value "compliant"
	LicensePackageResponseInlineRecordsInlineArrayItemStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateNoncompliant captures enum value "noncompliant"
	LicensePackageResponseInlineRecordsInlineArrayItemStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateUnlicensed captures enum value "unlicensed"
	LicensePackageResponseInlineRecordsInlineArrayItemStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateUnknown captures enum value "unknown"
	LicensePackageResponseInlineRecordsInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item based on the context it is used
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEntitlement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLicenses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateEntitlement(ctx context.Context, formats strfmt.Registry) error {

	if o.Entitlement != nil {
		if err := o.Entitlement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateLicenses(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "licenses", "body", []*LicenseDeleteCollectionParamsBodyRecordsItems0LicensesItems0(o.Licenses)); err != nil {
		return err
	}

	for i := 0; i < len(o.Licenses); i++ {

		if o.Licenses[i] != nil {
			if err := o.Licenses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks license package response inline records inline array item inline links
swagger:model license_package_response_inline_records_inline_array_item_inline__links
*/
type LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this license package response inline records inline array item inline links
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item inline links based on the context it is used
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement license package response inline records inline array item inline entitlement
swagger:model license_package_response_inline_records_inline_array_item_inline_entitlement
*/
type LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement struct {

	// Entitlement action to be taken to mitigate the risk
	// Read Only: true
	// Enum: ["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]
	Action *string `json:"action,omitempty"`

	// Entitlement risk of the package
	// Read Only: true
	// Enum: ["high","medium","low","unlicensed","unknown"]
	Risk *string `json:"risk,omitempty"`
}

// Validate validates this license package response inline records inline array item inline entitlement
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRisk(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// acquire_license
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAcquireLicense captures enum value "acquire_license"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAcquireLicense string = "acquire_license"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// adjust_capacity
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAdjustCapacity captures enum value "adjust_capacity"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAdjustCapacity string = "adjust_capacity"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// verify_entitlement
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifyEntitlement captures enum value "verify_entitlement"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifyEntitlement string = "verify_entitlement"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// verify_system_health
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifySystemHealth captures enum value "verify_system_health"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifySystemHealth string = "verify_system_health"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// none
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionNone captures enum value "none"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionNone string = "none"
)

// prop value enum
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("entitlement"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","low","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// high
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskHigh captures enum value "high"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskHigh string = "high"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// medium
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskMedium captures enum value "medium"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskMedium string = "medium"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// low
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskLow captures enum value "low"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskLow string = "low"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// unlicensed
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnlicensed captures enum value "unlicensed"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// unknown
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnknown captures enum value "unknown"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnknown string = "unknown"
)

// prop value enum
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateRiskEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateRisk(formats strfmt.Registry) error {
	if swag.IsZero(o.Risk) { // not required
		return nil
	}

	// value enum
	if err := o.validateRiskEnum("entitlement"+"."+"risk", "body", *o.Risk); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item inline entitlement based on the context it is used
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) contextValidateAction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"action", "body", o.Action); err != nil {
		return err
	}

	return nil
}

func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) contextValidateRisk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"risk", "body", o.Risk); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
